/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.test;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.FIFOExoCache;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.cache.impl.CacheServiceImpl;
import org.exoplatform.services.cache.test.MBeanServerLocator;

public class TestCacheService
extends TestCase {
    CacheService service_;

    public TestCacheService(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.service_ = (CacheService)PortalContainer.getInstance().getComponentInstanceOfType(CacheService.class);
    }

    public void testCacheFactory() throws Exception {
        InitParams params = new InitParams();
        ObjectParameter param = new ObjectParameter();
        param.setName("NoImpl");
        ExoCacheConfig config = new ExoCacheConfig();
        config.setName(param.getName());
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("KnownImpl");
        config = new ExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("UnKnownImpl");
        config = new ExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("fakeImpl");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("UnKnownImplButCorrectFQN");
        config = new ExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("java.lang.String");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("NoImpl-MyExoCacheConfig");
        config = new MyExoCacheConfig();
        config.setName(param.getName());
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("KnownImpl-MyExoCacheConfig");
        config = new MyExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("org.exoplatform.services.cache.FIFOExoCache");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("UnKnownImpl-MyExoCacheConfig");
        config = new MyExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("fakeImpl");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        param = new ObjectParameter();
        param.setName("UnKnownImplButCorrectFQN-MyExoCacheConfig");
        config = new MyExoCacheConfig();
        config.setName(param.getName());
        config.setImplementation("java.lang.String");
        param.setObject((Object)config);
        params.addParameter((Parameter)param);
        CacheServiceImpl cs = new CacheServiceImpl(params, (ExoCacheFactory)new MyExoCacheFactory());
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("NoImpl").getClass()), (boolean)(cs.getCacheInstance("NoImpl") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type ConcurrentFIFOExoCache found " + cs.getCacheInstance("KnownImpl").getClass()), (boolean)(cs.getCacheInstance("KnownImpl") instanceof ConcurrentFIFOExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("UnKnownImpl").getClass()), (boolean)(cs.getCacheInstance("UnKnownImpl") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("UnKnownImplButCorrectFQN").getClass()), (boolean)(cs.getCacheInstance("UnKnownImplButCorrectFQN") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("NoImpl-MyExoCacheConfig").getClass()), (boolean)(cs.getCacheInstance("NoImpl-MyExoCacheConfig") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("KnownImpl-MyExoCacheConfig").getClass()), (boolean)(cs.getCacheInstance("KnownImpl-MyExoCacheConfig") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("UnKnownImpl-MyExoCacheConfig").getClass()), (boolean)(cs.getCacheInstance("UnKnownImpl-MyExoCacheConfig") instanceof MyExoCache));
        TestCacheService.assertTrue((String)("Expected type MyExoCache found " + cs.getCacheInstance("UnKnownImplButCorrectFQN-MyExoCacheConfig").getClass()), (boolean)(cs.getCacheInstance("UnKnownImplButCorrectFQN-MyExoCacheConfig") instanceof MyExoCache));
    }

    public void testCacheService() throws Exception {
        TestCacheService.assertNotNull((Object)this.service_.getAllCacheInstances());
        int size = this.service_.getAllCacheInstances().size();
        ExoCache nocache = this.service_.getCacheInstance("nocache");
        TestCacheService.assertTrue((String)"expect find nocache configuaration", (boolean)(nocache instanceof SimpleExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of nocache is", (int)5, (int)nocache.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'liveTime' of nocache' is", (long)0L, (long)nocache.getLiveTime());
        nocache.put((Serializable)((Object)"key1"), (Object)"object 1");
        TestCacheService.assertEquals((String)"expect 'nocache' is not lived(LiveTime=0)", (int)0, (int)nocache.getCacheSize());
        ExoCache cacheLiveTime2s = this.service_.getCacheInstance("cacheLiveTime2s");
        TestCacheService.assertTrue((String)"expect find cacheLiveTime2s configuaration", (boolean)(cacheLiveTime2s instanceof SimpleExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)5, (int)cacheLiveTime2s.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'liveTime' of nocache' is", (long)2L, (long)cacheLiveTime2s.getLiveTime());
        cacheLiveTime2s.put((Serializable)((Object)"key"), (Object)"object2s");
        String obj2s = (String)cacheLiveTime2s.get((Serializable)((Object)"key"));
        TestCacheService.assertTrue((String)"expect found 'object' in cache", (obj2s != null && obj2s.equals("object2s") ? 1 : 0) != 0);
        TestCacheService.assertEquals((String)"expect found object in this cache", (int)1, (int)cacheLiveTime2s.getCacheSize());
        Thread.sleep(2500L);
        TestCacheService.assertTrue((String)"expect no found 'object' in this cache", (cacheLiveTime2s.get((Serializable)((Object)"key")) == null ? 1 : 0) != 0);
        TestCacheService.assertEquals((String)"expect cache size is ", (int)0, (int)cacheLiveTime2s.getCacheSize());
        ExoCache cacheMaxSize0 = this.service_.getCacheInstance("cacheMaxSize0");
        TestCacheService.assertTrue((String)"expect find cacheMaxSize0 configuaration", (boolean)(cacheMaxSize0 instanceof SimpleExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)0, (int)cacheMaxSize0.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'liveTime' of nocache' is", (long)4L, (long)cacheMaxSize0.getLiveTime());
        cacheMaxSize0.put((Serializable)((Object)"mkey"), (Object)"maxsize object");
        TestCacheService.assertTrue((String)"expect can't put any object to  cache", (cacheMaxSize0.get((Serializable)((Object)"mkey")) == null ? 1 : 0) != 0);
        ExoCache cache = this.service_.getCacheInstance("exo");
        TestCacheService.assertTrue((String)"expect find defaul cache configuaration", (boolean)(cache instanceof SimpleExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)100, (int)cache.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'liveTime' of this cache' is", (long)300L, (long)cache.getLiveTime());
        cache.put((Serializable)((Object)"test"), (Object)"this is a test");
        String ret = (String)cache.get((Serializable)((Object)"test"));
        TestCacheService.assertTrue((String)"expect object is cached", (ret != null ? 1 : 0) != 0);
        ExoCache fifoCache = this.service_.getCacheInstance("fifocache");
        TestCacheService.assertTrue((String)"expect find fifo cache configuration", (boolean)(fifoCache instanceof FIFOExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)3, (int)fifoCache.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'liveTime' of this cache' is", (long)4L, (long)fifoCache.getLiveTime());
        fifoCache.put((Serializable)((Object)"key1"), (Object)"object 1");
        fifoCache.put((Serializable)((Object)"key2"), (Object)"object 2");
        TestCacheService.assertEquals((String)"expect FIFOExoCache size is:", (int)2, (int)fifoCache.getCacheSize());
        String obj1 = (String)fifoCache.get((Serializable)((Object)"key1"));
        String obj2 = (String)fifoCache.get((Serializable)((Object)"key2"));
        TestCacheService.assertTrue((String)"expect found 'key1' object", (obj1 != null && obj1.equals("object 1") ? 1 : 0) != 0);
        TestCacheService.assertTrue((String)"expect found 'key2' object", (obj2 != null && obj2.equals("object 2") ? 1 : 0) != 0);
        fifoCache.put((Serializable)((Object)"skey"), (Object)"serializable object");
        TestCacheService.assertEquals((String)"expect FIFOExoCache size is:", (int)3, (int)fifoCache.getCacheSize());
        String sobj = (String)fifoCache.get((Serializable)((Object)"skey"));
        TestCacheService.assertTrue((String)"expect found serializable key and it's value", (sobj != null && sobj.equals("serializable object") ? 1 : 0) != 0);
        fifoCache.put((Serializable)((Object)"key4"), (Object)"object 4");
        TestCacheService.assertEquals((String)"expect cache size is still:", (int)3, (int)fifoCache.getCacheSize());
        String obj4 = (String)fifoCache.get((Serializable)((Object)"key4"));
        TestCacheService.assertTrue((String)"expect object has 'key4' is put in cache", (obj4 != null && obj4.equals("object 4") ? 1 : 0) != 0);
        TestCacheService.assertTrue((String)"expect object has key is 'key1' is remove automatically", (fifoCache.get((Serializable)((Object)"key1")) == null ? 1 : 0) != 0);
        fifoCache.remove((Serializable)((Object)"key2"));
        TestCacheService.assertEquals((String)"now, expect cache size is", (int)2, (int)fifoCache.getCacheSize());
        TestCacheService.assertEquals((String)"now, expect number of object in cache is:", (int)2, (int)fifoCache.getCachedObjects().size());
        TestCacheService.assertTrue((String)"expect object has 'key2' is removed", (fifoCache.get((Serializable)((Object)"key2")) == null ? 1 : 0) != 0);
        fifoCache.remove((Serializable)((Object)new String("skey")));
        TestCacheService.assertEquals((String)"now, expect cache size is", (int)1, (int)fifoCache.getCacheSize());
        TestCacheService.assertEquals((String)"now, expect number of object in cache is:", (int)1, (int)fifoCache.getCachedObjects().size());
        TestCacheService.assertTrue((String)"expect serializable object with name 'skey' is remove", (fifoCache.get((Serializable)((Object)new String("skey"))) == null ? 1 : 0) != 0);
        fifoCache.clearCache();
        TestCacheService.assertEquals((String)"now, expect cache is clear", (int)0, (int)fifoCache.getCacheSize());
        TestCacheService.assertEquals((String)"now, expect number of object in cache is:", (int)0, (int)fifoCache.getCachedObjects().size());
        ExoCache simpleCachePlugin = this.service_.getCacheInstance("simpleCachePlugin");
        TestCacheService.assertTrue((String)"expect found simpleCache from extenal plugin", (boolean)(simpleCachePlugin instanceof SimpleExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)8, (int)simpleCachePlugin.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'LiveTime' of this cache is", (long)5L, (long)simpleCachePlugin.getLiveTime());
        ExoCache fifoCachePlugin = this.service_.getCacheInstance("fifoCachePlugin");
        TestCacheService.assertTrue((String)"expect found fifoCache from extenal plugin", (boolean)(fifoCachePlugin instanceof FIFOExoCache));
        TestCacheService.assertEquals((String)"expect 'maxsize' of this cache is", (int)6, (int)fifoCachePlugin.getMaxSize());
        TestCacheService.assertEquals((String)"expect 'LiveTime' of this cache is", (long)10L, (long)fifoCachePlugin.getLiveTime());
        Collection caches = this.service_.getAllCacheInstances();
        TestCacheService.assertEquals((String)"expect number of cache instanse is ", (int)(size + 7), (int)caches.size());
        TestCacheService.hasObjectInCollection(nocache, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(cacheLiveTime2s, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(cacheMaxSize0, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(fifoCache, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(cache, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(simpleCachePlugin, caches, new ExoCacheComparator());
        TestCacheService.hasObjectInCollection(fifoCachePlugin, caches, new ExoCacheComparator());
        MBeanServerLocator locator = (MBeanServerLocator)PortalContainer.getInstance().getComponentInstanceOfType(MBeanServerLocator.class);
        MBeanServer server = locator.server;
        TestCacheService.assertNotNull((Object)locator.server);
        ObjectName name = new ObjectName("exo:service=cache,name=cacheLiveTime2s,portal=portal");
        MBeanInfo info = server.getMBeanInfo(name);
        TestCacheService.assertNotNull((Object)info);
        HashMap<String, MBeanAttributeInfo> infoMap = new HashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo attributeInfo : info.getAttributes()) {
            infoMap.put(attributeInfo.getName(), attributeInfo);
        }
        TestCacheService.assertTrue((boolean)infoMap.containsKey("Name"));
        TestCacheService.assertTrue((boolean)infoMap.containsKey("Size"));
        TestCacheService.assertTrue((boolean)infoMap.containsKey("MaxNodes"));
        TestCacheService.assertTrue((boolean)infoMap.containsKey("TimeToLive"));
        TestCacheService.assertTrue((boolean)infoMap.containsKey("HitCount"));
        TestCacheService.assertTrue((boolean)infoMap.containsKey("MissCount"));
        TestCacheService.assertEquals((int)6, (int)infoMap.size());
        TestCacheService.assertEquals((Object)5, (Object)server.getAttribute(name, "MaxNodes"));
        TestCacheService.assertEquals((int)(size + 7), (int)this.service_.getAllCacheInstances().size());
    }

    protected String getDescription() {
        return "Test Cache Service";
    }

    private static void hasObjectInCollection(Object obj, Collection c, Comparator comparator) throws Exception {
        for (Object o : c) {
            if (comparator.compare(obj, o) != 0) continue;
            return;
        }
        throw new Exception("Object " + obj + " hasn't in collection " + c);
    }

    public static class MyExoCacheConfig
    extends ExoCacheConfig {
    }

    public static class MyExoCacheFactory
    implements ExoCacheFactory {
        public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
            return new MyExoCache();
        }
    }

    public static class MyExoCache<V>
    implements ExoCache<Serializable, V> {
        public static AtomicInteger count = new AtomicInteger();

        public MyExoCache() {
            count.incrementAndGet();
        }

        public String getName() {
            return "TestConcurrentCreation";
        }

        public void setName(String name) {
        }

        public String getLabel() {
            return "TestConcurrentCreation";
        }

        public void setLabel(String s) {
        }

        public V get(Serializable key) {
            return null;
        }

        public V remove(Serializable key) throws NullPointerException {
            return null;
        }

        public void put(Serializable key, V value) throws NullPointerException {
        }

        public void putMap(Map<? extends Serializable, ? extends V> objs) throws NullPointerException, IllegalArgumentException {
        }

        public void clearCache() {
        }

        public void select(CachedObjectSelector<? super Serializable, ? super V> selector) throws Exception {
        }

        public int getCacheSize() {
            return 0;
        }

        public int getMaxSize() {
            return 0;
        }

        public void setMaxSize(int max) {
        }

        public long getLiveTime() {
            return 0L;
        }

        public void setLiveTime(long period) {
        }

        public int getCacheHit() {
            return 0;
        }

        public int getCacheMiss() {
            return 0;
        }

        public List<? extends V> getCachedObjects() throws Exception {
            return null;
        }

        public List<? extends V> removeCachedObjects() {
            return null;
        }

        public void addCacheListener(CacheListener<? super Serializable, ? super V> listener) throws NullPointerException {
        }

        public boolean isLogEnabled() {
            return false;
        }

        public void setLogEnabled(boolean b) {
        }
    }

    private static class ExoCacheComparator
    implements Comparator {
        private ExoCacheComparator() {
        }

        public int compare(Object o1, Object o2) {
            ExoCache c1 = (ExoCache)o1;
            ExoCache c2 = (ExoCache)o2;
            if (c1.getName().equals(c2.getName()) && c1.getMaxSize() == c2.getMaxSize() && c1.getLiveTime() == c2.getLiveTime()) {
                return 0;
            }
            return -1;
        }
    }
}

