/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.log.impl.ExoLog;

public class LogServiceImpl
implements LogService {
    private HashMap logs_ = new HashMap();
    private HashMap configure_ = new HashMap();

    public LogServiceImpl(InitParams params) throws Exception {
        this.configure_.put("org.exoplatform", new Integer(ExoLog.INFO));
        PropertiesParam param = params.getPropertiesParam("log.level.config");
        for (Map.Entry entry : param.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            int level = this.toLevel((String)entry.getValue());
            this.configure_.put(name, new Integer(level));
        }
    }

    public void start() {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getLog(String name) {
        Log log = (Log)this.logs_.get(name);
        if (log == null) {
            HashMap hashMap = this.logs_;
            synchronized (hashMap) {
                int level = ExoLog.INFO;
                try {
                    level = this.getDefaultLogLevel(name);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                log = new ExoLog(name, level);
                this.logs_.put(name, log);
            }
        }
        return log;
    }

    public Log getLog(Class clazz) {
        String name = clazz.getName();
        int idx = name.lastIndexOf(".");
        name = name.substring(0, idx);
        return this.getLog(name);
    }

    public Collection getLogs() {
        return this.logs_.values();
    }

    public int getLogLevel(String name) throws Exception {
        ExoLog log = (ExoLog)this.logs_.get(name);
        if (log != null) {
            return log.getLevel();
        }
        return 3;
    }

    public void setLogLevel(String name, int level, boolean recursive) throws Exception {
        if (recursive) {
            for (ExoLog log : this.logs_.values()) {
                if (!log.getLogCategory().startsWith(name)) continue;
                log.setLevel(level);
            }
        } else {
            ExoLog log = (ExoLog)this.logs_.get(name);
            if (log != null) {
                log.setLevel(level);
            }
        }
    }

    public List getLogBuffer() {
        return ExoLog.getLogBuffer();
    }

    public List getErrorBuffer() {
        return ExoLog.getErrorBuffer();
    }

    private int getDefaultLogLevel(String name) throws Exception {
        while (name != null) {
            Integer level = (Integer)this.configure_.get(name);
            if (level != null) {
                return level;
            }
            int index = name.lastIndexOf(".");
            if (index > 0) {
                name = name.substring(0, index);
                continue;
            }
            name = null;
        }
        return ExoLog.INFO;
    }

    private int toLevel(String s) {
        if ("FATAL".equals(s)) {
            return ExoLog.FATAL;
        }
        if ("ERROR".equals(s)) {
            return ExoLog.ERROR;
        }
        if ("WARN".equals(s)) {
            return ExoLog.WARN;
        }
        if ("INFO".equals(s)) {
            return ExoLog.INFO;
        }
        if ("DEBUG".equals(s)) {
            return ExoLog.DEBUG;
        }
        if ("TRACE".equals(s)) {
            return ExoLog.TRACE;
        }
        return ExoLog.INFO;
    }
}

