/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.services.transaction;

import javax.transaction.xa.XAException;

/**
 * Created by The eXo Platform SAS.
 * 
 * @author <a href="mailto:gennady.azarenkov@exoplatform.com">Gennady
 *         Azarenkov</a>
 * @version $Id: TransactionException.java 5987 2006-06-05 10:14:23Z geaz $
 */

public class TransactionException extends Exception
{

   private final int errcode;
   
   public TransactionException()
   {
      super();
      this.errcode = XAException.XA_RBOTHER; 
   }

   public TransactionException(String arg0)
   {
      super(arg0);
      this.errcode = XAException.XA_RBOTHER;
   }

   public TransactionException(String arg0, Throwable arg1)
   {
      super(arg0, arg1);
      this.errcode = XAException.XA_RBOTHER;
   }

   public TransactionException(Throwable arg0)
   {
      super(arg0);
      this.errcode = XAException.XA_RBOTHER;
   }
   
   public TransactionException(int errcode, String arg0)
   {
      super(arg0);
      this.errcode = errcode;
   }
   
   public TransactionException(int errcode, Throwable arg0)
   {
      super(arg0);
      this.errcode = errcode;
   }

   public int getErrorCode()
   {
      return errcode;
   }
}
