/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.AddJobListenerComponentPlugin;
import org.exoplatform.services.scheduler.AddTriggerListenerComponentPlugin;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobKey;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.services.scheduler.PeriodJob;
import org.exoplatform.services.scheduler.QueueTasks;
import org.exoplatform.services.scheduler.Task;
import org.exoplatform.services.scheduler.impl.JobEnvironmentConfigListener;
import org.exoplatform.services.scheduler.impl.QuartzSheduler;
import org.picocontainer.Startable;
import org.quartz.CronScheduleBuilder;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class JobSchedulerServiceImpl
implements JobSchedulerService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.JobSchedulerServiceImpl");
    static final String STANDALONE_CONTAINER_NAME = "$Standalone";
    private final Scheduler scheduler_;
    private final String containerName_;
    private final QueueTasks qtasks_;
    private final boolean jobStoreSupportsPersistence;

    public JobSchedulerServiceImpl(PortalContainerInfo pinfo, QuartzSheduler quartzSchduler, QueueTasks qtasks) {
        this.scheduler_ = quartzSchduler.getQuartzSheduler();
        this.containerName_ = pinfo.getContainerName();
        this.qtasks_ = qtasks;
        this.jobStoreSupportsPersistence = this.isJobStoreSupportsPersistence();
    }

    public JobSchedulerServiceImpl(QuartzSheduler quartzSchduler, QueueTasks qtasks) {
        this.scheduler_ = quartzSchduler.getQuartzSheduler();
        this.containerName_ = STANDALONE_CONTAINER_NAME;
        this.qtasks_ = qtasks;
        this.jobStoreSupportsPersistence = this.isJobStoreSupportsPersistence();
    }

    private boolean isJobStoreSupportsPersistence() {
        try {
            return this.scheduler_.getMetaData().isJobStoreSupportsPersistence();
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Cannot know if the job store supports the persistence, we assume by default that it is not supported: " + e.getMessage()));
            return false;
        }
    }

    @Override
    public void queueTask(Task task) {
        this.qtasks_.add(task);
    }

    private void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        if (this.registerJob(jobDetail)) {
            this.scheduler_.scheduleJob(jobDetail, trigger);
        } else {
            LOG.debug("The exact same Job has already been registered with the id '{}'.", new Object[]{jobDetail.getKey()});
        }
    }

    private boolean registerJob(JobDetail jobDetail) throws SchedulerException {
        if (!this.jobStoreSupportsPersistence) {
            return true;
        }
        JobDetail existingJob = this.scheduler_.getJobDetail(jobDetail.getKey());
        if (existingJob == null) {
            return true;
        }
        if (JobSchedulerServiceImpl.equals(existingJob, jobDetail)) {
            return false;
        }
        throw new ObjectAlreadyExistsException(jobDetail);
    }

    private static boolean equals(JobDetail jobDetail1, JobDetail jobDetail2) {
        if (jobDetail1.getJobClass() == null ? jobDetail2.getJobClass() != null : !jobDetail1.getJobClass().equals(jobDetail2.getJobClass())) {
            return false;
        }
        return !(jobDetail1.getJobDataMap() == null ? jobDetail2.getJobDataMap() != null : !jobDetail1.getJobDataMap().equals((Object)jobDetail2.getJobDataMap()));
    }

    public void addJob(JobDetail job, Trigger trigger) throws Exception {
        String gname = this.getGroupName(job.getKey().getGroup());
        trigger = trigger.getTriggerBuilder().withIdentity(job.getKey().getName(), gname).build();
        this.scheduleJob(job.getJobBuilder().withIdentity(job.getKey().getName(), gname).build(), trigger);
    }

    public void addJob(JobInfo jinfo, Trigger trigger) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        trigger = trigger.getTriggerBuilder().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).build();
        JobDetail job = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).requestRecovery(jobinfo.isShouldRecover()).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public void addJob(JobInfo jinfo, Date date) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).startAt(date).build();
        JobDetail job = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover()).build();
        this.scheduleJob(job, trigger);
    }

    public void addPeriodJob(JobInfo jinfo, int repeatCount, long period) throws Exception {
        int repeat = repeatCount < 0 ? -1 : (repeatCount == 0 ? -1 : repeatCount - 1);
        JobInfo jobinfo = this.getJobInfo(jinfo);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(repeat).withIntervalInMilliseconds(period)).build();
        JobDetail job = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover()).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public void addPeriodJob(JobInfo jinfo, PeriodInfo pinfo) throws Exception {
        int repeat = pinfo.getRepeatCount();
        Date start = pinfo.getStartTime();
        JobInfo jobinfo = this.getJobInfo(jinfo);
        if (start == null) {
            start = new Date();
        }
        repeat = repeat <= 0 ? -1 : --repeat;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(repeat).withIntervalInMilliseconds(pinfo.getRepeatInterval())).startAt(start).endAt(pinfo.getEndTime()).build();
        JobDetail job = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover()).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public void addPeriodJob(ComponentPlugin plugin) throws Exception {
        PeriodJob pjob = (PeriodJob)plugin;
        try {
            this.addPeriodJob(pjob.getJobInfo(), pjob.getPeriodInfo(), pjob.getJobDataMap());
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the period job (" + pjob.getJobInfo().getJobName() + ", " + pjob.getJobInfo().getGroupName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public void addCronJob(JobInfo jinfo, String exp) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).forJob(jobinfo.getJobName(), jobinfo.getGroupName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)exp)).build();
        JobDetail job = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover()).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public void addCronJob(ComponentPlugin plugin) throws Exception {
        CronJob cjob = (CronJob)plugin;
        try {
            this.addCronJob(cjob.getJobInfo(), cjob.getExpression(), cjob.getJobDataMap());
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the cron job (" + cjob.getJobInfo().getJobName() + ", " + cjob.getJobInfo().getGroupName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public void addCronJob(JobInfo jinfo, String exp, JobDataMap jdatamap) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).forJob(jobinfo.getJobName(), jobinfo.getGroupName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)exp)).build();
        JobBuilder jb = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover());
        JobDetail job = jdatamap == null ? jb.build() : jb.usingJobData(jdatamap).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public void addPeriodJob(JobInfo jinfo, PeriodInfo pinfo, JobDataMap jdatamap) throws Exception {
        int repeat = pinfo.getRepeatCount();
        Date start = pinfo.getStartTime();
        JobInfo jobinfo = this.getJobInfo(jinfo);
        if (start == null) {
            start = new Date();
        }
        repeat = repeat <= 0 ? -1 : --repeat;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(repeat).withIntervalInMilliseconds(pinfo.getRepeatInterval())).startAt(start).endAt(pinfo.getEndTime()).build();
        JobBuilder jb = JobBuilder.newJob((Class)jobinfo.getJob()).withIdentity(jobinfo.getJobName(), jobinfo.getGroupName()).withDescription(jinfo.getDescription()).requestRecovery(jinfo.isShouldRecover());
        JobDetail job = jdatamap == null ? jb.build() : jb.usingJobData(jdatamap).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public boolean removeJob(JobInfo jinfo) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        return this.scheduler_.deleteJob(org.quartz.JobKey.jobKey((String)jobinfo.getJobName(), (String)jobinfo.getGroupName()));
    }

    @Override
    public List<JobExecutionContext> getAllExcutingJobs() throws Exception {
        return this.scheduler_.getCurrentlyExecutingJobs();
    }

    @Override
    public List<JobDetail> getAllJobs() throws Exception {
        ArrayList<JobDetail> jlist = new ArrayList<JobDetail>();
        List jgroups = this.scheduler_.getJobGroupNames();
        int length = jgroups.size();
        for (int i = 0; i < length; ++i) {
            Set jkeys = this.scheduler_.getJobKeys(GroupMatcher.jobGroupEquals((String)((String)jgroups.get(i))));
            for (org.quartz.JobKey jkey : jkeys) {
                jlist.add(this.scheduler_.getJobDetail(jkey));
            }
        }
        return jlist;
    }

    @Override
    public void addGlobalJobListener(ComponentPlugin plugin) throws Exception {
        JobListener jl = (JobListener)plugin;
        try {
            this.scheduler_.getListenerManager().addJobListener(jl);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the global job listener (" + jl.getName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public List<JobListener> getAllGlobalJobListener() throws Exception {
        List listeners = this.scheduler_.getListenerManager().getJobListeners();
        ArrayList<JobListener> result = new ArrayList<JobListener>();
        for (JobListener l : listeners) {
            List matchers = this.scheduler_.getListenerManager().getJobListenerMatchers(l.getName());
            if (!matchers.contains(EverythingMatcher.allJobs())) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public JobListener getGlobalJobListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().getJobListener(name);
    }

    @Override
    public boolean removeGlobalJobListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().removeJobListener(name);
    }

    @Override
    public void addJobListener(AddJobListenerComponentPlugin plugin) throws Exception {
        AddJobListenerComponentPlugin jl = plugin;
        try {
            ArrayList<KeyMatcher> matchers = null;
            if (plugin.getKeys() != null) {
                matchers = new ArrayList<KeyMatcher>();
                for (JobKey key : plugin.getKeys()) {
                    matchers.add(KeyMatcher.keyEquals((Key)org.quartz.JobKey.jobKey((String)key.getName(), (String)this.getGroupName(key.getGroup()))));
                }
            }
            this.scheduler_.getListenerManager().addJobListener((JobListener)jl, matchers);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the job listener (" + jl.getName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public List<JobListener> getAllJobListener() throws Exception {
        List listeners = this.scheduler_.getListenerManager().getJobListeners();
        ArrayList<JobListener> result = new ArrayList<JobListener>();
        for (JobListener l : listeners) {
            List matchers = this.scheduler_.getListenerManager().getJobListenerMatchers(l.getName());
            if (matchers.contains(EverythingMatcher.allJobs())) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public JobListener getJobListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().getJobListener(name);
    }

    @Override
    public boolean removeJobListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().removeJobListener(name);
    }

    @Override
    public void addGlobalTriggerListener(ComponentPlugin plugin) throws Exception {
        TriggerListener tl = (TriggerListener)plugin;
        try {
            this.scheduler_.getListenerManager().addTriggerListener(tl);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the global trigger listener (" + tl.getName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public List<TriggerListener> getAllGlobalTriggerListener() throws Exception {
        List listeners = this.scheduler_.getListenerManager().getTriggerListeners();
        ArrayList<TriggerListener> result = new ArrayList<TriggerListener>();
        for (TriggerListener l : listeners) {
            List matchers = this.scheduler_.getListenerManager().getTriggerListenerMatchers(l.getName());
            if (!matchers.contains(EverythingMatcher.allJobs())) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public TriggerListener getGlobalTriggerListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().getTriggerListener(name);
    }

    @Override
    public boolean removeGlobaTriggerListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().removeTriggerListener(name);
    }

    @Override
    public void addTriggerListener(AddTriggerListenerComponentPlugin plugin) throws Exception {
        AddTriggerListenerComponentPlugin tl = plugin;
        try {
            ArrayList<KeyMatcher> matchers = null;
            if (plugin.getKeys() != null) {
                matchers = new ArrayList<KeyMatcher>();
                for (JobKey key : plugin.getKeys()) {
                    matchers.add(KeyMatcher.keyEquals((Key)TriggerKey.triggerKey((String)key.getName(), (String)this.getGroupName(key.getGroup()))));
                }
            }
            this.scheduler_.getListenerManager().addTriggerListener((TriggerListener)tl, matchers);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not add the trigger listener (" + tl.getName() + ") defined in the plugin " + plugin.getName() + " : " + e.getMessage()));
        }
    }

    @Override
    public List<TriggerListener> getAllTriggerListener() throws Exception {
        List listeners = this.scheduler_.getListenerManager().getTriggerListeners();
        ArrayList<TriggerListener> result = new ArrayList<TriggerListener>();
        for (TriggerListener l : listeners) {
            List matchers = this.scheduler_.getListenerManager().getTriggerListenerMatchers(l.getName());
            if (matchers.contains(EverythingMatcher.allJobs())) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public TriggerListener getTriggerListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().getTriggerListener(name);
    }

    @Override
    public boolean removeTriggerListener(String name) throws Exception {
        return this.scheduler_.getListenerManager().removeTriggerListener(name);
    }

    private JobInfo getJobInfo(JobInfo jinfo) throws Exception {
        String gname = this.getGroupName(jinfo.getGroupName());
        JobInfo jobInfo = new JobInfo(jinfo.getJobName(), gname, jinfo.getJob());
        jobInfo.setDescription(jinfo.getDescription());
        jobInfo.setShouldRecover(jinfo.isShouldRecover());
        return jobInfo;
    }

    @Override
    public void pauseJob(String jobName, String groupName) throws Exception {
        this.scheduler_.pauseJob(org.quartz.JobKey.jobKey((String)jobName, (String)this.getGroupName(groupName)));
    }

    @Override
    public void resumeJob(String jobName, String groupName) throws Exception {
        this.scheduler_.resumeJob(org.quartz.JobKey.jobKey((String)jobName, (String)this.getGroupName(groupName)));
    }

    @Override
    public void executeJob(String jname, String jgroup, JobDataMap jdatamap) throws Exception {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jname, this.getGroupName(jgroup)).startNow().build();
        JobBuilder jb = JobBuilder.newJob().withIdentity(jname, this.getGroupName(jgroup));
        JobDetail job = jdatamap == null ? jb.build() : jb.usingJobData(jdatamap).build();
        this.scheduleJob(job, trigger);
    }

    @Override
    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws Exception {
        List triggers = this.scheduler_.getTriggersOfJob(org.quartz.JobKey.jobKey((String)jobName, (String)this.getGroupName(groupName)));
        Trigger[] aTriggers = new Trigger[triggers.size()];
        return triggers.toArray(aTriggers);
    }

    @Override
    public Trigger.TriggerState getTriggerState(String jobName, String groupName) throws Exception {
        return this.scheduler_.getTriggerState(TriggerKey.triggerKey((String)jobName, (String)this.getGroupName(groupName)));
    }

    @Override
    public Date rescheduleJob(String jobName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.scheduler_.rescheduleJob(TriggerKey.triggerKey((String)jobName, (String)this.getGroupName(groupName)), newTrigger.getTriggerBuilder().withIdentity(jobName, this.getGroupName(groupName)).build());
    }

    @Override
    @Managed
    @ManagedDescription(value="Suspend all the existing jobs")
    public boolean suspend() {
        try {
            this.scheduler_.standby();
            return true;
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Could not suspend the scheduler", (Throwable)e);
            return false;
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="Resume all the existing jobs")
    public boolean resume() {
        try {
            this.scheduler_.start();
            return true;
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Could not resume the scheduler", (Throwable)e);
            return false;
        }
    }

    public void start() {
        try {
            while (this.removeGlobalJobListener("JobContextConfigListener")) {
            }
            this.scheduler_.getListenerManager().addJobListener((JobListener)new JobEnvironmentConfigListener());
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not remove the GlobalJobListener JobContextConfigListener", (Throwable)e);
        }
    }

    public void stop() {
        try {
            List<JobExecutionContext> jobs = this.getAllExcutingJobs();
            for (JobExecutionContext ctx : jobs) {
                Job job = ctx.getJobInstance();
                if (!(job instanceof InterruptableJob)) continue;
                ((InterruptableJob)job).interrupt();
            }
            this.scheduler_.shutdown(true);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Could not interrupt all the current jobs properly", (Throwable)ex);
        }
    }

    @Override
    public JobDetail getJob(JobInfo jobInfo) throws Exception {
        JobInfo innerJobInfo = this.getJobInfo(jobInfo);
        return this.scheduler_.getJobDetail(org.quartz.JobKey.jobKey((String)innerJobInfo.getJobName(), (String)innerJobInfo.getGroupName()));
    }

    private String getGroupName(String initialGroupName) {
        String gname = initialGroupName == null || (initialGroupName = initialGroupName.trim()).isEmpty() ? this.containerName_ : this.containerName_ + ":" + initialGroupName;
        return gname;
    }
}

