/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jdbc.impl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CloseableDataSource
implements DataSource {
    private DataSource ds;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Exception closedByCallStack;
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.CloseableDataSource");
    private static final boolean PROHIBIT_CLOSED_DATASOURCE_USAGE = Boolean.valueOf(PrivilegedSystemHelper.getProperty((String)"exo.jcr.prohibit.closed.datasource.usage", (String)"true"));

    public CloseableDataSource(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        this.checkValid();
        return this.ds.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        this.checkValid();
        return this.ds.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.checkValid();
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.checkValid();
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkValid();
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkValid();
        return this.ds.unwrap(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkValid();
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.checkValid();
        return this.ds.getConnection(username, password);
    }

    public void close() {
        this.closed.set(true);
        if (PROHIBIT_CLOSED_DATASOURCE_USAGE) {
            this.ds = null;
        }
        if (PROHIBIT_CLOSED_DATASOURCE_USAGE || PropertyManager.isDevelopping()) {
            this.closedByCallStack = new Exception("The datasource has been closed by the following call stack");
        }
    }

    private void checkValid() throws SQLException {
        if (this.closed.get()) {
            if (this.ds == null) {
                throw new SQLException("The datasource is closed", this.closedByCallStack);
            }
            if (PropertyManager.isDevelopping()) {
                log.warn((Object)"This kind of operation is forbidden after a DataSource closed, please note that an exception will be raised in the next jcr version.", (Throwable)new Exception(this.closedByCallStack));
            }
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            this.checkValid();
            Method m = this.ds.getClass().getMethod("getParentLogger", new Class[0]);
            return (Logger)m.invoke((Object)this.ds, new Object[0]);
        }
        catch (Exception e) {
            throw new SQLFeatureNotSupportedException(e);
        }
    }
}

