/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.cache.impl.infinispan.AbstractExoCache;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheFactoryImpl;

public class TestAbstractExoCache
extends TestCase {
    PortalContainer container;
    CacheService service;
    AbstractExoCache<Serializable, Object> cache;

    public TestAbstractExoCache(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        ExoContainer topContainer = ExoContainerContext.getTopContainer();
        if (topContainer != null) {
            topContainer.stop();
        }
        RootContainer.setInstance(null);
        ExoContainerContext.setCurrentContainer(null);
        this.container = PortalContainer.getInstance();
        this.service = (CacheService)this.container.getComponentInstanceOfType(CacheService.class);
        this.cache = (AbstractExoCache)this.service.getCacheInstance("myCache");
    }

    public void testGet() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        TestAbstractExoCache.assertEquals((Object)"a", (Object)this.cache.get((Serializable)new MyKey("a")));
        this.cache.put((Serializable)new MyKey("a"), (Object)"c");
        TestAbstractExoCache.assertEquals((Object)"c", (Object)this.cache.get((Serializable)new MyKey("a")));
        this.cache.remove((Serializable)new MyKey("a"));
        TestAbstractExoCache.assertEquals(null, (Object)this.cache.get((Serializable)new MyKey("a")));
        TestAbstractExoCache.assertEquals(null, (Object)this.cache.get((Serializable)new MyKey("x")));
        this.cache.clearCache();
    }

    public void testRemove() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)1);
        this.cache.put((Serializable)new MyKey("b"), (Object)2);
        this.cache.put((Serializable)new MyKey("c"), (Object)3);
        TestAbstractExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        TestAbstractExoCache.assertEquals((Object)1, (Object)this.cache.remove((Serializable)new MyKey("a")));
        TestAbstractExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
        TestAbstractExoCache.assertEquals((Object)2, (Object)this.cache.remove((Serializable)new MyKey("b")));
        TestAbstractExoCache.assertEquals((int)1, (int)this.cache.getCacheSize());
        TestAbstractExoCache.assertEquals(null, (Object)this.cache.remove((Serializable)new MyKey("x")));
        TestAbstractExoCache.assertEquals((int)1, (int)this.cache.getCacheSize());
        this.cache.clearCache();
    }

    public void testPutMap() throws Exception {
        HashMap<Serializable, Object> values = new HashMap();
        values.put(new MyKey("a"), "a");
        values.put(new MyKey("b"), "b");
        TestAbstractExoCache.assertEquals((int)0, (int)this.cache.getCacheSize());
        this.cache.putMap(values);
        TestAbstractExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
        values = new HashMap<Serializable, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<Map.Entry<Serializable, Object>> entrySet() {
                LinkedHashSet<Map.Entry<Serializable, Object>> set = new LinkedHashSet<Map.Entry<Serializable, Object>>(super.entrySet());
                set.add(new Map.Entry<Serializable, Object>(){

                    @Override
                    public Object setValue(Object paramV) {
                        return null;
                    }

                    @Override
                    public Object getValue() {
                        throw new RuntimeException("An exception");
                    }

                    @Override
                    public Serializable getKey() {
                        return "c";
                    }
                });
                return set;
            }
        };
        values.put(new MyKey("e"), "e");
        values.put(new MyKey("d"), "d");
        this.cache.putMap((Map)values);
        TestAbstractExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
        this.cache.clearCache();
    }

    public void testGetCachedObjects() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        this.cache.put((Serializable)new MyKey("d"), null);
        TestAbstractExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        List values = this.cache.getCachedObjects();
        TestAbstractExoCache.assertEquals((int)3, (int)values.size());
        TestAbstractExoCache.assertTrue((boolean)values.contains("a"));
        TestAbstractExoCache.assertTrue((boolean)values.contains("b"));
        TestAbstractExoCache.assertTrue((boolean)values.contains("c"));
        this.cache.clearCache();
    }

    public void testRemoveCachedObjects() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        this.cache.put((Serializable)new MyKey("d"), null);
        TestAbstractExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        List values = this.cache.removeCachedObjects();
        TestAbstractExoCache.assertEquals((int)3, (int)values.size());
        TestAbstractExoCache.assertTrue((boolean)values.contains("a"));
        TestAbstractExoCache.assertTrue((boolean)values.contains("b"));
        TestAbstractExoCache.assertTrue((boolean)values.contains("c"));
        TestAbstractExoCache.assertEquals((int)0, (int)this.cache.getCacheSize());
        this.cache.clearCache();
    }

    public void testSelect() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)1);
        this.cache.put((Serializable)new MyKey("b"), (Object)2);
        this.cache.put((Serializable)new MyKey("c"), (Object)3);
        final AtomicInteger count = new AtomicInteger();
        CachedObjectSelector<Serializable, Object> selector = new CachedObjectSelector<Serializable, Object>(){

            public void onSelect(ExoCache<? extends Serializable, ? extends Object> cache, Serializable key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                TestCase.assertTrue((key.equals(new MyKey("a")) || key.equals(new MyKey("b")) || key.equals(new MyKey("c")) ? 1 : 0) != 0);
                TestCase.assertTrue((ocinfo.get().equals(1) || ocinfo.get().equals(2) || ocinfo.get().equals(3) ? 1 : 0) != 0);
                count.incrementAndGet();
            }

            public boolean select(Serializable key, ObjectCacheInfo<? extends Object> ocinfo) {
                return true;
            }
        };
        this.cache.select((CachedObjectSelector)selector);
        TestAbstractExoCache.assertEquals((int)3, (int)count.intValue());
        this.cache.clearCache();
    }

    public void testGetHitsNMisses() throws Exception {
        int hits = this.cache.getCacheHit();
        int misses = this.cache.getCacheMiss();
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.get((Serializable)new MyKey("a"));
        this.cache.remove((Serializable)new MyKey("a"));
        this.cache.get((Serializable)new MyKey("a"));
        this.cache.get((Serializable)new MyKey("z"));
        TestAbstractExoCache.assertEquals((int)1, (int)(this.cache.getCacheHit() - hits));
        TestAbstractExoCache.assertEquals((int)2, (int)(this.cache.getCacheMiss() - misses));
        this.cache.clearCache();
    }

    private ExoCacheFactory getExoCacheFactoryInstance() throws ExoCacheInitException {
        PortalContainer pc = PortalContainer.getInstance();
        return new ExoCacheFactoryImpl((ExoContainerContext)pc.getComponentInstanceOfType(ExoContainerContext.class), "jar:/conf/portal/cache-configuration-template.xml", null, (ConfigurationManager)pc.getComponentInstanceOfType(ConfigurationManager.class), null);
    }

    public void testMultiThreading() throws Exception {
        Thread thread;
        int i;
        int i2;
        final ExoCache cache = this.service.getCacheInstance("test-multi-threading");
        int totalElement = 100;
        int totalTimes = 20;
        int reader = 20;
        int writer = 10;
        int remover = 5;
        int cleaner = 1;
        final CountDownLatch startSignalWriter = new CountDownLatch(1);
        final CountDownLatch startSignalOthers = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(reader + writer + remover);
        final List<Exception> errors = Collections.synchronizedList(new ArrayList());
        int i22 = 0;
        while (i22 < writer) {
            final int index = i22++;
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalWriter.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                cache.put((Serializable)new MyKey("key" + i), (Object)("value" + i));
                            }
                            if (index == 0 && j == 0) {
                                startSignalOthers.countDown();
                            }
                            3.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread2.start();
        }
        startSignalWriter.countDown();
        for (i2 = 0; i2 < reader; ++i2) {
            Thread thread3 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                cache.get((Serializable)new MyKey("key" + i));
                            }
                            4.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread3.start();
        }
        for (i2 = 0; i2 < remover; ++i2) {
            Thread thread4 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                cache.remove((Serializable)new MyKey("key" + i));
                            }
                            5.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread4.start();
        }
        doneSignal.await();
        for (i2 = 0; i2 < 100; ++i2) {
            cache.put((Serializable)new MyKey("key" + i2), (Object)("value" + i2));
        }
        TestAbstractExoCache.assertEquals((int)100, (int)cache.getCacheSize());
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal2 = new CountDownLatch(writer + cleaner);
        for (i = 0; i < writer; ++i) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignal.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                cache.put((Serializable)new MyKey("key" + i), (Object)("value" + i));
                            }
                            6.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal2.countDown();
                    }
                }
            };
            thread.start();
        }
        for (i = 0; i < cleaner; ++i) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignal.await();
                        for (int j = 0; j < 20; ++j) {
                            7.sleep(150L);
                            cache.clearCache();
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal2.countDown();
                    }
                }
            };
            thread.start();
        }
        cache.clearCache();
        TestAbstractExoCache.assertEquals((int)0, (int)cache.getCacheSize());
        if (!errors.isEmpty()) {
            for (Exception e : errors) {
                e.printStackTrace();
            }
            throw errors.get(0);
        }
        cache.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCache() throws Exception {
        ExoCacheConfig config = new ExoCacheConfig();
        config.setName("MyCacheDistributed");
        config.setMaxSize(8);
        config.setLiveTime(1L);
        config.setImplementation("LRU");
        config.setReplicated(true);
        ExoCacheConfig config2 = new ExoCacheConfig();
        config2.setName("MyCacheDistributed2");
        config2.setMaxSize(8);
        config2.setLiveTime(1L);
        config2.setImplementation("LRU");
        config2.setReplicated(true);
        AbstractExoCache cache1 = (AbstractExoCache)this.getExoCacheFactoryInstance().createCache(config);
        MyCacheListener listener1 = new MyCacheListener();
        cache1.addCacheListener((CacheListener)listener1);
        AbstractExoCache cache2 = (AbstractExoCache)this.getExoCacheFactoryInstance().createCache(config);
        MyCacheListener listener2 = new MyCacheListener();
        cache2.addCacheListener((CacheListener)listener2);
        try {
            cache1.put((Serializable)new MyKey("a"), (Object)"b");
            TestAbstractExoCache.assertEquals((int)1, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((Object)"b", (Object)cache2.get((Serializable)new MyKey("a")));
            TestAbstractExoCache.assertEquals((int)1, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)0, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.get);
            cache2.put((Serializable)new MyKey("b"), (Object)"c");
            TestAbstractExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((Object)"c", (Object)cache1.get((Serializable)new MyKey("b")));
            TestAbstractExoCache.assertEquals((int)2, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)2, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)2, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)2, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.get);
            cache2.put((Serializable)new MyKey("a"), (Object)"a");
            TestAbstractExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((Object)"a", (Object)cache1.get((Serializable)new MyKey("a")));
            TestAbstractExoCache.assertEquals((int)3, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)3, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)2, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.get);
            cache2.remove((Serializable)new MyKey("a"));
            TestAbstractExoCache.assertEquals((int)1, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)1, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)3, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)3, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)2, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.remove);
            cache1.put((Serializable)new MyKey("c"), (Object)"c");
            cache1.clearCache();
            TestAbstractExoCache.assertEquals((int)0, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals(null, (Object)cache1.get((Serializable)new MyKey("b")));
            TestAbstractExoCache.assertEquals((Object)"c", (Object)cache2.get((Serializable)new MyKey("b")));
            TestAbstractExoCache.assertEquals((Object)"c", (Object)cache2.get((Serializable)new MyKey("c")));
            TestAbstractExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)4, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)4, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)3, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)3, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.clearCache);
            TestAbstractExoCache.assertEquals((int)0, (int)listener2.clearCache);
            HashMap<Serializable, Object> values = new HashMap();
            values.put(new MyKey("a"), "a");
            values.put(new MyKey("b"), "b");
            cache1.putMap(values);
            TestAbstractExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
            Thread.sleep(40L);
            TestAbstractExoCache.assertEquals((Object)"a", (Object)cache2.get((Serializable)new MyKey("a")));
            TestAbstractExoCache.assertEquals((Object)"b", (Object)cache2.get((Serializable)new MyKey("b")));
            TestAbstractExoCache.assertEquals((int)3, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)6, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)6, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)3, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)5, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.clearCache);
            TestAbstractExoCache.assertEquals((int)0, (int)listener2.clearCache);
            values = new HashMap<Serializable, Object>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Set<Map.Entry<Serializable, Object>> entrySet() {
                    LinkedHashSet<Map.Entry<Serializable, Object>> set = new LinkedHashSet<Map.Entry<Serializable, Object>>(super.entrySet());
                    set.add(new Map.Entry<Serializable, Object>(){

                        @Override
                        public Object setValue(Object paramV) {
                            return null;
                        }

                        @Override
                        public Object getValue() {
                            throw new RuntimeException("An exception");
                        }

                        @Override
                        public Serializable getKey() {
                            return "c";
                        }
                    });
                    return set;
                }
            };
            values.put(new MyKey("e"), "e");
            values.put(new MyKey("d"), "d");
            cache1.putMap((Map)values);
            TestAbstractExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)3, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)6, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)6, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)3, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)5, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.clearCache);
            TestAbstractExoCache.assertEquals((int)0, (int)listener2.clearCache);
            TestAbstractExoCache.assertEquals((int)0, (int)listener1.expire);
            TestAbstractExoCache.assertEquals((int)0, (int)listener2.expire);
            Thread.sleep(5600L);
            cache1.get((Serializable)new MyKey("a"));
            cache1.get((Serializable)new MyKey("b"));
            cache2.get((Serializable)new MyKey("a"));
            cache2.get((Serializable)new MyKey("b"));
            cache2.get((Serializable)new MyKey("c"));
            TestAbstractExoCache.assertEquals((int)0, (int)cache1.getCacheSize());
            TestAbstractExoCache.assertEquals((int)0, (int)cache2.getCacheSize());
            TestAbstractExoCache.assertEquals((int)6, (int)listener1.put);
            TestAbstractExoCache.assertEquals((int)6, (int)listener2.put);
            TestAbstractExoCache.assertEquals((int)5, (int)listener1.get);
            TestAbstractExoCache.assertEquals((int)8, (int)listener2.get);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener2.remove);
            TestAbstractExoCache.assertEquals((int)1, (int)listener1.clearCache);
            TestAbstractExoCache.assertEquals((int)0, (int)listener2.clearCache);
        }
        finally {
            cache1.cache.getCacheManager().stop();
            cache2.cache.getCacheManager().stop();
        }
    }

    public void testPut() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        TestAbstractExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        this.cache.put((Serializable)new MyKey("a"), (Object)"c");
        TestAbstractExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        this.cache.put((Serializable)new MyKey("d"), (Object)"c");
        TestAbstractExoCache.assertEquals((int)4, (int)this.cache.getCacheSize());
        this.cache.clearCache();
    }

    public void testClearCache() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        TestAbstractExoCache.assertTrue((this.cache.getCacheSize() > 0 ? 1 : 0) != 0);
        this.cache.clearCache();
        TestAbstractExoCache.assertTrue((this.cache.getCacheSize() == 0 ? 1 : 0) != 0);
        this.cache.clearCache();
    }

    public static class MyKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String value;

        public MyKey(String value) {
            this.value = value;
        }

        public boolean equals(Object paramObject) {
            return paramObject instanceof MyKey && ((MyKey)paramObject).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    public static class MyCacheListener
    implements CacheListener<Serializable, Object> {
        public int clearCache;
        public int expire;
        public int get;
        public int put;
        public int remove;

        public void onClearCache(CacheListenerContext context) throws Exception {
            ++this.clearCache;
        }

        public void onExpire(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.expire;
        }

        public void onGet(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.get;
        }

        public void onPut(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.put;
        }

        public void onRemove(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.remove;
        }
    }
}

