/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreatorPlugin;
import org.exoplatform.services.cache.impl.jboss.ExoCacheFactoryConfigPlugin;
import org.exoplatform.services.cache.impl.jboss.fifo.FIFOExoCacheCreator;
import org.exoplatform.services.log.ExoLogger;
import org.jboss.cache.Fqn;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;

public class ExoCacheFactoryImpl
implements ExoCacheFactory {
    private static final Log LOG = ExoLogger.getLogger(ExoCacheFactoryImpl.class);
    private static final String CACHE_CONFIG_TEMPLATE_KEY = "cache.config.template";
    private final ConfigurationManager configManager;
    private final String cacheConfigTemplate;
    private final Map<Class<? extends ExoCacheConfig>, ExoCacheCreator> mappingConfigTypeCreators = new HashMap<Class<? extends ExoCacheConfig>, ExoCacheCreator>();
    private final Map<String, ExoCacheCreator> mappingImplCreators = new HashMap<String, ExoCacheCreator>();
    private final Map<String, String> mappingCacheNameConfig = new HashMap<String, String>();
    private final ExoCacheCreator defaultCreator = new FIFOExoCacheCreator();

    public ExoCacheFactoryImpl(InitParams params, ConfigurationManager configManager) {
        this.configManager = configManager;
        this.cacheConfigTemplate = ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY);
        if (this.cacheConfigTemplate == null) {
            throw new RuntimeException("The parameter 'cache.config.template' must be set");
        }
    }

    public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
        ExoCache eXoCache;
        String region = config.getName();
        try {
            TreeCache cache = new TreeCache();
            PropertyConfigurator propertyConfigurator = new PropertyConfigurator();
            String customConfig = this.mappingCacheNameConfig.get(region);
            if (customConfig != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("A custom configuration has been set for the cache '" + region + "'."));
                }
                propertyConfigurator.configure((Object)cache, this.configManager.getInputStream(customConfig));
                cache.create();
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The configuration template will be used for the the cache '" + region + "'."));
                }
                propertyConfigurator.configure((Object)cache, this.configManager.getInputStream(this.cacheConfigTemplate));
                if (!config.isDistributed()) {
                    cache.setCacheMode(1);
                }
                cache.create();
                this.cleanConfigurationTemplate(cache, region);
            }
            ExoCacheCreator creator = this.getExoCacheCreator(config);
            eXoCache = creator.create(config, cache);
            cache.startService();
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The cache '" + region + "' could not be initialized", (Throwable)e);
        }
        return eXoCache;
    }

    public void addCreator(ExoCacheCreatorPlugin plugin) {
        List<ExoCacheCreator> creators = plugin.getCreators();
        for (ExoCacheCreator creator : creators) {
            this.mappingConfigTypeCreators.put(creator.getExpectedConfigType(), creator);
            this.mappingImplCreators.put(creator.getExpectedImplementation(), creator);
        }
    }

    public void addConfig(ExoCacheFactoryConfigPlugin plugin) {
        Map<String, String> configs = plugin.getConfigs();
        this.mappingCacheNameConfig.putAll(configs);
    }

    private static String getValueParam(InitParams params, String key) {
        String result;
        if (params == null) {
            return null;
        }
        ValueParam vp = params.getValueParam(key);
        if (vp == null || (result = vp.getValue()) == null || (result = result.trim()).length() == 0) {
            return null;
        }
        return result;
    }

    protected ExoCacheCreator getExoCacheCreator(ExoCacheConfig config) {
        ExoCacheCreator creator = this.mappingConfigTypeCreators.get(config.getClass());
        if (creator == null && (creator = this.mappingImplCreators.get(config.getImplementation())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No cache creator has been found for the the cache '" + config.getName() + "', the default one will be used."));
            }
            return this.defaultCreator;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The cache '" + config.getName() + "' will be created with '" + creator.getClass() + "'."));
        }
        return creator;
    }

    protected void cleanConfigurationTemplate(TreeCache cache, String sRegion) {
        String clusterName;
        RegionManager regionManager = cache.getEvictionRegionManager();
        Region[] regions = regionManager.getRegions();
        if (regions != null && regions.length > 0) {
            ArrayList<Fqn> fqns = new ArrayList<Fqn>(regions.length);
            for (Region region : regions) {
                fqns.add(region.getFqnObject());
            }
            for (Fqn fqn : fqns) {
                regionManager.removeRegion(fqn);
            }
        }
        if ((clusterName = cache.getClusterName()) != null && (clusterName = clusterName.trim()).length() > 0) {
            cache.setClusterName(clusterName + " " + sRegion);
        }
    }
}

