/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.lru;

import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.lru.LRUExoCacheConfig;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.RegionNameConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "LRU";
    protected int defaultMaxAgeSeconds;

    @Override
    public ExoCache create(ExoCacheConfig config, TreeCache cache) throws ExoCacheInitException {
        if (config instanceof LRUExoCacheConfig) {
            LRUExoCacheConfig lruConfig = (LRUExoCacheConfig)config;
            return this.create(config, cache, lruConfig.getMaxNodes(), lruConfig.getTimeToLiveSeconds(), lruConfig.getMaxAgeSeconds());
        }
        return this.create(config, cache, config.getMaxSize(), (int)config.getLiveTime(), this.defaultMaxAgeSeconds);
    }

    private ExoCache create(ExoCacheConfig config, TreeCache cache, int maxNodes, int timeToLiveSeconds, int maxAgeSeconds) throws ExoCacheInitException {
        RegionManager regionManager = cache.getEvictionRegionManager();
        LRUConfiguration lru = new LRUConfiguration();
        lru.setMaxNodes(maxNodes);
        lru.setTimeToLiveSeconds(timeToLiveSeconds);
        lru.setMaxAgeSeconds(maxAgeSeconds);
        LRUPolicy policy = new LRUPolicy();
        policy.configure(cache);
        try {
            regionManager.createRegion(RegionManager.DEFAULT_REGION, (EvictionPolicy)policy, (EvictionConfiguration)lru);
        }
        catch (RegionNameConflictException e) {
            throw new ExoCacheInitException("Cannot create the region", (Throwable)e);
        }
        return new LRUExoCache(config, cache, lru);
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return LRUExoCacheConfig.class;
    }

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    public static class LRUExoCache
    extends AbstractExoCache {
        private final LRUConfiguration lru;

        public LRUExoCache(ExoCacheConfig config, TreeCache cache, LRUConfiguration lru) {
            super(config, cache);
            this.lru = lru;
        }

        @ManagedName(value="TimeToLiveSeconds")
        @ManagedDescription(value="Time to idle (in seconds) before the node is swept away. 0 denotes no limit.")
        public long getLiveTime() {
            return this.lru.getTimeToLiveSeconds();
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes no limit.")
        public int getMaxSize() {
            return this.lru.getMaxNodes();
        }

        @Managed
        @ManagedName(value="MaxAgeSeconds")
        @ManagedDescription(value="Time an object should exist in TreeCache (in seconds) regardless of idle time before the node is swept away. 0 denotes no limit.")
        public int getMaxAge() {
            return this.lru.getMaxAgeSeconds();
        }

        public void setLiveTime(long timeToLiveSeconds) {
            this.lru.setTimeToLiveSeconds((int)timeToLiveSeconds);
        }

        public void setMaxSize(int max) {
            this.lru.setMaxNodes(max);
        }

        @Managed
        public void setMaxAge(int maxAgeSeconds) {
            this.lru.setMaxAgeSeconds(maxAgeSeconds);
        }
    }
}

