/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExoCache
implements ExoCache {
    private static final Log LOG = ExoLogger.getLogger(AbstractExoCache.class);
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private String label;
    private String name;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private final CopyOnWriteArrayList<CacheListener> listeners;
    protected final CacheSPI<Serializable, Object> cache;

    public AbstractExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache) {
        this.cache = (CacheSPI)cache;
        this.listeners = new CopyOnWriteArrayList();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
        cache.getConfiguration().setInvocationBatchingEnabled(true);
        cache.addCacheListener((Object)new CacheEventListener());
    }

    public void addCacheListener(CacheListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void clearCache() throws Exception {
        NodeSPI rootNode = this.cache.getRoot();
        for (Node node : rootNode.getChildren()) {
            if (node == null) continue;
            this.remove(this.getKey((Node<Serializable, Object>)node));
        }
        this.onClearCache();
    }

    public Object get(Serializable name) throws Exception {
        Object result = this.cache.get(this.getFqn(name), (Object)name);
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(name, result);
        return result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    public int getCacheSize() {
        return this.cache.getNumberOfNodes();
    }

    public List<Object> getCachedObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Node node : this.cache.getRoot().getChildren()) {
            Object value;
            if (node == null || (value = node.get((Object)this.getKey((Node<Serializable, Object>)node))) == null) continue;
            list.add(value);
        }
        return list;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(Serializable name, Object obj) throws Exception {
        this.putOnly(name, obj);
        this.onPut(name, obj);
    }

    private Object putOnly(Serializable name, Object obj) throws Exception {
        return this.cache.put(this.getFqn(name), (Object)name, obj);
    }

    public void putMap(Map<Serializable, Object> objs) throws Exception {
        this.cache.startBatch();
        int total = 0;
        try {
            for (Map.Entry<Serializable, Object> entry : objs.entrySet()) {
                Object value = this.putOnly(entry.getKey(), entry.getValue());
                if (value != null) continue;
                ++total;
            }
            this.cache.endBatch(true);
            for (Map.Entry<Serializable, Object> entry : objs.entrySet()) {
                this.onPut(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            this.cache.endBatch(false);
            throw e;
        }
    }

    public Object remove(Serializable name) throws Exception {
        Fqn<Serializable> fqn = this.getFqn(name);
        NodeSPI node = this.cache.getNode(fqn);
        Object result = null;
        if (node != null) {
            result = node.getDirect((Object)name);
            if (this.cache.removeNode(fqn)) {
                this.onRemove(name, result);
            }
        }
        return result;
    }

    public List<Object> removeCachedObjects() throws Exception {
        List<Object> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector selector) throws Exception {
        for (Node node : this.cache.getRoot().getChildren()) {
            Object value;
            ObjectCacheInfo info;
            Serializable key;
            if (node == null || !selector.select(key = this.getKey((Node<Serializable, Object>)node), info = new ObjectCacheInfo(value = node.get((Object)key)){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                public Object get() {
                    return this.val$value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    private Serializable getKey(Node<Serializable, Object> node) {
        return this.getKey(node.getFqn());
    }

    private Serializable getKey(Fqn fqn) {
        return (Serializable)fqn.get(0);
    }

    private Fqn<Serializable> getFqn(Serializable name) {
        return Fqn.fromElements((Object[])new Serializable[]{name});
    }

    void onExpire(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onExpire((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onRemove((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onPut((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onGet((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onClearCache((ExoCache)this);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @org.jboss.cache.notifications.annotation.CacheListener
    public class CacheEventListener {
        @NodeEvicted
        public void nodeEvicted(NodeEvent ne) {
            if (ne.isPre()) {
                AbstractExoCache.this.onExpire(AbstractExoCache.this.getKey(ne.getFqn()), null);
            }
        }

        @NodeRemoved
        public void nodeRemoved(NodeEvent ne) {
            if (ne.isPre() && !ne.isOriginLocal()) {
                NodeSPI node = AbstractExoCache.this.cache.getNode(ne.getFqn());
                Serializable key = AbstractExoCache.this.getKey(ne.getFqn());
                AbstractExoCache.this.onRemove(key, node.get((Object)key));
            }
        }

        @NodeModified
        public void nodeModified(NodeEvent ne) {
            if (!ne.isOriginLocal() && !ne.isPre()) {
                EventImpl evt;
                Map data;
                Serializable key = AbstractExoCache.this.getKey(ne.getFqn());
                if (ne instanceof EventImpl && (data = (evt = (EventImpl)ne).getData()) != null) {
                    AbstractExoCache.this.onPut(key, data.get(key));
                    return;
                }
                NodeSPI node = AbstractExoCache.this.cache.getNode(ne.getFqn());
                AbstractExoCache.this.onPut(key, node.get((Object)key));
            }
        }
    }
}

