/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreatorPlugin;
import org.exoplatform.services.cache.impl.jboss.ExoCacheFactoryConfigPlugin;
import org.exoplatform.services.cache.impl.jboss.fifo.FIFOExoCacheCreator;
import org.exoplatform.services.log.ExoLogger;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoCacheFactoryImpl
implements ExoCacheFactory {
    private static final Log LOG = ExoLogger.getLogger(ExoCacheFactoryImpl.class);
    private static final String CACHE_CONFIG_TEMPLATE_KEY = "cache.config.template";
    private final ConfigurationManager configManager;
    private final String cacheConfigTemplate;
    private final Map<Class<? extends ExoCacheConfig>, ExoCacheCreator> mappingConfigTypeCreators = new HashMap<Class<? extends ExoCacheConfig>, ExoCacheCreator>();
    private final Map<String, ExoCacheCreator> mappingImplCreators = new HashMap<String, ExoCacheCreator>();
    private final Map<String, String> mappingCacheNameConfig = new HashMap<String, String>();
    private final ExoCacheCreator defaultCreator = new FIFOExoCacheCreator();

    public ExoCacheFactoryImpl(InitParams params, ConfigurationManager configManager) {
        this.configManager = configManager;
        this.cacheConfigTemplate = ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY);
        if (this.cacheConfigTemplate == null) {
            throw new RuntimeException("The parameter 'cache.config.template' must be set");
        }
    }

    public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
        ExoCache eXoCache;
        String region = config.getName();
        String customConfig = this.mappingCacheNameConfig.get(region);
        DefaultCacheFactory factory = new DefaultCacheFactory();
        try {
            Cache cache;
            if (customConfig != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("A custom configuration has been set for the cache '" + region + "'."));
                }
                cache = factory.createCache(this.configManager.getInputStream(customConfig), false);
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The configuration template will be used for the the cache '" + region + "'."));
                }
                cache = factory.createCache(this.configManager.getInputStream(this.cacheConfigTemplate), false);
                if (!config.isDistributed()) {
                    cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
                }
                this.cleanConfigurationTemplate((Cache<Serializable, Object>)cache, region);
            }
            ExoCacheCreator creator = this.getExoCacheCreator(config);
            eXoCache = creator.create(config, (Cache<Serializable, Object>)cache);
            cache.create();
            cache.start();
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The cache '" + region + "' could not be initialized", (Throwable)e);
        }
        return eXoCache;
    }

    public void addCreator(ExoCacheCreatorPlugin plugin) {
        List<ExoCacheCreator> creators = plugin.getCreators();
        for (ExoCacheCreator creator : creators) {
            this.mappingConfigTypeCreators.put(creator.getExpectedConfigType(), creator);
            this.mappingImplCreators.put(creator.getExpectedImplementation(), creator);
        }
    }

    public void addConfig(ExoCacheFactoryConfigPlugin plugin) {
        Map<String, String> configs = plugin.getConfigs();
        this.mappingCacheNameConfig.putAll(configs);
    }

    private static String getValueParam(InitParams params, String key) {
        String result;
        if (params == null) {
            return null;
        }
        ValueParam vp = params.getValueParam(key);
        if (vp == null || (result = vp.getValue()) == null || (result = result.trim()).length() == 0) {
            return null;
        }
        return result;
    }

    protected ExoCacheCreator getExoCacheCreator(ExoCacheConfig config) {
        ExoCacheCreator creator = this.mappingConfigTypeCreators.get(config.getClass());
        if (creator == null && (creator = this.mappingImplCreators.get(config.getImplementation())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No cache creator has been found for the the cache '" + config.getName() + "', the default one will be used."));
            }
            return this.defaultCreator;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The cache '" + config.getName() + "' will be created with '" + creator.getClass() + "'."));
        }
        return creator;
    }

    protected void cleanConfigurationTemplate(Cache<Serializable, Object> cache, String region) {
        Configuration config = cache.getConfiguration();
        EvictionConfig evictionConfig = config.getEvictionConfig();
        if (evictionConfig == null) {
            evictionConfig = new EvictionConfig();
            config.setEvictionConfig(evictionConfig);
        }
        evictionConfig.setEvictionRegionConfigs(new LinkedList());
        String clusterName = config.getClusterName();
        if (clusterName != null && (clusterName = clusterName.trim()).length() > 0) {
            config.setClusterName(clusterName + " " + region);
        }
    }
}

