/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.spring;

import java.lang.annotation.Annotation;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.AbstractComponentAdapter;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.spring.ApplicationContextProvider;
import org.exoplatform.container.xml.Component;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class SpringContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = -4841328894117928913L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ext.provider.impl.spring.v3.SpringContainer");
    private ApplicationContext ctx;

    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        Object result = super.getComponentInstance(componentKey, bindType, autoRegistration);
        if (this.ctx != null && result == null) {
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                return bindType.cast(this.getInstanceOfType((Class)componentKey));
            }
            if (!(componentKey instanceof String) && !(componentKey instanceof Class)) {
                return null;
            }
            String beanName = SpringContainer.keyToBeanName(componentKey);
            if (this.ctx.containsBean(beanName) && bindType.isAssignableFrom(this.ctx.getType(beanName))) {
                return bindType.cast(this.ctx.getBean(beanName));
            }
            String[] names = this.ctx.getBeanNamesForType(bindType);
            if (names != null && names.length > 0) {
                for (String name : names) {
                    Annotation a;
                    Named n;
                    if (!(componentKey instanceof String ? (n = (Named)this.ctx.findAnnotationOnBean(name, Named.class)) != null && componentKey.equals(n.value()) : (a = this.ctx.findAnnotationOnBean(name, (Class)componentKey)) != null)) continue;
                    return bindType.cast(this.ctx.getBean(name));
                }
            }
        }
        return (T)result;
    }

    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        Object result = super.getComponentInstanceOfType(componentType, autoRegistration);
        if (this.ctx != null && result == null) {
            result = this.getInstanceOfType(componentType);
        }
        return (T)result;
    }

    private <T> T getInstanceOfType(final Class<T> componentType) {
        PrivilegedAction action = new PrivilegedAction<T>(){

            @Override
            public T run() {
                String name = SpringContainer.classToBeanName(componentType);
                if (SpringContainer.this.ctx.containsBean(name) && componentType.isAssignableFrom(SpringContainer.this.ctx.getType(name))) {
                    return componentType.cast(SpringContainer.this.ctx.getBean(name));
                }
                String[] names = SpringContainer.this.ctx.getBeanNamesForType(componentType);
                if (names != null && names.length > 0) {
                    return componentType.cast(SpringContainer.this.ctx.getBean(names[0]));
                }
                return null;
            }
        };
        Object result = SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        return (T)result;
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        ComponentAdapter result = super.getComponentAdapter(componentKey, bindType, autoRegistration);
        if (this.ctx != null && result == null) {
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                return this.getAdapterOfType(bindType);
            }
            if (!(componentKey instanceof String) && !(componentKey instanceof Class)) {
                return null;
            }
            String beanName = SpringContainer.keyToBeanName(componentKey);
            if (this.ctx.containsBean(beanName) && bindType.isAssignableFrom(this.ctx.getType(beanName))) {
                return this.createComponentAdapter(bindType, beanName);
            }
            String[] names = this.ctx.getBeanNamesForType(bindType);
            if (names != null && names.length > 0) {
                for (String name : names) {
                    Annotation a;
                    Named n;
                    if (!(componentKey instanceof String ? (n = (Named)this.ctx.findAnnotationOnBean(name, Named.class)) != null && componentKey.equals(n.value()) : (a = this.ctx.findAnnotationOnBean(name, (Class)componentKey)) != null)) continue;
                    return this.createComponentAdapter(bindType, name);
                }
            }
        }
        return result;
    }

    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> result = super.getComponentAdapterOfType(componentType, autoRegistration);
        if (this.ctx != null && result == null) {
            result = this.getAdapterOfType(componentType);
        }
        return result;
    }

    private <T> ComponentAdapter<T> getAdapterOfType(Class<T> componentType) {
        String name = SpringContainer.classToBeanName(componentType);
        if (this.ctx.containsBean(name) && componentType.isAssignableFrom(this.ctx.getType(name))) {
            return this.createComponentAdapter(componentType, name);
        }
        String[] names = this.ctx.getBeanNamesForType(componentType);
        if (names != null && names.length > 0) {
            return this.createComponentAdapter(componentType, names[0]);
        }
        return null;
    }

    private <T> ComponentAdapter<T> createComponentAdapter(final Class<T> type, final String name) {
        return new AbstractComponentAdapter<T>(type, type){
            private static final long serialVersionUID = -4625398501079851570L;

            public T getComponentInstance() throws ContainerException {
                return type.cast(SpringContainer.this.ctx.getBean(name));
            }

            public boolean isSingleton() {
                return SpringContainer.this.ctx.isSingleton(name);
            }
        };
    }

    public <T> List<ComponentAdapter<T>> getComponentAdaptersOfType(Class<T> componentType) {
        ArrayList<ComponentAdapter<T>> result = super.getComponentAdaptersOfType(componentType);
        if (this.ctx != null) {
            result = new ArrayList<ComponentAdapter<T>>(result);
            String[] names = this.ctx.getBeanNamesForType(componentType);
            if (names != null) {
                for (String name : names) {
                    result.add(this.createComponentAdapter(this.ctx.getType(name), name));
                }
            }
        }
        return result;
    }

    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) throws ContainerException {
        ArrayList result = super.getComponentInstancesOfType(componentType);
        if (this.ctx != null) {
            result = new ArrayList(result);
            result.addAll(this.ctx.getBeansOfType(componentType).values());
        }
        return result;
    }

    public void start() {
        ConfigurationManager cm = (ConfigurationManager)super.getComponentInstanceOfType(ConfigurationManager.class, false);
        Component component = cm.getComponent(ApplicationContextProvider.class);
        if (component == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No ApplicationContextProvider has been defined, thus the SpringContainer will be disabled. To enable the Spring Integration please define an ApplicationContextProvider");
            }
        } else {
            DefaultListableBeanFactory bf = new DefaultListableBeanFactory();
            bf.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
            Collection adapters = this.delegate.getComponentAdapters();
            for (ComponentAdapter adapter : adapters) {
                Object key = adapter.getComponentKey();
                String name = SpringContainer.keyToBeanName(key);
                String factoryName = name + "#factory";
                RootBeanDefinition def = new RootBeanDefinition(adapter.getComponentImplementation(), 0, false);
                def.setScope("prototype");
                def.setFactoryBeanName(factoryName);
                def.setFactoryMethodName("getInstance");
                def.setLazyInit(true);
                def.setTargetType(adapter.getComponentImplementation());
                if (key instanceof String) {
                    def.addQualifier(new AutowireCandidateQualifier(Named.class, key));
                } else if (key instanceof Class && ((Class)key).isAnnotation()) {
                    def.addQualifier(new AutowireCandidateQualifier((Class)key));
                } else {
                    def.setPrimary(true);
                }
                bf.registerBeanDefinition(name, (BeanDefinition)def);
                bf.registerSingleton(factoryName, new ComponentAdapterFactoryBean(adapter));
            }
            GenericApplicationContext parentContext = new GenericApplicationContext(bf);
            parentContext.refresh();
            ApplicationContextProvider provider = (ApplicationContextProvider)super.getComponentInstanceOfType(ApplicationContextProvider.class, false);
            this.ctx = provider.getApplicationContext((ApplicationContext)parentContext);
            LOG.info((Object)("A SpringContainer has been enabled using the ApplicationContextProvider " + provider.getClass()));
        }
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.ctx instanceof DisposableBean) {
            try {
                ((DisposableBean)this.ctx).destroy();
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not destroy the container: " + e.getMessage()));
            }
            finally {
                this.ctx = null;
            }
        }
    }

    private static String classToBeanName(Class<?> type) {
        return type.getName();
    }

    private static String keyToBeanName(Object key) {
        if (key instanceof Class) {
            return SpringContainer.classToBeanName((Class)key);
        }
        if (key instanceof String) {
            return (String)key;
        }
        return SpringContainer.classToBeanName(key.getClass());
    }

    public String getId() {
        return "SpringIntegration";
    }

    static class ComponentAdapterFactoryBean<T> {
        private final ComponentAdapter<T> adapter;

        private ComponentAdapterFactoryBean(ComponentAdapter<T> adapter) {
            this.adapter = adapter;
        }

        public T getInstance() throws Exception {
            return (T)this.adapter.getComponentInstance();
        }
    }
}

