/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.picocontainer.Startable;

public class MBeanServerProvider
implements Startable {
    private static final Log LOG = LogFactory.getLog(ExoContainer.class);
    private static final String PROTOCOL_PARAM_NAME = "protocol";
    private static final String HOST_PARAM_NAME = "host";
    private static final String PORT_PARAM_NAME = "port";
    private static final String PATH_PREFIX_PARAM_NAME = "path-prefix";
    private static final String NAME_SEPARATOR_PARAM_NAME = "name-separator";
    private static final String ENVIRONMENT_PARAM_NAME = "environment";
    private static final Pattern WC_DOMAIN_NAME_PATTERN = Pattern.compile("jcrws(.*)at(.*)mx");
    private static final Pattern RC_DOMAIN_NAME_PATTERN = Pattern.compile("jcrrep(.*)mx");
    private String protocol;
    private String host;
    private int port;
    private String path_prefix;
    private String name_separator;
    private Map<String, ?> environment;
    private static final List<JMXConnectorServer> SERVERS = new ArrayList<JMXConnectorServer>();

    public MBeanServerProvider(InitParams params) {
        if (params == null) {
            LOG.error((Object)"The protocol has not been defined");
        } else {
            ValueParam parameter = params.getValueParam(PROTOCOL_PARAM_NAME);
            if (parameter == null) {
                LOG.error((Object)"The protocol has not been defined");
            } else {
                this.protocol = parameter.getValue();
                this.host = this.getValue(params, HOST_PARAM_NAME);
                String sPort = this.getValue(params, PORT_PARAM_NAME);
                if (sPort != null && sPort.length() > 0) {
                    try {
                        this.port = Integer.valueOf(sPort);
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Object)"The port has not been defined properly", (Throwable)e);
                    }
                }
                this.path_prefix = this.getValue(params, PATH_PREFIX_PARAM_NAME);
                this.name_separator = this.getValue(params, NAME_SEPARATOR_PARAM_NAME);
                PropertiesParam properties = params.getPropertiesParam(ENVIRONMENT_PARAM_NAME);
                this.environment = properties == null ? null : properties.getProperties();
            }
        }
    }

    private String getValue(InitParams params, String paramName) {
        ValueParam parameter = params.getValueParam(paramName);
        return parameter == null ? null : parameter.getValue();
    }

    public void start() {
        if (this.protocol == null) {
            return;
        }
        this.bind(ExoContainerContext.getTopContainer());
        this.bind(ExoContainerContext.getCurrentContainer());
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            this.bind(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<JMXConnectorServer> list = SERVERS;
        synchronized (list) {
            for (JMXConnectorServer server : SERVERS) {
                try {
                    server.stop();
                }
                catch (IOException e) {
                    LOG.error((Object)("The server " + server.getMBeanServer().getDefaultDomain() + " could not be stopped"), (Throwable)e);
                }
            }
            SERVERS.clear();
        }
    }

    private String getURL(ExoContainer container) {
        StringBuffer result = this.getURLPrefix();
        result.append(this.getContainerPath(container));
        return result.toString();
    }

    private String getURL(MBeanServer mbServer) {
        String path = this.getMBeanServerPath(mbServer);
        if (path == null) {
            return null;
        }
        StringBuffer result = this.getURLPrefix();
        result.append(path);
        return result.toString();
    }

    private StringBuffer getURLPrefix() {
        StringBuffer result = new StringBuffer(128);
        result.append("service:jmx:");
        result.append(this.protocol);
        result.append("://");
        if (this.host != null) {
            result.append(this.host);
            if (this.port > 0) {
                result.append(':');
                result.append(this.port);
            }
        }
        result.append('/');
        if (this.path_prefix != null) {
            result.append(this.path_prefix);
        }
        return result;
    }

    private String getContainerPath(ExoContainer container) {
        if (container instanceof RootContainer || container instanceof StandaloneContainer) {
            return "root";
        }
        if (container instanceof PortalContainer) {
            return "root" + this.name_separator + container.getContext().getName();
        }
        throw new RuntimeException("Container of type " + container.getClass() + " not supported");
    }

    private String getMBeanServerPath(MBeanServer mbServer) {
        String domain = mbServer.getDefaultDomain();
        if (domain != null) {
            Matcher matcher = WC_DOMAIN_NAME_PATTERN.matcher(domain);
            if (matcher.find()) {
                return this.getContainerPath(ExoContainerContext.getCurrentContainer()) + this.name_separator + matcher.group(2) + this.name_separator + matcher.group(1);
            }
            matcher = RC_DOMAIN_NAME_PATTERN.matcher(domain);
            if (matcher.find()) {
                return this.getContainerPath(ExoContainerContext.getCurrentContainer()) + this.name_separator + matcher.group(1);
            }
        }
        return null;
    }

    private void bind(ExoContainer container) {
        String url = this.getURL(container);
        this.bind(container.getMBeanServer(), url);
    }

    private void bind(MBeanServer server) {
        String url = this.getURL(server);
        if (url == null) {
            return;
        }
        this.bind(server, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(MBeanServer server, String url) {
        if (this.isBound(server)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The server " + server.getDefaultDomain() + " has already been bound"));
            }
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Defining the server " + server.getDefaultDomain() + " at " + url));
        }
        try {
            JMXServiceURL address = new JMXServiceURL(url);
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(address, this.environment, server);
            cs.start();
            List<JMXConnectorServer> list = SERVERS;
            synchronized (list) {
                SERVERS.add(cs);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("The server " + server.getDefaultDomain() + " could not be started"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound(MBeanServer mbServer) {
        List<JMXConnectorServer> list = SERVERS;
        synchronized (list) {
            for (JMXConnectorServer server : SERVERS) {
                if (server.getMBeanServer() != mbServer) continue;
                return true;
            }
            return false;
        }
    }
}

