/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.exoplatform.commons.reflect.AnnotationIntrospector;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;

public class ExoMBeanInfoBuilder {
    private Class clazz;
    private boolean buildable;

    public ExoMBeanInfoBuilder(Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Managed mb = (Managed)AnnotationIntrospector.resolveClassAnnotations((Class)clazz, Managed.class);
        this.clazz = clazz;
        this.buildable = mb != null;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public ModelMBeanInfo build() throws IllegalStateException {
        if (!this.buildable) {
            throw new IllegalStateException("Class " + this.clazz.getName() + " does not contain management annotation");
        }
        ManagedDescription mbeanManagedDescription = (ManagedDescription)AnnotationIntrospector.resolveClassAnnotations((Class)this.clazz, ManagedDescription.class);
        String mbeanDescription = "Exo model mbean";
        if (mbeanManagedDescription != null) {
            mbeanDescription = mbeanManagedDescription.value();
        }
        Map managedMethods = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, Managed.class);
        Map methodNames = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, ManagedName.class);
        Map methodDescriptions = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, ManagedDescription.class);
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap getters = new HashMap();
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        for (Map.Entry entry : managedMethods.entrySet()) {
            Method method = (Method)entry.getKey();
            String operationDescription = "Management operation";
            ManagedDescription operationManagedDescription = (ManagedDescription)methodDescriptions.get(method);
            if (operationManagedDescription != null) {
                operationDescription = operationManagedDescription.value();
            }
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type type = Type.OP;
            Integer index = null;
            if (method.getReturnType() == Void.TYPE) {
                if (parameterTypes.length == 1 && methodName.startsWith("set") && methodName.length() > 4) {
                    type = Type.SET;
                    index = 3;
                }
            } else if (parameterTypes.length == 0) {
                if (methodName.startsWith("get") && methodName.length() > 3) {
                    type = Type.GET;
                    index = 3;
                } else if (methodName.startsWith("is") && methodName.length() > 2) {
                    type = Type.IS;
                    index = 2;
                }
            }
            if (index != null) {
                String attributeName;
                HashMap<String, Method> map = type == Type.SET ? setters : getters;
                Method previous = map.put(attributeName = methodName.substring(index), method);
                if (previous != null) {
                    throw new IllegalArgumentException("Duplicate attribute " + type.role + " " + previous + " and " + method);
                }
            } else {
                ManagedName managedName = (ManagedName)methodNames.get(method);
                if (managedName != null) {
                    throw new IllegalArgumentException("Managed operation " + method.getName() + " cannot be annoated with @" + ManagedName.class.getName() + " with value " + managedName.value());
                }
            }
            ModelMBeanOperationInfo operationInfo = new ModelMBeanOperationInfo(operationDescription, method);
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            MBeanParameterInfo[] parameterInfos = operationInfo.getSignature();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                MBeanParameterInfo parameterInfo = parameterInfos[i];
                String parameterName = parameterInfo.getName();
                String parameterDescription = operationInfo.getSignature()[i].getDescription();
                for (Annotation parameterAnnotation : parameterAnnotations[i]) {
                    if (parameterAnnotation instanceof ManagedName) {
                        parameterName = ((ManagedName)parameterAnnotation).value();
                        continue;
                    }
                    if (!(parameterAnnotation instanceof ManagedDescription)) continue;
                    parameterDescription = ((ManagedDescription)parameterAnnotation).value();
                }
                parameterInfos[i] = new MBeanParameterInfo(parameterName, parameterInfo.getType(), parameterDescription);
            }
            Descriptor operationDescriptor = operationInfo.getDescriptor();
            operationDescriptor.setField("role", type.role);
            operationInfo = new ModelMBeanOperationInfo(operationInfo.getName(), operationDescription, parameterInfos, operationInfo.getReturnType(), operationInfo.getImpact(), operationDescriptor);
            operations.add(operationInfo);
        }
        HashMap<String, ModelMBeanAttributeInfo> attributeInfos = new HashMap<String, ModelMBeanAttributeInfo>();
        HashSet attributeNames = new HashSet();
        attributeNames.addAll(getters.keySet());
        attributeNames.addAll(setters.keySet());
        for (String attributeName : attributeNames) {
            Method getter = (Method)getters.get(attributeName);
            Method setter = (Method)setters.get(attributeName);
            ManagedDescription managedAttributeDescription = null;
            ManagedName getterName = null;
            ManagedName setterName = null;
            if (getter != null) {
                getterName = (ManagedName)methodNames.get(getter);
                managedAttributeDescription = (ManagedDescription)methodDescriptions.get(getter);
            }
            if (setter != null) {
                setterName = (ManagedName)methodNames.get(setter);
                if (managedAttributeDescription == null) {
                    managedAttributeDescription = (ManagedDescription)methodDescriptions.get(setter);
                }
            }
            if (getterName != null) {
                if (setterName != null && !getterName.value().equals(setterName.value())) {
                    throw new IllegalArgumentException();
                }
                attributeName = getterName.value();
            } else if (setterName != null) {
                attributeName = setterName.value();
            }
            try {
                String attributeDescription = managedAttributeDescription != null ? managedAttributeDescription.value() : "Managed attribute " + attributeName;
                ModelMBeanAttributeInfo attributeInfo = new ModelMBeanAttributeInfo(attributeName, attributeDescription, getter, setter);
                Descriptor attributeDescriptor = attributeInfo.getDescriptor();
                if (getter != null) {
                    attributeDescriptor.setField("getMethod", getter.getName());
                }
                if (setter != null) {
                    attributeDescriptor.setField("setMethod", setter.getName());
                }
                attributeDescriptor.setField("currencyTimeLimit", "-1");
                attributeDescriptor.setField("persistPolicy", "Never");
                attributeInfo.setDescriptor(attributeDescriptor);
                ModelMBeanAttributeInfo previous = attributeInfos.put(attributeName, attributeInfo);
                if (previous == null) continue;
                throw new IllegalArgumentException();
            }
            catch (IntrospectionException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new ModelMBeanInfoSupport(this.clazz.getName(), mbeanDescription, attributeInfos.values().toArray(new ModelMBeanAttributeInfo[attributeInfos.size()]), new ModelMBeanConstructorInfo[0], operations.toArray(new ModelMBeanOperationInfo[operations.size()]), new ModelMBeanNotificationInfo[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SET("setter"),
        IS("getter"),
        GET("getter"),
        OP("operation");

        private final String role;

        private Type(String role) {
            this.role = role;
        }
    }
}

