/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.container.jmx.PropertiesInfo;
import org.exoplatform.container.jmx.PropertyInfo;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.jmx.annotations.NamingContext;

public class ExoModelMBean
extends RequiredModelMBean
implements ManagementContext {
    private Object mr;
    private ManagementContextImpl parentContext;
    private ManagementContextImpl context;

    public ExoModelMBean(ManagementContextImpl parentContext, Object mr, ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        super(mbi);
        this.parentContext = parentContext;
        this.mr = mr;
        this.setManagedResource(mr, "ObjectReference");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        name = super.preRegister(server, name);
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preRegister(server, name);
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        PropertiesInfo info = PropertiesInfo.resolve(this.mr.getClass(), NamingContext.class);
        HashMap<String, String> scopingProperties = new HashMap<String, String>();
        if (info != null) {
            for (PropertyInfo property : info.getProperties()) {
                scopingProperties.put(property.getKey(), property.resolveValue(this.mr));
            }
        }
        this.context = new ManagementContextImpl(this.parentContext, scopingProperties);
        if (this.mr instanceof ManagementAware) {
            ((ManagementAware)this.mr).setContext(this);
        }
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postRegister(registrationDone);
        }
    }

    public void preDeregister() throws Exception {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).preDeregister();
        }
        if (this.mr instanceof ManagementAware) {
            ((ManagementAware)this.mr).setContext(null);
        }
        super.preDeregister();
    }

    public void postDeregister() {
        if (this.mr instanceof MBeanRegistration) {
            ((MBeanRegistration)this.mr).postDeregister();
        }
        super.postDeregister();
    }

    public Object getManagedResource() {
        return this.mr;
    }

    public void register(Object o) throws IllegalArgumentException, NullPointerException {
        this.context.register(o);
    }

    public void unregister(Object o) throws IllegalArgumentException, NullPointerException {
        this.context.unregister(o);
    }
}

