/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.jmx.ExoContainerMBean;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoContainer
extends CachingContainer {
    private static final Log LOG = LogFactory.getLog(ExoContainer.class);
    private static final String DEFAULT_DOMAIN = "component";
    private static final String DEFAULT_DOMAIN_PREFIX = "eXo.";
    private static final String USE_EXISTING_SERVER_PARAM = "org.exoplatform.container.jmx.useExistingServer";
    private static final String FIND_EXISTING_SERVER_PARAM = "org.exoplatform.container.jmx.findExistingServer";
    private static final String FIND_EXISTING_SERVER_FROM_DEFAULT_DOMAIN_PARAM = "org.exoplatform.container.jmx.findExistingServerFromDefaultDomain";
    private static final boolean USE_EXISTING_SERVER = System.getProperty("org.exoplatform.container.jmx.useExistingServer") != null;
    private static volatile MBeanServer EXISTING_MBEAN_SERVER;
    private final Map<String, ComponentLifecyclePlugin> componentLifecylePlugin_ = new HashMap<String, ComponentLifecyclePlugin>();
    private final List<ContainerLifecyclePlugin> containerLifecyclePlugin_ = new ArrayList<ContainerLifecyclePlugin>();
    protected final ExoContainerContext context = new ExoContainerContext(this);

    public ExoContainer(PicoContainer parent) {
        super(parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
    }

    public ExoContainer(ComponentAdapterFactory factory, PicoContainer parent) {
        super(factory, parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
    }

    public ExoContainerContext getContext() {
        return this.context;
    }

    public void initContainer() throws Exception {
        ConfigurationManager manager = (ConfigurationManager)this.getComponentInstanceOfType(ConfigurationManager.class);
        ContainerUtil.addContainerLifecyclePlugin(this, manager);
        ContainerUtil.addComponentLifecyclePlugin(this, manager);
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.initContainer(this);
        }
        ContainerUtil.addComponents(this, manager);
    }

    public void startContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.startContainer(this);
        }
    }

    public void stopContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.stopContainer(this);
        }
    }

    public void destroyContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.destroyContainer(this);
        }
    }

    public MBeanServer getMBeanServer() {
        throw new UnsupportedOperationException("This container do not support jmx management");
    }

    private MBeanServer getExistingServer() {
        String agentId = System.getProperty(FIND_EXISTING_SERVER_PARAM);
        if (agentId != null) {
            if (agentId.length() == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"No agent id has been given to retrieve the local MBean server.");
                }
                agentId = null;
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to retrieve the local MBean server with agent id '" + agentId + "'."));
            }
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
            if (servers != null && servers.size() > 0) {
                String domain = System.getProperty(FIND_EXISTING_SERVER_FROM_DEFAULT_DOMAIN_PARAM);
                if (domain == null) {
                    if (servers.size() > 1) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("More than one MBean server has been found" + (agentId != null ? " (Agent Id: " + agentId + ")" : "") + ", the first MBean server will be used."));
                        }
                        for (MBeanServer server : servers) {
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info((Object)("Local MBean server default domain name '" + server.getDefaultDomain() + "'."));
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("The default domain name of the selected MBean server is '" + servers.get(0).getDefaultDomain() + "'."));
                    }
                    return servers.get(0);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Trying to retrieve the local MBean server with default domain name '" + domain + "'."));
                }
                for (MBeanServer server : servers) {
                    if (!domain.equals(server.getDefaultDomain())) continue;
                    return server;
                }
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"No MBean server has been found with the given criteria, the platform MBean server will be used");
            }
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected MBeanServer createMBeanServer(String domain) {
        if (USE_EXISTING_SERVER) {
            return null;
        }
        return MBeanServerFactory.createMBeanServer(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MBeanServer getCurrentMBeanServer() {
        if (!USE_EXISTING_SERVER) return this.getMBeanServer();
        MBeanServer server = EXISTING_MBEAN_SERVER;
        if (server != null) return EXISTING_MBEAN_SERVER;
        Class<ExoContainer> clazz = ExoContainer.class;
        synchronized (ExoContainer.class) {
            server = EXISTING_MBEAN_SERVER;
            if (server != null) return EXISTING_MBEAN_SERVER;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"An existing MBean server will be used.");
            }
            EXISTING_MBEAN_SERVER = this.getExistingServer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return EXISTING_MBEAN_SERVER;
        }
    }

    public String getMBeanContext() {
        return null;
    }

    public void addComponentLifecylePlugin(ComponentLifecyclePlugin plugin) {
        List<String> list = plugin.getManageableComponents();
        for (String component : list) {
            this.componentLifecylePlugin_.put(component, plugin);
        }
    }

    public void addContainerLifecylePlugin(ContainerLifecyclePlugin plugin) {
        this.containerLifecyclePlugin_.add(plugin);
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public <T> T createComponent(Class<T> clazz, InitParams params) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(clazz.getName() + " " + (params != null ? params : "") + " added to " + this.getContext().getName()));
        }
        Constructor<?>[] constructors = ContainerUtil.getSortedConstructors(clazz);
        Class<?> unknownParameter = null;
        for (int k = 0; k < constructors.length; ++k) {
            Constructor<?> constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean satisfied = true;
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) {
                    args[i] = params;
                    continue;
                }
                args[i] = this.getComponentInstanceOfType(parameters[i]);
                if (args[i] != null) continue;
                satisfied = false;
                unknownParameter = parameters[i];
                break;
            }
            if (!satisfied) continue;
            return clazz.cast(constructor.newInstance(args));
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz + " with parameter " + unknownParameter);
    }

    @Override
    public synchronized ComponentAdapter unregisterComponent(Object componentKey) {
        this.unregisterMBean(componentKey);
        return super.unregisterComponent(componentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMBean(Object key) {
        MBeanServer mbeanServer;
        String componentKey = null;
        if (key instanceof String) {
            componentKey = (String)key;
        } else if (key instanceof Class) {
            componentKey = ((Class)key).getName();
        } else {
            return;
        }
        ObjectName name = null;
        MBeanServer mBeanServer = mbeanServer = this.getCurrentMBeanServer();
        synchronized (mBeanServer) {
            block9: {
                try {
                    name = this.asObjectName(null, componentKey);
                    mbeanServer.unregisterMBean(name);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block9;
                    LOG.warn((Object)("The MBean '" + name + "' could not be unregistered."), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageMBean(Component component, String componentKey, Object bean) {
        ObjectName name = null;
        MBeanServer mbeanServer = this.getCurrentMBeanServer();
        ExoContainerMBean mbean = null;
        MBeanServer mBeanServer = mbeanServer;
        synchronized (mBeanServer) {
            try {
                name = this.asObjectName(component, componentKey);
                mbean = new ExoContainerMBean(bean);
                if (mbean.canBeMonitored()) {
                    mbeanServer.registerMBean(mbean, name);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The MBean '" + name + "' cannot be monitored since there is nothing to monitor."));
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("The MBean '" + name + "' has already been registered."), (Throwable)e);
                }
                try {
                    mbeanServer.unregisterMBean(name);
                    mbeanServer.registerMBean(mbean, name);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
            }
        }
    }

    private ObjectName asObjectName(Component component, String componentKey) throws MalformedObjectNameException {
        String domainPrefix;
        String mbeanContext;
        String name = null;
        if (component != null) {
            name = component.getJMXName();
        }
        if (USE_EXISTING_SERVER) {
            mbeanContext = this.getMBeanContext();
            domainPrefix = DEFAULT_DOMAIN_PREFIX;
        } else {
            mbeanContext = "";
            domainPrefix = "";
        }
        if (mbeanContext == null) {
            mbeanContext = "";
        } else if (mbeanContext.length() > 0) {
            mbeanContext = "," + mbeanContext;
        }
        if (name == null || name.indexOf(61) == -1 || name.indexOf(58) == -1) {
            name = "component:type=" + componentKey;
        }
        return new ObjectName(domainPrefix + name + mbeanContext);
    }

    public void printMBeanServer() {
        MBeanServer server = this.getCurrentMBeanServer();
        Set<ObjectName> names = server.queryNames(null, null);
        for (ObjectName name : names) {
            try {
                MBeanInfo info = server.getMBeanInfo(name);
                MBeanAttributeInfo[] attrs = info.getAttributes();
                if (attrs == null) continue;
                for (int j = 0; j < attrs.length; ++j) {
                    if (!attrs[j].isReadable()) continue;
                    try {
                        Object o = server.getAttribute(name, attrs[j].getName());
                        continue;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                MBeanOperationInfo[] methods = info.getOperations();
                for (int j = 0; j < methods.length; ++j) {
                    MBeanParameterInfo[] params = methods[j].getSignature();
                    for (int k = 0; k < params.length; ++k) {
                    }
                }
            }
            catch (Exception x) {
            }
        }
    }
}

