/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.mc;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.exoplatform.container.mc.MCIntegration;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;

public class MCIntegrationInvoker {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.MCIntegrationInvoker");
    private static volatile MCIntegration mcInt;
    private static volatile boolean permFailure;

    public static synchronized ComponentAdapter getMCAdapter(ComponentAdapter componentAdapter) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return componentAdapter;
        }
        return mcInt.getMCAdapter(componentAdapter);
    }

    public static synchronized boolean hasMCKernel(ComponentAdapter adapter) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return false;
        }
        return mcInt.hasMCKernel(adapter);
    }

    public static synchronized void initThreadCtx(ServletContext ctx) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return;
        }
        mcInt.initThreadCtx(ctx);
    }

    public static synchronized void resetThreadCtx(ServletContext ctx) {
        MCIntegration mcInt = MCIntegrationInvoker.getMCIntegration();
        if (mcInt == null) {
            return;
        }
        mcInt.resetThreadCtx(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MCIntegration getMCIntegration() {
        if (mcInt != null || permFailure) return mcInt;
        Class<MCIntegrationInvoker> clazz = MCIntegrationInvoker.class;
        synchronized (MCIntegrationInvoker.class) {
            if (mcInt != null || permFailure) return mcInt;
            Class clazz2 = null;
            try {
                clazz2 = MCIntegrationInvoker.loadClass("org.exoplatform.container.mc.impl.MCIntegrationImpl");
                Method m = clazz2.getMethod("getInstance", new Class[0]);
                mcInt = (MCIntegration)m.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException ignored) {
                permFailure = true;
                LOG.debug((Object)("MC integration not available in this environment (missing class: " + ignored.getMessage() + ")"));
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            catch (Exception e) {
                permFailure = true;
                throw new RuntimeException("MC Integration initialization error", e);
            }
            return mcInt;
        }
    }

    static Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                clazz = cl.loadClass(name);
            }
        }
        catch (ClassNotFoundException ignored) {
            clazz = Class.forName(name);
        }
        return clazz;
    }
}

