/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.management.ManagementContextImpl;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.jmx.impl.JMX;
import org.exoplatform.management.jmx.impl.JMXManagementProvider;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageableContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = 5573000068005815688L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ManageableContainer");
    ManagementContextImpl managementContext;
    private MBeanServer server;
    private volatile boolean objectNameSet;
    private ObjectName objectName;
    private final Set<ManagementProvider> providers = new CopyOnWriteArraySet<ManagementProvider>();

    private static MBeanServer findMBeanServer() {
        J2EEServerInfo serverenv_ = new J2EEServerInfo();
        return serverenv_.getMBeanServer();
    }

    public ManageableContainer() {
    }

    public ManageableContainer(ExoContainer holder, ExoContainer parent) {
        this.setHolder(holder);
        this.setParent(parent);
    }

    @Override
    public void setParent(ExoContainer parent) {
        this.parent = parent;
        ManagementContextImpl parentCtx = null;
        if (parent != null) {
            parentCtx = (ManagementContextImpl)parent.getManagementContext();
        }
        if (parentCtx != null) {
            this.server = parentCtx.container.server;
            this.managementContext = new ManagementContextImpl(parentCtx, this);
        } else {
            this.server = ManageableContainer.findMBeanServer();
            this.managementContext = new ManagementContextImpl(this);
            this.addProvider(new JMXManagementProvider(this.server));
        }
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    @Override
    public final MBeanServer getMBeanServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName getScopingObjectName() {
        if (!this.objectNameSet) {
            ManageableContainer manageableContainer = this;
            synchronized (manageableContainer) {
                if (!this.objectNameSet) {
                    LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                    List<MBeanScopingData> list = this.managementContext.getScopingData(MBeanScopingData.class);
                    if (list != null && !list.isEmpty()) {
                        for (int i = list.size(); i > 0; --i) {
                            MBeanScopingData scopingData = list.get(i - 1);
                            props.putAll(scopingData);
                        }
                        try {
                            this.objectName = JMX.createObjectName("exo", props);
                        }
                        catch (MalformedObjectNameException e) {
                            LOG.error((Object)"Could not create the object name", (Throwable)e);
                        }
                    }
                    this.objectNameSet = true;
                }
            }
        }
        return this.objectName;
    }

    @Override
    public <T> ComponentAdapter<T> registerComponentInstance(Object componentKey, T componentInstance) throws ContainerException {
        ComponentAdapter<T> adapter = super.registerComponentInstance(componentKey, componentInstance);
        if (this.managementContext != null) {
            this.managementContext.register(componentInstance);
            if (componentInstance instanceof ManagementProvider) {
                ManagementProvider provider = (ManagementProvider)componentInstance;
                this.addProvider(provider);
            }
        }
        return adapter;
    }

    @Override
    public ComponentAdapter<?> unregisterComponent(Object componentKey) {
        block3: {
            try {
                Object componentInstance = this.getComponentInstance(componentKey, Object.class, false);
                if (this.managementContext != null && componentInstance != null) {
                    this.managementContext.unregister(componentInstance);
                }
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return super.unregisterComponent(componentKey);
    }

    @Override
    public void stop() {
        if (this.managementContext != null) {
            this.managementContext.unregisterAll();
        }
        super.stop();
    }

    Collection<ManagementProvider> getProviders() {
        HashSet<ManagementProvider> allProviders = new HashSet<ManagementProvider>();
        this.computeAllProviders(allProviders);
        return allProviders;
    }

    private void computeAllProviders(Set<ManagementProvider> allProviders) {
        if (this.parent != null) {
            this.managementContext.parent.container.computeAllProviders(allProviders);
        }
        allProviders.addAll(this.providers);
    }

    boolean addProvider(ManagementProvider provider) {
        if (this.providers.contains(provider)) {
            return false;
        }
        this.providers.add(provider);
        this.managementContext.install(provider);
        return true;
    }

    public ExoContainer getHolder() {
        return this.holder;
    }

    @Override
    public String getId() {
        return "Management";
    }
}

