/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractHttpServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.AbstractHttpServlet");
    private static final long serialVersionUID = -3302886470677004895L;
    protected ServletConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.servletContextName = ContainerUtil.getServletContextName(config.getServletContext());
        this.afterInit(config);
    }

    protected void afterInit(ServletConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer();
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            if (this.requirePortalEnvironment()) {
                String ctxName = ContainerUtil.getServletContextName(this.config.getServletContext());
                if (!PortalContainer.isPortalContainerNameDisabled(ctxName) && container instanceof PortalContainer) {
                    if (PortalContainer.getInstanceIfPresent() == null) {
                        PortalContainer.setInstance((PortalContainer)container);
                        hasBeenSet = true;
                    }
                    Thread.currentThread().setContextClassLoader(((PortalContainer)container).getPortalClassLoader());
                } else {
                    this.onPortalEnvironmentError(req, res);
                    return;
                }
            }
            this.onService(container, req, res);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
            if (this.requirePortalEnvironment()) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            AbstractHttpServlet abstractHttpServlet = this;
            synchronized (abstractHttpServlet) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName(this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }

    protected void onService(ExoContainer container, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void onPortalEnvironmentError(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (PropertyManager.isDevelopping()) {
            LOG.info((Object)("The portal environment could not be set for the webapp '" + ContainerUtil.getServletContextName(this.config.getServletContext()) + "' because this servlet context has not been defined as a " + "dependency of any portal container or it is a disabled portal" + " container, the target URI was " + req.getRequestURI()));
        }
        res.sendError(404);
    }

    protected final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance(this.config.getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    public ServletContext getServletContext() {
        ExoContainer container;
        if (this.requirePortalEnvironment() && (container = this.getContainer()) instanceof PortalContainer) {
            return ((PortalContainer)container).getPortalContext();
        }
        return super.getServletContext();
    }
}

