/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.test;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.test.DefaultComponent;
import org.exoplatform.container.test.MultibleComponent;
import org.exoplatform.mocks.MockService;
import org.exoplatform.mocks.PriorityService;

public class TestContainer
extends TestCase {
    public void setUp() throws Exception {
        System.setProperty("maven.exoplatform.dir", TestContainer.class.getResource("/").getFile());
    }

    public void testComponent() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        MockService mservice = (MockService)rootContainer.getComponentInstance((Object)"MockService");
        TestContainer.assertTrue((mservice != null ? 1 : 0) != 0);
        TestContainer.assertTrue((mservice.getPlugins().size() == 2 ? 1 : 0) != 0);
    }

    public void testComponent2() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        MultibleComponent c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
    }

    public void testComponent3() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        DefaultComponent c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
    }

    public void testPriorityPlugins() {
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        PriorityService ps = (PriorityService)pcontainer.getComponentInstanceOfType(PriorityService.class);
        TestContainer.assertNotNull((Object)ps);
        List<ComponentPlugin> l = ps.getPlugins();
        TestContainer.assertNotNull(l);
        TestContainer.assertEquals((int)3, (int)l.size());
        TestContainer.assertEquals((String)"PluginPriority3", (String)l.get(0).getName());
        TestContainer.assertEquals((String)"PluginPriority1", (String)l.get(1).getName());
        TestContainer.assertEquals((String)"PluginPriority2", (String)l.get(2).getName());
    }

    public void testPortalContainer() throws Exception {
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        ExoContainer parent = pcontainer.getParent();
        TestContainer.assertTrue((String)"Root container should not be null", (parent != null ? 1 : 0) != 0);
        int INSERTLOOP = 0;
        for (int i = 0; i < INSERTLOOP; ++i) {
            rootContainer.getPortalContainer("name-" + Integer.toString(i));
        }
        int LOOP = 10000000;
        for (int i = 0; i < LOOP; ++i) {
            pcontainer = (PortalContainer)rootContainer.getComponentInstance((Object)"portal");
            TestContainer.assertTrue((String)"not null", (pcontainer != null ? 1 : 0) != 0);
        }
    }
}

