/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Stereotype;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.ContainerBuilder;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.ContextManager;
import org.exoplatform.container.context.DefinitionException;
import org.exoplatform.container.jmx.AbstractTestContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapter;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.DefinitionByName;
import org.exoplatform.container.spi.DefinitionByQualifier;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.junit.Assert;
import org.junit.Test;
import org.picocontainer.Disposable;
import org.picocontainer.Startable;

public class TestExoContainer {
    public static AtomicInteger COUNTER;
    private static ExoContainer parent;

    @Test
    public void testHasProfileInProperty() {
        String oldValue = PropertyManager.getProperty((String)"exo.profiles");
        try {
            System.clearProperty("exo.profiles");
            PropertyManager.refresh();
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty(null));
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            PropertyManager.setProperty((String)"exo.profiles", (String)"foo1");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty(null));
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo1"));
            System.clearProperty("exo.profiles");
            PropertyManager.refresh();
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            PropertyManager.setProperty((String)"exo.profiles", (String)"foo1, foo2, foo3");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo1"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo2"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo3"));
            PropertyManager.setProperty((String)"exo.profiles", (String)"  \tfoo   ");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo"));
            PropertyManager.setProperty((String)"exo.profiles", (String)",foo   ");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"foo"));
            PropertyManager.setProperty((String)"exo.profiles", (String)"foo, bar, \t baz \t");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"baz"));
            PropertyManager.setProperty((String)"exo.profiles", (String)"foo1, bar, \t baz1 \t");
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"foo0"));
            Assert.assertFalse((boolean)ExoContainer.hasProfileInProperty((String)"baz"));
            Assert.assertTrue((boolean)ExoContainer.hasProfileInProperty((String)"bar"));
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("exo.profiles");
                PropertyManager.refresh();
            } else {
                PropertyManager.setProperty((String)"exo.profiles", (String)oldValue);
            }
        }
    }

    @Test
    public void testRemoveComponent() throws Exception {
        ConcurrentContainer container = new ConcurrentContainer((ExoContainer)RootContainer.getInstance(), null);
        container.registerComponentInstance(CachedComponent.class, (Object)new CachedComponent());
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(CachedComponent.class, false));
        container.unregisterComponent(CachedComponent.class);
        Assert.assertNull((Object)container.getComponentInstanceOfType(CachedComponent.class, false));
        container.registerComponent((ComponentAdapter)new DummyAdapter());
        try {
            container.getComponentInstanceOfType(DummyClass.class, false);
            Assert.fail((String)"A RuntimeException is expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        container.unregisterComponent((Object)"testKey");
    }

    @Test
    public void testContainerLifecyclePlugin() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((long)3L, (long)counter.init.size());
        Assert.assertEquals((long)3L, (long)counter.start.size());
        container.stop();
        Assert.assertEquals((long)3L, (long)counter.stop.size());
        container.dispose();
        Assert.assertEquals((long)3L, (long)counter.destroy.size());
        Assert.assertTrue((boolean)(counter.init.get(0) instanceof MyContainerLifecyclePlugin2));
        MyContainerLifecyclePlugin2 plugin = (MyContainerLifecyclePlugin2)counter.init.get(0);
        Assert.assertNotNull((Object)plugin.getName());
        Assert.assertNotNull((Object)plugin.getDescription());
        Assert.assertNotNull((Object)plugin.param);
        Assert.assertTrue((boolean)(counter.init.get(1) instanceof MyContainerLifecyclePlugin3));
        Assert.assertTrue((boolean)(counter.init.get(2) instanceof MyContainerLifecyclePlugin1));
    }

    @Test
    public void testStackOverFlow() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        MyClass value = (MyClass)container.getComponentInstanceOfType(MyClass.class);
        Assert.assertNotNull((Object)value);
        MyClassPlugin plugin = value.plugin_;
        Assert.assertNotNull((Object)((Object)plugin));
        Assert.assertNotNull((Object)plugin.cmanager_);
        Assert.assertSame((Object)value, (Object)plugin.myClass_);
        MyClassPlugin2 plugin2 = value.plugin2_;
        Assert.assertNotNull((Object)((Object)plugin2));
        Assert.assertNotNull((Object)plugin2.cmanager_);
        Assert.assertSame((Object)value, (Object)plugin2.myClass_);
    }

    @Test
    public void testStackOverFlowB() throws Exception {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testStackOverFlowB").build();
        PortalContainer container = PortalContainer.getInstance();
        MyClassB value = (MyClassB)container.getComponentInstanceOfType(MyClassB.class);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)value.started);
        MyClassPluginB plugin = value.plugin_;
        Assert.assertNotNull((Object)((Object)plugin));
        Assert.assertNotNull((Object)plugin.cmanager_);
        Assert.assertSame((Object)value, (Object)plugin.myClass_);
        MyClassPlugin2B plugin2 = value.plugin2_;
        Assert.assertNotNull((Object)((Object)plugin2));
        Assert.assertNotNull((Object)plugin2.cmanager_);
        Assert.assertSame((Object)value, (Object)plugin2.myClass_);
    }

    @Test
    public void testStackOverFlow2() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        SOE1 soe1 = (SOE1)container.getComponentInstanceOfType(SOE1.class);
        Assert.assertNotNull((Object)soe1);
        Assert.assertEquals((long)1L, (long)soe1.plugins.size());
        SOEPlugin soe1Plugin = soe1.plugins.get(0);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertSame((Object)soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE2.class), (Object)soe1Plugin.soe2);
    }

    @Test
    public void testStackOverFlow3() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        SOE2 soe2 = (SOE2)container.getComponentInstanceOfType(SOE2.class);
        Assert.assertNotNull((Object)soe2);
        Assert.assertNotNull((Object)soe2.soe1);
        Assert.assertEquals((long)1L, (long)soe2.soe1.plugins.size());
        SOEPlugin soe1Plugin = soe2.soe1.plugins.get(0);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertSame((Object)soe2.soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE1.class), (Object)soe2.soe1);
    }

    @Test
    public void testStackOverFlow2B() throws Exception {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("test-exo-container-portal-mode.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        COUNTER = new AtomicInteger();
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("Case-B").build();
        PortalContainer container = PortalContainer.getInstance();
        SOE1B soe1 = (SOE1B)container.getComponentInstanceOfType(SOE1B.class);
        Assert.assertNotNull((Object)soe1);
        Assert.assertTrue((soe1.startOrder >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)soe1.plugins.size());
        SOEPluginB soe1Plugin = soe1.plugins.get(0);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertTrue((soe1Plugin.soe2.startOrder >= 1 ? 1 : 0) != 0);
        Assert.assertSame((Object)soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE2B.class), (Object)soe1Plugin.soe2);
    }

    @Test
    public void testStackOverFlow3B() throws Exception {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("test-exo-container-portal-mode.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        COUNTER = new AtomicInteger();
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("Case-B").build();
        PortalContainer container = PortalContainer.getInstance();
        SOE2B soe2 = (SOE2B)container.getComponentInstanceOfType(SOE2B.class);
        Assert.assertNotNull((Object)soe2);
        Assert.assertTrue((soe2.startOrder >= 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)soe2.soe1);
        Assert.assertEquals((long)1L, (long)soe2.soe1.plugins.size());
        SOEPluginB soe1Plugin = soe2.soe1.plugins.get(0);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertSame((Object)soe2.soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertTrue((soe2.soe1.startOrder >= 1 ? 1 : 0) != 0);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE1B.class), (Object)soe2.soe1);
    }

    @Test
    public void testStackOverFlow2C() throws Exception {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        SOE1C soe1 = (SOE1C)container.getComponentInstanceOfType(SOE1C.class);
        Assert.assertNotNull((Object)soe1);
        Assert.assertEquals((long)2L, (long)soe1.plugins.size());
        SOEPluginC soe1Plugin = (SOEPluginC)soe1.plugins.get(1);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertSame((Object)soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE2C.class), (Object)soe1Plugin.soe2);
    }

    @Test
    public void testStackOverFlow3C() throws Exception {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        SOE2C soe2 = (SOE2C)container.getComponentInstanceOfType(SOE2C.class);
        Assert.assertNotNull((Object)soe2);
        Assert.assertNotNull((Object)soe2.soe1);
        Assert.assertEquals((long)2L, (long)soe2.soe1.plugins.size());
        SOEPluginC soe1Plugin = (SOEPluginC)soe2.soe1.plugins.get(1);
        Assert.assertNotNull((Object)((Object)soe1Plugin));
        Assert.assertNotNull((Object)soe1Plugin.soe2);
        Assert.assertSame((Object)soe2.soe1, (Object)soe1Plugin.soe2.soe1);
        Assert.assertSame((Object)container.getComponentInstanceOfType(SOE1C.class), (Object)soe2.soe1);
    }

    @Test
    public void testStackOverFlow4() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testStackOverflowError");
        MyService ms = (MyService)container.getComponentInstanceOfType(MyService.class);
        Assert.assertNotNull((Object)ms);
        Assert.assertTrue((boolean)(ms instanceof MyServiceImpl));
        MyServiceImpl msi = (MyServiceImpl)ms;
        Assert.assertNotNull((Object)msi.componentPlugin);
        Assert.assertTrue((boolean)(msi.componentPlugin instanceof MyPlugin));
        MyPlugin mp = (MyPlugin)msi.componentPlugin;
        Assert.assertSame((Object)mp.svc, (Object)ms);
    }

    @Test
    public void testCyclicRef() {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testCyclicRef");
        A a = (A)container.getComponentInstanceOfType(A.class);
        Assert.assertNotNull((Object)a);
        B b = (B)container.getComponentInstanceOfType(B.class);
        Assert.assertNotNull((Object)b);
        Assert.assertSame((Object)a, (Object)b.a);
    }

    @Test
    public void testContainerNameSuffix() {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        RootContainer rContainer = new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testContainerNameSuffix").build();
        PortalContainer pContainer = PortalContainer.getInstance();
        TCNS t1 = (TCNS)rContainer.getComponentInstanceOfType(TCNS.class);
        Assert.assertNotNull((Object)t1);
        Assert.assertEquals((Object)"empty${container.name.suffix}", (Object)t1.value);
        Assert.assertNotNull((Object)t1.dep);
        Assert.assertEquals((Object)"empty${container.name.suffix}", (Object)t1.dep.value);
        TCNS t2 = (TCNS)pContainer.getComponentInstanceOfType(TCNS.class);
        Assert.assertNotNull((Object)t2);
        Assert.assertEquals((Object)"empty_portal", (Object)t2.value);
        Assert.assertNotNull((Object)t2.dep);
        Assert.assertEquals((Object)"empty_portal", (Object)t2.dep.value);
    }

    @Test
    public void testStartOrder() {
        this.testStartOrder(false);
    }

    protected void testStartOrder(boolean checkC0NC1) {
        COUNTER = new AtomicInteger();
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testStartOrder");
        C0 c0 = (C0)container.getComponentInstanceOfType(C0.class);
        Assert.assertNotNull((Object)c0);
        Assert.assertTrue((c0.startOrder > 0 ? 1 : 0) != 0);
        C1 c1 = (C1)container.getComponentInstanceOfType(C1.class);
        Assert.assertNotNull((Object)c1);
        Assert.assertTrue((c1.startOrder > 0 ? 1 : 0) != 0);
        if (checkC0NC1) {
            Assert.assertTrue((c1.startOrder < c0.startOrder ? 1 : 0) != 0);
        }
        C2 c2 = (C2)container.getComponentInstanceOfType(C2.class);
        Assert.assertNotNull((Object)c2);
        Assert.assertTrue((c2.startOrder > 0 ? 1 : 0) != 0);
        C2_1 c2_1 = (C2_1)container.getComponentInstanceOfType(C2_1.class);
        Assert.assertNotNull((Object)c2_1);
        Assert.assertTrue((c2_1.startOrder > 0 ? 1 : 0) != 0);
        C2_2 c2_2 = (C2_2)container.getComponentInstanceOfType(C2_2.class);
        Assert.assertNotNull((Object)c2_2);
        Assert.assertTrue((c2_2.startOrder > 0 ? 1 : 0) != 0);
        C2_3 c2_3 = (C2_3)container.getComponentInstanceOfType(C2_3.class);
        Assert.assertNotNull((Object)c2_3);
        Assert.assertTrue((c2_3.startOrder > 0 ? 1 : 0) != 0);
        C2_4 c2_4 = (C2_4)container.getComponentInstanceOfType(C2_4.class);
        Assert.assertNotNull((Object)c2_4);
        Assert.assertTrue((c2_4.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertSame((Object)c2_1.getC2(), (Object)c2_2);
        Assert.assertSame((Object)c2_1.getC3(), (Object)c2_3);
        Assert.assertSame((Object)c2_1.getC4(), (Object)c2_4);
        Assert.assertSame((Object)c2_2.c3, (Object)c2_3);
        Assert.assertSame((Object)c2_2.c4, (Object)c2_4);
        Assert.assertSame((Object)c2_3.c4, (Object)c2_4);
        Assert.assertTrue((c2_4.startOrder < c2_1.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c2_4.startOrder < c2_2.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c2_4.startOrder < c2_3.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c2_3.startOrder < c2_1.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c2_3.startOrder < c2_2.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c2_2.startOrder < c2_1.startOrder ? 1 : 0) != 0);
    }

    @Test
    public void testStartOrder2() {
        COUNTER = new AtomicInteger();
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testStartOrder2");
        TSO2_A a = (TSO2_A)container.getComponentInstanceOfType(TSO2_A.class);
        Assert.assertNotNull((Object)a);
        TSO2_B b = (TSO2_B)container.getComponentInstanceOfType(TSO2_B.class);
        Assert.assertNotNull((Object)b);
        TSO2_C c = (TSO2_C)container.getComponentInstanceOfType(TSO2_C.class);
        Assert.assertNotNull((Object)c);
        TSO2_D d = (TSO2_D)container.getComponentInstanceOfType(TSO2_D.class);
        Assert.assertNotNull((Object)d);
        Assert.assertTrue((a.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.startOrder < a.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((d.startOrder < a.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((c.startOrder < d.startOrder ? 1 : 0) != 0);
        TSO2_A2 a2 = (TSO2_A2)container.getComponentInstanceOfType(TSO2_A2.class);
        Assert.assertNotNull((Object)a2);
        TSO2_B2 b2 = (TSO2_B2)container.getComponentInstanceOfType(TSO2_B2.class);
        Assert.assertNotNull((Object)b2);
        TSO2_C2 c2 = (TSO2_C2)container.getComponentInstanceOfType(TSO2_C2.class);
        Assert.assertNotNull((Object)c2);
        Assert.assertTrue((a2.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b2.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c2.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c2.startOrder < b2.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((b2.startOrder < a2.startOrder ? 1 : 0) != 0);
    }

    @Test
    public void testStartOrder3() {
        COUNTER = new AtomicInteger();
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testStartOrder3");
        TSO3_A a = (TSO3_A)container.getComponentInstanceOfType(TSO3_A.class);
        Assert.assertNotNull((Object)a);
        TSO3_B b = (TSO3_B)container.getComponentInstanceOfType(TSO3_B.class);
        Assert.assertNotNull((Object)b);
        TSO3_C c = (TSO3_C)container.getComponentInstanceOfType(TSO3_C.class);
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((a.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.startOrder > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.startOrder < b.startOrder ? 1 : 0) != 0);
        Assert.assertTrue((b.startOrder < a.startOrder ? 1 : 0) != 0);
    }

    @Test
    public void testCache() {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("empty-config.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).build();
        RootContainer container = RootContainer.getInstance();
        MyClass value = new MyClass();
        ComponentAdapter ca = container.registerComponentInstance((Object)"MyKey", (Object)value);
        PortalContainer pcontainer = PortalContainer.getInstance();
        Assert.assertSame((Object)ca, (Object)container.getComponentAdapter((Object)"MyKey"));
        Assert.assertSame((Object)ca, (Object)pcontainer.getComponentAdapter((Object)"MyKey"));
        Assert.assertSame((Object)ca, (Object)container.getComponentAdapter((Object)"MyKey", MyClass.class));
        Assert.assertSame((Object)ca, (Object)pcontainer.getComponentAdapter((Object)"MyKey", MyClass.class));
        try {
            container.getComponentAdapter((Object)"MyKey", String.class);
            Assert.fail((String)"A ClassCastException was expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            pcontainer.getComponentAdapter((Object)"MyKey", String.class);
            Assert.fail((String)"A ClassCastException was expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Assert.assertSame((Object)value, (Object)container.getComponentInstance((Object)"MyKey"));
        Assert.assertSame((Object)value, (Object)pcontainer.getComponentInstance((Object)"MyKey"));
        Assert.assertSame((Object)value, (Object)container.getComponentInstance((Object)"MyKey", MyClass.class));
        Assert.assertSame((Object)value, (Object)pcontainer.getComponentInstance((Object)"MyKey", MyClass.class));
        try {
            container.getComponentInstance((Object)"MyKey", String.class);
            Assert.fail((String)"A ClassCastException was expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            pcontainer.getComponentInstance((Object)"MyKey", String.class);
            Assert.fail((String)"A ClassCastException was expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        container.unregisterComponent((Object)"MyKey");
        Assert.assertNull((Object)container.getComponentAdapter((Object)"MyKey"));
        Assert.assertNull((Object)pcontainer.getComponentAdapter((Object)"MyKey"));
        Assert.assertNull((Object)container.getComponentAdapter((Object)"MyKey", MyClass.class));
        Assert.assertNull((Object)pcontainer.getComponentAdapter((Object)"MyKey", MyClass.class));
        Assert.assertNull((Object)container.getComponentAdapter((Object)"MyKey", String.class));
        Assert.assertNull((Object)pcontainer.getComponentAdapter((Object)"MyKey", String.class));
        Assert.assertNull((Object)container.getComponentInstance((Object)"MyKey"));
        Assert.assertNull((Object)pcontainer.getComponentInstance((Object)"MyKey"));
        Assert.assertNull((Object)container.getComponentInstance((Object)"MyKey", MyClass.class));
        Assert.assertNull((Object)pcontainer.getComponentInstance((Object)"MyKey", MyClass.class));
        Assert.assertNull((Object)container.getComponentInstance((Object)"MyKey", String.class));
        Assert.assertNull((Object)pcontainer.getComponentInstance((Object)"MyKey", String.class));
    }

    @Test
    public void testStart() {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("empty-config.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testStart").build();
        RootContainer container = RootContainer.getInstance();
        PortalContainer pcontainer = PortalContainer.getInstance();
        container.stop();
        container.dispose();
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TS1.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TS2.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TS3.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TS4.class));
        Assert.assertNotNull((Object)pcontainer.getComponentInstanceOfType(TS1.class));
        Assert.assertNotNull((Object)pcontainer.getComponentInstanceOfType(TS2.class));
        Assert.assertNotNull((Object)pcontainer.getComponentInstanceOfType(TS3.class));
        Assert.assertNotNull((Object)pcontainer.getComponentInstanceOfType(TS4.class));
        TS1 ts1rc = (TS1)container.getComponentInstanceOfType(TS1.class);
        TS1 ts1pc = (TS1)pcontainer.getComponentInstanceOfType(TS1.class);
        Assert.assertSame((Object)ts1rc, (Object)ts1pc);
        Assert.assertEquals((long)1L, (long)ts1pc.started);
        Assert.assertEquals((long)1L, (long)ts1pc.stopped);
        TS2 ts2rc = (TS2)container.getComponentInstanceOfType(TS2.class);
        TS2 ts2pc = (TS2)pcontainer.getComponentInstanceOfType(TS2.class);
        Assert.assertSame((Object)ts2rc, (Object)ts2pc);
        Assert.assertEquals((long)1L, (long)ts2rc.disposed);
        TS3 ts3rc = (TS3)container.getComponentInstanceOfType(TS3.class);
        TS3 ts3pc = (TS3)pcontainer.getComponentInstanceOfType(TS3.class);
        Assert.assertNotSame((Object)ts3rc, (Object)ts3pc);
        Assert.assertEquals((long)1L, (long)ts3rc.started);
        Assert.assertEquals((long)1L, (long)ts3pc.started);
        Assert.assertEquals((long)1L, (long)ts3rc.stopped);
        Assert.assertEquals((long)1L, (long)ts3pc.stopped);
        TS4 ts4rc = (TS4)container.getComponentInstanceOfType(TS4.class);
        TS4 ts4pc = (TS4)pcontainer.getComponentInstanceOfType(TS4.class);
        Assert.assertNotSame((Object)ts4rc, (Object)ts4pc);
        Assert.assertEquals((long)1L, (long)ts4rc.disposed);
        Assert.assertEquals((long)1L, (long)ts4pc.disposed);
    }

    @Test
    public void testLifeCycle() throws Throwable {
        ExoContainer container = new ExoContainer();
        Assert.assertTrue((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.registerComponentImplementation(LC1.class, LC1.class);
        container.registerComponentImplementation(LC2.class, LC2.class);
        container.registerComponentImplementation(LC3.class, LC3.class);
        container.registerComponentImplementation(LC4.class, LC4.class);
        container.registerComponentImplementation(LC5.class, LC5.class);
        try {
            container.start();
            Assert.fail((String)"Should fail due to the start method of C1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LC1 c1 = (LC1)container.getComponentInstanceOfType(LC1.class);
        LC2 c2 = (LC2)container.getComponentInstanceOfType(LC2.class);
        LC3 c3 = (LC3)container.getComponentInstanceOfType(LC3.class);
        LC4 c4 = (LC4)container.getComponentInstanceOfType(LC4.class);
        LC5 c5 = (LC5)container.getComponentInstanceOfType(LC5.class);
        Assert.assertTrue((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.stop();
        Assert.assertTrue((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.dispose();
        Assert.assertTrue((c1.disposed && c2.disposed && c5.disposed ? 1 : 0) != 0);
        Assert.assertFalse((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertFalse((boolean)container.canBeDisposed());
        container = new ExoContainer();
        Assert.assertTrue((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.registerComponentImplementation(LC2.class, LC2.class);
        container.registerComponentImplementation(LC3.class, LC3.class);
        container.registerComponentImplementation(LC4.class, LC4.class);
        container.registerComponentImplementation(LC5.class, LC5.class);
        container.start();
        c2 = (LC2)container.getComponentInstanceOfType(LC2.class);
        c3 = (LC3)container.getComponentInstanceOfType(LC3.class);
        c4 = (LC4)container.getComponentInstanceOfType(LC4.class);
        Assert.assertTrue((c2.started && c3.started && c4.started ? 1 : 0) != 0);
        Assert.assertFalse((boolean)container.canBeStarted());
        Assert.assertTrue((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.stop();
        Assert.assertTrue((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertTrue((boolean)container.canBeDisposed());
        container.dispose();
        Assert.assertTrue((c1.disposed && c2.disposed && c5.disposed ? 1 : 0) != 0);
        Assert.assertFalse((boolean)container.canBeStarted());
        Assert.assertFalse((boolean)container.canBeStopped());
        Assert.assertFalse((boolean)container.canBeDisposed());
    }

    @Test
    public void testStates() throws Exception {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testStates");
        TSC1 value = (TSC1)container.getComponentInstanceOfType(TSC1.class);
        Assert.assertNotNull((Object)value);
        TSC2Plugin plugin = value.plugin;
        Assert.assertNotNull((Object)((Object)plugin));
        Assert.assertNotNull((Object)plugin.tsc2);
        Assert.assertNotNull((Object)((Object)plugin.tsc2.plugin));
        TSC2 value2 = (TSC2)container.getComponentInstanceOfType(TSC2.class);
        Assert.assertNotNull((Object)value2);
        Assert.assertSame((Object)value2, (Object)plugin.tsc2);
        TSC2Plugin plugin2 = value2.plugin;
        Assert.assertNotNull((Object)((Object)plugin2));
        Assert.assertNotNull((Object)plugin2.tsc2);
        Assert.assertSame((Object)value2, (Object)plugin2.tsc2);
        Assert.assertSame((Object)((Object)plugin.tsc2.plugin), (Object)((Object)plugin2));
    }

    @Test
    public void testContainerOwner() throws Exception {
        try {
            parent = new ExoContainer();
            parent.registerComponentImplementation(ContainerOwner.class);
            parent.start();
        }
        finally {
            parent = null;
        }
    }

    @Test
    public void testContainers() throws Exception {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testContainers").build();
        PortalContainer container = PortalContainer.getInstance();
        CCTC1 c1 = (CCTC1)container.getComponentInstanceOfType(CCTC1.class);
        Assert.assertNotNull((Object)c1);
        Assert.assertNotNull((Object)c1.container);
        Assert.assertNotNull((Object)c1.c2);
        Assert.assertNotNull((Object)c1.c2.container);
        Assert.assertNotNull((Object)c1.c3);
        Assert.assertNotNull((Object)c1.c3.container);
        Assert.assertSame((Object)c1.container, (Object)c1.c2.container);
        Assert.assertSame((Object)c1.container, (Object)c1.c3.container);
        Assert.assertSame((Object)container, (Object)c1.container);
    }

    @Test
    public void testSortedConstructors() {
        this.testSortedConstructors(SortedConstructorsA.class);
        this.testSortedConstructors(SortedConstructorsB.class);
        this.testSortedConstructors(SortedConstructorsC.class);
        this.testSortedConstructors(SortedConstructorsD.class);
        this.testSortedConstructors(SortedConstructorsE.class);
        this.testSortedConstructors(SortedConstructorsF.class);
    }

    private void testSortedConstructors(Class<?> c) {
        Constructor[] constructors = ContainerUtil.getSortedConstructors(c);
        Assert.assertEquals((long)3L, (long)constructors.length);
        Assert.assertEquals((long)3L, (long)constructors[0].getParameterTypes().length);
        Assert.assertEquals((long)2L, (long)constructors[1].getParameterTypes().length);
        Assert.assertEquals((long)1L, (long)constructors[2].getParameterTypes().length);
    }

    @Test
    public void testJSR330() throws Exception {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "empty-config.xml");
        container.registerComponentImplementation(JSR330_A.class);
        container.registerComponentImplementation(JSR330_B.class);
        container.registerComponentImplementation(JSR330_C.class);
        container.registerComponentImplementation(JSR330_C2.class);
        container.registerComponentImplementation(JSR330_C3.class);
        container.registerComponentImplementation(JSR330_C4.class);
        container.registerComponentImplementation(JSR330_C5.class);
        container.registerComponentImplementation(JSR330_C6.class);
        container.registerComponentImplementation(JSR330_D.class);
        container.registerComponentImplementation(JSR330_P1.class);
        container.registerComponentImplementation(JSR330_P2.class);
        container.registerComponentImplementation(JSR330_P3.class);
        container.registerComponentImplementation(JSR330_P4.class);
        container.registerComponentImplementation(N1.class, JSR330_N1.class);
        container.registerComponentImplementation((Object)"n2", JSR330_N2.class);
        JSR330_A a = (JSR330_A)container.getComponentInstanceOfType(JSR330_A.class);
        Assert.assertNotNull((Object)a);
        JSR330_P1 p1 = (JSR330_P1)container.getComponentInstanceOfType(JSR330_P1.class);
        Assert.assertNotNull((Object)p1);
        JSR330_P2 p2 = (JSR330_P2)container.getComponentInstanceOfType(JSR330_P2.class);
        Assert.assertNotNull((Object)p2);
        JSR330_B b = (JSR330_B)container.getComponentInstanceOfType(JSR330_B.class);
        Assert.assertNotNull((Object)b);
        Assert.assertSame((Object)a, (Object)b.a);
        Assert.assertSame((Object)a, (Object)b.a2);
        Assert.assertSame((Object)a, (Object)b.a3);
        Assert.assertSame((Object)a, (Object)b.a4);
        Assert.assertSame((Object)a, (Object)b.getA5());
        Assert.assertNull((Object)b.a6);
        Assert.assertNull((Object)JSR330_B.a7);
        Assert.assertNotNull((Object)b.p1);
        Assert.assertNotNull((Object)b.n);
        Assert.assertTrue((boolean)(b.n instanceof JSR330_N2));
        Assert.assertNotNull((Object)b.n2);
        Assert.assertTrue((boolean)(b.n2 instanceof JSR330_N1));
        Assert.assertSame((Object)container.getComponentInstanceOfType(JSR330_P1.class), (Object)b.p1.get());
        JSR330_C c = (JSR330_C)container.getComponentInstanceOfType(JSR330_C.class);
        Assert.assertNotNull((Object)c);
        Assert.assertNotSame((Object)c, (Object)container.getComponentInstanceOfType(JSR330_C.class));
        Assert.assertSame((Object)a, (Object)c.a);
        Assert.assertNotNull((Object)c.p2);
        Assert.assertNotNull((Object)c.n);
        Assert.assertTrue((boolean)(c.n instanceof JSR330_N2));
        Assert.assertNotNull((Object)c.n2);
        Assert.assertTrue((boolean)(c.n2 instanceof JSR330_N1));
        Assert.assertNotSame((Object)container.getComponentInstanceOfType(JSR330_P2.class), (Object)c.p2.get());
        JSR330_C2 c2 = (JSR330_C2)container.getComponentInstanceOfType(JSR330_C2.class);
        Assert.assertNotNull((Object)c2);
        Assert.assertSame((Object)a, (Object)c2.a);
        JSR330_C3 c3 = (JSR330_C3)container.getComponentInstanceOfType(JSR330_C3.class);
        Assert.assertNotNull((Object)c3);
        Assert.assertSame((Object)a, (Object)c3.a);
        JSR330_C4 c4 = (JSR330_C4)container.getComponentInstanceOfType(JSR330_C4.class);
        Assert.assertNotNull((Object)c4);
        Assert.assertSame((Object)a, (Object)c4.a);
        try {
            container.getComponentInstanceOfType(JSR330_C5.class);
            Assert.fail((String)"A Runtime Exception was expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(JSR330_C6.class);
            Assert.fail((String)"A Runtime Exception was expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        JSR330_D d = (JSR330_D)container.getComponentInstanceOfType(JSR330_D.class);
        Assert.assertNotNull((Object)d);
        Assert.assertSame((Object)a, (Object)d.a);
        Assert.assertSame((Object)a, (Object)d.a2);
        Assert.assertSame((Object)a, (Object)d.a3);
        Assert.assertSame((Object)a, (Object)d.a4);
        Assert.assertSame((Object)a, (Object)d.a5);
        Assert.assertEquals((long)1L, (long)d.calledInit);
        Assert.assertEquals((long)2L, (long)d.calledInit2);
        Assert.assertNotNull((Object)d.p3);
        Assert.assertNotNull((Object)d.n);
        Assert.assertTrue((boolean)(d.n instanceof JSR330_N2));
        Assert.assertNotNull((Object)d.n2);
        Assert.assertTrue((boolean)(d.n2 instanceof JSR330_N1));
        Assert.assertSame((Object)container.getComponentInstanceOfType(JSR330_P3.class), (Object)d.p3.get());
        Assert.assertNotNull((Object)d.p4);
        try {
            d.p4.get();
            Assert.fail((String)"A Runtime Exception was expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        JSR330_N2 n2 = (JSR330_N2)container.getComponentInstanceOfType(JSR330_N2.class);
        Assert.assertNotNull((Object)n2);
        Assert.assertNotSame((Object)n2, (Object)container.getComponentInstanceOfType(JSR330_N2.class));
        JSR330_N2 n2_2 = (JSR330_N2)container.getComponentInstance((Object)"n2", JSR330_N2.class);
        Assert.assertNotNull((Object)n2_2);
        Assert.assertNotSame((Object)n2_2, (Object)n2);
        Assert.assertNotSame((Object)n2_2, (Object)container.getComponentInstance((Object)"n2", JSR330_N2.class));
        List allN2 = container.getComponentInstancesOfType(JSR330_N2.class);
        Assert.assertNotNull((Object)allN2);
        Assert.assertEquals((long)1L, (long)allN2.size());
        JSR330_N2 n2_3 = (JSR330_N2)allN2.get(0);
        Assert.assertNotSame((Object)n2_3, (Object)n2);
        Assert.assertNotSame((Object)n2_3, (Object)n2_2);
        allN2 = container.getComponentInstancesOfType(JSR330_N2.class);
        Assert.assertNotNull((Object)allN2);
        Assert.assertEquals((long)1L, (long)allN2.size());
        Assert.assertNotSame((Object)n2_3, allN2.get(0));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_A.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_P3.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(JSR330_N2.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N2_2.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N2_3.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N2_4.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N2_5.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N2_6.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(JSR330_N7.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(JSR330_N7_2.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(JSR330_N8.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(JSR330_N8_2.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(JSR330_N8_3.class));
    }

    private static Class<? extends AS0> getClass(int index, boolean oldComponents) throws Exception {
        String classPrefix = S0.class.getName();
        String classsuffix = index == 1 ? (oldComponents ? "" : "27") : Integer.toString(oldComponents ? index : index + 26);
        String classname = classPrefix + classsuffix;
        return Class.forName(classname);
    }

    private void testScope(RootContainer container, ContextManager manager, boolean oldComponents) throws Exception {
        block93: {
            block92: {
                block91: {
                    block90: {
                        block89: {
                            block88: {
                                block87: {
                                    block86: {
                                        block85: {
                                            block84: {
                                                block83: {
                                                    block82: {
                                                        block81: {
                                                            block80: {
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(1, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(2, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(3, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(4, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(5, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(6, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(7, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(8, oldComponents)));
                                                                Assert.assertTrue((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(9, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(10, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(11, oldComponents)));
                                                                Assert.assertTrue((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(12, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(13, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(14, oldComponents)));
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(15, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(16, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(17, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(18, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(19, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.isSingleton(TestExoContainer.getClass(20, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                Assert.assertTrue((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(21, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(22, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(23, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(24, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(25, oldComponents)));
                                                                Assert.assertFalse((boolean)ContainerUtil.isSingleton(TestExoContainer.getClass(26, oldComponents)));
                                                                Assert.assertNull((Object)ContainerUtil.getScope(TestExoContainer.getClass(1, oldComponents), (boolean)true));
                                                                Assert.assertNull((Object)ContainerUtil.getScope(TestExoContainer.getClass(2, oldComponents), (boolean)true));
                                                                Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(3, oldComponents), (boolean)true));
                                                                Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(4, oldComponents), (boolean)true));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(23, oldComponents), (boolean)true));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(24, oldComponents), (boolean)true));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(25, oldComponents), (boolean)true));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(26, oldComponents), (boolean)true));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(1, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(2, oldComponents)));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(3, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(4, oldComponents)));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(5, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(6, oldComponents)));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(7, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(8, oldComponents)));
                                                                Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(9, oldComponents)));
                                                                Assert.assertSame(Dependent.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(10, oldComponents)));
                                                                Assert.assertSame(RequestScoped.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(11, oldComponents)));
                                                                Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(12, oldComponents)));
                                                                Assert.assertSame(Dependent.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(13, oldComponents)));
                                                                Assert.assertSame(RequestScoped.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(14, oldComponents)));
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(15, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(16, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(17, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(18, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(19, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    ContainerUtil.getScope(TestExoContainer.getClass(20, oldComponents));
                                                                }
                                                                catch (DefinitionException definitionException) {
                                                                    // empty catch block
                                                                }
                                                                Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(21, oldComponents)));
                                                                Assert.assertSame(Dependent.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(22, oldComponents)));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(23, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(24, oldComponents)));
                                                                Assert.assertSame(MyNormalScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(25, oldComponents)));
                                                                Assert.assertSame(MyPseudoScope.class, (Object)ContainerUtil.getScope(TestExoContainer.getClass(26, oldComponents)));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(1, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(2, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(3, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(4, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(5, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(6, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(7, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(8, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(9, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(10, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(11, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(12, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(13, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(14, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(15, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(16, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(17, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(18, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(19, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(20, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(21, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(22, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(23, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(24, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(25, oldComponents));
                                                                container.registerComponentImplementation(TestExoContainer.getClass(26, oldComponents));
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents)));
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents)));
                                                                if (oldComponents) {
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents))).getId());
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents))).getId());
                                                                } else {
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(1, oldComponents))).getId() ? 1 : 0) != 0);
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(2, oldComponents))).getId() ? 1 : 0) != 0);
                                                                }
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(3, oldComponents)));
                                                                Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(3, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(3, oldComponents)));
                                                                Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(3, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(3, oldComponents))).getId());
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(4, oldComponents)));
                                                                Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(4, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(4, oldComponents)));
                                                                Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(4, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(4, oldComponents))).getId());
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents)));
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents)));
                                                                if (manager == null && oldComponents) {
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents))).getId());
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents))).getId());
                                                                } else {
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(5, oldComponents))).getId() ? 1 : 0) != 0);
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(6, oldComponents))).getId() ? 1 : 0) != 0);
                                                                }
                                                                ServletRequest req = this.createProxy(ServletRequest.class, new HashMap<Object, Object>());
                                                                if (manager != null) {
                                                                    manager.getContext(RequestScoped.class).activate((Object)req);
                                                                }
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents)));
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents)));
                                                                if (manager == null && !oldComponents) {
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents))).getId() ? 1 : 0) != 0);
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents))).getId() ? 1 : 0) != 0);
                                                                } else {
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents))).getId());
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents))).getId());
                                                                }
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents)));
                                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents)));
                                                                if (manager == null && !oldComponents) {
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents))).getId() ? 1 : 0) != 0);
                                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents)));
                                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents))).getId() ? 1 : 0) != 0);
                                                                } else {
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents))).getId());
                                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents)));
                                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents))).getId());
                                                                }
                                                                if (manager != null) {
                                                                    manager.getContext(RequestScoped.class).deactivate((Object)req);
                                                                }
                                                                try {
                                                                    ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(7, oldComponents))).getId();
                                                                    if (manager != null) {
                                                                        Assert.fail((String)"An exception is expected as we are out of a request context");
                                                                    }
                                                                }
                                                                catch (Exception e1) {
                                                                    if (manager != null) break block80;
                                                                    throw e1;
                                                                }
                                                            }
                                                            try {
                                                                ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(8, oldComponents))).getId();
                                                                if (manager != null) {
                                                                    Assert.fail((String)"An exception is expected as we are out of a request context");
                                                                }
                                                            }
                                                            catch (Exception e1) {
                                                                if (manager != null) break block81;
                                                                throw e1;
                                                            }
                                                        }
                                                        try {
                                                            ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(11, oldComponents))).getId();
                                                            if (manager != null) {
                                                                Assert.fail((String)"An exception is expected as we are out of a request context");
                                                            }
                                                        }
                                                        catch (Exception e1) {
                                                            if (manager != null) break block82;
                                                            throw e1;
                                                        }
                                                    }
                                                    try {
                                                        ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(14, oldComponents))).getId();
                                                        if (manager != null) {
                                                            Assert.fail((String)"An exception is expected as we are out of a request context");
                                                        }
                                                    }
                                                    catch (Exception e1) {
                                                        if (manager != null) break block83;
                                                        throw e1;
                                                    }
                                                }
                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(9, oldComponents)));
                                                Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(9, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(9, oldComponents)));
                                                Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(9, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(9, oldComponents))).getId());
                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents)));
                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents)));
                                                if (manager == null && oldComponents) {
                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents)));
                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents))).getId());
                                                    Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents)));
                                                    Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents))).getId());
                                                } else {
                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents)));
                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(10, oldComponents))).getId() ? 1 : 0) != 0);
                                                    Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents)));
                                                    Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(13, oldComponents))).getId() ? 1 : 0) != 0);
                                                }
                                                Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(12, oldComponents)));
                                                Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(12, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(12, oldComponents)));
                                                Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(12, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(12, oldComponents))).getId());
                                                try {
                                                    container.getComponentInstanceOfType(TestExoContainer.getClass(15, oldComponents));
                                                    if (manager != null || !oldComponents) {
                                                        Assert.fail((String)"An exception is expected as the scope is invalid");
                                                    }
                                                }
                                                catch (Exception e1) {
                                                    if (manager != null || !oldComponents) break block84;
                                                    throw e1;
                                                }
                                            }
                                            try {
                                                container.getComponentInstanceOfType(TestExoContainer.getClass(16, oldComponents));
                                                if (manager != null || !oldComponents) {
                                                    Assert.fail((String)"An exception is expected as the scope is invalid");
                                                }
                                            }
                                            catch (Exception e1) {
                                                if (manager != null || !oldComponents) break block85;
                                                throw e1;
                                            }
                                        }
                                        try {
                                            container.getComponentInstanceOfType(TestExoContainer.getClass(17, oldComponents));
                                            if (manager != null || !oldComponents) {
                                                Assert.fail((String)"An exception is expected as the scope is invalid");
                                            }
                                        }
                                        catch (Exception e1) {
                                            if (manager != null || !oldComponents) break block86;
                                            throw e1;
                                        }
                                    }
                                    try {
                                        container.getComponentInstanceOfType(TestExoContainer.getClass(18, oldComponents));
                                        if (manager != null || !oldComponents) {
                                            Assert.fail((String)"An exception is expected as the scope is invalid");
                                        }
                                    }
                                    catch (Exception e1) {
                                        if (manager != null || !oldComponents) break block87;
                                        throw e1;
                                    }
                                }
                                try {
                                    container.getComponentInstanceOfType(TestExoContainer.getClass(19, oldComponents));
                                    if (manager != null || !oldComponents) {
                                        Assert.fail((String)"An exception is expected as the scope is invalid");
                                    }
                                }
                                catch (Exception e1) {
                                    if (manager != null || !oldComponents) break block88;
                                    throw e1;
                                }
                            }
                            try {
                                container.getComponentInstanceOfType(TestExoContainer.getClass(20, oldComponents));
                                if (manager != null || !oldComponents) {
                                    Assert.fail((String)"An exception is expected as the scope is invalid");
                                }
                            }
                            catch (Exception e1) {
                                if (manager != null || !oldComponents) break block89;
                                throw e1;
                            }
                        }
                        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(21, oldComponents)));
                        Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(21, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(21, oldComponents)));
                        Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(21, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(21, oldComponents))).getId());
                        Assert.assertNotNull((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents)));
                        if (manager == null && oldComponents) {
                            Assert.assertSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents)));
                            Assert.assertEquals((long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents))).getId(), (long)((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents))).getId());
                        } else {
                            Assert.assertNotSame((Object)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents)), (Object)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents)));
                            Assert.assertFalse((((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents))).getId() == ((AS0)container.getComponentInstanceOfType(TestExoContainer.getClass(22, oldComponents))).getId() ? 1 : 0) != 0);
                        }
                        try {
                            container.getComponentInstanceOfType(TestExoContainer.getClass(23, oldComponents));
                            if (manager != null) {
                                Assert.fail((String)"An exception is expected as the scope and the default scopes are unknown");
                            }
                        }
                        catch (Exception e1) {
                            if (manager != null) break block90;
                            throw e1;
                        }
                    }
                    try {
                        container.getComponentInstanceOfType(TestExoContainer.getClass(24, oldComponents));
                        if (manager != null) {
                            Assert.fail((String)"An exception is expected as the scope and the default scopes are unknown");
                        }
                    }
                    catch (Exception e1) {
                        if (manager != null) break block91;
                        throw e1;
                    }
                }
                try {
                    container.getComponentInstanceOfType(TestExoContainer.getClass(25, oldComponents));
                    if (manager != null) {
                        Assert.fail((String)"An exception is expected as the scope and the default scopes are unknown");
                    }
                }
                catch (Exception e1) {
                    if (manager != null) break block92;
                    throw e1;
                }
            }
            try {
                container.getComponentInstanceOfType(TestExoContainer.getClass(26, oldComponents));
                if (manager != null) {
                    Assert.fail((String)"An exception is expected as the scope and the default scopes are unknown");
                }
            }
            catch (Exception e1) {
                if (manager != null) break block93;
                throw e1;
            }
        }
    }

    @Test
    public void testScopeWithNoContextManager() throws Exception {
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml");
        ContextManager manager = (ContextManager)container.getComponentInstanceOfType(ContextManager.class);
        Assert.assertNull((Object)manager);
        this.testScope(container, manager, true);
        this.testScope(container, manager, false);
    }

    @Test
    public void testScope() throws Exception {
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(S1.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(S2.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(S3.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(S4.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(S5.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(S6.class));
        Assert.assertFalse((boolean)ContainerUtil.isSingleton(S7.class));
        Assert.assertTrue((boolean)ContainerUtil.isSingleton(S8.class));
        Assert.assertSame(RequestScoped.class, (Object)ContainerUtil.getScope(S1.class));
        Assert.assertSame(SessionScoped.class, (Object)ContainerUtil.getScope(S2.class));
        Assert.assertSame(ApplicationScoped.class, (Object)ContainerUtil.getScope(S3.class));
        Assert.assertSame(Singleton.class, (Object)ContainerUtil.getScope(S4.class));
        Assert.assertNull((Object)ContainerUtil.getScope(S5.class));
        Assert.assertNull((Object)ContainerUtil.getScope(S6.class));
        Assert.assertSame(Dependent.class, (Object)ContainerUtil.getScope(S7.class));
        Assert.assertSame(ApplicationScoped.class, (Object)ContainerUtil.getScope(S8.class));
        RootContainer container = AbstractTestContainer.createRootContainer(this.getClass(), "test-exo-container.xml", "testScope");
        container.registerComponentImplementation(S1.class);
        container.registerComponentImplementation(S1_DEP1.class);
        container.registerComponentImplementation(S1_DEP2.class);
        container.registerComponentImplementation(S1_DEP3.class);
        container.registerComponentImplementation(S1_DEP4.class);
        container.registerComponentImplementation(S1_DEP5.class);
        container.registerComponentImplementation(S1_DEP6.class);
        container.registerComponentImplementation(S2.class);
        container.registerComponentImplementation(S20.class);
        container.registerComponentImplementation(S3.class);
        container.registerComponentImplementation(S4.class);
        container.registerComponentImplementation(S5.class);
        container.registerComponentImplementation(S6.class);
        container.registerComponentImplementation(S7.class);
        container.registerComponentImplementation(S8.class);
        container.registerComponentImplementation(Unproxyable1.class);
        container.registerComponentImplementation(Unproxyable2.class);
        container.registerComponentImplementation(Unproxyable3.class);
        container.registerComponentImplementation(Unproxyable4.class);
        container.registerComponentImplementation(Unproxyable5.class);
        container.registerComponentImplementation(Proxyable.class);
        container.registerComponentImplementation(Proxyable2.class);
        ContextManager manager = (ContextManager)container.getComponentInstanceOfType(ContextManager.class);
        Assert.assertNotNull((Object)manager);
        this.testScope(container, manager, true);
        this.testScope(container, manager, false);
        try {
            container.getComponentInstanceOfType(Unproxyable1.class);
            Assert.fail((String)"An exception is expected as the class is unproxyable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(Unproxyable2.class);
            Assert.fail((String)"An exception is expected as the class is unproxyable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(Unproxyable3.class);
            Assert.fail((String)"An exception is expected as the class is unproxyable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(Unproxyable4.class);
            Assert.fail((String)"An exception is expected as the class is unproxyable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(Unproxyable5.class);
            Assert.fail((String)"An exception is expected as the class is unproxyable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(Proxyable.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(Proxyable2.class));
        try {
            ((S1)container.getComponentInstanceOfType(S1.class)).getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        S4 s4 = (S4)container.getComponentInstanceOfType(S4.class);
        Assert.assertSame((Object)s4, (Object)container.getComponentInstanceOfType(S4.class));
        Assert.assertSame(Singleton.class, (Object)((MX4JComponentAdapter)container.getComponentAdapterOfType(S4.class)).getScope());
        S5 s5 = (S5)container.getComponentInstanceOfType(S5.class);
        Assert.assertSame((Object)s5, (Object)container.getComponentInstanceOfType(S5.class));
        Assert.assertSame(Singleton.class, (Object)((MX4JComponentAdapter)container.getComponentAdapterOfType(S5.class)).getScope());
        S6 s6 = (S6)container.getComponentInstanceOfType(S6.class);
        Assert.assertNotSame((Object)s6, (Object)container.getComponentInstanceOfType(S6.class));
        Assert.assertSame(Dependent.class, (Object)((MX4JComponentAdapter)container.getComponentAdapterOfType(S6.class)).getScope());
        S7 s7 = (S7)container.getComponentInstanceOfType(S7.class);
        Assert.assertNotSame((Object)s7, (Object)container.getComponentInstanceOfType(S7.class));
        Assert.assertSame(Dependent.class, (Object)((MX4JComponentAdapter)container.getComponentAdapterOfType(S7.class)).getScope());
        S8 s8 = (S8)container.getComponentInstanceOfType(S8.class);
        Assert.assertSame((Object)s8, (Object)container.getComponentInstanceOfType(S8.class));
        Assert.assertSame(ApplicationScoped.class, (Object)((MX4JComponentAdapter)container.getComponentAdapterOfType(S8.class)).getScope());
        try {
            s4.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s5.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s6.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s7.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s8.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<Object, Object> mapReq1 = new HashMap<Object, Object>();
        ServletRequest req1 = this.createProxy(ServletRequest.class, mapReq1);
        manager.getContext(RequestScoped.class).activate((Object)req1);
        S1 s1 = (S1)container.getComponentInstanceOfType(S1.class);
        int s1Id = s1.getId();
        Assert.assertEquals((long)1L, (long)mapReq1.size());
        Assert.assertNotNull((Object)s1);
        Assert.assertSame((Object)s1, (Object)container.getComponentInstanceOfType(S1.class));
        Assert.assertEquals((long)s1Id, (long)((S1)container.getComponentInstanceOfType(S1.class)).getId());
        Assert.assertEquals((long)s1Id, (long)s1.getId());
        Assert.assertEquals((long)s1Id, (long)s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s1.getId3());
        Assert.assertSame((Object)s1, (Object)s4.s1);
        Assert.assertEquals((long)s1Id, (long)s4.s1.getId());
        Assert.assertEquals((long)s1Id, (long)s4.s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s4.s1.getId3());
        Assert.assertSame((Object)s1, (Object)s5.s1);
        Assert.assertEquals((long)s1Id, (long)s5.s1.getId());
        Assert.assertEquals((long)s1Id, (long)s5.s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s5.s1.getId3());
        Assert.assertSame((Object)s1, (Object)s6.s1);
        Assert.assertEquals((long)s1Id, (long)s6.s1.getId());
        Assert.assertEquals((long)s1Id, (long)s6.s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s6.s1.getId3());
        Assert.assertSame((Object)s1, (Object)s7.s1);
        Assert.assertEquals((long)s1Id, (long)s7.s1.getId());
        Assert.assertEquals((long)s1Id, (long)s7.s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s7.s1.getId3());
        Assert.assertSame((Object)s1, (Object)s8.s1);
        Assert.assertEquals((long)s1Id, (long)s8.s1.getId());
        Assert.assertEquals((long)s1Id, (long)s8.s1.getId2());
        Assert.assertEquals((long)s1Id, (long)s8.s1.getId3());
        Assert.assertNotNull((Object)s1.getDep1());
        Assert.assertNotNull((Object)s1.getDep2());
        Assert.assertNotNull((Object)s1.getDep3());
        Assert.assertNotNull((Object)s1.getDep4());
        Assert.assertNotNull((Object)s1.getDep5());
        Assert.assertSame((Object)s1.getDep1(), (Object)container.getComponentInstanceOfType(S1_DEP1.class));
        int dep1Id = s1.getDep1().getId();
        Assert.assertEquals((long)dep1Id, (long)((S1_DEP1)container.getComponentInstanceOfType(S1_DEP1.class)).getId());
        Assert.assertEquals((long)s1.getDep1().getId(), (long)s1.getDep1Id());
        Assert.assertSame((Object)s1.getDep2(), (Object)container.getComponentInstanceOfType(S1_DEP2.class));
        try {
            s1.getDep2().getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertSame((Object)s1.getDep3(), (Object)container.getComponentInstanceOfType(S1_DEP3.class));
        Assert.assertEquals((long)s1.getDep3().getId(), (long)((S1_DEP3)container.getComponentInstanceOfType(S1_DEP3.class)).getId());
        Assert.assertSame((Object)s1.getDep4(), (Object)container.getComponentInstanceOfType(S1_DEP4.class));
        Assert.assertEquals((long)s1.getDep4().getId(), (long)((S1_DEP4)container.getComponentInstanceOfType(S1_DEP4.class)).getId());
        Assert.assertNotSame((Object)s1.getDep5(), (Object)container.getComponentInstanceOfType(S1_DEP5.class));
        Assert.assertSame((Object)s1.getDep6(), (Object)container.getComponentInstanceOfType(S1_DEP6.class));
        Assert.assertEquals((long)s1.getDep6().getId(), (long)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getId());
        Assert.assertSame((Object)s1, (Object)s1.getDep6().getS1());
        Assert.assertEquals((long)s1.getId(), (long)s1.getDep6().getS1().getId());
        Assert.assertSame((Object)s1, (Object)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getS1());
        Assert.assertEquals((long)s1.getId(), (long)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getS1().getId());
        manager.getContext(RequestScoped.class).deactivate((Object)req1);
        Assert.assertTrue((boolean)mapReq1.isEmpty());
        s4 = (S4)container.getComponentInstanceOfType(S4.class);
        Assert.assertSame((Object)s1, (Object)s4.s1);
        s5 = (S5)container.getComponentInstanceOfType(S5.class);
        Assert.assertSame((Object)s1, (Object)s5.s1);
        s6 = (S6)container.getComponentInstanceOfType(S6.class);
        Assert.assertSame((Object)s1, (Object)s6.s1);
        s7 = (S7)container.getComponentInstanceOfType(S7.class);
        Assert.assertSame((Object)s1, (Object)s7.s1);
        s8 = (S8)container.getComponentInstanceOfType(S8.class);
        Assert.assertSame((Object)s1, (Object)s8.s1);
        try {
            ((S1)container.getComponentInstanceOfType(S1.class)).getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s4.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s5.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s6.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s7.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s8.s1.getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServletRequest req2 = this.createProxy(ServletRequest.class, new HashMap<Object, Object>());
        manager.getContext(RequestScoped.class).activate((Object)req2);
        S1 s1_2 = (S1)container.getComponentInstanceOfType(S1.class);
        Assert.assertNotNull((Object)s1_2);
        Assert.assertSame((Object)s1_2, (Object)container.getComponentInstanceOfType(S1.class));
        Assert.assertEquals((long)s1_2.getId(), (long)((S1)container.getComponentInstanceOfType(S1.class)).getId());
        Assert.assertFalse((s1_2.getId() == s1Id ? 1 : 0) != 0);
        Assert.assertSame((Object)s1_2, (Object)s4.s1);
        Assert.assertEquals((long)s1_2.getId(), (long)s4.s1.getId());
        Assert.assertEquals((long)s1_2.getId(), (long)s4.s1.getId2());
        Assert.assertEquals((long)s1_2.getId(), (long)s4.s1.getId3());
        Assert.assertSame((Object)s1_2, (Object)s5.s1);
        Assert.assertEquals((long)s1_2.getId(), (long)s5.s1.getId());
        Assert.assertEquals((long)s1_2.getId(), (long)s5.s1.getId2());
        Assert.assertEquals((long)s1_2.getId(), (long)s5.s1.getId3());
        Assert.assertSame((Object)s1_2, (Object)s6.s1);
        Assert.assertEquals((long)s1_2.getId(), (long)s6.s1.getId());
        Assert.assertEquals((long)s1_2.getId(), (long)s6.s1.getId2());
        Assert.assertEquals((long)s1_2.getId(), (long)s6.s1.getId3());
        Assert.assertSame((Object)s1_2, (Object)s7.s1);
        Assert.assertEquals((long)s1_2.getId(), (long)s7.s1.getId());
        Assert.assertEquals((long)s1_2.getId(), (long)s7.s1.getId2());
        Assert.assertEquals((long)s1_2.getId(), (long)s7.s1.getId3());
        Assert.assertSame((Object)s1_2, (Object)s8.s1);
        Assert.assertEquals((long)s1_2.getId(), (long)s8.s1.getId());
        Assert.assertEquals((long)s1_2.getId(), (long)s8.s1.getId2());
        Assert.assertEquals((long)s1_2.getId(), (long)s8.s1.getId3());
        Assert.assertNotNull((Object)s1_2.getDep1());
        Assert.assertNotNull((Object)s1_2.getDep2());
        Assert.assertNotNull((Object)s1_2.getDep3());
        Assert.assertNotNull((Object)s1_2.getDep4());
        Assert.assertNotNull((Object)s1_2.getDep5());
        Assert.assertSame((Object)s1_2.getDep1(), (Object)container.getComponentInstanceOfType(S1_DEP1.class));
        Assert.assertEquals((long)s1_2.getDep1().getId(), (long)((S1_DEP1)container.getComponentInstanceOfType(S1_DEP1.class)).getId());
        Assert.assertEquals((long)s1_2.getDep1().getId(), (long)s1_2.getDep1Id());
        Assert.assertTrue((s1_2.getDep1().getId() != dep1Id ? 1 : 0) != 0);
        Assert.assertSame((Object)s1_2.getDep2(), (Object)container.getComponentInstanceOfType(S1_DEP2.class));
        try {
            s1_2.getDep2().getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertSame((Object)s1_2.getDep3(), (Object)container.getComponentInstanceOfType(S1_DEP3.class));
        Assert.assertEquals((long)s1_2.getDep3().getId(), (long)((S1_DEP3)container.getComponentInstanceOfType(S1_DEP3.class)).getId());
        Assert.assertSame((Object)s1_2.getDep4(), (Object)container.getComponentInstanceOfType(S1_DEP4.class));
        Assert.assertEquals((long)s1_2.getDep4().getId(), (long)((S1_DEP4)container.getComponentInstanceOfType(S1_DEP4.class)).getId());
        Assert.assertNotSame((Object)s1_2.getDep5(), (Object)container.getComponentInstanceOfType(S1_DEP5.class));
        Assert.assertSame((Object)s1_2.getDep6(), (Object)container.getComponentInstanceOfType(S1_DEP6.class));
        Assert.assertEquals((long)s1_2.getDep6().getId(), (long)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getId());
        Assert.assertSame((Object)s1_2, (Object)s1_2.getDep6().getS1());
        Assert.assertEquals((long)s1_2.getId(), (long)s1_2.getDep6().getS1().getId());
        Assert.assertSame((Object)s1_2, (Object)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getS1());
        Assert.assertEquals((long)s1_2.getId(), (long)((S1_DEP6)container.getComponentInstanceOfType(S1_DEP6.class)).getS1().getId());
        manager.getContext(RequestScoped.class).deactivate((Object)req2);
        try {
            ((S2)container.getComponentInstanceOfType(S2.class)).getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.getContext(SessionScoped.class).activate(null);
        try {
            ((S2)container.getComponentInstanceOfType(S2.class)).getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.getContext(SessionScoped.class).deactivate(null);
        HashMap<Object, Object> mapSession1 = new HashMap<Object, Object>();
        HttpSession session1 = this.createProxy(HttpSession.class, mapSession1);
        manager.getContext(SessionScoped.class).register((Object)session1);
        manager.getContext(SessionScoped.class).activate(null);
        try {
            ((S2)container.getComponentInstanceOfType(S2.class)).getId();
            Assert.fail((String)"An exception is expected as the scope is not active");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)mapSession1.isEmpty());
        manager.getContext(SessionScoped.class).deactivate(null);
        manager.getContext(SessionScoped.class).activate((Object)session1);
        try {
            container.getComponentInstanceOfType(S20.class);
            Assert.fail((String)"An exception is expected as it is a passivating scope and S20 is not serializable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        S2 s2 = (S2)container.getComponentInstanceOfType(S2.class);
        Assert.assertNotNull((Object)s2);
        int s2Id = s2.getId();
        Assert.assertSame((Object)s2, (Object)container.getComponentInstanceOfType(S2.class));
        Assert.assertEquals((long)s2Id, (long)((S2)container.getComponentInstanceOfType(S2.class)).getId());
        manager.getContext(SessionScoped.class).deactivate((Object)session1);
        manager.getContext(SessionScoped.class).activate((Object)session1);
        S2 s2_2 = (S2)container.getComponentInstanceOfType(S2.class);
        Assert.assertNotNull((Object)s2_2);
        Assert.assertSame((Object)s2_2, (Object)container.getComponentInstanceOfType(S2.class));
        Assert.assertSame((Object)s2_2, (Object)s2);
        Assert.assertEquals((long)s2_2.getId(), (long)s2Id);
        manager.getContext(SessionScoped.class).deactivate((Object)session1);
        HashMap<Object, Object> mapSession2 = new HashMap<Object, Object>();
        HttpSession session2 = this.createProxy(HttpSession.class, mapSession2);
        manager.getContext(SessionScoped.class).register((Object)session2);
        manager.getContext(SessionScoped.class).activate((Object)session2);
        S2 s2_3 = (S2)container.getComponentInstanceOfType(S2.class);
        Assert.assertNotNull((Object)s2_3);
        Assert.assertSame((Object)s2_3, (Object)container.getComponentInstanceOfType(S2.class));
        Assert.assertFalse((s2_3.getId() == s2Id ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mapSession2.size());
        manager.getContext(SessionScoped.class).deactivate((Object)session2);
        Assert.assertEquals((long)1L, (long)mapSession2.size());
        manager.getContext(SessionScoped.class).unregister((Object)session2);
        Assert.assertTrue((boolean)mapSession2.isEmpty());
        manager.getContext(SessionScoped.class).unregister((Object)session1);
        Assert.assertTrue((boolean)mapSession1.isEmpty());
        manager.getContext(SessionScoped.class).activate((Object)session1);
        ((S2)container.getComponentInstanceOfType(S2.class)).getId();
        Assert.assertEquals((long)1L, (long)mapSession1.size());
        manager.getContext(SessionScoped.class).deactivate((Object)session1);
        HashMap<Object, Object> mapSession3 = new HashMap<Object, Object>();
        HttpSession session3 = this.createProxy(HttpSession.class, mapSession2);
        manager.getContext(SessionScoped.class).register((Object)session3);
        this.checkConcurrentAccesses(container, S2.class, mapSession3, HttpSession.class, manager.getContext(SessionScoped.class));
        manager.getContext(SessionScoped.class).unregister((Object)session3);
        S3 s3 = (S3)container.getComponentInstanceOfType(S3.class);
        Assert.assertNotNull((Object)s3);
        Assert.assertSame((Object)s3, (Object)container.getComponentInstanceOfType(S3.class));
        Assert.assertEquals((long)s3.getId(), (long)((S3)container.getComponentInstanceOfType(S3.class)).getId());
    }

    private <T> T createProxy(Class<T> type, final Map<Object, Object> map) {
        Object o = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if ("setAttribute".equals(method.getName())) {
                    Object o = map.put(args[0], args[1]);
                    if (o != null) {
                        throw new IllegalStateException("A value has already been set");
                    }
                } else {
                    if ("getAttribute".equals(method.getName())) {
                        return map.get(args[0]);
                    }
                    if ("removeAttribute".equals(method.getName())) {
                        map.remove(args[0]);
                    } else {
                        if ("getId".equals(method.getName())) {
                            return Integer.toString(System.identityHashCode(map));
                        }
                        if ("getAttributeNames".equals(method.getName())) {
                            final Iterator keys = map.keySet().iterator();
                            return new Enumeration<Object>(){

                                @Override
                                public boolean hasMoreElements() {
                                    return keys.hasNext();
                                }

                                @Override
                                public Object nextElement() {
                                    return keys.next();
                                }
                            };
                        }
                    }
                }
                return null;
            }
        });
        return type.cast(o);
    }

    private <K> void checkConcurrentAccesses(final RootContainer container, final Class<? extends S> type, final Map<Object, Object> map, final Class<K> keyType, final AdvancedContext<K> context) throws Exception {
        int reader = 20;
        final CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        final CopyOnWriteArrayList ids = new CopyOnWriteArrayList();
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(reader);
        final List<Exception> errors = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < reader; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Object key = TestExoContainer.this.createProxy(keyType, map);
                    try {
                        context.activate(key);
                        startSignal.await();
                        S s = (S)container.getComponentInstanceOfType(type);
                        ids.add(s.getId());
                        results.add(s);
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                        context.deactivate(key);
                    }
                }
            };
            thread.start();
        }
        startSignal.countDown();
        doneSignal.await();
        if (!errors.isEmpty()) {
            for (Exception e : errors) {
                e.printStackTrace();
            }
            throw errors.get(0);
        }
        Assert.assertEquals((long)reader, (long)results.size());
        Assert.assertEquals((long)reader, (long)ids.size());
        S value = (S)results.get(0);
        int id = (Integer)ids.get(0);
        for (int i = 1; i < reader; ++i) {
            Assert.assertSame((Object)value, results.get(i));
            Assert.assertEquals((long)id, (long)((Integer)ids.get(i)).intValue());
        }
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testGetExternalComponentPluginsUnused() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).build();
        PortalContainer container = PortalContainer.getInstance();
        Assert.assertNull((Object)container.getExternalComponentPluginsUnused());
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testGetExternalComponentPluginsUnused").build();
        container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container.getExternalComponentPluginsUnused());
        Assert.assertEquals((long)1L, (long)container.getExternalComponentPluginsUnused().size());
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        container = PortalContainer.getInstance();
        Assert.assertNull((Object)container.getExternalComponentPluginsUnused());
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration", "testGetExternalComponentPluginsUnused").build();
        container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container.getExternalComponentPluginsUnused());
        Assert.assertEquals((long)1L, (long)container.getExternalComponentPluginsUnused().size());
    }

    @Test
    public void testDefinitionByType() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        RootContainer rootContainer = new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration1.class));
        Assert.assertTrue((boolean)((AutoRegistration1)container.getComponentInstanceOfType(AutoRegistration1.class)).started);
        Assert.assertNotNull((Object)((AutoRegistration1)container.getComponentInstanceOfType(AutoRegistration1.class)).plugin);
        Assert.assertEquals((Object)"AutoRegistration1", (Object)((AutoRegistration1)container.getComponentInstanceOfType(AutoRegistration1.class)).plugin.getName());
        Assert.assertNull((Object)rootContainer.getComponentInstanceOfType(AutoRegistration1.class));
        try {
            container.getComponentInstanceOfType(AutoRegistration2.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration3.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration4.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistration5.class, false));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration5.class));
        Assert.assertTrue((boolean)(container.getComponentInstanceOfType(AutoRegistration6.class) instanceof AutoRegistration6Type));
        try {
            container.getComponentInstanceOfType(AutoRegistration7.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration8.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistration9.class, false));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration9.class));
    }

    @Test
    public void testDefinitionByTypeWithProvider() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        container.registerComponentImplementation(AutoRegistration1P.class);
        container.registerComponentImplementation(AutoRegistration2P.class);
        container.registerComponentImplementation(AutoRegistration3P.class);
        container.registerComponentImplementation(AutoRegistration4P.class);
        container.registerComponentImplementation(AutoRegistration5P.class);
        container.registerComponentImplementation(AutoRegistration6P.class);
        container.registerComponentImplementation(AutoRegistration7P.class);
        container.registerComponentImplementation(AutoRegistration8P.class);
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration1P.class));
        Assert.assertNotNull(((AutoRegistration1P)container.getComponentInstanceOfType(AutoRegistration1P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistration1P)container.getComponentInstanceOfType(AutoRegistration1P.class)).p.get());
        Assert.assertTrue((boolean)((AutoRegistration1)((AutoRegistration1P)container.getComponentInstanceOfType(AutoRegistration1P.class)).p.get()).started);
        Assert.assertNotNull((Object)((AutoRegistration1)((AutoRegistration1P)container.getComponentInstanceOfType(AutoRegistration1P.class)).p.get()).plugin);
        Assert.assertEquals((Object)"AutoRegistration1", (Object)((AutoRegistration1)((AutoRegistration1P)container.getComponentInstanceOfType(AutoRegistration1P.class)).p.get()).plugin.getName());
        try {
            container.getComponentInstanceOfType(AutoRegistration2P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration3P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration4P.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration5P.class));
        Assert.assertNotNull(((AutoRegistration5P)container.getComponentInstanceOfType(AutoRegistration5P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistration5P)container.getComponentInstanceOfType(AutoRegistration5P.class)).p.get());
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistration6P.class));
        Assert.assertNotNull(((AutoRegistration6P)container.getComponentInstanceOfType(AutoRegistration6P.class)).p);
        Assert.assertTrue((boolean)(((AutoRegistration6P)container.getComponentInstanceOfType(AutoRegistration6P.class)).p.get() instanceof AutoRegistration6Type));
        try {
            container.getComponentInstanceOfType(AutoRegistration7P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistration8P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDefinitionByName() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        RootContainer rootContainer = new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistrationN1.class));
        Assert.assertNull((Object)container.getComponentInstance((Object)"", AutoRegistrationN1.class, false));
        Assert.assertNotNull((Object)container.getComponentInstance((Object)"", AutoRegistrationN1.class));
        Assert.assertTrue((boolean)((AutoRegistrationN1)container.getComponentInstance((Object)"", AutoRegistrationN1.class)).started);
        Assert.assertNotNull((Object)((AutoRegistrationN1)container.getComponentInstance((Object)"", AutoRegistrationN1.class)).plugin);
        Assert.assertEquals((Object)"AutoRegistrationN1", (Object)((AutoRegistrationN1)container.getComponentInstance((Object)"", AutoRegistrationN1.class)).plugin.getName());
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationN1.class));
        Assert.assertNull((Object)rootContainer.getComponentInstance((Object)"", AutoRegistrationN1.class));
        Assert.assertNull((Object)rootContainer.getComponentInstanceOfType(AutoRegistrationN1.class));
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN2.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN3.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN4.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistrationN5.class));
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN5.class);
            Assert.fail((String)"An exception is expected as the type is not compatible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance((Object)"foo", AutoRegistrationN5.class, false));
        Assert.assertNotNull((Object)container.getComponentInstance((Object)"foo", AutoRegistrationN5.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationN5.class));
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN5.class);
            Assert.fail((String)"An exception is expected as the type is not compatible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance((Object)"foo2", AutoRegistrationN6.class, false));
        Assert.assertTrue((boolean)(container.getComponentInstance((Object)"foo2", AutoRegistrationN6.class) instanceof AutoRegistrationN6Type));
        try {
            container.getComponentInstance((Object)"", AutoRegistrationN7.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance((Object)"foo3", AutoRegistrationN8.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance((Object)"foo4", AutoRegistrationN9.class, false));
        Assert.assertTrue((boolean)(container.getComponentInstance((Object)"foo4", AutoRegistrationN9.class) instanceof AutoRegistrationN9));
    }

    @Test
    public void testDefinitionByNameWithProvider() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        container.registerComponentImplementation(AutoRegistrationN1P.class);
        container.registerComponentImplementation(AutoRegistrationN2P.class);
        container.registerComponentImplementation(AutoRegistrationN3P.class);
        container.registerComponentImplementation(AutoRegistrationN4P.class);
        container.registerComponentImplementation(AutoRegistrationN5P.class);
        container.registerComponentImplementation(AutoRegistrationN5P2.class);
        container.registerComponentImplementation(AutoRegistrationN6P.class);
        container.registerComponentImplementation(AutoRegistrationN7P.class);
        container.registerComponentImplementation(AutoRegistrationN8P.class);
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationN1P.class));
        Assert.assertNotNull(((AutoRegistrationN1P)container.getComponentInstanceOfType(AutoRegistrationN1P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistrationN1P)container.getComponentInstanceOfType(AutoRegistrationN1P.class)).p.get());
        Assert.assertTrue((boolean)((AutoRegistrationN1)((AutoRegistrationN1P)container.getComponentInstanceOfType(AutoRegistrationN1P.class)).p.get()).started);
        Assert.assertNotNull((Object)((AutoRegistrationN1)((AutoRegistrationN1P)container.getComponentInstanceOfType(AutoRegistrationN1P.class)).p.get()).plugin);
        Assert.assertEquals((Object)"AutoRegistrationN1", (Object)((AutoRegistrationN1)((AutoRegistrationN1P)container.getComponentInstanceOfType(AutoRegistrationN1P.class)).p.get()).plugin.getName());
        try {
            container.getComponentInstanceOfType(AutoRegistrationN2P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationN3P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationN4P.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationN5P.class));
        Assert.assertNotNull(((AutoRegistrationN5P)container.getComponentInstanceOfType(AutoRegistrationN5P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistrationN5P)container.getComponentInstanceOfType(AutoRegistrationN5P.class)).p.get());
        try {
            container.getComponentInstanceOfType(AutoRegistrationN5P2.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationN6P.class));
        Assert.assertNotNull(((AutoRegistrationN6P)container.getComponentInstanceOfType(AutoRegistrationN6P.class)).p);
        Assert.assertTrue((boolean)(((AutoRegistrationN6P)container.getComponentInstanceOfType(AutoRegistrationN6P.class)).p.get() instanceof AutoRegistrationN6Type));
        try {
            container.getComponentInstanceOfType(AutoRegistrationN7P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationN8P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDefinitionByQualifier() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        RootContainer rootContainer = new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ1.class));
        Assert.assertNull((Object)container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class, false));
        Assert.assertNotNull((Object)container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class));
        Assert.assertTrue((boolean)((AutoRegistrationQ1)container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class)).started);
        Assert.assertNotNull((Object)((AutoRegistrationQ1)container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class)).plugin);
        Assert.assertEquals((Object)"AutoRegistrationQ1", (Object)((AutoRegistrationQ1)container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class)).plugin.getName());
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ1.class));
        Assert.assertNull((Object)rootContainer.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ1.class));
        Assert.assertNull((Object)rootContainer.getComponentInstanceOfType(AutoRegistrationQ1.class));
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ2.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ3.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ4.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ5.class));
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ5.class);
            Assert.fail((String)"An exception is expected as the type is not compatible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance(AutoRegistrationQualifier2.class, AutoRegistrationQ5.class, false));
        Assert.assertNotNull((Object)container.getComponentInstance(AutoRegistrationQualifier2.class, AutoRegistrationQ5.class));
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ5.class));
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ5.class);
            Assert.fail((String)"An exception is expected as the type is not compatible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance(AutoRegistrationQualifier3.class, AutoRegistrationQ6.class, false));
        Assert.assertTrue((boolean)(container.getComponentInstance(AutoRegistrationQualifier3.class, AutoRegistrationQ6.class) instanceof AutoRegistrationQ6Type));
        try {
            container.getComponentInstance(AutoRegistrationQualifier1.class, AutoRegistrationQ7.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstance(AutoRegistrationQualifier4.class, AutoRegistrationQ8.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)container.getComponentInstance(AutoRegistrationBadQualifier.class, AutoRegistrationQ9.class));
        Assert.assertNull((Object)container.getComponentInstance(AutoRegistrationQualifier4.class, AutoRegistrationQ10.class, false));
        Assert.assertTrue((boolean)(container.getComponentInstance(AutoRegistrationQualifier4.class, AutoRegistrationQ10.class) instanceof AutoRegistrationQ10));
    }

    @Test
    public void testDefinitionByQualifierWithProvider() {
        URL rootURL = this.getClass().getResource("empty-config.xml");
        URL portalURL = this.getClass().getResource("test-exo-container.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testAutoRegistration").build();
        PortalContainer container = PortalContainer.getInstance();
        container.registerComponentImplementation(AutoRegistrationQ1P.class);
        container.registerComponentImplementation(AutoRegistrationQ2P.class);
        container.registerComponentImplementation(AutoRegistrationQ3P.class);
        container.registerComponentImplementation(AutoRegistrationQ4P.class);
        container.registerComponentImplementation(AutoRegistrationQ5P.class);
        container.registerComponentImplementation(AutoRegistrationQ5P2.class);
        container.registerComponentImplementation(AutoRegistrationQ6P.class);
        container.registerComponentImplementation(AutoRegistrationQ7P.class);
        container.registerComponentImplementation(AutoRegistrationQ8P.class);
        container.registerComponentImplementation(AutoRegistrationQ9P.class);
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ1P.class));
        Assert.assertNotNull(((AutoRegistrationQ1P)container.getComponentInstanceOfType(AutoRegistrationQ1P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistrationQ1P)container.getComponentInstanceOfType(AutoRegistrationQ1P.class)).p.get());
        Assert.assertTrue((boolean)((AutoRegistrationQ1)((AutoRegistrationQ1P)container.getComponentInstanceOfType(AutoRegistrationQ1P.class)).p.get()).started);
        Assert.assertNotNull((Object)((AutoRegistrationQ1)((AutoRegistrationQ1P)container.getComponentInstanceOfType(AutoRegistrationQ1P.class)).p.get()).plugin);
        Assert.assertEquals((Object)"AutoRegistrationQ1", (Object)((AutoRegistrationQ1)((AutoRegistrationQ1P)container.getComponentInstanceOfType(AutoRegistrationQ1P.class)).p.get()).plugin.getName());
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ2P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ3P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ4P.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ5P.class));
        Assert.assertNotNull(((AutoRegistrationQ5P)container.getComponentInstanceOfType(AutoRegistrationQ5P.class)).p);
        Assert.assertNotNull((Object)((AutoRegistrationQ5P)container.getComponentInstanceOfType(AutoRegistrationQ5P.class)).p.get());
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ5P2.class);
            Assert.fail((String)"An exception is expected as the type is not correct");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ6P.class));
        Assert.assertNotNull(((AutoRegistrationQ6P)container.getComponentInstanceOfType(AutoRegistrationQ6P.class)).p);
        Assert.assertTrue((boolean)(((AutoRegistrationQ6P)container.getComponentInstanceOfType(AutoRegistrationQ6P.class)).p.get() instanceof AutoRegistrationQ6Type));
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ7P.class);
            Assert.fail((String)"An exception is expected as the class is an abstract class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            container.getComponentInstanceOfType(AutoRegistrationQ8P.class);
            Assert.fail((String)"An exception is expected as the class is an interface");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)container.getComponentInstanceOfType(AutoRegistrationQ9P.class));
        Assert.assertNull(((AutoRegistrationQ9P)container.getComponentInstanceOfType(AutoRegistrationQ9P.class)).p);
    }

    @Test
    public void testSerializationRecursivity() {
        URL rootURL = this.getClass().getResource("test-exo-container.xml");
        URL portalURL = this.getClass().getResource("empty-config.xml");
        Assert.assertNotNull((Object)rootURL);
        Assert.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).profiledBy("testSerializationRecursivity").build();
        RootContainer container = RootContainer.getInstance();
        String xmlConfig = container.getConfigurationXML();
        SerializationRecursivity1 sr1 = (SerializationRecursivity1)container.getComponentInstanceOfType(SerializationRecursivity1.class);
        sr1.sr2.sr3 = (SerializationRecursivity3)container.getComponentInstanceOfType(SerializationRecursivity3.class);
        Assert.assertEquals((Object)xmlConfig, (Object)container.getConfigurationXML());
        PortalContainer pcontainer = PortalContainer.getInstance();
        xmlConfig = pcontainer.getConfigurationXML();
        sr1 = (SerializationRecursivity1)container.getComponentInstanceOfType(SerializationRecursivity1.class);
        sr1.sr2.sr3 = (SerializationRecursivity3)container.getComponentInstanceOfType(SerializationRecursivity3.class);
        Assert.assertEquals((Object)xmlConfig, (Object)pcontainer.getConfigurationXML());
    }

    public static class SerializationRecursivity3 {
    }

    public static class SerializationRecursivity2 {
        private SerializationRecursivity3 sr3;
    }

    public static class SerializationRecursivity1 {
        private SerializationRecursivity2 sr2;

        public SerializationRecursivity1(InitParams params) {
            this.sr2 = (SerializationRecursivity2)params.getObjectParam("SerializationRecursivity2").getObject();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AutoRegistrationBadQualifier {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface AutoRegistrationQualifier5 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface AutoRegistrationQualifier4 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface AutoRegistrationQualifier3 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface AutoRegistrationQualifier2 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface AutoRegistrationQualifier1 {
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier4.class, target={RootContainer.class})
    public static class AutoRegistrationQ10 {
    }

    public static class AutoRegistrationQ9P {
        @Inject
        @AutoRegistrationBadQualifier
        public Provider<AutoRegistrationQ9> p;
    }

    public static class AutoRegistrationQ9Type
    implements AutoRegistrationQ9 {
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationBadQualifier.class, type=AutoRegistrationQ9Type.class)
    public static interface AutoRegistrationQ9 {
    }

    public static class AutoRegistrationQ8P {
        @Inject
        @AutoRegistrationQualifier4
        public Provider<AutoRegistrationQ8> p;
    }

    public static interface AutoRegistrationQ8Type
    extends AutoRegistrationQ8 {
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier4.class, type=AutoRegistrationQ8Type.class)
    public static interface AutoRegistrationQ8 {
    }

    public static class AutoRegistrationQ7P {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ7> p;
    }

    public static abstract class AutoRegistrationQ7Type
    implements AutoRegistrationQ7 {
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier1.class, type=AutoRegistrationQ7Type.class)
    public static interface AutoRegistrationQ7 {
    }

    public static class AutoRegistrationQ6P {
        @Inject
        @AutoRegistrationQualifier3
        public Provider<AutoRegistrationQ6> p;
    }

    public static class AutoRegistrationQ6Type
    implements AutoRegistrationQ6 {
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier3.class, type=AutoRegistrationQ6Type.class)
    public static interface AutoRegistrationQ6 {
    }

    public static class AutoRegistrationQ5P2 {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ5> p;
    }

    public static class AutoRegistrationQ5P {
        @Inject
        @AutoRegistrationQualifier2
        public Provider<AutoRegistrationQ5> p;
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier2.class, type=AutoRegistrationQ5.class)
    public static class AutoRegistrationQ5 {
    }

    public static class AutoRegistrationQ4P {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ4> p;
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier1.class, type=AutoRegistrationQ1.class)
    public static class AutoRegistrationQ4 {
    }

    public static class AutoRegistrationQ3P {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ3> p;
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier1.class)
    public static interface AutoRegistrationQ3 {
    }

    public static class AutoRegistrationQ2P {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ2> p;
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier1.class)
    public static abstract class AutoRegistrationQ2 {
    }

    public static class AutoRegistrationQ1P {
        @Inject
        @AutoRegistrationQualifier1
        public Provider<AutoRegistrationQ1> p;
    }

    @DefinitionByQualifier(qualifier=AutoRegistrationQualifier1.class)
    public static class AutoRegistrationQ1
    implements Startable {
        boolean started;
        ComponentPlugin plugin;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }

        public void add(ComponentPlugin plugin) {
            this.plugin = plugin;
        }
    }

    @DefinitionByName(named="foo4", target={RootContainer.class})
    public static class AutoRegistrationN9 {
    }

    public static class AutoRegistrationN8P {
        @Inject
        @Named(value="foo3")
        public Provider<AutoRegistrationN8> p;
    }

    public static interface AutoRegistrationN8Type
    extends AutoRegistrationN8 {
    }

    @DefinitionByName(named="foo3", type=AutoRegistrationN8Type.class)
    public static interface AutoRegistrationN8 {
    }

    public static class AutoRegistrationN7P {
        @Inject
        @Named
        public Provider<AutoRegistrationN7> p;
    }

    public static abstract class AutoRegistrationN7Type
    implements AutoRegistrationN7 {
    }

    @DefinitionByName(type=AutoRegistrationN7Type.class)
    public static interface AutoRegistrationN7 {
    }

    public static class AutoRegistrationN6P {
        @Inject
        @Named(value="foo2")
        public Provider<AutoRegistrationN6> p;
    }

    public static class AutoRegistrationN6Type
    implements AutoRegistrationN6 {
    }

    @DefinitionByName(named="foo2", type=AutoRegistrationN6Type.class)
    public static interface AutoRegistrationN6 {
    }

    public static class AutoRegistrationN5P2 {
        @Inject
        @Named
        public Provider<AutoRegistrationN5> p;
    }

    public static class AutoRegistrationN5P {
        @Inject
        @Named(value="foo")
        public Provider<AutoRegistrationN5> p;
    }

    @DefinitionByName(named="foo", type=AutoRegistrationN5.class)
    public static class AutoRegistrationN5 {
    }

    public static class AutoRegistrationN4P {
        @Inject
        @Named
        public Provider<AutoRegistrationN4> p;
    }

    @DefinitionByName(type=AutoRegistrationN1.class)
    public static class AutoRegistrationN4 {
    }

    public static class AutoRegistrationN3P {
        @Inject
        @Named
        public Provider<AutoRegistrationN3> p;
    }

    @DefinitionByName
    public static interface AutoRegistrationN3 {
    }

    public static class AutoRegistrationN2P {
        @Inject
        @Named
        public Provider<AutoRegistrationN2> p;
    }

    @DefinitionByName
    public static abstract class AutoRegistrationN2 {
    }

    public static class AutoRegistrationN1P {
        @Inject
        @Named
        public Provider<AutoRegistrationN1> p;
    }

    @DefinitionByName
    public static class AutoRegistrationN1
    implements Startable {
        boolean started;
        ComponentPlugin plugin;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }

        public void add(ComponentPlugin plugin) {
            this.plugin = plugin;
        }
    }

    @DefinitionByType(target={RootContainer.class})
    public static class AutoRegistration9 {
    }

    public static class AutoRegistration8P {
        @Inject
        public Provider<AutoRegistration8> p;
    }

    public static interface AutoRegistration8Type
    extends AutoRegistration8 {
    }

    @DefinitionByType(type=AutoRegistration8Type.class)
    public static interface AutoRegistration8 {
    }

    public static class AutoRegistration7P {
        @Inject
        public Provider<AutoRegistration7> p;
    }

    public static abstract class AutoRegistration7Type
    implements AutoRegistration7 {
    }

    @DefinitionByType(type=AutoRegistration7Type.class)
    public static interface AutoRegistration7 {
    }

    public static class AutoRegistration6P {
        @Inject
        public Provider<AutoRegistration6> p;
    }

    public static class AutoRegistration6Type
    implements AutoRegistration6 {
    }

    @DefinitionByType(type=AutoRegistration6Type.class)
    public static interface AutoRegistration6 {
    }

    public static class AutoRegistration5P {
        @Inject
        public Provider<AutoRegistration5> p;
    }

    @DefinitionByType(type=AutoRegistration5.class)
    public static class AutoRegistration5 {
    }

    public static class AutoRegistration4P {
        @Inject
        public Provider<AutoRegistration4> p;
    }

    @DefinitionByType(type=AutoRegistration1.class)
    public static class AutoRegistration4 {
    }

    public static class AutoRegistration3P {
        @Inject
        public Provider<AutoRegistration3> p;
    }

    @DefinitionByType
    public static interface AutoRegistration3 {
    }

    public static class AutoRegistration2P {
        @Inject
        public Provider<AutoRegistration2> p;
    }

    @DefinitionByType
    public static abstract class AutoRegistration2 {
    }

    public static class AutoRegistration1P {
        @Inject
        public Provider<AutoRegistration1> p;
    }

    @DefinitionByType
    public static class AutoRegistration1
    implements Startable {
        boolean started;
        ComponentPlugin plugin;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }

        public void add(ComponentPlugin plugin) {
            this.plugin = plugin;
        }
    }

    @RequestScoped
    public static class Proxyable2 {
        public static void foo() {
        }
    }

    @RequestScoped
    public static class Proxyable {
        private final void foo() {
        }
    }

    @RequestScoped
    public static class Unproxyable5 {
        protected final void foo() {
        }
    }

    @RequestScoped
    public static class Unproxyable4 {
        protected final void foo() {
        }
    }

    @RequestScoped
    public static class Unproxyable3 {
        public final void foo() {
        }
    }

    @RequestScoped
    public static final class Unproxyable2 {
    }

    @RequestScoped
    public static class Unproxyable1 {
        @Inject
        public Unproxyable1(S1 s1) {
        }
    }

    @ApplicationScoped
    public static class S9 {
    }

    public static class S8
    extends S9 {
        @Inject
        private S1 s1;
    }

    @Dependent
    public static class S7 {
        @Inject
        private S1 s1;
    }

    public static class S6 {
        @Inject
        private S1 s1;
    }

    public static class S5 {
        private S1 s1;

        public S5(S1 s1) {
            this.s1 = s1;
        }
    }

    @Singleton
    public static class S4 {
        @Inject
        private S1 s1;
    }

    public static interface S {
        public int getId();
    }

    @ApplicationScoped
    public static class S3
    implements S {
        private final int id = System.identityHashCode(this);

        @Override
        public int getId() {
            return this.id;
        }
    }

    @SessionScoped
    public static class S2
    implements S,
    Serializable {
        private final int id = System.identityHashCode(this);

        @Override
        public int getId() {
            return this.id;
        }
    }

    @SessionScoped
    public static class S20 {
    }

    @RequestScoped
    public static class S1_DEP6 {
        @Inject
        public S1 s1;
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }

        public S1 getS1() {
            return this.s1;
        }
    }

    @Dependent
    public static class S1_DEP5 {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @Singleton
    public static class S1_DEP4 {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @ApplicationScoped
    public static class S1_DEP3 {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @SessionScoped
    public static class S1_DEP2
    implements Serializable {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @RequestScoped
    public static class S1_DEP1 {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @RequestScoped
    public static class S1 {
        private final int id = System.identityHashCode(this);
        private S1_DEP1 dep1;
        private int dep1Id;
        @Inject
        protected S1_DEP2 dep2;
        @Inject
        public S1_DEP3 dep3;
        @Inject
        private S1_DEP4 dep4;
        private S1_DEP5 dep5;
        private S1_DEP6 dep6;

        public int getId() {
            return this.id;
        }

        protected int getId2() {
            return this.id;
        }

        int getId3() {
            return this.id;
        }

        @Inject
        public void setDep1(S1_DEP1 dep1) {
            this.dep1 = dep1;
            this.dep1Id = dep1.getId();
        }

        @Inject
        protected void setDep5(S1_DEP5 dep5) {
            this.dep5 = dep5;
        }

        @Inject
        void setDep6(S1_DEP6 dep6) {
            this.dep6 = dep6;
        }

        public S1_DEP1 getDep1() {
            return this.dep1;
        }

        public int getDep1Id() {
            return this.dep1Id;
        }

        public S1_DEP2 getDep2() {
            return this.dep2;
        }

        public S1_DEP3 getDep3() {
            return this.dep3;
        }

        public S1_DEP4 getDep4() {
            return this.dep4;
        }

        public S1_DEP5 getDep5() {
            return this.dep5;
        }

        public S1_DEP6 getDep6() {
            return this.dep6;
        }
    }

    public static abstract class AS0 {
        private final int id = System.identityHashCode(this);

        public int getId() {
            return this.id;
        }
    }

    @MyPseudoScope
    @MyStereotype10
    public static class S052
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyNormalScope
    @MyStereotype10
    public static class S051
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyPseudoScope
    @MyStereotype9
    public static class S050
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyNormalScope
    @MyStereotype9
    public static class S049
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype2
    @MyStereotype8
    public static class S048
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyStereotype8
    public static class S047
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype8
    public static class S046
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @Singleton
    @ApplicationScoped
    public static class S045
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @Singleton
    @Dependent
    public static class S044
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype3
    @MyStereotype7
    public static class S043
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyStereotype3
    public static class S042
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyStereotype2
    public static class S041
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype3
    @MyStereotype6
    public static class S040
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype2
    @MyStereotype5
    public static class S039
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyStereotype4
    public static class S038
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype3
    public static class S037
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype2
    public static class S036
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    public static class S035
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype3
    @MyPseudoScope
    public static class S034
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype3
    @MyNormalScope
    public static class S033
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype2
    @MyPseudoScope
    public static class S032
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype2
    @MyNormalScope
    public static class S031
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyPseudoScope
    public static class S030
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyStereotype
    @MyNormalScope
    public static class S029
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyPseudoScope
    public static class S028
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyNormalScope
    public static class S027
    extends AS0 {
        @Inject
        public void init() {
        }
    }

    @MyPseudoScope
    @MyStereotype10
    public static class S026
    extends AS0 {
    }

    @MyNormalScope
    @MyStereotype10
    public static class S025
    extends AS0 {
    }

    @MyPseudoScope
    @MyStereotype9
    public static class S024
    extends AS0 {
    }

    @MyNormalScope
    @MyStereotype9
    public static class S023
    extends AS0 {
    }

    @MyStereotype2
    @MyStereotype8
    public static class S022
    extends AS0 {
    }

    @MyStereotype
    @MyStereotype8
    public static class S021
    extends AS0 {
    }

    @MyStereotype8
    public static class S020
    extends AS0 {
    }

    @Singleton
    @ApplicationScoped
    public static class S019
    extends AS0 {
    }

    @Singleton
    @Dependent
    public static class S018
    extends AS0 {
    }

    @MyStereotype3
    @MyStereotype7
    public static class S017
    extends AS0 {
    }

    @MyStereotype
    @MyStereotype3
    public static class S016
    extends AS0 {
    }

    @MyStereotype
    @MyStereotype2
    public static class S015
    extends AS0 {
    }

    @MyStereotype3
    @MyStereotype6
    public static class S014
    extends AS0 {
    }

    @MyStereotype2
    @MyStereotype5
    public static class S013
    extends AS0 {
    }

    @MyStereotype
    @MyStereotype4
    public static class S012
    extends AS0 {
    }

    @MyStereotype3
    public static class S011
    extends AS0 {
    }

    @MyStereotype2
    public static class S010
    extends AS0 {
    }

    @MyStereotype
    public static class S09
    extends AS0 {
    }

    @MyStereotype3
    @MyPseudoScope
    public static class S08
    extends AS0 {
    }

    @MyStereotype3
    @MyNormalScope
    public static class S07
    extends AS0 {
    }

    @MyStereotype2
    @MyPseudoScope
    public static class S06
    extends AS0 {
    }

    @MyStereotype2
    @MyNormalScope
    public static class S05
    extends AS0 {
    }

    @MyStereotype
    @MyPseudoScope
    public static class S04
    extends AS0 {
    }

    @MyStereotype
    @MyNormalScope
    public static class S03
    extends AS0 {
    }

    @MyPseudoScope
    public static class S02
    extends AS0 {
    }

    @MyNormalScope
    public static class S0
    extends AS0 {
    }

    @MyPseudoScope
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype10 {
    }

    @MyNormalScope
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype9 {
    }

    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype8 {
    }

    @ApplicationScoped
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype7 {
    }

    @RequestScoped
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype6 {
    }

    @Dependent
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype5 {
    }

    @Singleton
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype4 {
    }

    @RequestScoped
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype3 {
    }

    @Dependent
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype2 {
    }

    @Singleton
    @Stereotype
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MyStereotype {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Scope
    public static @interface MyPseudoScope {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @NormalScope
    @Inherited
    public static @interface MyNormalScope {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface N1 {
    }

    @Singleton
    public static class JSR330_N8_3
    extends JSR330_N8 {
    }

    public static class JSR330_N8_2
    extends JSR330_N8 {
    }

    public static class JSR330_N8 {
        @Inject
        public void setJSR330_N2(JSR330_N2 n) {
        }
    }

    public static class JSR330_N7_2
    extends JSR330_N7 {
    }

    public static class JSR330_N7 {
        @Inject
        public JSR330_N2 n;
    }

    public static class JSR330_N2_6
    extends JSR330_N2 {
    }

    public static class JSR330_N2_5
    extends JSR330_N2 {
        protected JSR330_N2_5() {
        }
    }

    public static class JSR330_N2_4
    extends JSR330_N2 {
        private JSR330_N2_4() {
        }
    }

    public static class JSR330_N2_3
    extends JSR330_N2 {
        JSR330_N2_3() {
        }
    }

    public static class JSR330_N2_2
    extends JSR330_N2 {
        public JSR330_N2_2() {
        }

        public JSR330_N2_2(JSR330_N n) {
        }
    }

    public static class JSR330_N2
    extends JSR330_N {
        @Inject
        public JSR330_N2() {
        }
    }

    public static class JSR330_N1
    extends JSR330_N {
    }

    public static class JSR330_N {
    }

    public static class JSR330_P4 {
        @Inject
        public JSR330_P4(int value) {
        }
    }

    @Singleton
    public static class JSR330_P3 {
        private JSR330_A a;

        @Inject
        public void setA(JSR330_A a) {
            this.a = a;
        }
    }

    public static class JSR330_P2 {
        private final JSR330_A a;

        @Inject
        public JSR330_P2(JSR330_A a) {
            this.a = a;
        }

        public JSR330_P2(JSR330_A a, JSR330_B b) {
            this.a = null;
        }
    }

    @Singleton
    public static class JSR330_P1 {
        @Inject
        JSR330_A a;
    }

    public static abstract class JSR330_D1 {
        protected JSR330_A a5;
        protected int calledInit2;

        @Inject
        private void setA5(JSR330_A a) {
            this.a5 = a;
        }

        @Inject
        public abstract void init();

        @Inject
        public void init2() {
            ++this.calledInit2;
        }

        @Inject
        public void init2(JSR330_A a) {
            this.init2();
        }
    }

    public static class JSR330_D
    extends JSR330_D1 {
        private JSR330_A a;
        private JSR330_A a2;
        private JSR330_A a3;
        private JSR330_A a4;
        private Provider<JSR330_P3> p3;
        @Inject
        private Provider<JSR330_P4> p4;
        private int value;
        private int calledInit;
        private JSR330_N n;
        private JSR330_N n2;

        @Inject
        public void setA(JSR330_A a) {
            this.a = a;
        }

        @Inject
        private void setA2(JSR330_A a) {
            this.a2 = a;
        }

        @Inject
        protected void setA3(JSR330_A a) {
            this.a3 = a;
        }

        @Inject
        void setA4(JSR330_A a) {
            this.a4 = a;
        }

        @Inject
        void setP3(Provider<JSR330_P3> p3) {
            this.p3 = p3;
        }

        @Inject
        void setValue(int value) {
            this.value = value;
        }

        @Inject
        void setN(@Named(value="n2") JSR330_N n) {
            this.n = n;
        }

        @Inject
        void setN2(@N1 JSR330_N n2) {
            this.n2 = n2;
        }

        @Override
        @Inject
        public void init() {
            ++this.calledInit;
        }

        @Override
        @Inject
        public void init2() {
            super.init2();
        }

        @Override
        @Inject
        public void init2(JSR330_A a) {
            super.init2();
        }
    }

    public static class JSR330_C6 {
        JSR330_C6() {
        }
    }

    public static class JSR330_C5 {
        @Inject
        JSR330_C5(int value) {
        }
    }

    public static class JSR330_C4 {
        private final JSR330_A a;

        @Inject
        JSR330_C4(JSR330_A a) {
            this.a = a;
        }
    }

    public static class JSR330_C3 {
        private final JSR330_A a;

        @Inject
        private JSR330_C3(JSR330_A a) {
            this.a = a;
        }
    }

    public static class JSR330_C2 {
        private final JSR330_A a;

        @Inject
        protected JSR330_C2(JSR330_A a) {
            this.a = a;
        }
    }

    public static class JSR330_C {
        private final JSR330_A a;
        private final Provider<JSR330_P2> p2;
        private final JSR330_N n;
        private final JSR330_N n2;

        @Inject
        public JSR330_C(JSR330_A a, Provider<JSR330_P2> p2, @Named(value="n2") JSR330_N n, @N1 JSR330_N n2) {
            this.a = a;
            this.p2 = p2;
            this.n = n;
            this.n2 = n2;
        }

        public JSR330_C(JSR330_A a, JSR330_B b, Provider<JSR330_P2> p2, JSR330_N n, JSR330_N n2) {
            this.a = null;
            this.p2 = null;
            this.n = null;
            this.n2 = null;
        }
    }

    public static class JSR330_B1 {
        @Inject
        private JSR330_A a5;

        protected JSR330_A getA5() {
            return this.a5;
        }
    }

    public static class JSR330_B
    extends JSR330_B1 {
        @Inject
        private JSR330_A a;
        @Inject
        protected JSR330_A a2;
        @Inject
        public JSR330_A a3;
        @Inject
        JSR330_A a4;
        @Inject
        private final JSR330_A a6 = null;
        @Inject
        private static JSR330_A a7;
        @Inject
        private Provider<JSR330_P1> p1;
        @Inject
        private int value;
        @Inject
        @Named(value="n2")
        private JSR330_N n;
        @Inject
        @N1
        private JSR330_N n2;
    }

    public static class JSR330_A {
    }

    public static class SortedConstructorsF {
        public SortedConstructorsF(String a) {
        }

        public SortedConstructorsF(String a, String b) {
        }

        public SortedConstructorsF(String a, String b, String c) {
        }
    }

    public static class SortedConstructorsE {
        public SortedConstructorsE(String a) {
        }

        public SortedConstructorsE(String a, String b, String c) {
        }

        public SortedConstructorsE(String a, String b) {
        }
    }

    public static class SortedConstructorsD {
        public SortedConstructorsD(String a, String b) {
        }

        public SortedConstructorsD(String a, String b, String c) {
        }

        public SortedConstructorsD(String a) {
        }
    }

    public static class SortedConstructorsC {
        public SortedConstructorsC(String a, String b) {
        }

        public SortedConstructorsC(String a) {
        }

        public SortedConstructorsC(String a, String b, String c) {
        }
    }

    public static class SortedConstructorsB {
        public SortedConstructorsB(String a, String b, String c) {
        }

        public SortedConstructorsB(String a) {
        }

        public SortedConstructorsB(String a, String b) {
        }
    }

    public static class SortedConstructorsA {
        public SortedConstructorsA(String a, String b, String c) {
        }

        public SortedConstructorsA(String a, String b) {
        }

        public SortedConstructorsA(String a) {
        }
    }

    public static class CCTC3 {
        public ExoContainer container = ExoContainerContext.getCurrentContainer();
    }

    public static class CCTC2 {
        public ExoContainer container = ExoContainerContext.getCurrentContainer();
    }

    public static class CCTC1 {
        public ExoContainer container = ExoContainerContext.getCurrentContainer();
        public CCTC2 c2;
        public CCTC3 c3;

        public CCTC1(CCTC2 c2, CCTC3 c3) {
            this.c2 = c2;
            this.c3 = c3;
        }
    }

    public static class ContainerOwnerHolder
    implements Startable {
        ContainerOwner co;

        public ContainerOwnerHolder(ContainerOwner co) {
            this.co = co;
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public static class ContainerOwner
    implements Startable {
        ExoContainer container;

        public void start() {
            this.container = new ExoContainer(parent);
            parent.registerComponentInstance((Object)"TestContainerOwner", (Object)this.container);
            this.container.registerComponentImplementation(ContainerOwnerHolder.class);
            this.container.start();
        }

        public void stop() {
        }
    }

    public static class TSC2Plugin
    extends BaseComponentPlugin {
        TSC2 tsc2;

        public TSC2Plugin(TSC2 tsc2) {
            this.tsc2 = tsc2;
        }
    }

    public static class TSC2 {
        TSC2Plugin plugin;

        public void addPlugin(TSC2Plugin plugin) {
            this.plugin = plugin;
        }
    }

    public static class TSC1 {
        TSC2Plugin plugin;

        public void addPlugin(TSC2Plugin plugin) {
            this.plugin = plugin;
        }
    }

    public static class TS4
    implements Disposable {
        public int disposed;

        public void dispose() {
            ++this.disposed;
        }
    }

    public static class TS3
    implements Startable {
        public int started;
        public int stopped;

        public void start() {
            ++this.started;
        }

        public void stop() {
            ++this.stopped;
        }
    }

    public static class TS2
    implements Disposable {
        public int disposed;

        public void dispose() {
            ++this.disposed;
        }
    }

    public static class TS1
    implements Startable {
        public int started;
        public int stopped;

        public void start() {
            ++this.started;
        }

        public void stop() {
            ++this.stopped;
        }
    }

    public static class MyServiceImpl
    implements MySpecialService,
    Startable {
        ComponentPlugin componentPlugin;

        @Override
        public void addPlugin(ComponentPlugin componentPlugin) {
            this.componentPlugin = componentPlugin;
        }

        public void stop() {
        }

        public void start() {
        }
    }

    public static interface MySpecialService
    extends MyService {
    }

    public static interface MyService {
        public void addPlugin(ComponentPlugin var1);
    }

    public static class MyPlugin
    extends BaseComponentPlugin {
        MySpecialService svc;

        public MyPlugin(MySpecialService svc) {
            this.svc = svc;
        }
    }

    public static class SOE2C {
        public SOE1C soe1;

        public SOE2C(SOE1C soe1) {
            this.soe1 = soe1;
        }
    }

    public static class SOEPluginC
    extends SOEPluginCR {
        public SOE2C soe2 = (SOE2C)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SOE2C.class);
    }

    public static class SOEPluginCR
    extends BaseComponentPlugin {
    }

    public static class SOE1C {
        public List<SOEPluginCR> plugins = new ArrayList<SOEPluginCR>();

        public void addPlugin(SOEPluginCR plugin) {
            this.plugins.add(plugin);
        }
    }

    public static class SOE2B
    implements Startable {
        public SOE1B soe1 = (SOE1B)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SOE1B.class);
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class SOEPluginB
    extends BaseComponentPlugin {
        public SOE2B soe2;

        public SOEPluginB(SOE2B soe2) {
            this.soe2 = soe2;
        }
    }

    public static class SOE1B
    implements Startable {
        public List<SOEPluginB> plugins = new ArrayList<SOEPluginB>();
        public int startOrder;

        public void addPlugin(SOEPluginB plugin) {
            this.plugins.add(plugin);
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class SOE2 {
        public SOE1 soe1 = (SOE1)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SOE1.class);
    }

    public static class SOEPlugin
    extends BaseComponentPlugin {
        public SOE2 soe2;

        public SOEPlugin(SOE2 soe2) {
            this.soe2 = soe2;
        }
    }

    public static class SOE1 {
        public List<SOEPlugin> plugins = new ArrayList<SOEPlugin>();

        public void addPlugin(SOEPlugin plugin) {
            this.plugins.add(plugin);
        }
    }

    public static class LC5
    implements Disposable {
        public boolean disposed;

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class LC4
    implements Startable {
        public boolean started;
        public boolean stopped;

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }
    }

    public static class LC3
    implements Startable,
    Disposable {
        public boolean started;
        public boolean stopped;
        public boolean disposed;

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }

        public void dispose() {
            throw new RuntimeException();
        }
    }

    public static class LC2
    implements Startable,
    Disposable {
        public boolean started;
        public boolean stopped;
        public boolean disposed;

        public void start() {
            this.started = true;
        }

        public void stop() {
            throw new RuntimeException();
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class LC1
    implements Startable,
    Disposable {
        public boolean started;
        public boolean stopped;
        public boolean disposed;

        public void start() {
            throw new RuntimeException();
        }

        public void stop() {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    @Singleton
    public static class C2_4
    implements Startable {
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    @Singleton
    public static class C2_3
    implements Startable {
        public C2_4 c4;
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }

        @Inject
        public void setC4(C2_4 c4) {
            this.c4 = c4;
        }
    }

    @Singleton
    public static class C2_2
    implements Startable {
        public C2_3 c3;
        public C2_4 c4;
        public int startOrder;

        @Inject
        public C2_2(C2_4 c4, C2_3 c3) {
            this.c3 = c3;
            this.c4 = c4;
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    @Singleton
    public static class C2_1
    implements Startable {
        @Inject
        public C2_2 c2;
        @Inject
        protected C2_3 c3;
        @Inject
        private C2_4 c4;
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }

        public C2_2 getC2() {
            return this.c2;
        }

        public C2_3 getC3() {
            return this.c3;
        }

        public C2_4 getC4() {
            return this.c4;
        }
    }

    public static class C2
    implements Startable {
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class P
    extends BaseComponentPlugin {
        public C0 c0;
        public C1 c1;
        public C2 c2;

        public P(C0 c0, C1 c1, C2 c2) {
            this.c0 = c0;
            this.c1 = c1;
            this.c2 = c2;
        }
    }

    public static class C1
    implements Startable {
        public int startOrder;
        P p;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }

        public void add(P p) {
            this.p = p;
        }
    }

    public static class C0
    implements Startable {
        public int startOrder;
        C1 c1;

        public C0(C1 c1) {
            this.c1 = c1;
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class DummyClass {
    }

    private class DummyAdapter
    implements ComponentAdapter<DummyClass> {
        private DummyAdapter() {
        }

        public Object getComponentKey() {
            return "testKey";
        }

        public DummyClass getComponentInstance() {
            throw new RuntimeException();
        }

        public Class<DummyClass> getComponentImplementation() {
            return DummyClass.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    public static class B {
        public A a;
        public BPlugin plugin_;

        public void add(BPlugin plugin) {
            this.plugin_ = plugin;
            this.a = plugin.a;
        }
    }

    public static class BPlugin
    extends BaseComponentPlugin {
        public A a;

        public BPlugin(A a) {
            this.a = a;
        }
    }

    public static class A {
        public B b;

        public A(B b) {
            this.b = b;
        }
    }

    public static class B2 {
        public A2 a;

        public B2(A2 a) {
            this.a = a;
        }
    }

    public static class A2
    implements Startable {
        public B2 b;

        public A2(B2 b) {
            this.b = b;
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public static class B1 {
        public A1 a;

        public B1(A1 a) {
            this.a = a;
        }
    }

    public static class A1 {
        public B1 b;

        public A1(B1 b) {
            this.b = b;
        }
    }

    public static class MyContainerLifecyclePlugin3
    extends BaseContainerLifecyclePlugin {
        public void destroyContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.destroy.add(this);
            }
        }

        public void initContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.init.add(this);
            }
        }

        public void startContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.start.add(this);
            }
        }

        public void stopContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.stop.add(this);
            }
        }
    }

    public static class MyContainerLifecyclePlugin2
    extends BaseContainerLifecyclePlugin {
        public final String param;

        public MyContainerLifecyclePlugin2(InitParams params) {
            this.param = params != null ? params.getValueParam("param").getValue() : null;
        }

        public void destroyContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.destroy.add(this);
            }
        }

        public void initContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.init.add(this);
            }
        }

        public void startContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.start.add(this);
            }
        }

        public void stopContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.stop.add(this);
            }
        }
    }

    public static class MyContainerLifecyclePlugin1
    extends BaseContainerLifecyclePlugin {
        public void destroyContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.destroy.add(this);
            }
        }

        public void initContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.init.add(this);
            }
        }

        public void startContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.start.add(this);
            }
        }

        public void stopContainer(ExoContainer container) throws Exception {
            MyCounter counter = (MyCounter)container.getComponentInstanceOfType(MyCounter.class);
            if (counter != null) {
                counter.stop.add(this);
            }
        }
    }

    public static class MyCounter {
        public final List<BaseContainerLifecyclePlugin> init = new ArrayList<BaseContainerLifecyclePlugin>();
        public final List<BaseContainerLifecyclePlugin> start = new ArrayList<BaseContainerLifecyclePlugin>();
        public final List<BaseContainerLifecyclePlugin> stop = new ArrayList<BaseContainerLifecyclePlugin>();
        public final List<BaseContainerLifecyclePlugin> destroy = new ArrayList<BaseContainerLifecyclePlugin>();
    }

    public static class MyClassPlugin2B
    extends BaseComponentPlugin {
        public ConfigurationManager cmanager_;
        public MyClassB myClass_;

        public MyClassPlugin2B(ConfigurationManager cmanager) {
            this.cmanager_ = cmanager;
            this.myClass_ = (MyClassB)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MyClassB.class);
        }
    }

    public static class MyClassPluginB
    extends BaseComponentPlugin {
        public ConfigurationManager cmanager_;
        public MyClassB myClass_;

        public MyClassPluginB(ConfigurationManager cmanager, MyClassB myClass) {
            this.cmanager_ = cmanager;
            this.myClass_ = myClass;
        }
    }

    public static class MyClassB
    implements Startable {
        public MyClassPluginB plugin_;
        public MyClassPlugin2B plugin2_;
        public boolean started;

        public void add(MyClassPluginB plugin) {
            this.plugin_ = plugin;
        }

        public void add(MyClassPlugin2B plugin) {
            this.plugin2_ = plugin;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
        }
    }

    public static class MyClassPlugin2
    extends BaseComponentPlugin {
        public ConfigurationManager cmanager_;
        public MyClass myClass_;

        public MyClassPlugin2(ConfigurationManager cmanager) {
            this.cmanager_ = cmanager;
            this.myClass_ = (MyClass)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MyClass.class);
        }
    }

    public static class MyClassPlugin
    extends BaseComponentPlugin {
        public ConfigurationManager cmanager_;
        public MyClass myClass_;

        public MyClassPlugin(ConfigurationManager cmanager, MyClass myClass) {
            this.cmanager_ = cmanager;
            this.myClass_ = myClass;
        }
    }

    public static class MyClass {
        public MyClassPlugin plugin_;
        public MyClassPlugin2 plugin2_;

        public void add(MyClassPlugin plugin) {
            this.plugin_ = plugin;
        }

        public void add(MyClassPlugin2 plugin) {
            this.plugin2_ = plugin;
        }
    }

    public static class MyMTClass {
        public MyMTClass() throws InterruptedException {
            Thread.sleep(10L);
        }
    }

    public static class TSO3_C
    implements Startable {
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    @Singleton
    public static class TSO3_B
    implements Startable {
        public int startOrder;

        @Inject
        public TSO3_B(TSO3_C c) {
        }

        @Inject
        public void setB(TSO3_B b) {
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    @Singleton
    public static class TSO3_A
    implements Startable {
        public int startOrder;

        @Inject
        public TSO3_A(TSO3_B b) {
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class TSO2_C2
    implements Startable {
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class TSO2_B2
    implements Startable,
    ComponentRequestLifecycle {
        public int startOrder;
        public TSO2_C2 c;

        public TSO2_B2(TSO2_C2 c) {
            this.c = c;
        }

        public void start() {
            try {
                RequestLifeCycle.begin((ComponentRequestLifecycle)this);
                this.startOrder = COUNTER.incrementAndGet();
            }
            finally {
                RequestLifeCycle.end();
            }
        }

        public void stop() {
        }

        public void startRequest(ExoContainer container) {
            if (this.c.startOrder == 0) {
                throw new IllegalStateException("TSO2_C2 should be started");
            }
        }

        public void endRequest(ExoContainer container) {
        }
    }

    public static class TSO2_A2
    implements Startable {
        public int startOrder;
        private ExoContainerContext ctx;

        public TSO2_A2(TSO2_B2 b, ExoContainerContext ctx) {
            this.ctx = ctx;
        }

        public void start() {
            try {
                RequestLifeCycle.begin((ExoContainer)this.ctx.getContainer());
                this.startOrder = COUNTER.incrementAndGet();
            }
            finally {
                RequestLifeCycle.end();
            }
        }

        public void stop() {
        }
    }

    public static class TSO2_D
    implements Startable {
        public int startOrder;

        public TSO2_D(TSO2_C c) {
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class TSO2_C
    implements Startable {
        public int startOrder;

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class TSO2_B {
        public TSO2_B(TSO2_C c, TSO2_D d) {
        }
    }

    public static class TSO2_A
    implements Startable {
        public int startOrder;

        public TSO2_A(TSO2_B b) {
        }

        public void start() {
            this.startOrder = COUNTER.incrementAndGet();
        }

        public void stop() {
        }
    }

    public static class TCNS_DEP
    implements Startable {
        public String value;

        public TCNS_DEP(InitParams params) {
            this.value = params.getValueParam("param").getValue();
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public static class TCNS
    implements Startable {
        public String value;
        public TCNS_DEP dep;

        public TCNS(InitParams params, TCNS_DEP dep) {
            this.dep = dep;
            this.value = params.getValueParam("param").getValue();
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public class CachedComponent {
        public int hash() {
            return this.hashCode();
        }
    }
}

