/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.ContextManager;
import org.exoplatform.container.web.AbstractHttpSessionListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ContextManagerListener
extends AbstractHttpSessionListener
implements ServletRequestListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ContextManagerListener");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer(event);
            if (container == null) {
                return;
            }
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            this.onRequestDestroyed(container, event);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(ServletRequestEvent event) {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer(event);
            if (container == null) {
                return;
            }
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            this.onRequestInitialized(container, event);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
        }
    }

    @Override
    protected boolean requirePortalEnvironment() {
        return false;
    }

    protected void onRequestInitialized(ExoContainer container, ServletRequestEvent event) {
        AdvancedContext<ServletRequest> ctxReq;
        ContextManager manager;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onRequestInitialized called on container = " + (container == null ? null : container.getContext().getName())));
        }
        if ((manager = container.getContextManager()) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestInitialized: no context manager found");
            }
            return;
        }
        AdvancedContext<HttpSession> ctxSess = manager.getContext(SessionScoped.class);
        if (ctxSess != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestInitialized: A context has been found for the scope session");
            }
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request;
                HttpSession session;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"onRequestInitialized: The request is an HttpServletRequest");
                }
                if ((session = (request = (HttpServletRequest)event.getServletRequest()).getSession(false)) != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"onRequestInitialized: A session has been found");
                    }
                    ctxSess.activate(session);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"onRequestInitialized: Session activated");
                    }
                }
            }
        }
        if ((ctxReq = manager.getContext(RequestScoped.class)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestInitialized: A context has been found for the scope request");
            }
            ctxReq.activate(event.getServletRequest());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestInitialized: Request activated");
            }
        }
    }

    protected void onRequestDestroyed(ExoContainer container, ServletRequestEvent event) {
        AdvancedContext<ServletRequest> ctxReq;
        ContextManager manager;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onRequestDestroyed called on container = " + (container == null ? null : container.getContext().getName())));
        }
        if ((manager = container.getContextManager()) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestDestroyed: no context manager found");
            }
            return;
        }
        AdvancedContext<HttpSession> ctxSess = manager.getContext(SessionScoped.class);
        if (ctxSess != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestDestroyed: A context has been found for the scope session");
            }
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request;
                HttpSession session;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"onRequestDestroyed: The request is an HttpServletRequest");
                }
                if ((session = (request = (HttpServletRequest)event.getServletRequest()).getSession(false)) != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"onRequestDestroyed: A session has been found");
                    }
                    ctxSess.deactivate(session);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"onRequestDestroyed: Session deactivated");
                    }
                }
            }
        }
        if ((ctxReq = manager.getContext(RequestScoped.class)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestDestroyed: A context has been found for the scope request");
            }
            ctxReq.deactivate(event.getServletRequest());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onRequestDestroyed: Request deactivated");
            }
        }
    }

    @Override
    protected void onSessionCreated(ExoContainer container, HttpSessionEvent event) {
        ContextManager manager;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onSessionCreated called on container = " + (container == null ? null : container.getContext().getName())));
        }
        if ((manager = container.getContextManager()) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onSessionCreated: no context manager found");
            }
            return;
        }
        AdvancedContext<HttpSession> ctx = manager.getContext(SessionScoped.class);
        if (ctx == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onSessionCreated: no context found for the scope session");
            }
            return;
        }
        ctx.register(event.getSession());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"onSessionCreated: Session registered");
        }
    }

    @Override
    protected void onSessionDestroyed(ExoContainer container, HttpSessionEvent event) {
        ContextManager manager;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onSessionDestroyed called on container = " + (container == null ? null : container.getContext().getName())));
        }
        if ((manager = container.getContextManager()) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onSessionDestroyed: no context manager found");
            }
            return;
        }
        AdvancedContext<HttpSession> ctx = manager.getContext(SessionScoped.class);
        if (ctx == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onSessionDestroyed: no context found for the scope session");
            }
            return;
        }
        ctx.unregister(event.getSession());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"onSessionCreated: Session unregistered");
        }
    }

    protected final ExoContainer getContainer(ServletRequestEvent event) {
        ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance(event.getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    public static void registerIfNeeded(ExoContainer container, ServletContext context) {
        ContextManager manager = container.getContextManager();
        if (manager != null && (manager.hasContext(SessionScoped.class) || manager.hasContext(RequestScoped.class))) {
            context.addListener(ContextManagerListener.class);
        }
    }
}

