/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.bbcode.core.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ks.bbcode.api.BBCode;
import org.exoplatform.ks.bbcode.api.BBCodeService;
import org.exoplatform.ks.bbcode.core.BBCodeServiceImpl;
import org.exoplatform.ks.bbcode.core.cache.data.BBCodeCacheData;
import org.exoplatform.ks.bbcode.core.cache.data.ListBBCodeData;
import org.exoplatform.ks.bbcode.core.cache.key.BBCodeKey;
import org.exoplatform.ks.bbcode.core.cache.model.CacheType;
import org.exoplatform.ks.bbcode.spi.BBCodePlugin;
import org.exoplatform.ks.common.cache.ServiceContext;
import org.exoplatform.ks.common.cache.model.key.SimpleCacheKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedBBCodeService
implements Startable,
BBCodeService {
    private static Log LOG = ExoLogger.getLogger(CachedBBCodeService.class);
    private CacheService service;
    private BBCodeService bbCodeService;
    private ExoCache<BBCodeKey, BBCodeCacheData> bbCodeData;
    private ExoCache<SimpleCacheKey, ListBBCodeData> bbCodeListData;
    private FutureExoCache<BBCodeKey, BBCodeCacheData, ServiceContext<BBCodeCacheData>> bbCodeDataFuture;
    private FutureExoCache<SimpleCacheKey, ListBBCodeData, ServiceContext<ListBBCodeData>> bbCodeListDataFuture;

    public CachedBBCodeService(CacheService service, BBCodeServiceImpl bbCodeService) {
        this.service = service;
        this.bbCodeService = bbCodeService;
    }

    private void clearBBCodeCached(String bbCodeId) {
        this.bbCodeData.remove((Serializable)((Object)new BBCodeKey(bbCodeId)));
    }

    private void clearBBCodeListCached() {
        SimpleCacheKey key = new SimpleCacheKey("bbcode", "forum.bbcode.list.key");
        this.bbCodeListData.remove((Serializable)key);
    }

    @Override
    public void registerBBCodePlugin(BBCodePlugin plugin) throws Exception {
        this.bbCodeService.registerBBCodePlugin(plugin);
    }

    @Override
    public void save(List<BBCode> bbcodes) throws Exception {
        this.bbCodeService.save(bbcodes);
        for (BBCode bb : bbcodes) {
            this.clearBBCodeCached(bb.getId());
        }
        this.clearBBCodeListCached();
    }

    @Override
    public List<BBCode> getAll() throws Exception {
        return this.bbCodeService.getAll();
    }

    @Override
    public List<String> getActive() throws Exception {
        SimpleCacheKey key = new SimpleCacheKey("bbcode", "forum.bbcode.list.key");
        return this.buildBBCodeIdOutput((ListBBCodeData)((Object)this.bbCodeListDataFuture.get((Object)new ServiceContext<ListBBCodeData>(){

            public ListBBCodeData execute() {
                try {
                    List<BBCode> got = CachedBBCodeService.this.getBBCodeActive();
                    return CachedBBCodeService.this.buildBBCodeInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)));
    }

    @Override
    public List<BBCode> getBBCodeActive() throws Exception {
        return this.bbCodeService.getBBCodeActive();
    }

    @Override
    public BBCode findById(final String bbcodeId) throws Exception {
        return ((BBCodeCacheData)this.bbCodeDataFuture.get((Object)new ServiceContext<BBCodeCacheData>(){

            public BBCodeCacheData execute() {
                try {
                    BBCode got = CachedBBCodeService.this.bbCodeService.findById(bbcodeId);
                    if (got != null) {
                        return new BBCodeCacheData(got);
                    }
                    return BBCodeCacheData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new BBCodeKey(bbcodeId))).build();
    }

    @Override
    public void delete(String bbcodeId) throws Exception {
        this.bbCodeService.delete(bbcodeId);
        this.clearBBCodeCached(bbcodeId);
        this.clearBBCodeListCached();
    }

    private ListBBCodeData buildBBCodeInput(List<BBCode> bbCodes) {
        ArrayList<BBCodeKey> data = new ArrayList<BBCodeKey>(bbCodes.size());
        for (BBCode p : bbCodes) {
            data.add(new BBCodeKey(p));
        }
        return new ListBBCodeData(data);
    }

    private List<String> buildBBCodeIdOutput(ListBBCodeData data) {
        if (data == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>(data.getIds().size());
        for (BBCodeKey k : data.getIds()) {
            try {
                out.add(this.findById(k.getBbCodeId()).getId());
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    public void start() {
        this.bbCodeData = CacheType.BBCODE_DATA.getFromService(this.service);
        this.bbCodeListData = CacheType.LIST_BBCODE_DATA.getFromService(this.service);
        this.bbCodeDataFuture = CacheType.BBCODE_DATA.createFutureCache(this.bbCodeData);
        this.bbCodeListDataFuture = CacheType.LIST_BBCODE_DATA.createFutureCache(this.bbCodeListData);
    }

    public void stop() {
    }
}

