/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ks.common.conf;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;

public class DataLocationPlugin extends ManagedPlugin {
  
  private String repository;

  private String workspace;

  public DataLocationPlugin(InitParams params) throws Exception {
    //this.repository = params.getValueParam("repository").getValue();
    this.workspace = params.getValueParam("workspace").getValue();
  }

  @Managed
  @ManagedName("repository")
  @ManagedDescription("Repository where data is located")
  public String getRepository() {
    return repository;
  }

  @Managed
  @ManagedName("workspace")
  @ManagedDescription("workspace in repository where data is located")
  public String getWorkspace() {
    return workspace;
  }

}
