/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.table;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="table-cell")
public class TableCellMacro
extends AbstractMacro<Object> {
    private static final String DESCRIPTION = "Inserts a table cell.";
    @Inject
    private ComponentManager componentManager;

    public TableCellMacro() {
        super("TableCell", DESCRIPTION);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        List childrenBlock = parsedDom.getChildren();
        if (childrenBlock.size() == 1 && childrenBlock.get(0) instanceof ParagraphBlock) {
            return ((Block)childrenBlock.get(0)).getChildren();
        }
        return Collections.singletonList(parsedDom);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }
}

