/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeAnswerPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeAnswerPlugin.class);
    private static final String GROUP_SPACE_ID = "/spaces";
    private KSDataLocation dataLocation;

    public UpgradeAnswerPlugin(InitParams initParams) {
        super(initParams);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.dataLocation = (KSDataLocation)container.getComponentInstance(KSDataLocation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)"\n\n\n\n -----------> processUpgrade Answer Migration......\n\n\n");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"\n\nMigration space....\n");
            this.migrationSpaceOfPLF(sProvider);
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeAnswerPlugin] Exception when migrate data from 2.1.x to 2.2.3 for Answer.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        log.info((Object)"\n\n\n\n -----------> The end Answer Migration......\n\n\n");
    }

    private void migrationSpaceOfPLF(SessionProvider sProvider) throws Exception {
        Node cateHomeNode = this.getCategoryHomeNode(sProvider);
        NodeIterator cIter = cateHomeNode.getNodes();
        if (cIter.getSize() > 0L) {
            Session session = cateHomeNode.getSession();
            Map<String, String> groupIds = this.getAllGroupOfSpaces();
            String parentPath = cateHomeNode.getPath();
            while (cIter.hasNext()) {
                Node cNode = cIter.nextNode();
                if (!cNode.isNodeType("exo:faqCategory")) continue;
                String nodeName = cNode.getName();
                log.info((Object)("\nMigration category : " + nodeName));
                PropertyReader reader = new PropertyReader(cNode);
                String[] permission = reader.strings("exo:userPrivate", new String[]{""});
                String groupId = this.getGroupId(permission);
                if (!groupIds.containsKey(groupId)) continue;
                String newId = Utils.CATE_SPACE_ID_PREFIX + groupId;
                try {
                    if (groupId.equals(reader.string("exo:name", ""))) {
                        cNode.setProperty("exo:name", groupIds.get(groupId));
                    }
                    cNode.setProperty("exo:id", newId);
                    cNode.save();
                    this.migradeChildrenItems(cNode, newId);
                    if (!nodeName.equals(newId)) {
                        session.move(cNode.getPath(), parentPath + "/" + newId);
                        session.save();
                    }
                    log.info((Object)String.format("Rename node of category %s to %s", nodeName, newId));
                }
                catch (Exception e) {
                    log.info((Object)String.format("Failed to rename node of category %s to %s", nodeName, newId));
                }
            }
        }
    }

    private void migradeChildrenItems(Node cateNode, String newName) throws Exception {
        NodeIterator iterator = this.getNodeIterator(cateNode);
        while (iterator.hasNext()) {
            Node cNode = iterator.nextNode();
            try {
                if (!cNode.hasProperty("exo:categoryId")) continue;
                log.info((Object)("\nSet new category id for items children: " + cNode.getName()));
                cNode.setProperty("exo:categoryId", newName);
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to set new name %s for category", newName), (Throwable)e);
            }
        }
        cateNode.save();
    }

    private NodeIterator getNodeIterator(Node node) throws Exception {
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder("/jcr:root").append(node.getNode(Utils.QUESTION_HOME).getPath()).append("//*");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    private String getGroupId(String[] grs) throws Exception {
        for (int i = 0; i < grs.length; ++i) {
            String s = grs[i];
            if (s.indexOf("/spaces/") < 0 || CommonUtils.isEmpty((String)(s = s.substring(s.lastIndexOf("/") + 1)))) continue;
            return s;
        }
        return "";
    }

    private Node getCategoryHomeNode(SessionProvider sProvider) throws Exception {
        return this.getNodeByPath(this.dataLocation.getFaqCategoriesLocation(), sProvider);
    }

    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        if (nodePath.indexOf("/") == 0) {
            nodePath = nodePath.substring(1);
        }
        return this.getSession(sessionProvider).getRootNode().getNode(nodePath);
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    private Session getSession(SessionProvider sProvider) throws Exception {
        return this.dataLocation.getSessionManager().getSession(sProvider);
    }

    private Map<String, String> getAllGroupOfSpaces() throws Exception {
        HashMap<String, String> groupIds = new HashMap<String, String>();
        try {
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)container);
            Group group = organizationService.getGroupHandler().findGroupById(GROUP_SPACE_ID);
            if (group != null) {
                Collection groups = organizationService.getGroupHandler().findGroups(group);
                for (Group gr : groups) {
                    groupIds.put(gr.getGroupName(), gr.getLabel());
                }
            }
            log.info((Object)("\n\n ------> all group: " + groupIds.keySet().toString()));
            ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)container);
        }
        catch (Exception e) {
            log.warn((Object)"\nFailed to get all groups in spaces.", (Throwable)e);
        }
        return groupIds;
    }
}

