/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.io.InputStream;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeForumPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeForumPlugin.class);
    private static final String NEW_DOAMIN_FORUM = "new.domain.forum";
    private String newDomain = "";
    private KSDataLocation dataLocation;

    public UpgradeForumPlugin(InitParams initParams) {
        super(initParams);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.dataLocation = (KSDataLocation)container.getComponentInstance(KSDataLocation.class);
        this.getNewDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)"\n\n\n\n -----------> processUpgrade Forum Migration......\n\n\n");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"\n\nRegister new nodeTypes...\n");
            this.registerNodeTypes("jar:/conf/portal/forum-nodetypes.xml", 0);
            this.registerNodeTypes("jar:/conf/portal/forum-migrate-nodetypes.xml", 4);
            log.info((Object)"\n\nMigration forum data....\n");
            this.migrationForumData(sProvider);
            log.info((Object)"\n\nMigration space....\n");
            this.migrationSpaceOfPLF(sProvider);
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeForumPlugin] Exception when migrate data from 2.1.x to 2.2.3 for Forum.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        log.info((Object)"\n\n\n\n -----------> The end Forum Migration......\n\n\n");
    }

    private void getNewDomain() {
        log.info((Object)"\nGet new domain for migration forum datas...");
        try {
            Properties props = new Properties(System.getProperties());
            this.newDomain = props.getProperty(NEW_DOAMIN_FORUM);
            log.info((Object)("\nnewDomain: " + this.newDomain));
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get new domain in system configation. ", (Throwable)e);
        }
    }

    private void migrationForumData(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHomeNode(sProvider);
        NodeIterator pIter = this.getNodeIterator(sProvider, forumHome, "exo:post", new StringBuilder(""));
        log.info((Object)("\nThe size of list post migration: " + pIter.getSize()));
        String link = null;
        while (pIter.hasNext()) {
            Node pNode = pIter.nextNode();
            log.info((Object)("Migration node " + pNode.getName() + " properties:  "));
            try {
                pNode.getProperty("exo:isWaiting");
            }
            catch (Exception e) {
                pNode.addMixin("exo:forumMigrate");
                pNode.setProperty("exo:isWaiting", false);
                System.out.print(" exo:isWatting=false");
            }
            if (Utils.isEmpty((String)this.newDomain) || Utils.isEmpty((String)(link = this.calculateURL(new PropertyReader(pNode).string("exo:link", ""))))) continue;
            pNode.setProperty("exo:link", link);
            System.out.print(" ,exo:link=" + link);
        }
        if (!Utils.isEmpty((String)this.newDomain)) {
            NodeIterator tIter = this.getNodeIterator(sProvider, forumHome, "exo:topic", new StringBuilder(""));
            log.info((Object)("The size of list topic migration: " + tIter.getSize()));
            while (tIter.hasNext()) {
                Node tNode = tIter.nextNode();
                link = this.calculateURL(new PropertyReader(tNode).string("exo:link", ""));
                if (Utils.isEmpty((String)link)) continue;
                tNode.setProperty("exo:link", link);
                log.info((Object)("Migration node " + tNode.getName() + " properties:  ,exo:link=" + link));
            }
        }
        forumHome.getSession().save();
    }

    private String calculateURL(String oldUrl) {
        if (!Utils.isEmpty((String)oldUrl) && oldUrl.indexOf(this.newDomain) < 0) {
            oldUrl = this.newDomain + oldUrl.substring(oldUrl.indexOf("/", 8));
        }
        return "";
    }

    private void migrationSpaceOfPLF(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHomeNode(sProvider);
        NodeIterator cIter = this.getOldAllNodeCateSpace(sProvider, forumHome);
        log.info((Object)("\nNumber spaces migration: " + cIter.getSize()));
        if (cIter.getSize() > 0L) {
            String fName = null;
            Node newSpNode = this.getCatNSPNode(sProvider, false);
            String newSpPath = newSpNode.getPath();
            log.info((Object)("\nPath of category Spaces: " + newSpPath));
            Session session = forumHome.getSession();
            Map<Object, Object> scInfo = new HashMap();
            try {
                log.info((Object)"\nGet info data social ....");
                scInfo = this.getInfoSocial(sProvider);
                log.info((Object)("\nSize of spaces: " + scInfo.size()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashSet<String> permissions = new HashSet<String>();
            permissions.add("/spaces");
            while (cIter.hasNext()) {
                Node cNode = cIter.nextNode();
                PropertyReader reader = new PropertyReader(cNode);
                String[] permission = reader.strings("exo:userPrivate", new String[]{""});
                log.info((Object)("Migration category : " + cNode.getName()));
                NodeIterator fIter = cNode.getNodes();
                while (fIter.hasNext()) {
                    Node fNode = fIter.nextNode();
                    if (!fNode.isNodeType("exo:forum") || this.hasNodeInSP(sProvider, fNode.getName())) continue;
                    fNode.setProperty("exo:poster", permission);
                    fNode.setProperty("exo:createTopicRole", permission);
                    fNode.setProperty("exo:viewer", permission);
                    fNode.save();
                    fName = fNode.getProperty("exo:name").getString();
                    fName = scInfo.containsKey(fName) ? Utils.FORUM + (String)scInfo.get(fName) : fNode.getName();
                    session.move(fNode.getPath(), newSpPath + "/" + fName);
                    session.save();
                    log.info((Object)String.format("Move forum %s in to category Spaces with new node name %s", fNode.getName(), fName));
                }
                permissions.addAll(Arrays.asList(permission));
                log.info((Object)String.format("Remove old category space: %s ", cNode.getName()));
                cNode.remove();
                session.save();
            }
            newSpNode.setProperty("exo:userPrivate", permissions.toArray(new String[permissions.size()]));
            forumHome.save();
        }
    }

    private boolean hasNodeInSP(SessionProvider sProvider, String id) {
        try {
            this.getCatNSPNode(sProvider, false).getNode(id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        return this.getNodeByPath(this.dataLocation.getForumHomeLocation(), sProvider);
    }

    private Node getCatNSPNode(SessionProvider sProvider, boolean isClear) throws Exception {
        Node categoryHome = this.getNodeByPath(this.dataLocation.getForumCategoriesLocation(), sProvider);
        Node catNode = null;
        String id = Utils.CATEGORY + "spaces";
        try {
            catNode = categoryHome.getNode(id);
            if (isClear) {
                catNode.remove();
                categoryHome.getSession().save();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (catNode == null) {
            catNode = categoryHome.addNode(id, "exo:forumCategory");
            catNode.setProperty("exo:id", id);
            catNode.setProperty("exo:owner", "");
            catNode.setProperty("exo:createdDate", GregorianCalendar.getInstance());
            catNode.setProperty("exo:name", "Spaces");
            catNode.setProperty("exo:categoryOrder", 100L);
            catNode.setProperty("exo:description", "The category sotorage all forums of spaces.");
            catNode.setProperty("exo:modifiedBy", "");
            catNode.setProperty("exo:modifiedDate", GregorianCalendar.getInstance());
            catNode.setProperty("exo:userPrivate", new String[]{"/spaces"});
            catNode.getSession().save();
        }
        return catNode;
    }

    private NodeIterator getOldAllNodeCateSpace(SessionProvider sProvider, Node forumHome) throws Exception {
        StringBuilder strQuery = new StringBuilder("[(@").append("exo:name").append("='spaces') and (jcr:contains(@").append("exo:userPrivate").append(", 'spaces'))]");
        return this.getNodeIterator(sProvider, forumHome, "exo:forumCategory", strQuery);
    }

    private NodeIterator getNodeIterator(SessionProvider sProvider, Node node, String nodeType, StringBuilder strQuery) throws Exception {
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder("/jcr:root").append(node.getPath()).append("//element(*,").append(nodeType).append(")").append((CharSequence)strQuery).append(" order by @").append("exo:name").append(" descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        if (nodePath.indexOf("/") == 0) {
            nodePath = nodePath.substring(1);
        }
        return this.getSession(sessionProvider).getRootNode().getNode(nodePath);
    }

    private void registerNodeTypes(String nodeTypeFilesName, int alreadyExistsBehaviour) throws Exception {
        ConfigurationManager configurationService = (ConfigurationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ConfigurationManager.class);
        InputStream isXml = configurationService.getInputStream(nodeTypeFilesName);
        ExtendedNodeTypeManager ntManager = this.dataLocation.getRepositoryService().getDefaultRepository().getNodeTypeManager();
        log.info((Object)("\nTrying register node types from xml-file " + nodeTypeFilesName));
        ntManager.registerNodeTypes(isXml, alreadyExistsBehaviour, "text/xml");
        log.info((Object)("\nNode types were registered from xml-file " + nodeTypeFilesName));
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return true;
    }

    private Session getSession(SessionProvider sProvider) throws Exception {
        return this.dataLocation.getSessionManager().getSession(sProvider);
    }

    private Map<String, String> getInfoSocial(SessionProvider sProvider) throws Exception {
        NodeIterator csIter = this.getAllSpace(sProvider);
        HashMap<String, String> info = new HashMap<String, String>();
        while (csIter.hasNext()) {
            PropertyReader reader = new PropertyReader(csIter.nextNode());
            String prName = reader.string("soc:name");
            String dsName = reader.string("soc:displayName");
            info.put(dsName, prName);
        }
        return info;
    }

    private NodeIterator getAllSpace(SessionProvider sProvider) throws Exception {
        return this.getNodeIterator(sProvider, this.getSocialHome(sProvider), "soc:spacedefinition", new StringBuilder());
    }

    private Node getSocialHome(SessionProvider sProvider) throws Exception {
        return this.getSessionSocial(sProvider).getRootNode().getNode("production/soc:spaces");
    }

    private Session getSessionSocial(SessionProvider sProvider) throws Exception {
        ManageableRepository repository = this.dataLocation.getRepositoryService().getCurrentRepository();
        return sProvider.getSession("social", repository);
    }
}

