/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.datamigration;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MigrateService
implements Startable {
    private ConfigurationManager configManager_;
    private ExtendedNodeTypeManager ntManager_;
    private NodeHierarchyCreator nodeHierarchy_;
    private InitParams params_;
    private static Log log = ExoLogger.getLogger(MigrateService.class);

    public MigrateService(ConfigurationManager configManager, NodeHierarchyCreator nodeHierarchy, InitParams params) throws Exception {
        this.configManager_ = configManager;
        this.nodeHierarchy_ = nodeHierarchy;
        this.params_ = params;
    }

    public void start() {
        NodeType nt;
        NodeTypeIterator ntIter;
        RepositoryService repoService;
        ExoContainer container;
        try {
            container = ExoContainerContext.getCurrentContainer();
            repoService = (RepositoryService)container.getComponentInstance(RepositoryService.class);
            this.ntManager_ = repoService.getCurrentRepository().getNodeTypeManager();
            ntIter = this.ntManager_.getAllNodeTypes();
            boolean hasAnswerNT = false;
            boolean hasFAQHomeNT = false;
            while (ntIter.hasNext()) {
                nt = ntIter.nextNodeType();
                if (nt.getName().equals("exo:answer")) {
                    hasAnswerNT = true;
                    continue;
                }
                if (!nt.getName().equals("exo:faqHome")) continue;
                hasFAQHomeNT = true;
            }
            if (hasAnswerNT && !hasFAQHomeNT) {
                this.exportFAQData1_1();
                this.removeFAQNodetypes1_1();
            } else if (!hasAnswerNT) {
                this.registerFAQNodetypeForMigration();
                this.faqMigration();
                this.removeFAQMigragionNodetypes();
            } else {
                this.importNewFAQData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            container = ExoContainerContext.getCurrentContainer();
            repoService = (RepositoryService)container.getComponentInstance(RepositoryService.class);
            this.ntManager_ = repoService.getCurrentRepository().getNodeTypeManager();
            ntIter = this.ntManager_.getAllNodeTypes();
            boolean hasForumDataNT = false;
            boolean hasForumServiceNT = false;
            while (ntIter.hasNext()) {
                nt = ntIter.nextNodeType();
                if (nt.getName().equals("exo:forumData")) {
                    hasForumDataNT = true;
                    continue;
                }
                if (!nt.getName().equals("exo:forumHome")) continue;
                hasForumServiceNT = true;
            }
            if (!hasForumDataNT && hasForumServiceNT) {
                this.exportForumData1_1();
                this.removeForumNodetypes1_1();
            } else if (!hasForumServiceNT) {
                this.registerForumNodetypeForMigration();
                this.forumMigration();
                this.removeForumMigragionNodetypes();
            } else {
                this.importNewForumData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFAQData1_1() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQHome(sProvider);
            log.info((Object)"\n\nExporting FAQ data version 1.1 ...");
            String file = this.params_.getValueParam("faqData1.1").getValue();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            faqHome.getSession().exportSystemView(faqHome.getPath(), (OutputStream)bos, false, false);
            this.saveToFile(bos.toByteArray(), file);
            log.info((Object)("\nFAQ data has exported to " + file + "\n\n"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportForumData1_1() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHome(sProvider);
            log.info((Object)"\n\nExporting Forum data version 1.1 ...");
            String file = this.params_.getValueParam("forumData1.1").getValue();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            forumHome.getSession().exportSystemView(forumHome.getPath(), (OutputStream)bos, false, false);
            this.saveToFile(bos.toByteArray(), file);
            log.info((Object)("\nForum data has exported to " + file + "\n"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFAQNodetypeForMigration() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"Register FAQ nodetypes for migrate data\n");
            String ntFile = this.params_.getValueParam("migrationFAQNodetypes").getValue();
            InputStream in = this.configManager_.getInputStream(ntFile);
            this.ntManager_.registerNodeTypes(in, 0);
            log.info((Object)"FAQ nodetypes for migrate data registered \n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForumNodetypeForMigration() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"Register Forum nodetypes for migrate data");
            String ntFile = this.params_.getValueParam("migrationForumNodetypes").getValue();
            InputStream in = this.configManager_.getInputStream(ntFile);
            this.ntManager_.registerNodeTypes(in, 0);
            log.info((Object)"Forum nodetypes for migrate data registered \n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFAQNodetypes1_1() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQHome(sProvider);
            log.info((Object)"Removing FAQ 1.1 nodetypes in JCR");
            Node nodeTypes = (Node)faqHome.getSession().getItem("/jcr:system/jcr:nodetypes");
            String nt_migrate_File = this.params_.getValueParam("faqNodetypes1.1").getValue();
            InputStream in_migrate = this.configManager_.getInputStream(nt_migrate_File);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in_migrate);
            NodeList list = doc.getElementsByTagName("nodeType");
            for (int i = 0; i < list.getLength(); ++i) {
                try {
                    log.info((Object)("====>" + list.item(i).getAttributes().getNamedItem("name").getNodeValue()));
                    Node NT = nodeTypes.getNode(list.item(i).getAttributes().getNamedItem("name").getNodeValue());
                    NT.remove();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            faqHome.remove();
            nodeTypes.getSession().save();
            log.info((Object)"Nodetypes removed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeForumNodetypes1_1() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHome(sProvider);
            Node nodeTypes = (Node)forumHome.getSession().getItem("/jcr:system/jcr:nodetypes");
            String nt_11_file = this.params_.getValueParam("forumNodetypes1.1").getValue();
            InputStream in_migrate = this.configManager_.getInputStream(nt_11_file);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in_migrate);
            NodeList list = doc.getElementsByTagName("nodeType");
            log.info((Object)"Removing forum 1.1 nodetypes in JCR");
            for (int i = 0; i < list.getLength(); ++i) {
                try {
                    log.info((Object)("====>" + list.item(i).getAttributes().getNamedItem("name").getNodeValue()));
                    Node NT = nodeTypes.getNode(list.item(i).getAttributes().getNamedItem("name").getNodeValue());
                    NT.remove();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            forumHome.remove();
            nodeTypes.getSession().save();
            log.info((Object)"Nodetypes removed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFAQMigragionNodetypes() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQHome(sProvider);
            Node nodeTypes = (Node)faqHome.getSession().getItem("/jcr:system/jcr:nodetypes");
            String nt_migrate_File = this.params_.getValueParam("migrationFAQNodetypes").getValue();
            InputStream in_migrate = this.configManager_.getInputStream(nt_migrate_File);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in_migrate);
            NodeList list = doc.getElementsByTagName("nodeType");
            log.info((Object)"Removing FAQ migrate data nodetypes");
            for (int i = 0; i < list.getLength(); ++i) {
                try {
                    log.info((Object)("====>" + list.item(i).getAttributes().getNamedItem("name").getNodeValue()));
                    Node NT = nodeTypes.getNode(list.item(i).getAttributes().getNamedItem("name").getNodeValue());
                    NT.remove();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.info((Object)"FAQ Nodetypes removed");
            nodeTypes.getSession().save();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeForumMigragionNodetypes() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHome(sProvider);
            Node nodeTypes = (Node)forumHome.getSession().getItem("/jcr:system/jcr:nodetypes");
            String nt_migrate_File = this.params_.getValueParam("migrationForumNodetypes").getValue();
            InputStream in_migrate = this.configManager_.getInputStream(nt_migrate_File);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in_migrate);
            NodeList list = doc.getElementsByTagName("nodeType");
            log.info((Object)"Removing forum migrate data nodetypes");
            for (int i = 0; i < list.getLength(); ++i) {
                try {
                    log.info((Object)("====>" + list.item(i).getAttributes().getNamedItem("name").getNodeValue()));
                    Node NT = nodeTypes.getNode(list.item(i).getAttributes().getNamedItem("name").getNodeValue());
                    NT.remove();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.info((Object)"Forum Nodetypes removed");
            nodeTypes.getSession().save();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importNewFAQData() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String faqData12 = this.params_.getValueParam("faqData1.2").getValue();
            InputStream in = this.configManager_.getInputStream(faqData12);
            Node faqHome = this.getFAQHome(sProvider);
            Node parent = faqHome.getParent();
            faqHome.remove();
            parent.save();
            log.info((Object)"\n >>>>>> Knowledge Suite: FAQ's data version 1.2 is importing.... \n");
            parent.getSession().importXML(parent.getPath(), in, 0);
            parent.getSession().save();
            log.info((Object)"\n >>>>>> Knowledge Suite: FAQ's data version 1.2 is imported succesful !\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void faqMigration() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempNode = this.getFAQTemp(sProvider);
            if (tempNode.hasNodes()) {
                return;
            }
            log.info((Object)"\n\n Knowledge Suite 1.2: Migrating FAQ data from 1.1 to 1.2 ....");
            String faqData11 = this.params_.getValueParam("faqData1.1").getValue();
            log.info((Object)("faqData11===>" + faqData11));
            InputStream in = this.configManager_.getInputStream(faqData11);
            tempNode.getSession().importXML(tempNode.getPath(), in, 0);
            tempNode.getSession().save();
            log.info((Object)"\n >>>>>> Data version 1.1 has imported \n");
            this.migrateFAQData();
            Node faqHome = this.getFAQHome(sProvider);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            faqHome.getSession().exportSystemView(faqHome.getPath(), (OutputStream)bos, false, false);
            String faqData12 = this.params_.getValueParam("faqData1.2").getValue();
            this.saveToFile(bos.toByteArray(), faqData12);
            Node parent = faqHome.getParent();
            faqHome.remove();
            parent.getSession().save();
            log.info((Object)("\n >>>>>> Data version 1.2 has exported to file " + faqData12));
            log.info((Object)"\n Knowledge Suite: Migrate FAQ data 1.1 to 1.2 is finished .... \n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFAQData() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempData = this.getFAQTemp(sProvider);
            if (!tempData.hasNodes()) {
                log.info((Object)">>>>>> There is no FAQ's data for migrating!");
                return;
            }
            Node faqTempHome = tempData.getNode("faqApp");
            if (faqTempHome.hasNode("catetories")) {
                this.migrateFAQCategory(faqTempHome.getNode("catetories"));
            }
            Node parent = tempData.getParent();
            tempData.remove();
            parent.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private Node getFAQTemp(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchy_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode("FAQ_TEMP");
        }
        catch (PathNotFoundException ex) {
            userApp.addNode("FAQ_TEMP", "nt:unstructured");
            userApp.getSession().save();
            return userApp.getNode("FAQ_TEMP");
        }
    }

    private Node getFAQHome(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchy_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode("faqApp");
        }
        catch (PathNotFoundException ex) {
            userApp.addNode("faqApp", "exo:faqHome");
            userApp.getSession().save();
            return userApp.getNode("faqApp");
        }
    }

    private Node getFAQCategoryHome(SessionProvider sProvider) throws Exception {
        try {
            return this.getFAQHome(sProvider).getNode("categories");
        }
        catch (PathNotFoundException ex) {
            Node catHome = this.getFAQHome(sProvider).addNode(org.exoplatform.faq.service.Utils.CATEGORY_HOME, "exo:faqCategory");
            catHome.setProperty("exo:name", "Root");
            catHome.addMixin("mix:faqSubCategory");
            catHome.setProperty("exo:isView", true);
            catHome.getSession().save();
            return catHome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFAQCategory(Node tempcatHome) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getFAQCategoryHome(sProvider);
            NodeIterator iter = tempcatHome.getNodes();
            log.info((Object)" >>>> Migrating FAQ categories ");
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                categoryHome.getSession().getWorkspace().move(node.getPath(), categoryHome.getPath() + "/" + node.getName());
            }
            categoryHome.getSession().save();
            this.repairQuestion();
            this.migrateCategoryChildren();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairQuestion() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempNode = this.getFAQTemp(sProvider);
            QueryManager qm = tempNode.getSession().getWorkspace().getQueryManager();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(tempNode.getPath()).append("//element(*,exo:faqQuestion)[@exo:categoryId='null']");
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node question = iter.nextNode();
                question.setProperty("exo:categoryId", org.exoplatform.faq.service.Utils.CATEGORY_HOME);
                question.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateCategoryChildren() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempNode = this.getFAQTemp(sProvider);
            Node categoryHome = this.getFAQHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)");
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node category = iter.nextNode();
                if (category.canAddMixin("mix:faqSubCategory")) {
                    category.addMixin("mix:faqSubCategory");
                }
                category.setProperty("exo:isView", true);
                Node questionHome = category.addNode(org.exoplatform.faq.service.Utils.QUESTION_HOME, "exo:faqQuestionHome");
                category.save();
                this.migrateQuestion(category.getName(), questionHome, tempNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void migrateQuestion(String categoryId, Node questionHome, Node tempData) {
        log.info((Object)"Migrating questions .... \n");
        try {
            QueryManager qm = questionHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(tempData.getPath()).append("//element(*,exo:faqQuestion)");
            queryBuffer.append("[@exo:categoryId='" + categoryId + "']");
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node question = iter.nextNode();
                log.info((Object)("question ===> " + question.getPath()));
                try {
                    this.migrateAnswer(question);
                    this.migrateComment(question);
                    this.migrateLanguage(question);
                    this.migrateAttachment(question);
                    questionHome.getSession().getWorkspace().move(question.getPath(), questionHome.getPath() + "/" + question.getName());
                    questionHome.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"End migrate questions \n");
    }

    private void migrateAttachment(Node question) {
        log.info((Object)"===> Migrating attachments...");
        try {
            NodeIterator iter = question.getNodes();
            log.info((Object)("attsize ===>" + iter.getSize()));
            while (iter.hasNext()) {
                Node att = iter.nextNode();
                if (!att.isNodeType("nt:file") && !att.isNodeType("exo:faqAttachment")) continue;
                Node attTemp = att;
                Node nodeFile = question.addNode("file" + IdGenerator.generate(), "exo:faqAttachment");
                FAQServiceUtils.reparePermissions((Node)nodeFile, (String)"any");
                Node nodeContent = nodeFile.addNode("jcr:content", "exo:faqResource");
                nodeContent.setProperty("exo:fileName", attTemp.getProperty("exo:fileName").getValue());
                nodeContent.setProperty("exo:categoryId", question.getProperty("exo:categoryId").getValue());
                nodeContent.setProperty("jcr:mimeType", attTemp.getNode("jcr:content").getProperty("jcr:mimeType").getValue());
                nodeContent.setProperty("jcr:data", attTemp.getNode("jcr:content").getProperty("jcr:data").getValue());
                nodeContent.setProperty("jcr:lastModified", attTemp.getNode("jcr:content").getProperty("jcr:lastModified").getValue());
                log.info((Object)("fileName ===>" + nodeContent.getProperty("exo:fileName").getString()));
                att.remove();
            }
            question.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void migrateAnswer(Node question) {
        log.info((Object)"===> Migrating anwsers...");
        try {
            if (question.hasNode(org.exoplatform.faq.service.Utils.ANSWER_HOME)) {
                question.getSession().getWorkspace().move(question.getPath() + "/" + org.exoplatform.faq.service.Utils.ANSWER_HOME, question.getPath() + "/answerTemp");
                question.save();
                Node temp = question.getNode("answerTemp");
                Node answerHome = question.addNode(org.exoplatform.faq.service.Utils.ANSWER_HOME, "exo:answerHome");
                question.save();
                NodeIterator iter = temp.getNodes();
                while (iter.hasNext()) {
                    Node ans = iter.nextNode();
                    ans.setProperty("exo:questionId", question.getName());
                    ans.setProperty("exo:categoryId", question.getProperty("exo:categoryId").getString());
                    ans.setProperty("exo:responseLanguage", question.getProperty("exo:language").getString());
                    ans.setProperty("exo:fullName", ans.getProperty("exo:responseBy").getString());
                    ans.save();
                    answerHome.getSession().getWorkspace().move(ans.getPath(), answerHome.getPath() + "/" + ans.getName());
                }
                temp.remove();
                question.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void migrateComment(Node question) {
        log.info((Object)"===> Migrating comments...");
        try {
            if (question.hasNode(org.exoplatform.faq.service.Utils.COMMENT_HOME)) {
                question.getSession().getWorkspace().move(question.getPath() + "/" + org.exoplatform.faq.service.Utils.COMMENT_HOME, question.getPath() + "/commentTemp");
                question.save();
                Node temp = question.getNode("commentTemp");
                Node commentHome = question.addNode(org.exoplatform.faq.service.Utils.COMMENT_HOME, "exo:commentHome");
                question.save();
                NodeIterator iter = temp.getNodes();
                while (iter.hasNext()) {
                    Node comment = iter.nextNode();
                    comment.setProperty("exo:fullName", comment.getProperty("exo:commentBy").getString());
                    comment.save();
                    commentHome.getSession().getWorkspace().move(comment.getPath(), commentHome.getPath() + "/" + comment.getName());
                }
                temp.remove();
                question.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void migrateLanguage(Node question) {
        log.info((Object)"===> Migrating other question languages ...");
        try {
            if (question.hasNode(org.exoplatform.faq.service.Utils.LANGUAGE_HOME)) {
                question.getSession().getWorkspace().move(question.getPath() + "/" + org.exoplatform.faq.service.Utils.LANGUAGE_HOME, question.getPath() + "/languageTemp");
                question.save();
                Node temp = question.getNode("languageTemp");
                Node languageHome = question.addNode(org.exoplatform.faq.service.Utils.LANGUAGE_HOME, "exo:questionLanguageHome");
                NodeIterator iter = temp.getNodes();
                while (iter.hasNext()) {
                    Node language = iter.nextNode();
                    Node newLang = languageHome.addNode(language.getName(), "exo:faqLanguage");
                    newLang.setProperty("exo:language", language.getProperty("exo:language").getString());
                    newLang.setProperty("exo:name", language.getProperty("exo:name").getString());
                    newLang.setProperty("exo:title", language.getProperty("exo:title").getString());
                    newLang.setProperty("exo:questionId", question.getName());
                    newLang.setProperty("exo:categoryId", question.getProperty("exo:categoryId").getString());
                    Node ansHome = newLang.addNode(org.exoplatform.faq.service.Utils.ANSWER_HOME, "exo:answerHome");
                    Node commentHome = newLang.addNode(org.exoplatform.faq.service.Utils.COMMENT_HOME, "exo:commentHome");
                    question.save();
                    if (language.hasNode(org.exoplatform.faq.service.Utils.ANSWER_HOME)) {
                        NodeIterator ansIter = language.getNode(org.exoplatform.faq.service.Utils.ANSWER_HOME).getNodes();
                        while (ansIter.hasNext()) {
                            Node ans = ansIter.nextNode();
                            ansHome.getSession().getWorkspace().move(ans.getPath(), ansHome.getPath() + "/" + ans.getName());
                        }
                        ansHome.getSession().save();
                    }
                    if (!language.hasNode(org.exoplatform.faq.service.Utils.COMMENT_HOME)) continue;
                    NodeIterator commentIter = language.getNode(org.exoplatform.faq.service.Utils.COMMENT_HOME).getNodes();
                    while (commentIter.hasNext()) {
                        Node comment = commentIter.nextNode();
                        commentHome.getSession().getWorkspace().move(comment.getPath(), commentHome.getPath() + "/" + comment.getName());
                    }
                    commentHome.getSession().save();
                }
                temp.remove();
                languageHome.getSession().save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forumMigration() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempNode = this.getForumTemp(sProvider);
            if (tempNode.hasNodes()) {
                return;
            }
            log.info((Object)"\n\n Knowledge Suite 1.2: Migrating Forum data from 1.1 to 1.2 ....");
            String forumData11 = this.params_.getValueParam("forumData1.1").getValue();
            log.info((Object)("forumData11===>" + forumData11));
            InputStream in = this.configManager_.getInputStream(forumData11);
            tempNode.getSession().importXML(tempNode.getPath(), in, 0);
            tempNode.getSession().save();
            log.info((Object)"\n >>>>>> Data version 1.1 has imported \n");
            this.migrateForumData();
            Node forumHome = this.getForumHome(sProvider);
            NodeIterator iter = forumHome.getNodes();
            while (iter.hasNext()) {
                Node data = iter.nextNode();
                if (data.getName().equals(CommonUtils.FORUM_SYSTEM) || data.getName().equals(CommonUtils.FORUM_DATA)) continue;
                log.info((Object)(" Removed ==> " + data.getPath()));
                data.remove();
            }
            forumHome.getSession().save();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            forumHome.getSession().exportSystemView(forumHome.getPath(), (OutputStream)bos, false, false);
            String forumData12 = this.params_.getValueParam("forumData1.2").getValue();
            this.saveToFile(bos.toByteArray(), forumData12);
            log.info((Object)("\n >>>>>> Data version 1.2 has exported to file " + forumData12 + "\n"));
            log.info((Object)"\n\n Knowledge Suite: Migrate Forum data 1.1 to 1.2 is finished .... \n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importNewForumData() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String forumData12 = this.params_.getValueParam("forumData1.2").getValue();
            InputStream in = this.configManager_.getInputStream(forumData12);
            Node forumHome = this.getForumHome(sProvider);
            Node parent = forumHome.getParent();
            forumHome.remove();
            parent.save();
            log.info((Object)"\n >>>>>> Knowledge Suite: Forum's data version 1.2 is importing.... \n");
            parent.getSession().importXML(parent.getPath(), in, 0);
            parent.getSession().save();
            log.info((Object)"\n >>>>>> Knowledge Suite: Forum's data version 1.2 is imported succesful !\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void saveToFile(byte[] data, String path) throws Exception {
        FileOutputStream file = new FileOutputStream(path.replaceAll("file:", ""));
        file.write(data);
        file.flush();
        file.close();
    }

    private Node getForumTemp(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchy_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode("FORUM_TEMP");
        }
        catch (PathNotFoundException ex) {
            userApp.addNode("FORUM_TEMP");
            userApp.getSession().save();
            return userApp.getNode("FORUM_TEMP");
        }
    }

    private Node getForumHome(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchy_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode(Utils.FORUM_SERVICE);
        }
        catch (PathNotFoundException ex) {
            userApp.addNode(Utils.FORUM_SERVICE, "exo:forumHome");
            userApp.getSession().save();
            return userApp.getNode(Utils.FORUM_SERVICE);
        }
    }

    private Node getForumSystem(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHome(sProvider);
        try {
            return forumHome.getNode(CommonUtils.FORUM_SYSTEM);
        }
        catch (PathNotFoundException ex) {
            forumHome.addNode(CommonUtils.FORUM_SYSTEM, "exo:forumSystem");
            forumHome.getSession().save();
            return forumHome.getNode(CommonUtils.FORUM_SYSTEM);
        }
    }

    private Node getForumData(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHome(sProvider);
        try {
            return forumHome.getNode(CommonUtils.FORUM_DATA);
        }
        catch (PathNotFoundException ex) {
            forumHome.addNode(CommonUtils.FORUM_DATA, "exo:forumData");
            forumHome.getSession().save();
            return forumHome.getNode(CommonUtils.FORUM_DATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumData() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tempData = this.getForumTemp(sProvider);
            if (!tempData.hasNodes()) {
                log.info((Object)">>>>>> There is no Forum's data for migrating!");
                return;
            }
            Node forumHome = tempData.getNode(Utils.FORUM_SERVICE);
            if (forumHome.hasNode(Utils.FORUM_BAN_IP)) {
                this.migrateForumBanIP(forumHome.getNode(Utils.FORUM_BAN_IP));
            }
            if (forumHome.hasNode("UserAdministration")) {
                this.migrateForumUserProfiles(forumHome.getNode("UserAdministration"));
            }
            if (forumHome.hasNode(Utils.FORUMADMINISTRATION)) {
                this.migrateForumAdministration(forumHome.getNode(Utils.FORUMADMINISTRATION));
            }
            if (forumHome.hasNode("forumStatisticId")) {
                this.migrateForumStatistic(forumHome.getNode("forumStatisticId"));
            }
            NodeIterator iter = forumHome.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (node.isNodeType("exo:forumTag")) {
                    this.migrateForumTag(node);
                }
                if (!node.isNodeType("exo:forumCategory")) continue;
                this.migrateForumCategory(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumBanIP(Node banIP) {
        log.info((Object)"===> migrating Forum BanIP");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banHome;
            try {
                banHome = this.getForumSystem(sProvider).getNode(Utils.BANIP_HOME);
            }
            catch (PathNotFoundException e) {
                banHome = this.getForumSystem(sProvider).addNode(Utils.BANIP_HOME, "exo:banIPHome");
                banHome.getSession().save();
            }
            log.info((Object)("===>" + banHome.getPath() + "/" + banIP.getName()));
            banHome.getSession().getWorkspace().move(banIP.getPath(), banHome.getPath() + "/" + banIP.getName());
            banHome.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumUserProfiles(Node userProfileHome) {
        log.info((Object)"===> migrating User Profiles");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profileHome;
            try {
                profileHome = this.getForumSystem(sProvider).getNode(Utils.USER_PROFILE_HOME);
            }
            catch (PathNotFoundException e) {
                profileHome = this.getForumSystem(sProvider).addNode(Utils.USER_PROFILE_HOME, "exo:userProfileHome");
                profileHome.getSession().save();
            }
            NodeIterator iter = userProfileHome.getNode("UserProfile").getNodes();
            while (iter.hasNext()) {
                try {
                    Node profile = iter.nextNode();
                    profileHome.getSession().getWorkspace().move(profile.getPath(), profileHome.getPath() + "/" + profile.getName());
                    profileHome.save();
                    log.info((Object)("===>" + profileHome.getPath() + "/" + profile.getName()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            profileHome.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumAdministration(Node administration) {
        log.info((Object)"===> migrating Administration");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node adminHome;
            try {
                adminHome = this.getForumSystem(sProvider).getNode(Utils.ADMINISTRATION_HOME);
            }
            catch (PathNotFoundException e) {
                adminHome = this.getForumSystem(sProvider).addNode(Utils.ADMINISTRATION_HOME, "exo:administrationHome");
                adminHome.getSession().save();
            }
            log.info((Object)("===>" + adminHome.getPath() + "/" + administration.getName()));
            adminHome.getSession().getWorkspace().move(administration.getPath(), adminHome.getPath() + "/" + administration.getName());
            adminHome.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumStatistic(Node statistic) {
        log.info((Object)"===> migrating Statistic");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node statisticHome;
            Node systemHome = this.getForumSystem(sProvider);
            if (systemHome.hasNode(Utils.STATISTIC_HOME)) {
                statisticHome = systemHome.getNode(Utils.STATISTIC_HOME);
            } else {
                statisticHome = systemHome.addNode(Utils.STATISTIC_HOME, "exo:statisticHome");
                systemHome.save();
            }
            if (statisticHome.hasNode(Utils.FORUM_STATISTIC)) {
                statisticHome.getNode(Utils.FORUM_STATISTIC).remove();
                statisticHome.save();
            }
            systemHome.getSession().getWorkspace().move(statistic.getPath(), statisticHome.getPath() + "/" + Utils.FORUM_STATISTIC);
            statisticHome.getSession().save();
            log.info((Object)("===>" + statisticHome.getPath() + "/" + Utils.FORUM_STATISTIC));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumTag(Node tag) {
        log.info((Object)"===> migrating Forum Tags");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tagHome;
            try {
                tagHome = this.getForumData(sProvider).getNode(Utils.TAG_HOME);
            }
            catch (PathNotFoundException e) {
                tagHome = this.getForumData(sProvider).addNode(Utils.TAG_HOME, "exo:tagHome");
                tagHome.getSession().save();
            }
            log.info((Object)("===>" + tagHome.getPath() + "/" + tag.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateForumCategory(Node category) {
        log.info((Object)"===> migrating Category");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome;
            try {
                categoryHome = this.getForumData(sProvider).getNode(Utils.CATEGORY_HOME);
            }
            catch (PathNotFoundException e) {
                categoryHome = this.getForumData(sProvider).addNode(Utils.CATEGORY_HOME, "exo:categoryHome");
                categoryHome.getSession().save();
            }
            this.migratePostAttachment(category);
            log.info((Object)("===>" + categoryHome.getPath() + "/" + category.getName()));
            categoryHome.getSession().getWorkspace().move(category.getPath(), categoryHome.getPath() + "/" + category.getName());
            categoryHome.getSession().save();
            Node movedCategory = categoryHome.getNode(category.getName());
            this.initAutoPrune(movedCategory);
            this.renameRSSType(categoryHome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void migratePostAttachment(Node category) throws Exception {
        QueryManager qm = category.getSession().getWorkspace().getQueryManager();
        StringBuilder strQuery = new StringBuilder();
        strQuery.append("/jcr:root" + category.getPath()).append("//element(*,exo:forumAttachment)");
        Query query = qm.createQuery(strQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        try {
            log.info((Object)("attsize ===>" + iter.getSize()));
            while (iter.hasNext()) {
                Node att = iter.nextNode();
                if (!att.isNodeType("nt:file") && !att.isNodeType("exo:faqAttachment")) continue;
                Node post = att.getParent();
                Node attTemp = att;
                Node nodeFile = post.addNode("file" + IdGenerator.generate(), "exo:forumAttachment");
                ForumServiceUtils.reparePermissions((Node)nodeFile, (String)"any");
                Node nodeContent = nodeFile.addNode("jcr:content", "exo:forumResource");
                nodeContent.setProperty("exo:fileName", attTemp.getProperty("exo:fileName").getValue());
                nodeContent.setProperty("jcr:mimeType", attTemp.getNode("jcr:content").getProperty("jcr:mimeType").getValue());
                nodeContent.setProperty("jcr:data", attTemp.getNode("jcr:content").getProperty("jcr:data").getValue());
                nodeContent.setProperty("jcr:lastModified", attTemp.getNode("jcr:content").getProperty("jcr:lastModified").getValue());
                log.info((Object)("fileName ===>" + nodeContent.getProperty("exo:fileName").getString()));
                att.remove();
            }
            category.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAutoPrune(Node category) {
        try {
            log.info((Object)("Initiallizing prune for category " + category.getPath()));
            NodeIterator iter = category.getNodes();
            while (iter.hasNext()) {
                Node forum = iter.nextNode();
                try {
                    if (!forum.isNodeType("exo:forum")) continue;
                    StringBuilder id = new StringBuilder();
                    id.append(category.getProperty("exo:categoryOrder").getString());
                    id.append(category.getProperty("exo:createdDate").getDate().getTimeInMillis());
                    id.append(forum.getProperty("exo:forumOrder").getString());
                    id.append(forum.getProperty("exo:createdDate").getDate().getTimeInMillis());
                    Node pruneNode = forum.addNode(Utils.PRUNESETTING, "exo:pruneSetting");
                    pruneNode.setProperty("exo:id", id.toString());
                    pruneNode.setProperty("exo:inActiveDay", 0L);
                    pruneNode.setProperty("exo:periodTime", 0L);
                    pruneNode.setProperty("exo:isActive", false);
                    forum.save();
                    log.info((Object)("Initiallized prune " + pruneNode.getPath()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.info((Object)"End");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renameRSSType(Node categoryHome) throws Exception {
        log.info((Object)"===> migrating rename Rss Type");
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:KSRSS)");
        Query query = qm.createQuery(queryBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            try {
                Node ksRssNode = iter.nextNode();
                Node parentNode = ksRssNode.getParent();
                Node forumRssNode = parentNode.addNode("ks.rss", "exo:forumRSS");
                forumRssNode.setProperty("exo:content", ksRssNode.getProperty("exo:content").getValue());
                ksRssNode.remove();
                parentNode.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

