/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.ks.rss.RSSGenerate;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSProcess
extends RSSGenerate {
    protected String linkItem = "";

    public RSSProcess(InitParams params) throws Exception {
        super(null);
        String maximum;
        PropertiesParam proParams = params.getPropertiesParam("rss-limit-config");
        if (proParams != null && (maximum = proParams.getProperty("maximum.rss")) != null && maximum.length() > 0) {
            try {
                this.maxSize = Integer.parseInt(maximum);
            }
            catch (Exception e) {
                this.maxSize = 10;
            }
        }
        System.out.println("\n\n-------------------------->max: " + this.maxSize);
    }

    public RSSProcess(NodeHierarchyCreator nodeHierarchyCreator) {
        super(nodeHierarchyCreator);
    }

    public RSSProcess(SessionProvider sProvider, String serviceType) {
        super(null);
        try {
            this.appHomeNode = serviceType.equals(this.KS_FAQ) ? this.getKSServiceHome(sProvider, this.FAQ_APP) : this.getKSServiceHome(sProvider, this.FORUM_APP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateRSS(String path, int typeEvent) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        this.linkItem = this.getPageLink();
        try {
            if (path.indexOf(this.FAQ_APP) > 0) {
                this.generateFAQRSS(path, typeEvent, sProvider);
            } else {
                this.generateForumsRSS(path, typeEvent, sProvider);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            sProvider.close();
        }
        return true;
    }

    @Override
    public void generateForumsRSS(String path, int typeEvent, SessionProvider sProvider) throws Exception {
        this.appHomeNode = this.getKSServiceHome(sProvider, this.FORUM_APP);
        Node node = null;
        this.linkItem = this.linkItem + "?portal:componentId=forum&portal:type=action&portal:isSecure=false&uicomponent=UIBreadcumbs&op=ChangePath&objectId=";
        if (typeEvent != 2) {
            node = (Node)this.appHomeNode.getSession().getItem(path);
            if (node.isNodeType("exo:post")) {
                this.generatePostRSS(path, typeEvent);
            }
        } else {
            String objectId = null;
            objectId = path.substring(path.lastIndexOf("/") + 1);
            path = path.substring(0, path.lastIndexOf("/"));
            while (node == null) {
                try {
                    node = (Node)this.appHomeNode.getSession().getItem(path);
                }
                catch (PathNotFoundException pn) {
                    objectId = path.substring(path.lastIndexOf("/") + 1);
                    path = path.substring(0, path.lastIndexOf("/"));
                    node = null;
                }
            }
            while (node.isNodeType("exo:forumCategory") || node.isNodeType("exo:forum") || node.isNodeType("exo:topic")) {
                String description = null;
                description = node.hasProperty("exo:description") ? node.getProperty("exo:description").getString() : " ";
                this.removeRSSItem(objectId, node, description);
                node = node.getParent();
            }
        }
    }

    protected void generatePostRSS(String path, int typeEvent) {
        boolean isNew = false;
        try {
            Node postNode = (Node)this.appHomeNode.getSession().getItem(path);
            Node topicNode = postNode.getParent();
            if (postNode.hasProperty("exo:isFirstPost") && postNode.getProperty("exo:isFirstPost").getBoolean() && topicNode.hasProperty("exo:isApproved") && !topicNode.getProperty("exo:isApproved").getBoolean() || postNode.hasProperty("exo:userPrivate") && !postNode.getProperty("exo:userPrivate").getValues()[0].getString().equals("exoUserPri")) {
                return;
            }
            Node forumNode = topicNode.getParent();
            Node categoryNode = forumNode.getParent();
            if (postNode.hasProperty("exo:isApproved") && !postNode.getProperty("exo:isApproved").getBoolean() || postNode.hasProperty("exo:isActiveByTopic") && !postNode.getProperty("exo:isActiveByTopic").getBoolean() || postNode.hasProperty("exo:isHidden") && postNode.getProperty("exo:isHidden").getBoolean()) {
                if (typeEvent != 1) {
                    if (topicNode.hasProperty("exo:description")) {
                        this.removeRSSItem(postNode.getName(), topicNode, topicNode.getProperty("exo:description").getString());
                    } else {
                        this.removeRSSItem(postNode.getName(), topicNode, " ");
                    }
                    if (forumNode.hasProperty("exo:description")) {
                        this.removeRSSItem(postNode.getName(), forumNode, forumNode.getProperty("exo:description").getString());
                    } else {
                        this.removeRSSItem(postNode.getName(), forumNode, " ");
                    }
                    if (categoryNode.hasProperty("exo:description")) {
                        this.removeRSSItem(postNode.getName(), categoryNode, categoryNode.getProperty("exo:description").getString());
                    } else {
                        this.removeRSSItem(postNode.getName(), categoryNode, " ");
                    }
                }
                return;
            }
            ArrayList<String> listContent = new ArrayList<String>();
            listContent.add(postNode.getProperty("exo:message").getString());
            SyndContentImpl description = new SyndContentImpl();
            description.setType(this.descriptionType);
            description.setValue(postNode.getProperty("exo:message").getString());
            SyndEntry entry = this.createNewEntry(postNode.getName(), postNode.getProperty("exo:name").getString(), this.linkItem, listContent, (SyndContent)description, postNode.getProperty("exo:createdDate").getDate().getTime(), postNode.getProperty("exo:owner").getString());
            entry.setLink(this.linkItem + topicNode.getName());
            Node RSSNode = null;
            SyndFeed feed = null;
            for (Node node : new Node[]{topicNode, forumNode, categoryNode}) {
                isNew = false;
                this.data = new RSS();
                try {
                    RSSNode = node.getNode(this.KS_RSS);
                    this.getRSSData(RSSNode, this.data);
                    feed = this.updateRSSFeed(this.data, postNode.getName(), entry);
                }
                catch (PathNotFoundException e) {
                    RSSNode = node.addNode(this.KS_RSS, this.FORUM_RSS_TYPE);
                    isNew = true;
                    feed = this.createNewFedd(node.getProperty("exo:name").getString(), node.getProperty("exo:createdDate").getDate().getTime());
                    feed.setLink(this.linkItem + node.getName());
                    feed.setEntries(Arrays.asList(entry));
                }
                catch (Exception e) {
                    continue;
                }
                if (node.hasProperty("exo:description")) {
                    feed.setDescription(node.getProperty("exo:description").getString());
                } else {
                    feed.setDescription(" ");
                }
                SyndFeedOutput output = new SyndFeedOutput();
                this.data.setContent(new ByteArrayInputStream(output.outputString(feed).getBytes()));
                this.addNodeRSS(node, RSSNode, this.data, isNew);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateFAQRSS(String path, int typeEvent, SessionProvider sProvider) {
        block23: {
            boolean isNew = false;
            try {
                this.appHomeNode = this.getKSServiceHome(sProvider, this.FAQ_APP);
                Node categoryNode = null;
                if (typeEvent != 2) {
                    Node RSSNode = null;
                    String categoryLink = this.linkItem + "?portal:componentId=faq&portal:type=action&portal:isSecure=false&uicomponent=UICategories&op=OpenCategory&" + "objectId=";
                    this.linkItem = this.linkItem + "?portal:componentId=faq&portal:type=action&portal:isSecure=false&uicomponent=UIQuestions&op=ViewQuestion&objectId=";
                    Node questionNode = (Node)this.appHomeNode.getSession().getItem(path);
                    if (!(questionNode.isNodeType("exo:faqQuestion") || questionNode.isNodeType("exo:answer") || questionNode.isNodeType("exo:answerHome") || questionNode.isNodeType("exo:comment") || questionNode.isNodeType("exo:commentHome"))) {
                        return;
                    }
                    if (questionNode.isNodeType("exo:answer") || questionNode.isNodeType("exo:comment") ? !(questionNode = questionNode.getParent().getParent()).isNodeType("exo:faqQuestion") : (questionNode.isNodeType("exo:answerHome") || questionNode.isNodeType("exo:commentHome")) && !(questionNode = questionNode.getParent()).isNodeType("exo:faqQuestion")) {
                        return;
                    }
                    String categoreDescription = "";
                    categoryNode = questionNode.getParent().getParent();
                    categoreDescription = categoryNode.hasProperty("exo:description") ? categoryNode.getProperty("exo:description").getString() : "eXo link:" + this.eXoLink;
                    if (!questionNode.getProperty("exo:isActivated").getBoolean() || !questionNode.getProperty("exo:isApproved").getBoolean()) {
                        this.removeRSSItem(questionNode.getName(), categoryNode, categoreDescription);
                        return;
                    }
                    ArrayList<String> listContent = new ArrayList<String>();
                    String content = "";
                    if (questionNode.hasNode("faqAnswerHome") && questionNode.getNode("faqAnswerHome").hasNodes()) {
                        for (String answer : this.getAnswers(questionNode)) {
                            content = content + " <b><u>Answer:</u></b> " + answer + ". ";
                        }
                    }
                    if (questionNode.hasNode("faqCommentHome") && questionNode.getNode("faqCommentHome").hasNodes()) {
                        for (String comment : this.getComments(questionNode)) {
                            content = content + " <b><u>Comment:</u></b> " + comment + ". ";
                        }
                    }
                    listContent.add(content);
                    SyndContentImpl description = new SyndContentImpl();
                    description.setType(this.descriptionType);
                    description.setValue(questionNode.getProperty("exo:name").getString() + ". " + content);
                    String questionPath = questionNode.getPath();
                    this.linkItem = this.linkItem + questionPath.substring(questionPath.indexOf("/categories/") + 1);
                    SyndEntry entry = this.createNewEntry(questionNode.getName(), questionNode.getProperty("exo:title").getString(), this.linkItem, listContent, (SyndContent)description, questionNode.getProperty("exo:createdDate").getDate().getTime(), questionNode.getProperty("exo:author").getString());
                    entry.setLink(this.linkItem);
                    SyndFeed feed = null;
                    try {
                        RSSNode = categoryNode.getNode(this.KS_RSS);
                        this.getRSSData(RSSNode, this.data);
                        feed = typeEvent == 1 ? this.updateRSSFeed(this.data, null, entry) : this.updateRSSFeed(this.data, questionNode.getName(), entry);
                    }
                    catch (PathNotFoundException e) {
                        RSSNode = categoryNode.addNode(this.KS_RSS, this.FAQ_RSS_TYPE);
                        isNew = true;
                        feed = categoryNode.hasProperty("exo:createdDate") ? this.createNewFedd("", categoryNode.getProperty("exo:createdDate").getDate().getTime()) : this.createNewFedd("", new Date());
                        feed.setLink(categoryLink + questionNode.getProperty("exo:categoryId").getString());
                        feed.setEntries(Arrays.asList(entry));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    feed.setDescription(categoreDescription);
                    try {
                        feed.setTitle(categoryNode.getProperty("exo:name").getString());
                    }
                    catch (Exception e) {
                        feed.setTitle("Home");
                    }
                    SyndFeedOutput output = new SyndFeedOutput();
                    this.data.setContent(new ByteArrayInputStream(output.outputString(feed).getBytes()));
                    this.addNodeRSS(categoryNode, RSSNode, this.data, isNew);
                    break block23;
                }
                String categoryPath = path.substring(0, path.indexOf("/questions/"));
                categoryNode = (Node)this.appHomeNode.getSession().getItem(categoryPath);
                while (!categoryNode.isNodeType("exo:faqCategory")) {
                    categoryNode = categoryNode.getParent();
                }
                this.removeRSSItem(path.substring(path.lastIndexOf("/") + 1), categoryNode, "");
            }
            catch (Exception e) {
            }
            finally {
                sProvider.close();
            }
        }
    }

    protected List<String> getAnswers(Node questionNode) throws Exception {
        ArrayList<String> listAnswers = new ArrayList<String>();
        try {
            if (questionNode.hasNode("faqAnswerHome")) {
                NodeIterator nodeIterator = questionNode.getNode("faqAnswerHome").getNodes();
                Node answerNode = null;
                int i = 0;
                while (nodeIterator.hasNext()) {
                    answerNode = nodeIterator.nextNode();
                    if (answerNode.hasProperty("exo:responses") && answerNode.getProperty("exo:approveResponses").getBoolean() && answerNode.getProperty("exo:activateResponses").getBoolean()) {
                        listAnswers.add(answerNode.getProperty("exo:responses").getValue().getString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listAnswers;
    }

    protected List<String> getComments(Node questionNode) throws Exception {
        ArrayList<String> listComment = new ArrayList<String>();
        try {
            if (questionNode.hasNode("faqCommentHome")) {
                NodeIterator nodeIterator = questionNode.getNode("faqCommentHome").getNodes();
                Node commentNode = null;
                while (nodeIterator.hasNext()) {
                    commentNode = nodeIterator.nextNode();
                    if (!commentNode.hasProperty("exo:comments")) continue;
                    listComment.add(commentNode.getProperty("exo:comments").getValue().getString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listComment;
    }

    public InputStream getRSSNode(SessionProvider sProvider, String objectId, String appType) throws Exception {
        Node parentNode = null;
        String rssType = "";
        try {
            if (appType.equals(this.KS_FAQ)) {
                parentNode = this.getKSServiceHome(sProvider, this.FAQ_APP).getNode(objectId);
                rssType = this.FAQ_RSS_TYPE;
            } else {
                parentNode = this.getKSServiceHome(sProvider, this.FORUM_APP);
                QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer("/jcr:root" + parentNode.getPath() + "//*[@exo:id='").append(objectId).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                parentNode = result.getNodes().nextNode();
                rssType = this.FORUM_RSS_TYPE;
            }
        }
        catch (Exception e) {
            return null;
        }
        Node RSSNode = null;
        ByteArrayInputStream inputStream = null;
        if (!parentNode.hasNode(this.KS_RSS)) {
            String feedType = "rss_2.0";
            String title = "FORUM RSS FEED";
            if (appType.equals(this.KS_FAQ)) {
                title = "FAQ RSS FEED";
            }
            SyndFeed feed = this.createNewFedd(title, new Date());
            ArrayList entries = new ArrayList();
            RSSNode = parentNode.addNode(this.KS_RSS, rssType);
            try {
                feed.setTitle(parentNode.getProperty("exo:name").getString());
                if (parentNode.hasProperty("exo:description")) {
                    feed.setDescription(parentNode.getProperty("exo:description").getString());
                } else {
                    feed.setDescription(" ");
                }
            }
            catch (Exception e) {
                feed.setTitle(parentNode.getName());
                feed.setDescription(" ");
            }
            feed.setLink(this.eXoLink);
            feed.setFeedType(feedType);
            feed.setEntries(entries);
            feed.setPublishedDate(new Date());
            RSS data = new RSS();
            SyndFeedOutput output = new SyndFeedOutput();
            inputStream = new ByteArrayInputStream(output.outputString(feed).getBytes());
            data.setContent(inputStream);
            this.addNodeRSS(parentNode, RSSNode, data, false);
            return inputStream;
        }
        RSSNode = parentNode.getNode(this.KS_RSS);
        return RSSNode.getProperty("exo:content").getStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getForumSubscription(String userId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node subscriptionNode = this.appHomeNode.getNode("ForumSystem/UserProfileHome/" + userId + "/forumSubscription" + userId);
            try {
                list.addAll(this.ValuesToList(subscriptionNode.getProperty("exo:categoryIds").getValues()));
                list.addAll(this.ValuesToList(subscriptionNode.getProperty("exo:forumIds").getValues()));
                list.addAll(this.ValuesToList(subscriptionNode.getProperty("exo:topicIds").getValues()));
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    private List<String> ValuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list;
    }

    public InputStream getRSSOfMultiObjects(String userId, SessionProvider sProvider) throws Exception {
        if (userId == null || userId.trim().length() == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        HashMap<String, SyndEntry> mapEntries = new HashMap<String, SyndEntry>();
        Node RSSNode = null;
        this.appHomeNode = this.getKSServiceHome(sProvider, this.FORUM_APP);
        SyndEntry syndEntry = null;
        for (String objectId : this.getForumSubscription(userId)) {
            try {
                RSSNode = this.getNodeById(objectId, sProvider).getNode(this.KS_RSS);
                this.getRSSData(RSSNode, this.data);
                for (Object entry : this.updateRSSFeed(this.data, null, null).getEntries()) {
                    syndEntry = (SyndEntry)entry;
                    mapEntries.put(syndEntry.getUri(), syndEntry);
                }
            }
            catch (Exception e) {
            }
        }
        SyndFeed feed = this.createNewFedd("FORUM RSS FEED", new Date());
        feed.setDescription(" ");
        feed.setEntries(Arrays.asList(mapEntries.values().toArray(new SyndEntry[0])));
        SyndFeedOutput output = new SyndFeedOutput();
        inputStream = new ByteArrayInputStream(output.outputString(feed).getBytes());
        return inputStream;
    }
}

