/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import com.lowagie.text.pdf.ByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.ks.common.conf.ManagedPlugin;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;

@Managed
@NameTemplate(value={@Property(key="service", value="faq"), @Property(key="view", value="plugins"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Plugin that allows to initialize default data for the FAQ")
public class InitialDataPlugin
extends ManagedPlugin {
    private static final String TEXT_XML = "text/xml";
    private static final String APPLICATION_ZIP = "application/zip";
    private static Log log = ExoLogger.getLogger(InitialDataPlugin.class);
    private String location;
    private boolean forceXML = false;

    public InitialDataPlugin(InitParams params) {
        ValueParam vp1 = params.getValueParam("location");
        if (vp1 == null) {
            log.warn((Object)("value-param 'location' is missing for " + this.getName() + ". The plugin will not be used"));
        } else {
            this.location = vp1.getValue();
        }
        ValueParam vp2 = params.getValueParam("forceXML");
        if (vp2 != null) {
            try {
                this.forceXML = Boolean.valueOf(vp2.getValue());
            }
            catch (Exception e) {
                log.warn((Object)("value-param 'forceXML' is erroneous for " + this.getName() + ". Expected 'true' or 'false', received '" + vp2.getValue() + "'. Using " + this.forceXML));
            }
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setForceXML(boolean forceXML) {
        this.forceXML = forceXML;
    }

    @Managed
    @ManagedDescription(value="The location where FAQ an XML export file will be looked")
    public String getLocation() {
        return this.location;
    }

    @Managed
    @ManagedDescription(value="Indicate if the data loaded should override any data found in the existing database")
    public boolean isForceXML() {
        return this.forceXML;
    }

    public boolean importData(FAQService service, ConfigurationManager configurationService) throws RuntimeException {
        try {
            if (this.location == null) {
                log.warn((Object)("No data location provided for " + (Object)((Object)this)));
                return false;
            }
            boolean isZip = this.isZip(this.location);
            if (!isZip) {
                throw new RuntimeException("the .zip FAQ export format is expected");
            }
            String categoryId = this.readCategoryFromZipEntry(configurationService);
            if (categoryId == null) {
                throw new RuntimeException("Could not extract category id from .zip . Is it a real FAQ export?");
            }
            Category oCat = service.getCategoryById(Utils.CATEGORY_HOME + "/" + categoryId);
            if (oCat != null) {
                log.info((Object)("FAQ data in " + this.location + " was not imported. The category '" + oCat.getName() + "' already exists."));
                return false;
            }
            InputStream inputStream = configurationService.getInputStream(this.location);
            boolean result = service.importData(Utils.CATEGORY_HOME, inputStream, isZip);
            return result;
        }
        catch (Exception e) {
            log.error((Object)("The plugin " + this.getName() + " failed to initialize data " + e));
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCategoryFromZipEntry(ConfigurationManager configurationService) throws Exception {
        ZipInputStream zipStream;
        InputStream inputStream;
        block3: {
            inputStream = null;
            zipStream = null;
            try {
                String result;
                inputStream = configurationService.getInputStream(this.location);
                zipStream = new ZipInputStream(inputStream);
                ZipEntry entry = zipStream.getNextEntry();
                if (entry == null) break block3;
                String name = entry.getName();
                zipStream.closeEntry();
                String string = result = name.substring(0, name.lastIndexOf(".xml"));
                this.safeClose(inputStream);
                this.safeClose(zipStream);
                return string;
            }
            catch (Throwable throwable) {
                this.safeClose(inputStream);
                this.safeClose(zipStream);
                throw throwable;
            }
        }
        String string = null;
        this.safeClose(inputStream);
        this.safeClose(zipStream);
        return string;
    }

    private void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCategoryFromXml(ConfigurationManager configurationService) throws Exception, UnsupportedEncodingException, IOException {
        InputStream inputStream = null;
        try {
            int len;
            String importedCategoryId = null;
            inputStream = configurationService.getInputStream(this.location);
            boolean keepReading = true;
            StringBuffer sbuf = new StringBuffer();
            byte[] buf = new byte[1024];
            String patternStr = "name=\"(\\S*)\"";
            Pattern pattern = Pattern.compile(patternStr);
            while ((len = inputStream.read(buf)) > 0 && keepReading) {
                ByteBuffer bb = new ByteBuffer();
                bb.append(buf);
                sbuf.append(bb.toString("UTF-8"));
                String content = sbuf.substring(0);
                Matcher matcher = pattern.matcher(content);
                if (!matcher.find()) continue;
                importedCategoryId = matcher.group(1);
                break;
            }
            String string = importedCategoryId;
            this.safeClose(inputStream);
            return string;
        }
        catch (Throwable throwable) {
            this.safeClose(inputStream);
            throw throwable;
        }
    }

    private void createCategory(FAQService service, String categoryName) throws Exception {
        Category categ = new Category();
        categ.setCreatedDate(new Date());
        categ.setName(categoryName);
        categ.setModerators(new String[0]);
        categ.setIndex(11L);
        service.saveCategory(Utils.CATEGORY_HOME, categ, true);
    }

    boolean isZip(String fileName) {
        MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
        String mimeType = mimeTypeResolver.getMimeType(fileName);
        if (APPLICATION_ZIP.equals(mimeType)) {
            return true;
        }
        if (TEXT_XML.equals(mimeType)) {
            return false;
        }
        throw new RuntimeException("The format " + mimeType + " is not supported. Expecting " + APPLICATION_ZIP + " or " + TEXT_XML);
    }

    public String toString() {
        return this.getName() + " (forceXML=" + this.forceXML + ",location=" + this.location + ")";
    }
}

