/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.ks.common.bbcode.BBCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String FAQ_APP = "faqApp".intern();
    public static final String DEFAULT_AVATAR_URL = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
    public static final String QUESTION_HOME = "questions".intern();
    public static final String SETTING_HOME = "settingHome".intern();
    public static final String USER_SETTING_HOME = "userSettingHome".intern();
    public static final String CATEGORY_HOME = "categories".intern();
    public static final String TEMPLATE_HOME = "templateHome".intern();
    public static final String ANSWER_HOME = "faqAnswerHome".intern();
    public static final String COMMENT_HOME = "faqCommentHome".intern();
    public static final String LANGUAGE_HOME = "languages".intern();
    public static final String EXO_FAQQUESTIONHOME = "exo:faqQuestionHome".intern();
    public static final String EXO_FAQCATEGORYHOME = "exo:faqCategoryHome".intern();
    public static final String ALL = "All".intern();

    public static String[] splitForFAQ(String str) throws Exception {
        if (str != null && str.length() > 0) {
            if (str.contains(",")) {
                return str.trim().split(",");
            }
            return str.trim().split(";");
        }
        return new String[0];
    }

    public static List<String> ValuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        if (values.length == 1) {
            list.add(values[0].getString());
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list;
    }

    public static String getStandardId(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int t = s.codePointAt(i);
            if (t > 48 && t < 122) {
                builder.append(s.charAt(i));
                continue;
            }
            builder.append("id");
        }
        return builder.toString();
    }

    public static String[] compareStr(String[] arr1, String[] arr2) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arr1));
        if (list.isEmpty() || ((String)list.get(0)).equals(" ")) {
            return new String[]{" "};
        }
        for (int i = 0; i < arr2.length; ++i) {
            if (list.contains(arr2[i])) continue;
            list.add(arr2[i]);
        }
        return list.toArray(new String[0]);
    }

    public static String getReplacementByBBcode(String s, List<BBCode> bbcodes) throws Exception {
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        s = Utils.getReplacementByBBcode(s, bbcodes, faqService);
        return s;
    }

    public static String getReplacementByBBcode(String s, List<BBCode> bbcodes, FAQService faqService) throws Exception {
        int lastIndex = 0;
        int tagIndex = 0;
        int clsIndex = 0;
        String str = "";
        for (BBCode bbcode : bbcodes) {
            String bbc = bbcode.getTagName();
            if (bbc.equals("URL")) {
                s = StringUtils.replace((String)s, (String)"[link", (String)"[URL");
                s = StringUtils.replace((String)s, (String)"[/link]", (String)"[/URL]");
                s = StringUtils.replace((String)s, (String)"[LINK", (String)"[URL");
                s = StringUtils.replace((String)s, (String)"[/LINK]", (String)"[/URL]");
            }
            if (!(bbc = bbc.toLowerCase()).equals("list")) {
                String param;
                String end;
                String start;
                lastIndex = 0;
                tagIndex = 0;
                if (bbcode.isOption()) {
                    start = "[" + bbc + "=";
                    end = "[/" + bbc + "]";
                    s = StringUtils.replace((String)s, (String)start.toUpperCase(), (String)start);
                    s = StringUtils.replace((String)s, (String)end.toUpperCase(), (String)end);
                    while ((tagIndex = s.indexOf(start, lastIndex)) != -1) {
                        lastIndex = tagIndex + 1;
                        try {
                            String option;
                            clsIndex = s.indexOf(end, tagIndex);
                            str = bbcode.getReplacement();
                            if (str == null || str.trim().length() == 0 || str.equals("null")) {
                                bbcode.setReplacement(faqService.getBBcode(bbcode.getId()).getReplacement());
                            }
                            if ((option = (str = s.substring(tagIndex + start.length(), clsIndex)).substring(0, str.indexOf("]"))).indexOf("+") == 0) {
                                option = option.replaceFirst("+", "");
                            }
                            if (option.indexOf("\"") == 0) {
                                option = option.replaceAll("\"", "");
                            }
                            if (option.indexOf("&quot;") == 0) {
                                option = option.replaceAll("&quot;", "");
                            }
                            param = str.substring(str.indexOf("]") + 1);
                            param = StringUtils.replace((String)bbcode.getReplacement(), (String)"{param}", (String)param);
                            param = StringUtils.replace((String)param, (String)"{option}", (String)option.trim());
                            s = StringUtils.replace((String)s, (String)(start + str + end), (String)param);
                        }
                        catch (Exception e) {}
                    }
                    continue;
                }
                start = "[" + bbc + "]";
                end = "[/" + bbc + "]";
                s = StringUtils.replace((String)s, (String)start.toUpperCase(), (String)start);
                s = StringUtils.replace((String)s, (String)end.toUpperCase(), (String)end);
                while ((tagIndex = s.indexOf(start, lastIndex)) != -1) {
                    lastIndex = tagIndex + 1;
                    try {
                        clsIndex = s.indexOf(end, tagIndex);
                        str = bbcode.getReplacement();
                        if (str == null || str.trim().length() == 0 || str.equals("null")) {
                            bbcode.setReplacement(faqService.getBBcode(bbcode.getId()).getReplacement());
                        }
                        str = s.substring(tagIndex + start.length(), clsIndex);
                        param = StringUtils.replace((String)bbcode.getReplacement(), (String)"{param}", (String)str);
                        s = StringUtils.replace((String)s, (String)(start + str + end), (String)param);
                    }
                    catch (Exception e) {}
                }
                continue;
            }
            lastIndex = 0;
            tagIndex = 0;
            s = StringUtils.replace((String)s, (String)"[LIST", (String)"[list");
            s = StringUtils.replace((String)s, (String)"[/LIST]", (String)"[/list]");
            while ((tagIndex = s.indexOf("[list]", lastIndex)) != -1) {
                lastIndex = tagIndex + 1;
                try {
                    clsIndex = s.indexOf("[/list]", tagIndex);
                    str = s.substring(tagIndex + 6, clsIndex);
                    String str_ = "";
                    str_ = StringUtils.replaceOnce((String)str, (String)"[*]", (String)"<li>");
                    str_ = StringUtils.replace((String)str_, (String)"[*]", (String)"</li><li>");
                    if (str_.lastIndexOf("</li><li>") > 0) {
                        str_ = str_ + "</li>";
                    }
                    if (str_.indexOf("<br/>") >= 0) {
                        str_ = StringUtils.replace((String)str_, (String)"<br/>", (String)"");
                    }
                    if (str_.indexOf("<p>") >= 0) {
                        str_ = StringUtils.replace((String)str_, (String)"<p>", (String)"");
                        str_ = StringUtils.replace((String)str_, (String)"</p>", (String)"");
                    }
                    s = StringUtils.replace((String)s, (String)("[list]" + str + "[/list]"), (String)("<ul>" + str_ + "</ul>"));
                }
                catch (Exception e) {}
            }
            lastIndex = 0;
            tagIndex = 0;
            while ((tagIndex = s.indexOf("[list=", lastIndex)) != -1) {
                lastIndex = tagIndex + 1;
                try {
                    clsIndex = s.indexOf("[/list]", tagIndex);
                    String content = s.substring(tagIndex + 6, clsIndex);
                    int clsType = content.indexOf("]");
                    String type = content.substring(0, clsType);
                    type.replaceAll("\"", "").replaceAll("'", "");
                    str = content.substring(clsType + 1);
                    String str_ = "";
                    str_ = StringUtils.replaceOnce((String)str, (String)"[*]", (String)"<li>");
                    str_ = StringUtils.replace((String)str_, (String)"[*]", (String)"</li><li>");
                    if (str_.lastIndexOf("</li><li>") > 0) {
                        str_ = str_ + "</li>";
                    }
                    if (str_.indexOf("<br/>") >= 0) {
                        str_ = StringUtils.replace((String)str_, (String)"<br/>", (String)"");
                    }
                    if (str_.indexOf("<p>") >= 0) {
                        str_ = StringUtils.replace((String)str_, (String)"<p>", (String)"");
                        str_ = StringUtils.replace((String)str_, (String)"</p>", (String)"");
                    }
                    s = StringUtils.replace((String)s, (String)("[list=" + content + "[/list]"), (String)("<ol type=\"" + type + "\">" + str_ + "</ol>"));
                }
                catch (Exception e) {}
            }
        }
        return s;
    }

    public static String convertCodeHTML(String s, List<String> bbcs) {
        if (s == null || s.length() <= 0) {
            return "";
        }
        s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
        s = s.replaceFirst("(<br/>)*", "");
        s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
        try {
            ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
            for (String string : bbcs) {
                BBCode bbcode = new BBCode();
                if (string.indexOf("=") >= 0) {
                    bbcode.setOption(true);
                    string = string.replaceFirst("=", "");
                    bbcode.setId(string + "_option");
                } else {
                    bbcode.setId(string);
                }
                bbcode.setTagName(string);
                bbcodes.add(bbcode);
            }
            s = Utils.getReplacementByBBcode(s, bbcodes);
            s = s.replaceAll("(https?|ftp)://", " $0").replaceAll("(=\"|='|'>|\">)( )(https?|ftp)", "$1$3").replaceAll("[^=\"|^='|^'>|^\">](https?://|ftp://)([-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", "<a target=\"_blank\" href=\"$1$2\">$1$2</a>");
            s = s.replaceAll("&apos;", "'");
        }
        catch (Exception e) {
            return "";
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Watch)o1).getUser();
            String name2 = ((Watch)o2).getUser();
            return name1.compareToIgnoreCase(name2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name2.compareToIgnoreCase(name1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date2.compareTo(date1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date1.compareTo(date2);
        }
    }
}

