/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.utils.ISO8601;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAQEventQuery {
    private String type;
    private String text;
    private String name;
    private String isModeQuestion;
    private String moderator;
    private String path;
    private String author;
    private String userId;
    private String questionDisplayMode;
    private String email;
    private String question;
    private String response;
    private String attachment;
    private List<String> userMembers;
    private Calendar fromDate;
    private Calendar toDate;
    private String language;
    private boolean isAnd = false;
    private boolean isAdmin = false;
    private List<String> viewingCategories = new ArrayList<String>();
    private boolean isQuestionLevelSearch = false;
    private boolean isLanguageLevelSearch = false;
    private boolean isAnswerLevelSearch = false;
    private boolean isSearchOnDefaultLanguage = false;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuestionDisplayMode(String questionDisplayMode) {
        this.questionDisplayMode = questionDisplayMode;
    }

    public String getQuestionDisplayMode() {
        return this.questionDisplayMode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setIsModeQuestion(String isModeQuestion) {
        this.isModeQuestion = isModeQuestion;
    }

    public String getIsModeQuestion() {
        return this.isModeQuestion;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public List<String> getUserMembers() {
        return this.userMembers;
    }

    public void setUserMembers(List<String> userMembers) {
        this.userMembers = userMembers;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Calendar fromDate) {
        this.fromDate = fromDate;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public void setToDate(Calendar toDate) {
        this.toDate = toDate;
    }

    public boolean getIsAnd() {
        return this.isAnd;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getQuery() throws Exception {
        StringBuilder queryString = new StringBuilder();
        if (this.type.equals("faqCategory")) {
            queryString = new StringBuilder();
            queryString.append("/jcr:root").append(this.path);
            queryString.append("//element(*,exo:faqCategory)");
            queryString.append("[(@exo:isView='true') ");
            if (this.text != null && this.text.length() > 0) {
                queryString.append(" and (jcr:contains(., '").append(this.text).append("'))");
            }
            if (this.name != null && this.name.length() > 0) {
                queryString.append(" and (jcr:contains(@exo:name, '").append(this.name).append("'))");
            }
            if (this.isModeQuestion != null && this.isModeQuestion.length() > 0 && !this.isModeQuestion.equals("AllCategories")) {
                queryString.append(" and (@exo:isModerateQuestions='").append(this.isModeQuestion).append("')");
            }
            if (this.moderator != null && this.moderator.length() > 0) {
                queryString.append(" and (jcr:contains(@exo:moderators, '").append(this.moderator).append("'))");
            }
            if (!this.isAdmin) {
                queryString.append(" and (not(@exo:userPrivate) ");
                if (this.userMembers != null && !this.userMembers.isEmpty()) {
                    for (String str : this.userMembers) {
                        queryString.append(" or @exo:userPrivate='").append(str).append("' or @exo:moderators='").append(str).append("'");
                    }
                }
                queryString.append(")");
            }
            if (this.fromDate != null) {
                queryString.append(" and (@exo:createdDate >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("'))");
            }
            if (this.toDate != null) {
                queryString.append(" and (@exo:createdDate <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("'))");
            }
            queryString.append("]");
        } else if (this.type.equals("faqQuestion")) {
            queryString = new StringBuilder();
            this.isQuestionLevelSearch = false;
            this.isAnswerLevelSearch = false;
            this.isAnd = false;
            queryString.append("/jcr:root").append(this.path);
            queryString.append("//* [");
            StringBuilder questionSearch = new StringBuilder("(");
            this.isAnd = false;
            if (this.author != null && this.author.length() > 0) {
                if (this.isAnd) {
                    questionSearch.append(" and ");
                }
                questionSearch.append("jcr:contains(@exo:author, '").append(this.author).append("')");
                this.isAnd = true;
            }
            if (this.email != null && this.email.length() > 0) {
                if (this.isAnd) {
                    questionSearch.append(" and ");
                }
                questionSearch.append("jcr:contains(@exo:email, '").append(this.email).append("')");
                this.isAnd = true;
            }
            if (this.fromDate != null) {
                if (this.isAnd) {
                    questionSearch.append(" and ");
                }
                questionSearch.append("(@exo:createdDate").append(" >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("'))");
                this.isAnd = true;
            }
            if (this.toDate != null) {
                if (this.isAnd) {
                    questionSearch.append(" and ");
                }
                questionSearch.append("(@exo:createdDate").append(" <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("'))");
                this.isAnd = true;
            }
            questionSearch.append(")");
            if (questionSearch.length() > 2 || this.isSearchOnDefaultLanguage) {
                this.isQuestionLevelSearch = true;
            }
            StringBuilder questionLanguageSearch = new StringBuilder("");
            if (this.question != null && this.question.length() > 0) {
                questionLanguageSearch.append("((exo:language='").append(this.language).append("')");
                questionLanguageSearch.append(" and ( jcr:contains(@exo:title,'").append(this.question).append("') or jcr:contains(@exo:name, '").append(this.question).append("') )");
                questionLanguageSearch.append(")");
                this.isLanguageLevelSearch = !this.isSearchOnDefaultLanguage;
            }
            StringBuilder answerSearch = new StringBuilder("");
            if (this.response != null && this.response.length() > 0) {
                answerSearch.append("( exo:responseLanguage='").append(this.language).append("'");
                answerSearch.append(" and jcr:contains(@exo:responses,'" + this.response + "')");
                answerSearch.append(")");
                this.isAnswerLevelSearch = true;
            }
            StringBuilder searchCategoryScoping = new StringBuilder("(");
            for (String category : this.getViewingCategories()) {
                if (searchCategoryScoping.length() > 1) {
                    searchCategoryScoping.append(" or ");
                }
                searchCategoryScoping.append("exo:categoryId='").append(category).append("'");
            }
            searchCategoryScoping.append(")");
            boolean isAdd = false;
            if (questionSearch.length() > 2) {
                System.out.println("questionSearch" + questionSearch.toString());
                queryString.append("(").append(questionSearch.toString());
                isAdd = true;
            }
            if (questionLanguageSearch.length() > 0) {
                if (this.isSearchOnDefaultLanguage()) {
                    if (isAdd) {
                        queryString.append(" and ").append(questionLanguageSearch.toString());
                    } else {
                        queryString.append("(").append(questionLanguageSearch.toString());
                        isAdd = true;
                    }
                } else if (isAdd) {
                    queryString.append(" or ").append(questionLanguageSearch.toString());
                } else {
                    queryString.append("(").append(questionLanguageSearch.toString());
                    isAdd = true;
                }
            }
            if (answerSearch.length() > 2) {
                if (isAdd) {
                    queryString.append(" or ").append(answerSearch.toString());
                } else {
                    queryString.append("(").append(answerSearch.toString());
                    isAdd = true;
                }
            }
            if (isAdd) {
                queryString.append(")");
            }
            if (isAdd) {
                queryString.append(" and ").append(searchCategoryScoping.toString());
            } else {
                queryString.append(searchCategoryScoping.toString());
                isAdd = true;
            }
            if (this.text != null && this.text.length() > 0) {
                if (isAdd) {
                    queryString.append(" and  jcr:contains(., '").append(this.text).append("')");
                } else {
                    queryString.append("jcr:contains(., '").append(this.text).append("')");
                }
            }
            queryString.append("]");
        } else if (this.type.equals("categoryAndQuestion")) {
            queryString = new StringBuilder();
            queryString.append("/jcr:root").append(this.path).append("//*[");
            if (this.text != null && this.text.length() > 0) {
                queryString.append(" jcr:contains(., '").append(this.text).append("')");
            }
            if (!this.isAdmin) {
                queryString.append(" and ( ");
                queryString.append("not(@exo:isApproved) or @exo:isApproved='true'");
                queryString.append(" ) ");
            }
            if (this.viewingCategories.size() > 0) {
                queryString.append(" and (");
                int i = 0;
                for (String catId : this.viewingCategories) {
                    if (i > 0) {
                        queryString.append(" or ");
                    }
                    queryString.append("(@exo:categoryId='").append(catId).append("')");
                    queryString.append(" or @exo:id='").append(catId).append("'");
                    queryString.append(" and (");
                    queryString.append(" not(@exo:userPrivate)");
                    if (this.userMembers != null && this.userMembers.size() > 0) {
                        for (String id : this.userMembers) {
                            queryString.append(" or @exo:userPrivate='").append(id).append("'");
                        }
                    }
                    queryString.append(" ) ");
                    ++i;
                }
                queryString.append(")");
            }
            if (this.fromDate != null) {
                queryString.append(" and (@exo:createdDate >= xs:dateTime('").append(ISO8601.format((Calendar)this.fromDate)).append("'))");
            }
            if (this.toDate != null) {
                queryString.append(" and (@exo:createdDate <= xs:dateTime('").append(ISO8601.format((Calendar)this.toDate)).append("'))");
            }
            queryString.append("]");
        }
        return queryString.toString();
    }

    public void setViewingCategories(List<String> viewingCategories) {
        this.viewingCategories = viewingCategories;
    }

    public List<String> getViewingCategories() {
        return this.viewingCategories;
    }

    public boolean isQuestionLevelSearch() throws Exception {
        return this.isQuestionLevelSearch;
    }

    public boolean isAnswerLevelSearch() throws Exception {
        return this.isAnswerLevelSearch;
    }

    public void setSearchOnDefaultLanguage(boolean isSearchOnDefaultLanguage) {
        this.isSearchOnDefaultLanguage = isSearchOnDefaultLanguage;
    }

    public boolean isSearchOnDefaultLanguage() {
        return this.isSearchOnDefaultLanguage;
    }

    public void setLanguageLevelSearch(boolean isLanguageLevelSearch) {
        this.isLanguageLevelSearch = isLanguageLevelSearch;
    }

    public boolean isLanguageLevelSearch() {
        return this.isLanguageLevelSearch;
    }
}

