/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIAdvancedSearchForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIAdvancedSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAdvancedSearchForm
extends UIForm
implements UIPopupComponent {
    private static final String FIELD_TEXT = "Text";
    private static final String FIELD_SEARCHOBJECT_SELECTBOX = "SearchObject";
    private static final String FIELD_CATEGORY_NAME = "CategoryName";
    private static final String FIELD_ISMODERATEQUESTION = "IsModerateQuestion";
    private static final String FIELD_CATEGORY_MODERATOR = "CategoryModerator";
    private static final String FIELD_FROM_DATE = "FromDate";
    private static final String FIELD_TO_DATE = "ToDate";
    private static final String FIELD_AUTHOR = "Author";
    private static final String FIELD_EMAIL_ADDRESS = "EmailAddress";
    private static final String FIELD_LANGUAGE = "Language";
    private static final String FIELD_QUESTION = "Question";
    private static final String FIELD_RESPONSE = "Response";
    private static final String ITEM_EMPTY = "empty";
    private static final String ITEM_CATEGORY = "faqCategory";
    private static final String ITEM_QUESTION = "faqQuestion";
    private static final String ITEM_MODERATEQUESTION_EMPTY2 = "empty2";
    private static final String ITEM_MODERATEQUESTION_TRUE = "true";
    private static final String ITEM_MODERATEQUESTION_FALSE = "false";
    private FAQSetting faqSetting_ = new FAQSetting();
    private String defaultLanguage_ = new String();

    public UIAdvancedSearchForm() throws Exception {
        FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        this.faqSetting_ = new FAQSetting();
        String currentUser = FAQUtils.getCurrentUser();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        if (currentUser != null && currentUser.trim().length() > 0) {
            if (this.faqSetting_.getIsAdmin() == null || this.faqSetting_.getIsAdmin().trim().length() < 1) {
                if (faqService_.isAdminRole(currentUser)) {
                    this.faqSetting_.setIsAdmin("TRUE");
                } else {
                    this.faqSetting_.setIsAdmin("FALSE");
                }
            }
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            faqService_.getUserSetting(sessionProvider, currentUser, this.faqSetting_);
            sessionProvider.close();
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        UIFormStringInput text = new UIFormStringInput(FIELD_TEXT, FIELD_TEXT, null);
        ArrayList<String> listLanguage = new ArrayList<String>();
        LocaleConfigService configService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        this.defaultLanguage_ = configService.getDefaultLocaleConfig().getLocale().getDisplayLanguage();
        Iterator i$ = configService.getLocalConfigs().iterator();
        while (i$.hasNext()) {
            LocaleConfig object;
            LocaleConfig localeConfig = object = (LocaleConfig)i$.next();
            Locale locale = localeConfig.getLocale();
            String displayName = locale.getDisplayLanguage();
            listLanguage.add(displayName);
        }
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(ITEM_EMPTY, (Object)ITEM_EMPTY));
        list.add(new SelectItemOption(ITEM_CATEGORY, (Object)ITEM_CATEGORY));
        list.add(new SelectItemOption(ITEM_QUESTION, (Object)ITEM_QUESTION));
        UIFormSelectBox searchType = new UIFormSelectBox(FIELD_SEARCHOBJECT_SELECTBOX, FIELD_SEARCHOBJECT_SELECTBOX, list);
        searchType.setOnChange("Onchange");
        UIFormStringInput categoryName = new UIFormStringInput(FIELD_CATEGORY_NAME, FIELD_CATEGORY_NAME, null);
        list = new ArrayList();
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_EMPTY2, (Object)ITEM_MODERATEQUESTION_EMPTY2));
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_TRUE, (Object)ITEM_MODERATEQUESTION_TRUE));
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_FALSE, (Object)ITEM_MODERATEQUESTION_FALSE));
        UIFormSelectBox modeQuestion = new UIFormSelectBox(FIELD_ISMODERATEQUESTION, FIELD_ISMODERATEQUESTION, list);
        UIFormStringInput moderator = new UIFormStringInput(FIELD_CATEGORY_MODERATOR, FIELD_CATEGORY_MODERATOR, null);
        UIFormDateTimeInput fromDate = new UIFormDateTimeInput(FIELD_FROM_DATE, FIELD_FROM_DATE, null, false);
        UIFormDateTimeInput toDate = new UIFormDateTimeInput(FIELD_TO_DATE, FIELD_TO_DATE, null, false);
        UIFormStringInput author = new UIFormStringInput(FIELD_AUTHOR, FIELD_AUTHOR, null);
        UIFormStringInput emailAdress = new UIFormStringInput(FIELD_EMAIL_ADDRESS, FIELD_EMAIL_ADDRESS, null);
        list = new ArrayList();
        list.add(new SelectItemOption(this.defaultLanguage_, (Object)this.defaultLanguage_));
        for (String language : listLanguage) {
            if (language.equals(this.defaultLanguage_)) continue;
            list.add(new SelectItemOption(language, (Object)language));
        }
        UIFormSelectBox language = new UIFormSelectBox(FIELD_LANGUAGE, FIELD_LANGUAGE, list);
        UIFormTextAreaInput question = new UIFormTextAreaInput(FIELD_QUESTION, FIELD_QUESTION, null);
        UIFormTextAreaInput response = new UIFormTextAreaInput(FIELD_RESPONSE, FIELD_RESPONSE, null);
        this.addUIFormInput((UIFormInput)text);
        this.addUIFormInput((UIFormInput)searchType);
        this.addUIFormInput((UIFormInput)categoryName);
        this.addUIFormInput((UIFormInput)modeQuestion);
        this.addUIFormInput((UIFormInput)moderator);
        this.addUIFormInput((UIFormInput)author);
        this.addUIFormInput((UIFormInput)emailAdress);
        this.addUIFormInput((UIFormInput)language);
        this.addUIFormInput((UIFormInput)question);
        this.addUIFormInput((UIFormInput)response);
        this.addUIFormInput((UIFormInput)fromDate);
        this.addUIFormInput((UIFormInput)toDate);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Calendar getFromDate() {
        return this.getUIFormDateTimeInput(FIELD_FROM_DATE).getCalendar();
    }

    public Calendar getToDate() {
        return this.getUIFormDateTimeInput(FIELD_TO_DATE).getCalendar();
    }

    public void setText(String value) {
        this.getUIStringInput(FIELD_TEXT).setValue((Object)value);
    }

    public String getText() {
        return (String)this.getUIStringInput(FIELD_TEXT).getValue();
    }

    public void setValue(boolean isCategoryName, boolean isModeQuestion, boolean isModerator, boolean isAuthor, boolean isEmailAddress, boolean isLanguage, boolean isQuestion, boolean isResponse) {
        UIFormStringInput categoryName = (UIFormStringInput)this.getUIStringInput(FIELD_CATEGORY_NAME).setRendered(isCategoryName);
        UIFormSelectBox modeQuestion = (UIFormSelectBox)this.getUIFormSelectBox(FIELD_ISMODERATEQUESTION).setRendered(isModeQuestion);
        UIFormStringInput moderator = (UIFormStringInput)this.getUIStringInput(FIELD_CATEGORY_MODERATOR).setRendered(isModerator);
        UIFormStringInput author = (UIFormStringInput)this.getUIStringInput(FIELD_AUTHOR).setRendered(isAuthor);
        UIFormStringInput emailAddress = (UIFormStringInput)this.getUIStringInput(FIELD_EMAIL_ADDRESS).setRendered(isEmailAddress);
        UIFormSelectBox language = (UIFormSelectBox)this.getUIFormSelectBox(FIELD_LANGUAGE).setRendered(isLanguage);
        UIFormTextAreaInput question = (UIFormTextAreaInput)this.getUIFormTextAreaInput(FIELD_QUESTION).setRendered(isQuestion);
        UIFormStringInput response = (UIFormStringInput)this.getUIFormTextAreaInput(FIELD_RESPONSE).setRendered(isResponse);
        categoryName.setValue((Object)"");
        modeQuestion.setValue("");
        moderator.setValue((Object)"");
        author.setValue((Object)"");
        emailAddress.setValue((Object)"");
        language.setValue("");
        question.setValue((Object)"");
        response.setValue((Object)"");
    }

    public String getLabel(ResourceBundle res, String id) throws Exception {
        String label = this.getId() + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Search", "Cancel"};
    }

    private Calendar getCalendar(UIFormDateTimeInput dateTimeInput, String field) throws Exception {
        Calendar calendar = dateTimeInput.getCalendar();
        if (!FAQUtils.isFieldEmpty((String)((String)dateTimeInput.getValue())) && calendar == null) {
            Object[] args = new Object[]{this.getLabel(field)};
            throw new MessageException(new ApplicationMessage("UIAdvancedSearchForm.msg.error-input-text-date", args, 1));
        }
        return calendar;
    }

    private List<Question> getResultListQuestion(String language, String question, String response, String text, List<Question> listResultQuesiton) throws Exception {
        FAQServiceUtils serviceUtils = new FAQServiceUtils();
        FAQService faqService = FAQUtils.getFAQService();
        String currentUser = FAQUtils.getCurrentUser();
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        String categoryId = null;
        Category category = null;
        String[] moderator = null;
        if (language.equals(this.defaultLanguage_)) {
            ArrayList<Question> listQuestionSearch = new ArrayList<Question>();
            if (this.faqSetting_.getDisplayMode().equals("both")) {
                if (this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    return listResultQuesiton;
                }
                for (Question quest : listResultQuesiton) {
                    categoryId = quest.getCategoryId();
                    if (!categoryId.equals("null")) {
                        category = faqService.getCategoryById(categoryId, sProvider);
                        moderator = category.getModeratorsCategory();
                        if (Arrays.asList(moderator).contains(currentUser)) {
                            listQuestionSearch.add(quest);
                            continue;
                        }
                        if (!quest.isActivated()) continue;
                        listQuestionSearch.add(quest);
                        continue;
                    }
                    if (!quest.isActivated()) continue;
                    listQuestionSearch.add(quest);
                }
                sProvider.close();
                return listQuestionSearch;
            }
            for (Question quest : listResultQuesiton) {
                categoryId = quest.getCategoryId();
                if (!categoryId.equals("null")) {
                    category = faqService.getCategoryById(categoryId, sProvider);
                    moderator = category.getModeratorsCategory();
                    if (Arrays.asList(moderator).contains(currentUser) || this.faqSetting_.isAdmin()) {
                        if (!quest.isApproved()) continue;
                        listQuestionSearch.add(quest);
                        continue;
                    }
                    if (!quest.isApproved() || !quest.isActivated()) continue;
                    listQuestionSearch.add(quest);
                    continue;
                }
                if (!quest.isApproved() || !quest.isActivated()) continue;
                listQuestionSearch.add(quest);
            }
            sProvider.close();
            return listQuestionSearch;
        }
        ArrayList<Question> listQuestionSearchByLanguage = new ArrayList();
        ArrayList<Question> listQuestionLanguage = new ArrayList<Question>();
        if (FAQUtils.isFieldEmpty((String)text)) {
            listQuestionSearchByLanguage = faqService.searchQuestionByLangage(listResultQuesiton, language, question, response, sProvider);
        } else if (!FAQUtils.isFieldEmpty((String)text) && FAQUtils.isFieldEmpty((String)question) && FAQUtils.isFieldEmpty((String)response)) {
            listQuestionSearchByLanguage = faqService.searchQuestionByLangageOfText(listResultQuesiton, language, text, sProvider);
        } else {
            List listQuestionSearchByLanguageTemp = faqService.searchQuestionByLangageOfText(listResultQuesiton, language, text, sProvider);
            listQuestionSearchByLanguage = faqService.searchQuestionByLangage(listQuestionSearchByLanguageTemp, language, question, response, sProvider);
        }
        if (this.faqSetting_.getDisplayMode().equals("both")) {
            if (this.faqSetting_.isAdmin()) {
                return listQuestionSearchByLanguage;
            }
            for (Question quest : listQuestionSearchByLanguage) {
                categoryId = quest.getCategoryId();
                if (!categoryId.equals("null")) {
                    category = faqService.getCategoryById(categoryId, sProvider);
                    moderator = category.getModeratorsCategory();
                    if (Arrays.asList(moderator).contains(currentUser)) {
                        listQuestionLanguage.add(quest);
                        continue;
                    }
                    if (!quest.isActivated()) continue;
                    listQuestionLanguage.add(quest);
                    continue;
                }
                if (!quest.isActivated()) continue;
                listQuestionLanguage.add(quest);
            }
            sProvider.close();
            return listQuestionLanguage;
        }
        for (Question quest : listQuestionSearchByLanguage) {
            categoryId = quest.getCategoryId();
            if (!categoryId.equals("null")) {
                category = faqService.getCategoryById(categoryId, sProvider);
                moderator = category.getModeratorsCategory();
                if (Arrays.asList(moderator).contains(currentUser) || this.faqSetting_.isAdmin()) {
                    if (!quest.isApproved()) continue;
                    listQuestionLanguage.add(quest);
                    continue;
                }
                if (!quest.isApproved() || !quest.isActivated()) continue;
                listQuestionLanguage.add(quest);
                continue;
            }
            if (!quest.isApproved() || !quest.isActivated()) continue;
            listQuestionLanguage.add(quest);
        }
        sProvider.close();
        return listQuestionLanguage;
    }

    static /* synthetic */ Calendar access$000(UIAdvancedSearchForm x0, UIFormDateTimeInput x1, String x2) throws Exception {
        return x0.getCalendar(x1, x2);
    }

    static /* synthetic */ String access$100(UIAdvancedSearchForm x0) {
        return x0.defaultLanguage_;
    }

    static /* synthetic */ List access$200(UIAdvancedSearchForm x0, String x1, String x2, String x3, String x4, List x5) throws Exception {
        return x0.getResultListQuestion(x1, x2, x3, x4, x5);
    }
}

