/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UICategoryForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UISelector;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private String categoryId_ = "";
    private String parentId_;
    private static final String FIELD_NAME_INPUT = "eventCategoryName";
    private static final String FIELD_DESCRIPTION_INPUT = "description";
    private static final String FIELD_MODERATOR_INPUT = "moderator";
    private static final String FIELD_MODERATEQUESTIONS_CHECKBOX = "moderatequestions";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private static boolean isAddNew_ = true;
    private String oldName_ = "";

    public void init(boolean isAddNew) throws Exception {
        isAddNew_ = isAddNew;
        UIFormInputWithActions inputset = new UIFormInputWithActions("UIAddCategoryForm");
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME_INPUT, FIELD_NAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]));
        inputset.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX, FIELD_MODERATEQUESTIONS_CHECKBOX, (Object)false));
        UIFormStringInput moderator = new UIFormStringInput(FIELD_MODERATOR_INPUT, FIELD_MODERATOR_INPUT, null);
        moderator.setValue((Object)FAQUtils.getCurrentUser());
        moderator.addValidator(MandatoryValidator.class, new Object[0]);
        inputset.addUIFormInput((UIFormInput)moderator);
        ArrayList<UIFormInputWithActions.ActionData> actionData = new ArrayList<UIFormInputWithActions.ActionData>();
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        int i = 0;
        for (String string : strings) {
            UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
            ad.setActionListener("SelectPermission");
            ad.setActionName(string);
            ad.setActionType(0);
            ad.setCssIconClass(string + "Icon");
            ad.setActionParameter(String.valueOf(i));
            actionData.add(ad);
            ++i;
        }
        inputset.setActionField(FIELD_MODERATOR_INPUT, actionData);
        this.addChild((UIComponent)inputset);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getParentId() {
        return this.parentId_;
    }

    public void setParentId(String s) {
        this.parentId_ = s;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        String oldValue = (String)fieldInput.getValue();
        oldValue = oldValue != null && oldValue.trim().length() > 0 ? oldValue + "," + value : value;
        fieldInput.setValue((Object)oldValue);
    }

    public void setCategoryValue(String categoryId, boolean isUpdate) throws Exception {
        if (isUpdate) {
            FAQService faqService = FAQUtils.getFAQService();
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            Category cat = faqService.getCategoryById(categoryId, sessionProvider);
            sessionProvider.close();
            String[] modera = cat.getModeratorsCategory();
            this.categoryId_ = categoryId;
            this.oldName_ = cat.getName();
            this.getUIStringInput(FIELD_NAME_INPUT).setValue((Object)this.oldName_);
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setDefaultValue((Object)cat.getDescription());
            this.getUIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX).setChecked(cat.isModerateQuestions());
            String moderator = "";
            for (String str : cat.getModerators()) {
                if (moderator != null && moderator.trim().length() > 0) {
                    moderator = moderator + ",";
                }
                moderator = moderator + str;
            }
            this.getUIStringInput(FIELD_MODERATOR_INPUT).setValue((Object)moderator);
        }
    }

    public String cutColonCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ':' || c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    private String filterItemInString(String string) throws Exception {
        if (string != null && string.trim().length() > 0) {
            String[] strings = FAQUtils.splitForFAQ((String)string);
            ArrayList<String> list = new ArrayList<String>();
            string = strings[0];
            String string1 = this.cutColonCaret(string);
            list.add(string1);
            for (String string_ : strings) {
                string1 = this.cutColonCaret(string_);
                if (list.contains(string1)) continue;
                list.add(string1);
                string = string + "," + string_;
            }
        }
        return string;
    }

    private String removeSpaceInString(String str) throws Exception {
        if (str != null && str.trim().length() > 0) {
            String[] strs = new String[]{";", ", ", " ,", ",,"};
            for (int i = 0; i < strs.length; ++i) {
                while (str.indexOf(strs[i]) >= 0) {
                    str = str.replaceAll(strs[i], ",");
                }
            }
            if (str.lastIndexOf(",") == str.length() - 1) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.indexOf(",") == 0) {
                str = str.substring(1, str.length());
            }
            return str;
        }
        return "";
    }

    static /* synthetic */ String access$000(UICategoryForm x0, String x1) throws Exception {
        return x0.removeSpaceInString(x1);
    }

    static /* synthetic */ String access$100(UICategoryForm x0, String x1) throws Exception {
        return x0.filterItemInString(x1);
    }

    static /* synthetic */ FAQService access$200() {
        return faqService_;
    }

    static /* synthetic */ String access$300(UICategoryForm x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ boolean access$400() {
        return isAddNew_;
    }
}

