/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIResponseForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIResponseForm.gtmpl", events={@EventConfig(listeners={AddNewAnswerActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={AddRelationActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class}), @EventConfig(listeners={RemoveRelationActionListener.class}), @EventConfig(listeners={ViewEditQuestionActionListener.class}), @EventConfig(listeners={ChangeQuestionActionListener.class})})
public class UIResponseForm
extends UIForm
implements UIPopupComponent {
    private static final String QUESTION_CONTENT = "QuestionContent";
    private static final String QUESTION_LANGUAGE = "Language";
    private static final String RESPONSE_CONTENT = "QuestionRespone";
    private static final String ATTATCH_MENTS = "QuestionAttach";
    private static final String REMOVE_FILE_ATTACH = "RemoveFile";
    private static final String FILE_ATTACHMENTS = "FileAttach";
    private static final String SHOW_ANSWER = "QuestionShowAnswer";
    private static final String IS_APPROVED = "IsApproved";
    private static Question question_ = null;
    private static FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private boolean isViewEditQuestion_ = true;
    private String labelContent_ = new String();
    private boolean noCheck = false;
    private UIFormStringInput questionContent_;
    private UIFormSelectBox questionLanguages_;
    private UIFormWYSIWYGInput responseQuestion_;
    private UIFormInputWithActions inputAttachment_;
    private UIFormCheckBoxInput checkShowAnswer_;
    private UIFormCheckBoxInput<Boolean> isApproved_;
    private String questionId_ = new String();
    private List<String> listRelationQuestion = new ArrayList();
    private List<String> listQuestIdRela = new ArrayList();
    private List<FileAttachment> listFileAttach_ = new ArrayList();
    private List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    private List<SelectItemOption<String>> listLanguageToReponse = new ArrayList();
    private String questionChanged_ = new String();
    private String responseContent_ = new String();
    private String languageIsResponsed = "";
    private String link_ = "";
    private boolean isChildren_ = false;
    private FAQSetting faqSetting_;
    private List<String> listResponse = new ArrayList();
    private List<String> listUserResponse = new ArrayList();
    private List<Date> listDateResponse = new ArrayList();
    private int posOfResponse = 0;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public UIResponseForm() throws Exception {
        this.questionContent_ = new UIFormTextAreaInput(QUESTION_CONTENT, QUESTION_CONTENT, null);
        this.responseQuestion_ = new UIFormWYSIWYGInput(RESPONSE_CONTENT, null, null, true);
        this.checkShowAnswer_ = new UIFormCheckBoxInput(SHOW_ANSWER, SHOW_ANSWER, (Object)false);
        this.isApproved_ = new UIFormCheckBoxInput(IS_APPROVED, IS_APPROVED, (Object)false);
        this.inputAttachment_ = new UIFormInputWithActions(ATTATCH_MENTS);
        this.inputAttachment_.addUIFormInput((UIFormInput)new UIFormInputInfo(FILE_ATTACHMENTS, FILE_ATTACHMENTS, null));
        this.setActions(new String[]{"Attachment", "AddRelation", "Save", "Cancel"});
    }

    private int numberOfAnswer() {
        return this.listResponse.size();
    }

    public void setQuestionId(Question question, String languageViewed, boolean nonCheck) {
        this.noCheck = nonCheck;
        this.listResponse = new ArrayList();
        this.listUserResponse = new ArrayList();
        this.listDateResponse = new ArrayList();
        try {
            if (this.listQuestIdRela != null && !this.listQuestIdRela.isEmpty()) {
                this.listRelationQuestion.clear();
                this.listQuestIdRela.clear();
            }
            question_ = question;
            this.listResponse.addAll(Arrays.asList(question.getAllResponses()));
            if (this.listResponse.size() == 1 && ((String)this.listResponse.get(0)).trim().length() < 1) {
                this.listUserResponse.add(FAQUtils.getFullName((String)FAQUtils.getCurrentUser()));
                this.listDateResponse.add(new Date());
            } else {
                this.listUserResponse.addAll(Arrays.asList(question.getResponseBy()));
                this.listDateResponse.addAll(Arrays.asList(question.getDateResponse()));
            }
            this.posOfResponse = 0;
            this.languageIsResponsed = languageViewed != null && languageViewed.trim().length() > 0 ? languageViewed : question.getLanguage();
            QuestionLanguage questionLanguage = new QuestionLanguage();
            questionLanguage.setLanguage(question.getLanguage());
            questionLanguage.setQuestion(question.getQuestion());
            if (question.getAllResponses() != null && question.getAllResponses().length > 0) {
                questionLanguage.setResponse(question.getAllResponses());
                questionLanguage.setResponseBy(question.getResponseBy());
                questionLanguage.setDateResponse(question.getDateResponse());
            } else {
                questionLanguage.setResponse(new String[]{""});
            }
            this.listQuestionLanguage.add(questionLanguage);
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            this.listQuestionLanguage.addAll(faqService.getQuestionLanguages(question_.getId(), sessionProvider));
            sessionProvider.close();
            for (QuestionLanguage language : this.listQuestionLanguage) {
                this.listLanguageToReponse.add(new SelectItemOption(language.getLanguage(), (Object)language.getLanguage()));
                if (!language.getLanguage().equals(this.languageIsResponsed)) continue;
                this.questionChanged_ = language.getQuestion();
                this.questionContent_.setValue((Object)language.getQuestion());
                this.labelContent_ = language.getQuestion();
                this.responseQuestion_.setValue((Object)language.getResponse()[0]);
            }
            this.setListRelation();
            this.setListFileAttach(question.getAttachMent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.questionId_ = question.getId();
        this.checkShowAnswer_.setChecked(question_.isActivated());
        this.isApproved_.setChecked(question_.isApproved());
        try {
            this.inputAttachment_.setActionField(FILE_ATTACHMENTS, this.getUploadFileList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.questionLanguages_ = new UIFormSelectBox(QUESTION_LANGUAGE, QUESTION_LANGUAGE, this.getListLanguageToReponse());
        this.questionLanguages_.setSelectedValues(new String[]{this.languageIsResponsed});
        this.questionLanguages_.setOnChange("ChangeQuestion");
        this.addChild((UIComponent)this.questionContent_);
        this.addChild((UIComponent)this.questionLanguages_);
        this.addChild((UIComponent)this.responseQuestion_);
        this.addChild((UIComponent)this.isApproved_);
        this.addChild((UIComponent)this.checkShowAnswer_);
        this.addChild((UIComponent)this.inputAttachment_);
    }

    public String getQuestionId() {
        return this.questionId_;
    }

    public List<UIFormInputWithActions.ActionData> getUploadFileList() {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (FileAttachment attachdata : this.listFileAttach_) {
            UIFormInputWithActions.ActionData fileUpload = new UIFormInputWithActions.ActionData();
            fileUpload.setActionListener("Download");
            fileUpload.setActionParameter(attachdata.getPath());
            fileUpload.setActionType(0);
            fileUpload.setCssIconClass("AttachmentIcon");
            fileUpload.setActionName(attachdata.getName() + " (" + attachdata.getSize() + " B)");
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(REMOVE_FILE_ATTACH);
            removeAction.setActionParameter(attachdata.getPath());
            removeAction.setCssIconClass("LabelLink");
            removeAction.setActionType(1);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void setListFileAttach(List<FileAttachment> listFileAttachment) {
        this.listFileAttach_.addAll(listFileAttachment);
    }

    public void setListFileAttach(FileAttachment fileAttachment) {
        this.listFileAttach_.add(fileAttachment);
    }

    private List<FileAttachment> getListFile() {
        return this.listFileAttach_;
    }

    private String getLanguageIsResponse() {
        return this.languageIsResponsed;
    }

    public void refreshUploadFileList() throws Exception {
        ((UIFormInputWithActions)this.getChildById(ATTATCH_MENTS)).setActionField(FILE_ATTACHMENTS, this.getUploadFileList());
    }

    private void setListRelation() throws Exception {
        String[] relations = question_.getRelations();
        this.setListIdQuesRela(Arrays.asList(relations));
        if (relations != null && relations.length > 0) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            for (String relation : relations) {
                this.listRelationQuestion.add(faqService.getQuestionById(relation, sessionProvider).getQuestion());
            }
            sessionProvider.close();
        }
    }

    public List<String> getListRelation() {
        return this.listRelationQuestion;
    }

    private List<SelectItemOption<String>> getListLanguageToReponse() {
        return this.listLanguageToReponse;
    }

    public List<String> getListIdQuesRela() {
        return this.listQuestIdRela;
    }

    public void setListIdQuesRela(List<String> listId) {
        if (!this.listQuestIdRela.isEmpty()) {
            this.listQuestIdRela.clear();
        }
        this.listQuestIdRela.addAll(listId);
    }

    public void setListRelationQuestion(List<String> listQuestionContent) {
        this.listRelationQuestion.clear();
        this.listRelationQuestion.addAll(listQuestionContent);
    }

    private List<String> getListRelationQuestion() {
        return this.listRelationQuestion;
    }

    public void setIsChildren(boolean isChildren) {
        this.isChildren_ = isChildren;
        this.removeChildById(QUESTION_CONTENT);
        this.removeChildById(QUESTION_LANGUAGE);
        this.removeChildById(RESPONSE_CONTENT);
        this.removeChildById(ATTATCH_MENTS);
        this.removeChildById(IS_APPROVED);
        this.removeChildById(SHOW_ANSWER);
        this.listFileAttach_.clear();
        this.listLanguageToReponse.clear();
        this.listQuestIdRela.clear();
        this.listQuestionLanguage.clear();
        this.listRelationQuestion.clear();
    }

    private boolean compareTowArraies(String[] array1, String[] array2) {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.addAll(Arrays.asList(array1));
        int count = 0;
        for (String str : array2) {
            if (!list1.contains(str)) continue;
            ++count;
        }
        return count == array1.length && count == array2.length;
    }

    static /* synthetic */ List access$000(UIResponseForm x0) {
        return x0.listResponse;
    }

    static /* synthetic */ int access$100(UIResponseForm x0) {
        return x0.posOfResponse;
    }

    static /* synthetic */ List access$200(UIResponseForm x0) {
        return x0.listDateResponse;
    }

    static /* synthetic */ String access$300(UIResponseForm x0) {
        return x0.languageIsResponsed;
    }

    static /* synthetic */ Question access$400() {
        return question_;
    }

    static /* synthetic */ boolean access$500(UIResponseForm x0, String[] x1, String[] x2) {
        return x0.compareTowArraies(x1, x2);
    }

    static /* synthetic */ List access$600(UIResponseForm x0) {
        return x0.listUserResponse;
    }

    static /* synthetic */ List access$700(UIResponseForm x0) {
        return x0.listQuestionLanguage;
    }

    static /* synthetic */ List access$800(UIResponseForm x0) {
        return x0.listFileAttach_;
    }

    static /* synthetic */ FAQSetting access$900(UIResponseForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$1000() {
        return faqService;
    }

    static /* synthetic */ boolean access$1100(UIResponseForm x0) {
        return x0.isChildren_;
    }

    static /* synthetic */ boolean access$1200(UIResponseForm x0) {
        return x0.noCheck;
    }

    static /* synthetic */ String access$1300(UIResponseForm x0) {
        return x0.questionId_;
    }

    static /* synthetic */ List access$1400(UIResponseForm x0) {
        return x0.listQuestIdRela;
    }

    static /* synthetic */ List access$1500(UIResponseForm x0) {
        return x0.listRelationQuestion;
    }

    static /* synthetic */ int access$102(UIResponseForm x0, int x1) {
        x0.posOfResponse = x1;
        return x0.posOfResponse;
    }

    static /* synthetic */ boolean access$1602(UIResponseForm x0, boolean x1) {
        x0.isViewEditQuestion_ = x1;
        return x0.isViewEditQuestion_;
    }

    static /* synthetic */ String access$302(UIResponseForm x0, String x1) {
        x0.languageIsResponsed = x1;
        return x0.languageIsResponsed;
    }

    static /* synthetic */ String access$1702(UIResponseForm x0, String x1) {
        x0.labelContent_ = x1;
        return x0.labelContent_;
    }
}

