/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIFAQContainer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UICategories.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={EditSubCategoryActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={MoveCategoryActionListener.class}), @EventConfig(listeners={WatchActionListener.class}), @EventConfig(listeners={WatchManagerActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ChangeIndexActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={MoveCategoryIntoActionListener.class})})
public class UICategories
extends UIContainer {
    public String parentCateID_ = null;
    private String categoryId_ = null;
    private boolean isSwap = false;
    private String currentName = "";
    private boolean viewBackIcon = false;
    private List<Category> listCate = new ArrayList();
    private List<String> listCateId_ = new ArrayList();
    private List<Boolean> categoryModerators = new ArrayList();
    private boolean canEditQuestion = false;
    private boolean isModeratorSubCate = false;
    private FAQSetting faqSetting_ = new FAQSetting();
    private String[] firstActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] firstActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] secondActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] secondActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] userActionsCateUnWatch_ = new String[]{"AddNewQuestion", "UnWatch"};
    FAQService faqService_;
    private String portalName = this.getPortalName();
    private String currentUser = FAQUtils.getCurrentUser();

    public void setFAQService(FAQService service) {
        this.faqService_ = service;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    private long[] getCategoryInfo() {
        long[] result = new long[]{0L, 0L, 0L, 0L};
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            result = this.faqService_.getCategoryInfo(this.categoryId_, sessionProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
        return result;
    }

    private List<Category> getListCate() {
        return this.listCate;
    }

    public void setPathCategory(String pathCategory) {
        String[] listIds = pathCategory.split("/");
        this.categoryId_ = listIds[listIds.length - 1];
        if (listIds.length > 1) {
            this.parentCateID_ = listIds.length > 2 ? listIds[listIds.length - 2] : null;
        } else {
            this.categoryId_ = null;
            this.parentCateID_ = null;
        }
    }

    private void setIsModerators(String currentUser_) {
        block20: {
            block21: {
                int i;
                block18: {
                    block19: {
                        this.isModeratorSubCate = false;
                        this.canEditQuestion = false;
                        if (!this.faqSetting_.isAdmin()) break block19;
                        this.canEditQuestion = true;
                        this.isModeratorSubCate = true;
                        break block20;
                    }
                    if (this.categoryId_ == null || this.categoryId_.trim().length() < 1) {
                        this.listCateId_.clear();
                    } else if (!this.listCateId_.contains(this.categoryId_)) {
                        try {
                            if (this.listCateId_.isEmpty() || !this.getPathService(this.categoryId_).equals(this.getPathService((String)this.listCateId_.get(this.listCateId_.size() - 1)))) {
                                this.listCateId_.add(this.categoryId_);
                                break block18;
                            }
                            this.listCateId_.set(this.listCateId_.size() - 1, this.categoryId_);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        int pos = this.listCateId_.indexOf(this.categoryId_);
                        for (i = pos + 1; i < this.listCateId_.size(); ++i) {
                            this.listCateId_.remove(i);
                        }
                    }
                }
                if (this.listCateId_.size() > 0) {
                    SessionProvider sessionProvider = FAQUtils.getSystemProvider();
                    i = 0;
                    for (String cateIdProcess : this.listCateId_) {
                        try {
                            if (this.faqService_.getCategoryById(cateIdProcess, sessionProvider).getModeratorsCategory().contains(currentUser_)) {
                                this.canEditQuestion = true;
                                if (i >= this.listCateId_.size()) break;
                                this.isModeratorSubCate = true;
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    sessionProvider.close();
                }
                if (this.isModeratorSubCate) break block21;
                this.categoryModerators.clear();
                for (Category category : this.listCate) {
                    try {
                        if (category.getModeratorsCategory().contains(currentUser_)) {
                            this.categoryModerators.add(true);
                            continue;
                        }
                        this.categoryModerators.add(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block20;
            }
            if (!this.viewBackIcon) break block20;
            this.categoryModerators.clear();
            for (int i = 0; i < this.listCate.size(); ++i) {
                this.categoryModerators.add(true);
            }
        }
    }

    public boolean getCanEditQuestions() {
        return this.canEditQuestion;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    private boolean isWatched(String cateId) {
        try {
            SessionProvider sProvider = FAQUtils.getSystemProvider();
            boolean isWatched = this.faqService_.getWatchByUser(this.currentUser, cateId, sProvider);
            sProvider.close();
            return isWatched;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setListCate() throws Exception {
        if (!this.isSwap) {
            List newList = new ArrayList();
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            newList = this.faqService_.getSubCategories(this.categoryId_, sessionProvider, this.faqSetting_);
            this.viewBackIcon = true;
            if (newList.isEmpty()) {
                newList = this.faqService_.getSubCategories(this.parentCateID_, sessionProvider, this.faqSetting_);
                this.viewBackIcon = false;
            }
            this.currentName = this.faqService_.getCategoryById(this.categoryId_, sessionProvider).getName();
            if (this.currentName == null || this.currentName.trim().length() < 1) {
                this.currentName = FAQUtils.getResourceBundle((String)"UIBreadcumbs.label.eXoFAQ");
            }
            UIBreadcumbs breadcumbs = (UIBreadcumbs)((UIFAQContainer)this.getAncestorOfType(UIFAQContainer.class)).getChild(UIBreadcumbs.class);
            this.listCate.clear();
            this.listCate.addAll(newList);
            String[] listId = breadcumbs.getPath(breadcumbs.getBreadcumbs().size() - 1).split("/");
            sessionProvider.close();
            this.setIsModerators(FAQUtils.getCurrentUser());
        }
        this.isSwap = false;
    }

    public String getRSSLink(String cateId) {
        String rssLink = "";
        rssLink = "/faq/iFAQRss/" + this.portalName + "/" + cateId + "/faq.rss";
        return rssLink;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public void resetListCate(SessionProvider sProvider) throws Exception {
        this.isSwap = true;
        this.listCate.clear();
        this.listCate.addAll(this.faqService_.getSubCategories(this.parentCateID_, sProvider, this.faqSetting_));
        this.setIsModerators(FAQUtils.getCurrentUser());
    }

    public List<Watch> getListWatch(String categoryId) throws Exception {
        ArrayList<Watch> watchList_ = new ArrayList();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        watchList_ = this.faqService_.getListMailInWatch(categoryId, sessionProvider).getAllWatch();
        sessionProvider.close();
        return watchList_;
    }

    private List<Category> getAllSubCategory(String categoryId) throws Exception {
        ArrayList<Category> listResult = new ArrayList<Category>();
        Stack<Category> stackCate = new Stack<Category>();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Category cate = null;
        listResult.add(this.faqService_.getCategoryById(categoryId, sessionProvider));
        for (Category category : this.faqService_.getSubCategories(categoryId, sessionProvider, this.faqSetting_)) {
            stackCate.push(category);
        }
        while (!stackCate.isEmpty()) {
            cate = (Category)stackCate.pop();
            listResult.add(cate);
            for (Category category : this.faqService_.getSubCategories(cate.getId(), sessionProvider, this.faqSetting_)) {
                stackCate.push(category);
            }
        }
        sessionProvider.close();
        return listResult;
    }

    public String cutCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    public String getPathService(String categoryId) throws Exception {
        String oldPath = "";
        String path = "FAQService";
        if (categoryId != null && !categoryId.equals("null")) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            List listPath = this.faqService_.getCategoryPath(sessionProvider, categoryId);
            sessionProvider.close();
            for (int i = listPath.size() - 1; i >= 0; --i) {
                oldPath = oldPath + "/" + (String)listPath.get(i);
            }
            path = path + oldPath;
            oldPath = path.substring(0, path.lastIndexOf("/"));
        } else {
            oldPath = path;
        }
        return oldPath;
    }

    private String[] getActionCategory(String cateId) {
        if (this.categoryId_ == null) {
            if (this.isWatched(cateId)) {
                return this.firstActionCateUnWatch_;
            }
            return this.firstActionCate_;
        }
        if (this.isWatched(cateId)) {
            return this.secondActionCateUnWatch_;
        }
        return this.secondActionCate_;
    }

    private String[] getActionCategoryWithUser(String cateId) {
        try {
            if (FAQUtils.getCurrentUser() != null) {
                if (!this.isWatched(cateId)) {
                    return this.userActionsCate_;
                }
                return this.userActionsCateUnWatch_;
            }
            return new String[]{this.userActionsCate_[0]};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[]{this.userActionsCate_[0]};
        }
    }

    static /* synthetic */ List access$000(UICategories x0) {
        return x0.listCate;
    }

    static /* synthetic */ FAQSetting access$100(UICategories x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ boolean access$200(UICategories x0) {
        return x0.viewBackIcon;
    }

    static /* synthetic */ String access$300(UICategories x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ boolean access$400(UICategories x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ List access$500(UICategories x0, String x1) throws Exception {
        return x0.getAllSubCategory(x1);
    }
}

