/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQFormSearch;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIQuickSearch;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/UIQuickSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UIQuickSearch
extends UIForm {
    private static final String FIELD_SEARCHVALUE = "inputValue";
    private FAQSetting faqSetting_ = new FAQSetting();

    public UIQuickSearch() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SEARCHVALUE, FIELD_SEARCHVALUE, null));
        FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        this.faqSetting_ = new FAQSetting();
        String currentUser = FAQUtils.getCurrentUser();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        if (currentUser != null && currentUser.trim().length() > 0) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            if (this.faqSetting_.getIsAdmin() == null || this.faqSetting_.getIsAdmin().trim().length() < 1) {
                if (faqService_.isAdminRole(currentUser, sessionProvider)) {
                    this.faqSetting_.setIsAdmin("TRUE");
                } else {
                    this.faqSetting_.setIsAdmin("FALSE");
                }
            }
            faqService_.getUserSetting(sessionProvider, currentUser, this.faqSetting_);
            sessionProvider.close();
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        this.setSubmitAction(this.event("Search"));
    }

    public List<FAQFormSearch> getResultListQuickSearch(List<FAQFormSearch> formSearchs) throws Exception {
        ArrayList<FAQFormSearch> listQuickSearch = new ArrayList<FAQFormSearch>();
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        String currentUser = FAQUtils.getCurrentUser();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Question question = null;
        String categoryIdOfQuestion = null;
        if (this.faqSetting_.getDisplayMode().equals("both")) {
            if (this.faqSetting_.isAdmin()) {
                return formSearchs;
            }
            for (FAQFormSearch faqSearch : formSearchs) {
                if (faqSearch.getType().equals("faqCategory")) {
                    listQuickSearch.add(faqSearch);
                    continue;
                }
                question = faqService.getQuestionById(faqSearch.getId(), sessionProvider);
                categoryIdOfQuestion = question.getCategoryId();
                if (!categoryIdOfQuestion.equals("null")) {
                    if (Arrays.asList(faqService.getCategoryById(categoryIdOfQuestion, sessionProvider).getModeratorsCategory()).contains(currentUser)) {
                        listQuickSearch.add(faqSearch);
                        continue;
                    }
                    if (!question.isActivated()) continue;
                    listQuickSearch.add(faqSearch);
                    continue;
                }
                if (!question.isActivated()) continue;
                listQuickSearch.add(faqSearch);
            }
            sessionProvider.close();
            return listQuickSearch;
        }
        for (FAQFormSearch faqSearch : formSearchs) {
            if (faqSearch.getType().equals("faqCategory")) {
                listQuickSearch.add(faqSearch);
                continue;
            }
            question = faqService.getQuestionById(faqSearch.getId(), sessionProvider);
            categoryIdOfQuestion = question.getCategoryId();
            if (!categoryIdOfQuestion.equals("null")) {
                if (!question.isApproved()) continue;
                if (this.faqSetting_.isAdmin() || Arrays.asList(faqService.getCategoryById(categoryIdOfQuestion, sessionProvider).getModeratorsCategory()).contains(currentUser)) {
                    listQuickSearch.add(faqSearch);
                    continue;
                }
                if (!question.isActivated()) continue;
                listQuickSearch.add(faqSearch);
                continue;
            }
            if ((!question.isApproved() || !question.isActivated()) && !this.faqSetting_.isAdmin()) continue;
            listQuickSearch.add(faqSearch);
        }
        sessionProvider.close();
        return listQuickSearch;
    }
}

