/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIMoveCategoryForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIMoveCategoryForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIMoveCategoryForm
extends UIForm
implements UIPopupComponent {
    private String categoryId_;
    private String homeCategoryName = "";
    private FAQSetting faqSetting_;
    private static List<String> listCateSelected = new ArrayList();
    private List<Cate> listCate = new ArrayList();
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public UIMoveCategoryForm() throws Exception {
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        Node homeNode = faqService_.getCategoryNodeById(null, sProvider);
        if (homeNode.hasProperty("exo:name")) {
            this.homeCategoryName = homeNode.getProperty("exo:name").getString();
        } else {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            this.homeCategoryName = res.getString("UIAddRelationForm.title.RootCategory");
        }
        sProvider.close();
    }

    public String getCategoryID() {
        return this.categoryId_;
    }

    public void setCategoryID(String s) {
        this.categoryId_ = s;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Cate> getListCate() {
        return this.listCate;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
        String orderType = faqSetting.getOrderType();
        if (orderType.equals("asc")) {
            faqSetting.setOrderType("desc");
        } else {
            faqSetting.setOrderType("asc");
        }
    }

    public void setListCate() throws Exception {
        ArrayList<Cate> listCate = new ArrayList<Cate>();
        Cate parentCate = null;
        Cate childCate = null;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        for (Category category : faqService_.getSubCategories(null, sessionProvider, this.faqSetting_)) {
            if (category == null || category.getId().equals(this.categoryId_)) continue;
            Cate cate = new Cate(this);
            cate.setCategory(category);
            cate.setDeft(0);
            listCate.add(cate);
        }
        while (!listCate.isEmpty()) {
            parentCate = new Cate(this);
            parentCate = (Cate)listCate.get(listCate.size() - 1);
            listCate.remove(parentCate);
            this.listCate.add(parentCate);
            for (Category category : faqService_.getSubCategories(parentCate.getCategory().getId(), sessionProvider, this.faqSetting_)) {
                if (category == null || category.getId().equals(this.categoryId_)) continue;
                childCate = new Cate(this);
                childCate.setCategory(category);
                childCate.setDeft(parentCate.getDeft() + 1);
                listCate.add(childCate);
            }
        }
        String orderType = this.faqSetting_.getOrderType();
        if (orderType.equals("asc")) {
            this.faqSetting_.setOrderType("desc");
        } else {
            this.faqSetting_.setOrderType("asc");
        }
        sessionProvider.close();
    }

    private List<Question> getQuestions(String cateId) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            List listQues = faqService_.getQuestionsByCatetory(cateId, sessionProvider, this.faqSetting_).getAll();
            sessionProvider.close();
            return listQues;
        }
        catch (Exception e) {
            sessionProvider.close();
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CateClass> getListObjCategory(String newParentId) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            ArrayList<CateClass> listCate = new ArrayList<CateClass>();
            CateClass cateClass = new CateClass(this);
            cateClass.setCategory(faqService_.getCategoryById(this.categoryId_, sessionProvider));
            cateClass.setCateParentId(newParentId);
            listCate.add(cateClass);
            for (int i = 0; i < listCate.size(); ++i) {
                for (Category category : faqService_.getSubCategories(((CateClass)listCate.get(i)).getCategory().getId(), sessionProvider, this.faqSetting_)) {
                    cateClass = new CateClass(this);
                    cateClass.setCategory(category);
                    cateClass.setCateParentId(((CateClass)listCate.get(i)).getCategory().getId());
                    listCate.add(cateClass);
                }
            }
            sessionProvider.close();
            ArrayList<CateClass> arrayList = listCate;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sessionProvider.close();
        }
        return null;
    }

    static /* synthetic */ FAQSetting access$000(UIMoveCategoryForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$100() {
        return faqService_;
    }
}

