/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.rendering.RenderHelper;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIPopupViewQuestion;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIPopupViewQuestion.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIPopupViewQuestion
extends UIForm
implements UIPopupComponent {
    private String questionId_ = null;
    private String language_ = "";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private String[] sizes = new String[]{"bytes", "KB", "MB"};
    private RenderHelper renderHelper = new RenderHelper();

    public UIPopupViewQuestion() throws Exception {
        this.setActions(new String[]{"Close"});
    }

    public String getQuestion() {
        return this.questionId_;
    }

    public void setQuestion(String questionId) {
        this.questionId_ = questionId;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String renderAnswer(Answer answer) {
        return this.renderHelper.renderAnswer(answer);
    }

    public Question getViewQuestion() {
        Question question = null;
        try {
            question = faqService_.getQuestionById(this.questionId_);
            ArrayList listQuestionLanguage = new ArrayList();
            listQuestionLanguage.addAll(faqService_.getQuestionLanguages(this.questionId_));
            for (QuestionLanguage questionLanguage : listQuestionLanguage) {
                if (!questionLanguage.getLanguage().equals(this.language_)) continue;
                question.setDetail(questionLanguage.getDetail());
                question.setQuestion(questionLanguage.getQuestion());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return question;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getQuestionRelationById(String questionId) {
        Question question = new Question();
        try {
            question = faqService_.getQuestionById(questionId);
            if (question != null) {
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 1000L) {
            String str = residual + "";
            result = size + "." + str.substring(0, 3) + " " + this.sizes[i];
        } else {
            result = size + "." + residual + " " + this.sizes[i];
        }
        return result;
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    private String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return this.getFileSource(input, fileName, dservice);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

