/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.faq.webui.SelectItem;
import org.exoplatform.faq.webui.SelectOption;
import org.exoplatform.faq.webui.UIFormSelectBoxWithGroups;
import org.exoplatform.faq.webui.popup.UIAddressEmailsForm;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIAddressEmailsForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressEmailsForm
extends BaseUIForm
implements UIPopupComponent {
    public static final String USER_SEARCH = "user-search".intern();
    public static final String USER_GROUP = "user-group".intern();
    public Map<String, User> checkedList_ = new HashMap();
    public Map<String, User> newCheckedList_ = new HashMap();
    private static final String FILED_ALL_GROUP = "all-group";
    private String selectedAddressId_ = "";
    private String recipientsType_ = "";
    private UIPageIterator uiPageList_;

    public void setRecipientsType(String type) {
        this.recipientsType_ = type;
    }

    public String getRecipientType() {
        return this.recipientsType_;
    }

    public UIAddressEmailsForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_SEARCH, USER_SEARCH, null));
        UIFormSelectBoxWithGroups uiSelect = new UIFormSelectBoxWithGroups(USER_GROUP, USER_GROUP, this.getOptions());
        uiSelect.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelect);
        this.uiPageList_ = new UIPageIterator();
        try {
            this.setUserList(UserHelper.getPageListUser());
        }
        catch (Exception e) {
            this.log.error((Object)("Can not set users list, exception: " + e.getMessage()));
        }
    }

    public List<SelectItem> getOptions() throws Exception {
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        options.add((SelectItem)new SelectOption(FILED_ALL_GROUP, FILED_ALL_GROUP));
        try {
            List groupIds = UserHelper.getAllGroupId();
            if (!groupIds.isEmpty()) {
                for (String publicCg : groupIds) {
                    options.add((SelectItem)new SelectOption(publicCg, publicCg));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not get all groups user , exception: ", (Throwable)e);
        }
        return options;
    }

    private void searchUserProfileByKey(String keyWord) throws Exception {
        try {
            HashMap<String, User> mapObject = new HashMap<String, User>();
            OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            keyWord = "*" + keyWord + "*";
            Query q = new Query();
            q.setUserName(keyWord);
            ListAccess listAcess = service.getUserHandler().findUsersByQuery(q);
            for (User user : (User[])listAcess.load(0, listAcess.getSize())) {
                mapObject.put(user.getUserName(), user);
            }
            listAcess = service.getUserHandler().findUsersByQuery(q);
            for (User user : (User[])listAcess.load(0, listAcess.getSize())) {
                mapObject.put(user.getUserName(), user);
            }
            q = new Query();
            q.setFirstName(keyWord);
            listAcess = service.getUserHandler().findUsersByQuery(q);
            for (User user : (User[])listAcess.load(0, listAcess.getSize())) {
                mapObject.put(user.getUserName(), user);
            }
            q = new Query();
            q.setEmail(keyWord);
            listAcess = service.getUserHandler().findUsersByQuery(q);
            for (User user : (User[])listAcess.load(0, listAcess.getSize())) {
                mapObject.put(user.getUserName(), user);
            }
            ObjectPageList objPageList = new ObjectPageList(Arrays.asList(mapObject.values().toArray()), 10);
            this.uiPageList_.setPageList((PageList)objPageList);
        }
        catch (Exception e) {
            this.log.error((Object)("Can not search user by key, exception: " + e.getMessage()));
        }
    }

    public List<User> getUsers() throws Exception {
        ArrayList<User> users = new ArrayList<User>(this.uiPageList_.getCurrentPageData());
        for (User c : users) {
            String userName = c.getUserName();
            UICheckBoxInput uiInput = this.getUICheckBoxInput(userName);
            if (uiInput == null) {
                uiInput = new UICheckBoxInput(userName, userName, null);
                this.addUIFormInput((UIFormInput)uiInput);
            }
            if (this.checkedList_.containsKey(userName)) {
                uiInput.setChecked(true);
            }
            uiInput.setHTMLAttribute("title", c.getFullName());
        }
        return users;
    }

    public void setUserList(PageList<User> userList) throws Exception {
        this.uiPageList_.setPageList(userList);
    }

    public void setAlreadyCheckedUser(List<User> alreadyCheckedUser) throws Exception {
        for (User ct : alreadyCheckedUser) {
            this.checkedList_.put(ct.getUserName(), ct);
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageList_;
    }

    public long getAvailablePage() {
        return this.uiPageList_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageList_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageList_.setCurrentPage(page);
    }

    public List<User> getCheckedUser() throws Exception {
        ArrayList<User> userList = new ArrayList<User>();
        for (User user : new ArrayList(this.uiPageList_.getCurrentPageData())) {
            UICheckBoxInput uiCheckbox = (UICheckBoxInput)this.getChildById(user.getUserName());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            userList.add(user);
        }
        return userList;
    }

    static /* synthetic */ void access$000(UIAddressEmailsForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$100(UIAddressEmailsForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$200(UIAddressEmailsForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ String access$302(UIAddressEmailsForm x0, String x1) {
        x0.selectedAddressId_ = x1;
        return x0.selectedAddressId_;
    }

    static /* synthetic */ String access$300(UIAddressEmailsForm x0) {
        return x0.selectedAddressId_;
    }

    static /* synthetic */ void access$400(UIAddressEmailsForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ void access$500(UIAddressEmailsForm x0, String x1) throws Exception {
        x0.searchUserProfileByKey(x1);
    }
}

