/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.webui.BaseUIFAQForm;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIAdvancedSearchForm;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIAdvancedSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAdvancedSearchForm
extends BaseUIFAQForm
implements UIPopupComponent {
    private static final String FIELD_TEXT = "Text";
    private static final String FIELD_SEARCHOBJECT_SELECTBOX = "SearchObject";
    private static final String FIELD_CATEGORY_NAME = "CategoryName";
    private static final String FIELD_ISMODERATEQUESTION = "IsModerateQuestion";
    private static final String FIELD_CATEGORY_MODERATOR = "CategoryModerator";
    private static final String FIELD_FROM_DATE = "FromDate";
    private static final String FIELD_TO_DATE = "ToDate";
    private static final String FIELD_AUTHOR = "Author";
    private static final String FIELD_EMAIL_ADDRESS = "EmailAddress";
    private static final String FIELD_LANGUAGE = "Language";
    private static final String FIELD_QUESTION = "Question";
    private static final String FIELD_RESPONSE = "Response";
    private static final String FIELD_COMMENT = "Comment";
    private static final String ITEM_EMPTY = "empty";
    private static final String ITEM_CATEGORY = "faqCategory";
    private static final String ITEM_QUESTION = "faqQuestion";
    private static final String ITEM_MODERATEQUESTION_EMPTY2 = "empty2";
    private static final String ITEM_MODERATEQUESTION_TRUE = "true";
    private static final String ITEM_MODERATEQUESTION_FALSE = "false";
    private FAQSetting faqSetting_ = new FAQSetting();
    private String defaultLanguage_ = "";

    public UIAdvancedSearchForm() throws Exception {
        String currentUser = FAQUtils.getCurrentUser();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        if (currentUser != null && currentUser.trim().length() > 0) {
            if (this.faqSetting_.getIsAdmin() == null || this.faqSetting_.getIsAdmin().trim().length() < 1) {
                if (this.getFAQService().isAdminRole(null)) {
                    this.faqSetting_.setIsAdmin("TRUE");
                } else {
                    this.faqSetting_.setIsAdmin("FALSE");
                }
            }
            this.getFAQService().getUserSetting(currentUser, this.faqSetting_);
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        UIFormStringInput text = new UIFormStringInput(FIELD_TEXT, FIELD_TEXT, null);
        ArrayList<String> listLanguage = new ArrayList<String>();
        LocaleConfigService configService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        this.defaultLanguage_ = configService.getDefaultLocaleConfig().getLocale().getDisplayLanguage();
        Iterator i$ = configService.getLocalConfigs().iterator();
        while (i$.hasNext()) {
            LocaleConfig object;
            LocaleConfig localeConfig = object = (LocaleConfig)i$.next();
            Locale locale = localeConfig.getLocale();
            String displayName = locale.getDisplayLanguage();
            listLanguage.add(displayName);
        }
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(ITEM_EMPTY, (Object)"categoryAndQuestion"));
        list.add(new SelectItemOption(ITEM_CATEGORY, (Object)ITEM_CATEGORY));
        list.add(new SelectItemOption(ITEM_QUESTION, (Object)ITEM_QUESTION));
        UIFormSelectBox searchType = new UIFormSelectBox(FIELD_SEARCHOBJECT_SELECTBOX, FIELD_SEARCHOBJECT_SELECTBOX, list);
        searchType.setOnChange("Onchange");
        UIFormStringInput categoryName = new UIFormStringInput(FIELD_CATEGORY_NAME, FIELD_CATEGORY_NAME, null);
        list = new ArrayList();
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_EMPTY2, (Object)"AllCategories"));
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_TRUE, (Object)ITEM_MODERATEQUESTION_TRUE));
        list.add(new SelectItemOption(ITEM_MODERATEQUESTION_FALSE, (Object)ITEM_MODERATEQUESTION_FALSE));
        UIFormSelectBox modeQuestion = new UIFormSelectBox(FIELD_ISMODERATEQUESTION, FIELD_ISMODERATEQUESTION, list);
        UIFormStringInput moderator = new UIFormStringInput(FIELD_CATEGORY_MODERATOR, FIELD_CATEGORY_MODERATOR, null);
        UIFormDateTimeInput fromDate = new UIFormDateTimeInput(FIELD_FROM_DATE, FIELD_FROM_DATE, null, false);
        UIFormDateTimeInput toDate = new UIFormDateTimeInput(FIELD_TO_DATE, FIELD_TO_DATE, null, false);
        UIFormStringInput author = new UIFormStringInput(FIELD_AUTHOR, FIELD_AUTHOR, null);
        UIFormStringInput emailAdress = new UIFormStringInput(FIELD_EMAIL_ADDRESS, FIELD_EMAIL_ADDRESS, null);
        list = new ArrayList();
        list.add(new SelectItemOption(this.defaultLanguage_, (Object)this.defaultLanguage_));
        for (String language : listLanguage) {
            if (language.equals(this.defaultLanguage_)) continue;
            list.add(new SelectItemOption(language, (Object)language));
        }
        UIFormSelectBox language = new UIFormSelectBox(FIELD_LANGUAGE, FIELD_LANGUAGE, list);
        UIFormTextAreaInput question = new UIFormTextAreaInput(FIELD_QUESTION, FIELD_QUESTION, null);
        UIFormTextAreaInput response = new UIFormTextAreaInput(FIELD_RESPONSE, FIELD_RESPONSE, null);
        UIFormTextAreaInput comment = new UIFormTextAreaInput(FIELD_COMMENT, FIELD_COMMENT, null);
        this.addUIFormInput((UIFormInput)text);
        this.addUIFormInput((UIFormInput)searchType);
        this.addUIFormInput((UIFormInput)categoryName);
        this.addUIFormInput((UIFormInput)modeQuestion);
        this.addUIFormInput((UIFormInput)moderator);
        this.addUIFormInput((UIFormInput)author);
        this.addUIFormInput((UIFormInput)emailAdress);
        this.addUIFormInput((UIFormInput)language);
        this.addUIFormInput((UIFormInput)question);
        this.addUIFormInput((UIFormInput)response);
        this.addUIFormInput((UIFormInput)comment);
        this.addUIFormInput((UIFormInput)fromDate);
        this.addUIFormInput((UIFormInput)toDate);
        this.setActions(new String[]{"Search", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Calendar getFromDate() {
        return this.getCalendar(this.getUIFormDateTimeInput(FIELD_FROM_DATE), FIELD_FROM_DATE);
    }

    public Calendar getToDate() {
        return this.getCalendar(this.getUIFormDateTimeInput(FIELD_TO_DATE), FIELD_TO_DATE);
    }

    public void setText(String value) {
        this.getUIStringInput(FIELD_TEXT).setValue((Object)value);
    }

    public String getText() {
        return (String)this.getUIStringInput(FIELD_TEXT).getValue();
    }

    public void setIsSearch(boolean isCategory, boolean isQuestion) {
        UIFormStringInput categoryName = (UIFormStringInput)this.getUIStringInput(FIELD_CATEGORY_NAME).setRendered(isCategory);
        UIFormSelectBox modeQuestion = (UIFormSelectBox)this.getUIFormSelectBox(FIELD_ISMODERATEQUESTION).setRendered(isCategory);
        UIFormStringInput moderator = (UIFormStringInput)this.getUIStringInput(FIELD_CATEGORY_MODERATOR).setRendered(isCategory);
        categoryName.setValue((Object)"");
        modeQuestion.setValue("");
        moderator.setValue((Object)"");
        UIFormStringInput author = (UIFormStringInput)this.getUIStringInput(FIELD_AUTHOR).setRendered(isQuestion);
        UIFormStringInput emailAddress = (UIFormStringInput)this.getUIStringInput(FIELD_EMAIL_ADDRESS).setRendered(isQuestion);
        UIFormSelectBox language = (UIFormSelectBox)this.getUIFormSelectBox(FIELD_LANGUAGE).setRendered(isQuestion);
        UIFormTextAreaInput question = (UIFormTextAreaInput)this.getUIFormTextAreaInput(FIELD_QUESTION).setRendered(isQuestion);
        UIFormTextAreaInput response = (UIFormTextAreaInput)this.getUIFormTextAreaInput(FIELD_RESPONSE).setRendered(isQuestion);
        UIFormTextAreaInput comment = (UIFormTextAreaInput)this.getUIFormTextAreaInput(FIELD_COMMENT).setRendered(isQuestion);
        author.setValue((Object)"");
        emailAddress.setValue((Object)"");
        language.setValue("");
        question.setValue((Object)"");
        response.setValue((Object)"");
        comment.setValue((Object)"");
    }

    private Calendar getCalendar(UIFormDateTimeInput dateTimeInput, String field) {
        Calendar calendar = dateTimeInput.getCalendar();
        if (!FAQUtils.isFieldEmpty((String)((String)dateTimeInput.getValue())) && calendar == null) {
            this.warning("UIAdvancedSearchForm.msg.error-input-text-date", "UIAdvancedSearchForm.label." + field);
        }
        return calendar;
    }

    static /* synthetic */ void access$000(UIAdvancedSearchForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$100(UIAdvancedSearchForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ String access$200(UIAdvancedSearchForm x0) {
        return x0.defaultLanguage_;
    }

    static /* synthetic */ FAQSetting access$300(UIAdvancedSearchForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$400(UIAdvancedSearchForm x0) {
        return x0.getFAQService();
    }
}

