/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersPageIterator;
import org.exoplatform.faq.webui.popup.UIUserWatchManager;
import org.exoplatform.faq.webui.popup.UIWatchManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormTabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIUserWatchManager.gtmpl", events={@EventConfig(listeners={LinkActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}, confirm="UIUserWatchManager.msg.confirm-unwatch-category"), @EventConfig(listeners={CancelActionListener.class})})
public class UIUserWatchManager
extends UIFormTabPane
implements UIPopupComponent {
    private FAQSetting faqSetting_ = null;
    protected UIAnswersPageIterator pageIteratorCate;
    protected JCRPageList pageListCate;
    private UIAnswersPageIterator pageIteratorQues;
    private UIAnswersPageIterator pageIteratorCates;
    private JCRPageList pageListQues;
    private JCRPageList pageListCates;
    private String LIST_QUESTIONS_WATCHED = "listQuestionsWatch";
    private String LIST_CATES_WATCHED = "listCatesWatch";
    private int tabSelect = 0;
    private String emailAddress;
    private static Log log = ExoLogger.getLogger(UIWatchManager.class);
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public UIUserWatchManager() throws Exception {
        super("UIUswerWatchManager");
        this.addChild(UIAnswersPageIterator.class, null, this.LIST_QUESTIONS_WATCHED);
        this.addChild(UIAnswersPageIterator.class, null, this.LIST_CATES_WATCHED);
        this.emailAddress = FAQUtils.getEmailUser(null);
        this.setActions(new String[]{"Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public int getTabSelect() {
        return this.tabSelect;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public List<Category> getListCategory() throws Exception {
        return this.getListCategoriesWatch();
    }

    public String getCategoriesName(String categoryId) throws Exception {
        return faqService_.getParentCategoriesName(categoryId);
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!FAQUtils.isFieldEmpty((String)str) && (l = str.length()) > max) {
            int comma = (str = str.substring(0, max - 3)).lastIndexOf(",");
            str = comma > 0 ? str.substring(0, comma) + "..." : str + "...";
        }
        return str;
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    private List<Category> getListCategoriesWatch() {
        try {
            if (this.pageListCates == null) {
                this.pageListCates = faqService_.getWatchedCategoryByUser(FAQUtils.getCurrentUser());
                this.pageListCates.setPageSize(5L);
                this.pageIteratorCates = (UIAnswersPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                this.pageIteratorCates.updatePageList(this.pageListCates);
            }
            long pageSelect = this.pageIteratorCates.getPageSelected();
            ArrayList<Category> listCategories = new ArrayList<Category>();
            listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(pageSelect, null));
            if (listCategories.isEmpty()) {
                UIAnswersPageIterator pageIterator = null;
                while (listCategories.isEmpty() && pageSelect > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                    listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(--pageSelect, null));
                    pageIterator.setSelectPage(pageSelect);
                }
            }
            return listCategories;
        }
        catch (Exception e) {
            log.error((Object)"Fail to get list of category watch: ", (Throwable)e);
            return null;
        }
    }

    protected List<Question> getListQuestionsWatch() {
        try {
            if (this.pageListQues == null) {
                this.pageListQues = faqService_.getListQuestionsWatch(this.faqSetting_, FAQUtils.getCurrentUser());
                this.pageListQues.setPageSize(5L);
                this.pageIteratorQues = (UIAnswersPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                this.pageIteratorQues.updatePageList(this.pageListQues);
            }
            long pageSelect = this.pageIteratorQues.getPageSelected();
            ArrayList<Question> listQuestion_ = new ArrayList<Question>();
            listQuestion_.addAll(this.pageListQues.getPage(pageSelect, null));
            if (listQuestion_.isEmpty()) {
                UIAnswersPageIterator pageIterator = null;
                while (listQuestion_.isEmpty() && pageSelect > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                    listQuestion_.addAll(this.pageListQues.getPage(--pageSelect, null));
                    pageIterator.setSelectPage(pageSelect);
                }
            }
            return listQuestion_;
        }
        catch (Exception e) {
            log.error((Object)("fail to get list of question watch: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected long getTotalpages(String pageInteratorId) {
        UIAnswersPageIterator pageIterator = (UIAnswersPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            log.debug((Object)"Getting total page fail: ", (Throwable)e);
            return 1L;
        }
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }
}

