/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.JCRForumAttachment;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumPageList
extends JCRPageList {
    private boolean isQuery_ = false;
    private String value_;
    private SessionProvider sProvider_;
    private NodeIterator iter_ = null;

    public ForumPageList(long pageSize, int size) {
        super(pageSize);
        this.setAvailablePage(size);
    }

    public ForumPageList(SessionProvider sProvider, NodeIterator iter, long pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.sProvider_ = sProvider;
        if (iter == null) {
            iter = this.setQuery(sProvider, this.isQuery_, this.value_);
        }
        if (iter != null) {
            this.iter_ = iter;
            this.setAvailablePage(iter.getSize());
        }
    }

    @Override
    protected void populateCurrentPage(long page) throws Exception {
        if (this.iter_ == null) {
            this.iter_ = this.setQuery(this.sProvider_, this.isQuery_, this.value_);
            this.setAvailablePage(this.iter_.getSize());
            this.checkAndSetPage(page);
            page = this.currentPage_;
        }
        long pageSize = 0L;
        if (page > 0L) {
            long position = 0L;
            pageSize = this.getPageSize();
            if (page == 1L) {
                position = 0L;
            } else {
                position = (page - 1L) * pageSize;
                this.iter_.skip(position);
            }
        } else {
            pageSize = this.iter_.getSize();
        }
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:post")) {
                this.currentListPage_.add(this.getPost(currentNode));
            } else if (currentNode.isNodeType("exo:topic")) {
                this.currentListPage_.add(this.getTopic(currentNode));
            } else if (currentNode.isNodeType("exo:userProfile")) {
                this.currentListPage_.add(this.getUserProfile(currentNode));
            } else if (currentNode.isNodeType("exo:privateMessage")) {
                this.currentListPage_.add(this.getPrivateMessage(currentNode));
            }
            ++i;
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPage(String valueString) throws Exception {
        NodeIterator nodeIterator = this.setQuery(this.sProvider_, this.isQuery_, this.value_);
        if (this.iter_ == null) {
            this.iter_ = this.setQuery(this.sProvider_, this.isQuery_, this.value_);
        }
        int pos = 0;
        int i = 0;
        while ((long)i < nodeIterator.getSize()) {
            if (this.getUserProfile(nodeIterator.nextNode()).getUserId().equals(valueString)) {
                pos = i + 1;
                break;
            }
            ++i;
        }
        long pageSize = this.getPageSize();
        long page = 1L;
        if ((long)pos < pageSize) {
            page = 1L;
        } else {
            page = (long)pos / pageSize;
            if ((long)pos % pageSize > 0L) {
                ++page;
            }
        }
        this.pageSelected = page;
        this.iter_.skip((page - 1L) * pageSize);
        this.currentListPage_ = new ArrayList();
        int i2 = 0;
        while ((long)i2 < pageSize && this.iter_.hasNext()) {
            this.currentListPage_.add(this.getUserProfile(this.iter_.nextNode()));
            ++i2;
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPageSearch(long page, List list) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < list.size(); ++i) {
            this.currentListPage_.add(list.get(i));
        }
    }

    @Override
    protected void populateCurrentPageList(long page, List<String> list) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < list.size(); ++i) {
            this.currentListPage_.add(list.get(i));
        }
    }

    private NodeIterator setQuery(SessionProvider sProvider, boolean isQuery, String value) throws Exception {
        NodeIterator iter;
        Session session = this.getJCRSession(sProvider);
        if (isQuery) {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(value, "xpath");
            QueryResult result = query.execute();
            iter = result.getNodes();
        } else {
            Node node = (Node)session.getItem(value);
            iter = node.getNodes();
        }
        return iter;
    }

    private Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        if (postNode.hasProperty("exo:owner")) {
            postNew.setOwner(postNode.getProperty("exo:owner").getString());
        }
        if (postNode.hasProperty("exo:createdDate")) {
            postNew.setCreatedDate(postNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:modifiedBy")) {
            postNew.setModifiedBy(postNode.getProperty("exo:modifiedBy").getString());
        }
        if (postNode.hasProperty("exo:modifiedDate")) {
            postNew.setModifiedDate(postNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:editReason")) {
            postNew.setEditReason(postNode.getProperty("exo:editReason").getString());
        }
        if (postNode.hasProperty("exo:name")) {
            postNew.setName(postNode.getProperty("exo:name").getString());
        }
        if (postNode.hasProperty("exo:message")) {
            postNew.setMessage(postNode.getProperty("exo:message").getString());
        }
        if (postNode.hasProperty("exo:remoteAddr")) {
            postNew.setRemoteAddr(postNode.getProperty("exo:remoteAddr").getString());
        }
        if (postNode.hasProperty("exo:icon")) {
            postNew.setIcon(postNode.getProperty("exo:icon").getString());
        }
        if (postNode.hasProperty("exo:link")) {
            postNew.setLink(postNode.getProperty("exo:link").getString());
        }
        if (postNode.hasProperty("exo:isApproved")) {
            postNew.setIsApproved(postNode.getProperty("exo:isApproved").getBoolean());
        }
        if (postNode.hasProperty("exo:isHidden")) {
            postNew.setIsHidden(postNode.getProperty("exo:isHidden").getBoolean());
        }
        if (postNode.hasProperty("exo:isActiveByTopic")) {
            postNew.setIsActiveByTopic(postNode.getProperty("exo:isActiveByTopic").getBoolean());
        }
        if (postNode.hasProperty("exo:userPrivate")) {
            postNew.setUserPrivate(this.ValuesToArray(postNode.getProperty("exo:userPrivate").getValues()));
        }
        if (postNode.hasProperty("exo:numberAttach")) {
            long numberAttach = postNode.getProperty("exo:numberAttach").getLong();
            postNew.setNumberAttach(numberAttach);
            if (numberAttach > 0L) {
                NodeIterator postAttachments = postNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("nt:file")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(node.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                postNew.setAttachments(attachments);
            }
        }
        return postNew;
    }

    private Topic getTopic(Node topicNode) throws Exception {
        Node FirstPostNode;
        String idFirstPost;
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setOwner(topicNode.getProperty("exo:owner").getString());
        topicNew.setTopicName(topicNode.getProperty("exo:name").getString());
        topicNew.setCreatedDate(topicNode.getProperty("exo:createdDate").getDate().getTime());
        if (topicNode.hasProperty("exo:modifiedBy")) {
            topicNew.setModifiedBy(topicNode.getProperty("exo:modifiedBy").getString());
        }
        if (topicNode.hasProperty("exo:modifiedDate")) {
            topicNew.setModifiedDate(topicNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        topicNew.setLastPostBy(topicNode.getProperty("exo:lastPostBy").getString());
        topicNew.setLastPostDate(topicNode.getProperty("exo:lastPostDate").getDate().getTime());
        topicNew.setDescription(topicNode.getProperty("exo:description").getString());
        topicNew.setPostCount(topicNode.getProperty("exo:postCount").getLong());
        topicNew.setViewCount(topicNode.getProperty("exo:viewCount").getLong());
        if (topicNode.hasProperty("exo:numberAttachments")) {
            topicNew.setNumberAttachment(topicNode.getProperty("exo:numberAttachments").getLong());
        }
        topicNew.setIcon(topicNode.getProperty("exo:icon").getString());
        topicNew.setLink(topicNode.getProperty("exo:link").getString());
        topicNew.setIsNotifyWhenAddPost(topicNode.getProperty("exo:isNotifyWhenAddPost").getString());
        topicNew.setIsModeratePost(topicNode.getProperty("exo:isModeratePost").getBoolean());
        topicNew.setIsClosed(topicNode.getProperty("exo:isClosed").getBoolean());
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsApproved(topicNode.getProperty("exo:isApproved").getBoolean());
        topicNew.setIsSticky(topicNode.getProperty("exo:isSticky").getBoolean());
        topicNew.setIsWaiting(topicNode.getProperty("exo:isWaiting").getBoolean());
        topicNew.setIsActive(topicNode.getProperty("exo:isActive").getBoolean());
        topicNew.setIsActiveByForum(topicNode.getProperty("exo:isActiveByForum").getBoolean());
        topicNew.setCanView(this.ValuesToArray(topicNode.getProperty("exo:canView").getValues()));
        topicNew.setCanPost(this.ValuesToArray(topicNode.getProperty("exo:canPost").getValues()));
        if (topicNode.hasProperty("exo:isPoll")) {
            topicNew.setIsPoll(topicNode.getProperty("exo:isPoll").getBoolean());
        }
        if (topicNode.hasProperty("exo:userVoteRating")) {
            topicNew.setUserVoteRating(this.ValuesToArray(topicNode.getProperty("exo:userVoteRating").getValues()));
        }
        if (topicNode.hasProperty("exo:tagId")) {
            topicNew.setTagId(this.ValuesToArray(topicNode.getProperty("exo:tagId").getValues()));
        }
        if (topicNode.hasProperty("exo:voteRating")) {
            topicNew.setVoteRating(topicNode.getProperty("exo:voteRating").getDouble());
        }
        if (topicNode.isNodeType("exo:forumWatching")) {
            topicNew.setEmailNotification(this.ValuesToArray(topicNode.getProperty("exo:emailWatching").getValues()));
        }
        if (topicNode.hasNode(idFirstPost = topicNode.getName().replaceFirst("topic", "post")) && (FirstPostNode = topicNode.getNode(idFirstPost)).hasProperty("exo:numberAttachments") && FirstPostNode.getProperty("exo:numberAttachments").getLong() > 0L) {
            NodeIterator postAttachments = FirstPostNode.getNodes();
            ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
            while (postAttachments.hasNext()) {
                Node node = postAttachments.nextNode();
                if (!node.isNodeType("nt:file")) continue;
                JCRForumAttachment attachment = new JCRForumAttachment();
                Node nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getName());
                attachment.setPathNode(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setName(node.getProperty("exo:fileName").getString());
                String workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                attachment.setPath("/" + workspace + node.getPath());
                attachments.add(attachment);
            }
            topicNew.setAttachments(attachments);
        }
        return topicNew;
    }

    private UserProfile getUserProfile(Node userProfileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userProfileNode.getName());
        userProfile.setUserTitle(userProfileNode.getProperty("exo:userTitle").getString());
        userProfile.setFullName(userProfileNode.getProperty("exo:fullName").getString());
        userProfile.setFirstName(userProfileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(userProfileNode.getProperty("exo:lastName").getString());
        userProfile.setEmail(userProfileNode.getProperty("exo:email").getString());
        userProfile.setUserRole(userProfileNode.getProperty("exo:userRole").getLong());
        userProfile.setSignature(userProfileNode.getProperty("exo:signature").getString());
        userProfile.setTotalPost(userProfileNode.getProperty("exo:totalPost").getLong());
        userProfile.setTotalTopic(userProfileNode.getProperty("exo:totalTopic").getLong());
        userProfile.setModerateForums(this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues()));
        if (userProfileNode.hasProperty("exo:lastLoginDate")) {
            userProfile.setLastLoginDate(userProfileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:joinedDate")) {
            userProfile.setJoinedDate(userProfileNode.getProperty("exo:joinedDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:lastPostDate")) {
            userProfile.setLastPostDate(userProfileNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        userProfile.setIsDisplaySignature(userProfileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(userProfileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setNewMessage(userProfileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(userProfileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(userProfileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(userProfileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(userProfileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(userProfileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(userProfileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(userProfileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsBanned(userProfileNode.getProperty("exo:isBanned").getBoolean());
        if (userProfileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(userProfileNode.getProperty("exo:banUntil").getLong());
        }
        if (userProfileNode.hasProperty("exo:banReason")) {
            userProfile.setBanReason(userProfileNode.getProperty("exo:banReason").getString());
        }
        if (userProfileNode.hasProperty("exo:banCounter")) {
            userProfile.setBanCounter(Integer.parseInt(userProfileNode.getProperty("exo:banCounter").getString()));
        }
        if (userProfileNode.hasProperty("exo:banReasonSummary")) {
            userProfile.setBanReasonSummary(this.ValuesToArray(userProfileNode.getProperty("exo:banReasonSummary").getValues()));
        }
        if (userProfileNode.hasProperty("exo:createdDateBan")) {
            userProfile.setCreatedDateBan(userProfileNode.getProperty("exo:createdDateBan").getDate().getTime());
        }
        return userProfile;
    }

    private ForumPrivateMessage getPrivateMessage(Node messageNode) throws Exception {
        ForumPrivateMessage message = new ForumPrivateMessage();
        message.setId(messageNode.getName());
        message.setFrom(messageNode.getProperty("exo:from").getString());
        message.setSendTo(messageNode.getProperty("exo:sendTo").getString());
        message.setName(messageNode.getProperty("exo:name").getString());
        message.setMessage(messageNode.getProperty("exo:message").getString());
        message.setReceivedDate(messageNode.getProperty("exo:receivedDate").getDate().getTime());
        message.setIsUnread(messageNode.getProperty("exo:isUnread").getBoolean());
        message.setType(messageNode.getProperty("exo:type").getString());
        return message;
    }

    private String[] ValuesToArray(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private Session getJCRSession(SessionProvider sProvider) throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
        return sProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
    }
}

