/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeactiveJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            Object obj = exoContainer.getComponentInstanceOfType(ForumService.class);
            if (obj != null) {
                int days;
                ForumService forumService = (ForumService)obj;
                JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
                String inactiveDays = jdatamap.getString("inactiveDays");
                String forumName = jdatamap.getString("forumName");
                if (inactiveDays != null && inactiveDays.length() > 0 && (days = Integer.parseInt(inactiveDays)) > 0) {
                    long oneDay = 86400000L;
                    Calendar calendar = GregorianCalendar.getInstance();
                    long currentDay = calendar.getTimeInMillis();
                    calendar.setTimeInMillis(currentDay -= (long)days * oneDay);
                    SessionProvider sysProvider = SessionProvider.createSystemProvider();
                    String path = forumService.getForumHomePath(sysProvider);
                    StringBuilder stringBuffer = new StringBuilder();
                    stringBuffer.append("/jcr:root").append(path).append("//element(*,exo:topic)[");
                    stringBuffer.append("@exo:lastPostDate <= xs:dateTime('" + ISO8601.format((Calendar)calendar) + "') and @exo:isActive = 'true']");
                    NodeIterator iter = forumService.search(stringBuffer.toString(), sysProvider);
                    while (iter.hasNext()) {
                        Node topic = iter.nextNode();
                        if (forumName != null && forumName.length() > 0) {
                            if (forumName.equals(topic.getParent().getProperty("exo:name").getString())) {
                                topic.setProperty("exo:isActive", false);
                                topic.save();
                            }
                        } else {
                            topic.setProperty("exo:isActive", false);
                            topic.save();
                        }
                        if (!log_.isDebugEnabled()) continue;
                        log_.debug((Object)("\n\n The DeactiveJob have been running: The topic '" + topic.getProperty("exo:name").getString() + "' deactived"));
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

