/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RecountActiveUserJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            Object obj = exoContainer.getComponentInstanceOfType(ForumService.class);
            if (obj != null) {
                int days;
                ForumService forumService = (ForumService)obj;
                JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
                String lastPost = jdatamap.getString("lastPost");
                if (lastPost != null && lastPost.length() > 0 && (days = Integer.parseInt(lastPost)) > 0) {
                    long oneDay = 86400000L;
                    Calendar calendar = GregorianCalendar.getInstance();
                    long currentDay = calendar.getTimeInMillis();
                    calendar.setTimeInMillis(currentDay -= (long)days * oneDay);
                    SessionProvider sysProvider = SessionProvider.createSystemProvider();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
                    forumService.evaluateActiveUsers(sysProvider, stringBuilder.toString());
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)"\n\n The RecoundActiveUserJob have been done");
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

