/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.EmailNotifyPlugin;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.JCRForumAttachment;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.CategoryData;
import org.exoplatform.forum.service.conf.CategoryEventListener;
import org.exoplatform.forum.service.conf.ForumData;
import org.exoplatform.forum.service.conf.InitializeForumPlugin;
import org.exoplatform.forum.service.conf.PostData;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.conf.StatisticEventListener;
import org.exoplatform.forum.service.conf.TopicData;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.quartz.JobDataMap;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final String KS_USER_AVATAR = "ksUserAvatar".intern();
    private Map<String, String> serverConfig_ = new HashMap<String, String>();
    private Map<String, SendMessageInfo> messagesInfoMap_ = new HashMap<String, SendMessageInfo>();
    private List<RoleRulesPlugin> rulesPlugins_ = new ArrayList<RoleRulesPlugin>();
    private List<InitializeForumPlugin> defaultPlugins_ = new ArrayList<InitializeForumPlugin>();
    protected Map<String, EventListener> listeners_ = new HashMap<String, EventListener>();

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public JCRDataStorage() {
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            if (plugin instanceof EmailNotifyPlugin) {
                this.serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof RoleRulesPlugin) {
            this.rulesPlugins_.add((RoleRulesPlugin)plugin);
        }
    }

    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitializeForumPlugin) {
            this.defaultPlugins_.add((InitializeForumPlugin)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCategoryListener() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        this.listeners_.clear();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            ObservationManager observation = forumHome.getSession().getWorkspace().getObservationManager();
            String wsName = forumHome.getSession().getWorkspace().getName();
            String repoName = ((RepositoryImpl)forumHome.getSession().getRepository()).getName();
            if (!this.listeners_.containsKey(forumHome.getPath())) {
                CategoryEventListener categoryListener = new CategoryEventListener(wsName, repoName);
                observation.addEventListener((EventListener)categoryListener, 3, forumHome.getPath(), false, null, null, false);
                this.listeners_.put(forumHome.getPath(), categoryListener);
            }
            NodeIterator iter = forumHome.getNodes();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                if (!catNode.isNodeType("exo:forumCategory") || this.listeners_.containsKey(catNode.getPath())) continue;
                StatisticEventListener sListener = new StatisticEventListener(wsName, repoName);
                observation.addEventListener((EventListener)sListener, 3, catNode.getPath(), true, null, null, false);
                this.listeners_.put(catNode.getPath(), sListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    public boolean isAdminRole(String userName) throws Exception {
        try {
            String[] strings = new String[]{};
            for (int i = 0; i < this.rulesPlugins_.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(this.rulesPlugins_.get(i).getRules(Utils.ADMIN_ROLE));
                if (list.contains(userName)) {
                    return true;
                }
                strings = JCRDataStorage.getStringsInList(list);
                if (!ForumServiceUtils.hasPermission(strings, userName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        Node appNode = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return appNode.getNode(Utils.FORUM_SERVICE);
        }
        catch (PathNotFoundException e) {
            Node forumHomeNode = appNode.addNode(Utils.FORUM_SERVICE, "exo:forumHome");
            return forumHomeNode;
        }
    }

    private Node getKSUserAvatarHomeNode(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode(KS_USER_AVATAR);
        }
        catch (PathNotFoundException ex) {
            Node faqHome = userApp.addNode(KS_USER_AVATAR, "nt:unstructured");
            userApp.getSession().save();
            return faqHome;
        }
    }

    private Node getForumBanNode(SessionProvider sProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            return forumHomeNode.getNode(Utils.FORUM_BAN_IP);
        }
        catch (PathNotFoundException e) {
            forumHomeNode.addNode(Utils.FORUM_BAN_IP, "exo:banIP");
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
            return forumHomeNode.getNode(Utils.FORUM_BAN_IP);
        }
    }

    public Node getUserProfileHome(SessionProvider sProvider) throws Exception {
        Node userAdministration;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            userAdministration = forumHomeNode.getNode(Utils.USER_PROFILE_HOME);
        }
        catch (PathNotFoundException e) {
            userAdministration = forumHomeNode.addNode(Utils.USER_PROFILE_HOME, "exo:userProfileHome");
        }
        try {
            return userAdministration.getNode(Utils.USER_PROFILES);
        }
        catch (PathNotFoundException e) {
            return userAdministration.addNode(Utils.USER_PROFILES, "exo:userProfiles");
        }
    }

    public void setDefaultAvatar(String userName, SessionProvider sessionProvider) throws Exception {
        Node node;
        Node ksAvatarHomnode = this.getKSUserAvatarHomeNode(sessionProvider);
        if (ksAvatarHomnode.hasNode(userName) && (node = ksAvatarHomnode.getNode(userName)).isNodeType("nt:file")) {
            node.remove();
            ksAvatarHomnode.save();
        }
    }

    public ForumAttachment getUserAvatar(String userName, SessionProvider sessionProvider) throws Exception {
        Node ksAvatarHomnode = this.getKSUserAvatarHomeNode(sessionProvider);
        ArrayList<JCRForumAttachment> attachments = new ArrayList<JCRForumAttachment>();
        if (ksAvatarHomnode.hasNode(userName)) {
            Node node = ksAvatarHomnode.getNode(userName);
            Node nodeFile = null;
            String workspace = "";
            if (node.isNodeType("nt:file")) {
                JCRForumAttachment attachment = new JCRForumAttachment();
                nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getName());
                attachment.setPathNode(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setName("avatar." + attachment.getMimeType());
                workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setPath("/" + workspace + node.getPath());
                try {
                    if (nodeFile.hasProperty("jcr:data")) {
                        attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    } else {
                        attachment.setSize(0L);
                    }
                    attachments.add(attachment);
                    return (ForumAttachment)attachments.get(0);
                }
                catch (Exception e) {
                    attachment.setSize(0L);
                    e.printStackTrace();
                }
            }
            return null;
        }
        return null;
    }

    public void saveUserAvatar(String userId, ForumAttachment fileAttachment, SessionProvider sessionProvider) throws Exception {
        Node ksAvatarHomnode = this.getKSUserAvatarHomeNode(sessionProvider);
        Node avatarNode = null;
        avatarNode = ksAvatarHomnode.hasNode(userId) ? ksAvatarHomnode.getNode(userId) : ksAvatarHomnode.addNode(userId, "nt:file");
        try {
            ForumServiceUtils.reparePermissions(avatarNode, "any");
            Node nodeContent = null;
            nodeContent = avatarNode.hasNode("jcr:content") ? avatarNode.getNode("jcr:content") : avatarNode.addNode("jcr:content", "nt:resource");
            nodeContent.setProperty("jcr:mimeType", fileAttachment.getMimeType());
            nodeContent.setProperty("jcr:data", fileAttachment.getInputStream());
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (avatarNode.isNew()) {
            ksAvatarHomnode.getSession().save();
        } else {
            ksAvatarHomnode.save();
        }
    }

    public void saveForumAdministration(SessionProvider sProvider, ForumAdministration forumAdministration) throws Exception {
        Node forumAdminNode;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            forumAdminNode = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
        }
        catch (PathNotFoundException e) {
            forumAdminNode = forumHomeNode.addNode(Utils.FORUMADMINISTRATION, "exo:administration");
        }
        forumAdminNode.setProperty("exo:forumSortBy", forumAdministration.getForumSortBy());
        forumAdminNode.setProperty("exo:forumSortByType", forumAdministration.getForumSortByType());
        forumAdminNode.setProperty("exo:topicSortBy", forumAdministration.getTopicSortBy());
        forumAdminNode.setProperty("exo:topicSortByType", forumAdministration.getTopicSortByType());
        forumAdminNode.setProperty("exo:censoredKeyword", forumAdministration.getCensoredKeyword());
        forumAdminNode.setProperty("exo:enableHeaderSubject", forumAdministration.getEnableHeaderSubject());
        forumAdminNode.setProperty("exo:headerSubject", forumAdministration.getHeaderSubject());
        forumAdminNode.setProperty("exo:notifyEmailContent", forumAdministration.getNotifyEmailContent());
        if (forumAdminNode.isNew()) {
            forumAdminNode.getSession().save();
        } else {
            forumAdminNode.save();
        }
    }

    public ForumAdministration getForumAdministration(SessionProvider sProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ForumAdministration forumAdministration = new ForumAdministration();
        try {
            Node forumAdminNode = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
            if (forumAdminNode.hasProperty("exo:forumSortBy")) {
                forumAdministration.setForumSortBy(forumAdminNode.getProperty("exo:forumSortBy").getString());
            }
            if (forumAdminNode.hasProperty("exo:forumSortByType")) {
                forumAdministration.setForumSortByType(forumAdminNode.getProperty("exo:forumSortByType").getString());
            }
            if (forumAdminNode.hasProperty("exo:topicSortBy")) {
                forumAdministration.setTopicSortBy(forumAdminNode.getProperty("exo:topicSortBy").getString());
            }
            if (forumAdminNode.hasProperty("exo:topicSortByType")) {
                forumAdministration.setTopicSortByType(forumAdminNode.getProperty("exo:topicSortByType").getString());
            }
            if (forumAdminNode.hasProperty("exo:censoredKeyword")) {
                forumAdministration.setCensoredKeyword(forumAdminNode.getProperty("exo:censoredKeyword").getString());
            }
            if (forumAdminNode.hasProperty("exo:enableHeaderSubject")) {
                forumAdministration.setEnableHeaderSubject(forumAdminNode.getProperty("exo:enableHeaderSubject").getBoolean());
            }
            if (forumAdminNode.hasProperty("exo:headerSubject")) {
                forumAdministration.setHeaderSubject(forumAdminNode.getProperty("exo:headerSubject").getString());
            }
            if (forumAdminNode.hasProperty("exo:notifyEmailContent")) {
                forumAdministration.setNotifyEmailContent(forumAdminNode.getProperty("exo:notifyEmailContent").getString());
            }
            return forumAdministration;
        }
        catch (PathNotFoundException e) {
            return forumAdministration;
        }
    }

    public void initDefaultData() throws Exception {
        SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            for (InitializeForumPlugin pln : this.defaultPlugins_) {
                List<CategoryData> categories = pln.getForumInitialData().getCategories();
                for (CategoryData categoryData : categories) {
                    String categoryId = "";
                    NodeIterator iter = forumHomeNode.getNodes();
                    boolean isAdd = true;
                    while (iter.hasNext()) {
                        if (!iter.nextNode().isNodeType("exo:forumCategory")) continue;
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    Category category = new Category();
                    category.setCategoryName(categoryData.getName());
                    category.setDescription(categoryData.getDescription());
                    category.setOwner(categoryData.getOwner());
                    this.saveCategory(sProvider, category, true);
                    categoryId = category.getId();
                    List<ForumData> forums = categoryData.getForums();
                    String forumId = "";
                    for (ForumData forumData : forums) {
                        Forum forum = new Forum();
                        forum.setForumName(forumData.getName());
                        forum.setDescription(forumData.getDescription());
                        forum.setOwner(forumData.getOwner());
                        this.saveForum(sProvider, categoryId, forum, true);
                        forumId = forum.getId();
                    }
                    ForumData forum = forums.get(0);
                    List<TopicData> topics = forum.getTopics();
                    String topicId = "";
                    String ct = "";
                    for (TopicData topicData : topics) {
                        Topic topic = new Topic();
                        topic.setTopicName(topicData.getName());
                        ct = topicData.getContent();
                        ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                        ct = Utils.removeCharterStrange(ct);
                        topic.setDescription(ct);
                        topic.setOwner(topicData.getOwner());
                        topic.setIcon(topicData.getIcon());
                        this.saveTopic(sProvider, categoryId, forumId, topic, true, false, "");
                        topicId = topic.getId();
                    }
                    TopicData topic = topics.get(0);
                    List<PostData> posts = topic.getPosts();
                    for (PostData postData : posts) {
                        Post post = new Post();
                        post.setName(postData.getName());
                        ct = postData.getContent();
                        ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                        ct = Utils.removeCharterStrange(ct);
                        post.setMessage(ct);
                        post.setOwner(postData.getOwner());
                        post.setIcon(postData.getIcon());
                        this.savePost(sProvider, categoryId, forumId, topicId, post, true, "");
                    }
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    public List<Category> getCategories(SessionProvider sProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + forumHomeNode.getPath() + "/element(*,exo:forumCategory) order by @exo:categoryOrder ascending, @exo:createdDate ascending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<Category> categories = new ArrayList<Category>();
        while (iter.hasNext()) {
            Node cateNode = iter.nextNode();
            categories.add(this.getCategory(cateNode));
        }
        return categories;
    }

    public Category getCategory(SessionProvider sProvider, String categoryId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node cateNode = forumHomeNode.getNode(categoryId);
            return this.getCategory(cateNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Category getCategory(Node cateNode) throws Exception {
        Category cat = new Category();
        cat.setId(cateNode.getName());
        cat.setPath(cateNode.getPath());
        if (cateNode.hasProperty("exo:owner")) {
            cat.setOwner(cateNode.getProperty("exo:owner").getString());
        }
        if (cateNode.hasProperty("exo:name")) {
            cat.setCategoryName(cateNode.getProperty("exo:name").getString());
        }
        if (cateNode.hasProperty("exo:categoryOrder")) {
            cat.setCategoryOrder(cateNode.getProperty("exo:categoryOrder").getLong());
        }
        if (cateNode.hasProperty("exo:createdDate")) {
            cat.setCreatedDate(cateNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (cateNode.hasProperty("exo:description")) {
            cat.setDescription(cateNode.getProperty("exo:description").getString());
        }
        if (cateNode.hasProperty("exo:modifiedBy")) {
            cat.setModifiedBy(cateNode.getProperty("exo:modifiedBy").getString());
        }
        if (cateNode.hasProperty("exo:modifiedDate")) {
            cat.setModifiedDate(cateNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (cateNode.hasProperty("exo:userPrivate")) {
            cat.setUserPrivate(this.ValuesToArray(cateNode.getProperty("exo:userPrivate").getValues()));
        }
        if (cateNode.hasProperty("exo:forumCount")) {
            cat.setForumCount(cateNode.getProperty("exo:forumCount").getLong());
        }
        if (cateNode.isNodeType("exo:forumWatching")) {
            cat.setEmailNotification(this.ValuesToArray(cateNode.getProperty("exo:emailWatching").getValues()));
        }
        return cat;
    }

    public void saveCategory(SessionProvider sProvider, Category category, boolean isNew) throws Exception {
        Node catNode;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        if (isNew) {
            catNode = forumHomeNode.addNode(category.getId(), "exo:forumCategory");
            catNode.setProperty("exo:id", category.getId());
            catNode.setProperty("exo:owner", category.getOwner());
            catNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
        } else {
            catNode = forumHomeNode.getNode(category.getId());
        }
        catNode.setProperty("exo:name", category.getCategoryName());
        catNode.setProperty("exo:categoryOrder", category.getCategoryOrder());
        catNode.setProperty("exo:description", category.getDescription());
        catNode.setProperty("exo:modifiedBy", category.getModifiedBy());
        catNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
        catNode.setProperty("exo:userPrivate", category.getUserPrivate());
        if (catNode.isNew()) {
            catNode.getSession().save();
        } else {
            catNode.save();
        }
    }

    public void registerListenerForCategory(SessionProvider sessionProvider, String path) throws Exception {
        String id;
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        Node catNode = forumHomeNode.getNode(id = path.substring(path.lastIndexOf("/") + 1));
        if (catNode.isNodeType("exo:forumCategory") && !this.listeners_.containsKey(catNode.getPath())) {
            String wsName = catNode.getSession().getWorkspace().getName();
            RepositoryImpl repo = (RepositoryImpl)catNode.getSession().getRepository();
            ObservationManager observation = catNode.getSession().getWorkspace().getObservationManager();
            StatisticEventListener statisticEventListener = new StatisticEventListener(wsName, repo.getName());
            observation.addEventListener((EventListener)statisticEventListener, 3, catNode.getPath(), true, null, null, false);
            this.listeners_.put(catNode.getPath(), statisticEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterListenerForCategory(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            if (this.listeners_.containsKey(path)) {
                ObservationManager obserManager = this.getForumHomeNode(sProvider).getSession().getWorkspace().getObservationManager();
                obserManager.removeEventListener((EventListener)((StatisticEventListener)this.listeners_.get(path)));
                this.listeners_.remove(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    public Category removeCategory(SessionProvider sProvider, String categoryId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node categoryNode = forumHomeNode.getNode(categoryId);
            Category category = this.getCategory(categoryNode);
            try {
                categoryNode.remove();
                forumHomeNode.getSession().save();
            }
            catch (Exception e) {
                // empty catch block
            }
            return category;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public List<Forum> getForums(SessionProvider sProvider, String categoryId, String strQuery) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            ForumAdministration administration = this.getForumAdministration(sProvider);
            String orderBy = administration.getForumSortBy();
            String orderType = administration.getForumSortByType();
            Node catNode = forumHomeNode.getNode(categoryId);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(catNode.getPath()).append("/element(*,exo:forum)");
            if (strQuery != null && strQuery.trim().length() > 0) {
                queryBuffer.append("[").append(strQuery).append("]");
            }
            queryBuffer.append("order by @exo:").append(orderBy).append(" ").append(orderType);
            if (!orderBy.equals("forumOrder")) {
                queryBuffer.append(",@exo:forumOrder ascending");
                if (!orderBy.equals("createdDate")) {
                    queryBuffer.append(",@exo:createdDate ascending");
                }
            } else {
                queryBuffer.append(",@exo:createdDate ascending");
            }
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<Forum> forums = new ArrayList<Forum>();
            while (iter.hasNext()) {
                Node forumNode = iter.nextNode();
                forums.add(this.getForum(forumNode));
            }
            return forums;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public Forum getForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node catNode = forumHomeNode.getNode(categoryId);
            Node forumNode = catNode.getNode(forumId);
            Forum forum = new Forum();
            forum = this.getForum(forumNode);
            return forum;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void modifyForum(SessionProvider sProvider, Forum forum, int type) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            String forumPath = forum.getPath();
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            switch (type) {
                case 1: {
                    forumNode.setProperty("exo:isClosed", forum.getIsClosed());
                    this.setActiveTopicByForum(sProvider, forumNode, forum.getIsClosed());
                    break;
                }
                case 2: {
                    forumNode.setProperty("exo:isLock", forum.getIsLock());
                    break;
                }
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void saveForum(SessionProvider sProvider, String categoryId, Forum forum, boolean isNew) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node forumNode;
            boolean isNewModerateTopic;
            Node catNode = forumHomeNode.getNode(categoryId);
            boolean isModerateTopic = isNewModerateTopic = forum.getIsModerateTopic();
            if (isNew) {
                forumNode = catNode.addNode(forum.getId(), "exo:forum");
                forumNode.setProperty("exo:id", forum.getId());
                forumNode.setProperty("exo:owner", forum.getOwner());
                forumNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                forumNode.setProperty("exo:lastTopicPath", forum.getLastTopicPath());
                forumNode.setProperty("exo:postCount", 0L);
                forumNode.setProperty("exo:topicCount", 0L);
                forumNode.setProperty("exo:banIPs", new String[0]);
                long forumCount = 1L;
                if (catNode.hasProperty("exo:forumCount")) {
                    forumCount = catNode.getProperty("exo:forumCount").getLong() + 1L;
                }
                catNode.setProperty("exo:forumCount", forumCount);
            } else {
                forumNode = catNode.getNode(forum.getId());
                if (forumNode.hasProperty("exo:isModerateTopic")) {
                    isModerateTopic = forumNode.getProperty("exo:isModerateTopic").getBoolean();
                }
            }
            forumNode.setProperty("exo:name", forum.getForumName());
            forumNode.setProperty("exo:forumOrder", (long)forum.getForumOrder());
            forumNode.setProperty("exo:modifiedBy", forum.getModifiedBy());
            forumNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            forumNode.setProperty("exo:description", forum.getDescription());
            forumNode.setProperty("exo:isAutoAddEmailNotify", forum.getIsAutoAddEmailNotify());
            forumNode.setProperty("exo:notifyWhenAddPost", forum.getNotifyWhenAddPost());
            forumNode.setProperty("exo:notifyWhenAddTopic", forum.getNotifyWhenAddTopic());
            forumNode.setProperty("exo:isModerateTopic", isNewModerateTopic);
            forumNode.setProperty("exo:isModeratePost", forum.getIsModeratePost());
            forumNode.setProperty("exo:isClosed", forum.getIsClosed());
            forumNode.setProperty("exo:isLock", forum.getIsLock());
            forumNode.setProperty("exo:viewer", forum.getViewer());
            forumNode.setProperty("exo:createTopicRole", forum.getCreateTopicRole());
            forumNode.setProperty("exo:poster", forum.getPoster());
            String[] oldModeratoForums = new String[]{};
            if (!isNew) {
                oldModeratoForums = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
            }
            String[] strModerators = forum.getModerators();
            forumNode.setProperty("exo:moderators", strModerators);
            if (strModerators != null && strModerators.length > 0 && !strModerators[0].equals(" ") && catNode.hasProperty("exo:userPrivate")) {
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(this.ValuesToList(catNode.getProperty("exo:userPrivate").getValues()));
                if (listPrivate.size() > 0 && !((String)listPrivate.get(0)).equals(" ")) {
                    for (int i = 0; i < strModerators.length; ++i) {
                        if (listPrivate.contains(strModerators[i])) continue;
                        listPrivate.add(strModerators[i]);
                    }
                    catNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[0]));
                }
            }
            if (catNode.isNew()) {
                catNode.getSession().save();
            } else {
                catNode.save();
            }
            if (isModerateTopic != isNewModerateTopic) {
                this.queryLastTopic(sProvider, forumNode.getPath());
            }
            Node userProfileHomeNode = this.getUserProfileHome(sProvider);
            ArrayList<String> list = new ArrayList<String>();
            List<String> moderators = ForumServiceUtils.getUserPermission(strModerators);
            if (moderators.size() > 0) {
                for (String string : moderators) {
                    Node userProfileNode;
                    string = string.trim();
                    list = new ArrayList();
                    try {
                        userProfileNode = userProfileHomeNode.getNode(string);
                        String[] moderatorForums = this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues());
                        boolean hasMod = false;
                        for (String string2 : moderatorForums) {
                            if (string2.indexOf(forum.getId()) > 0) {
                                hasMod = true;
                            }
                            list.add(string2);
                        }
                        if (hasMod) continue;
                        list.add(forum.getForumName() + "(" + categoryId + "/" + forum.getId());
                        userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(list));
                        if (!userProfileNode.hasProperty("exo:userRole") || userProfileNode.getProperty("exo:userRole").getLong() < 2L) continue;
                        userProfileNode.setProperty("exo:userRole", 1L);
                        userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    }
                    catch (PathNotFoundException e) {
                        userProfileNode = userProfileHomeNode.addNode(string, Utils.USER_PROFILES_TYPE);
                        String[] strings = new String[]{forum.getForumName() + "(" + categoryId + "/" + forum.getId()};
                        userProfileNode.setProperty("exo:moderateForums", strings);
                        userProfileNode.setProperty("exo:userRole", 1L);
                        userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                        if (userProfileNode.isNew()) {
                            userProfileNode.getSession().save();
                            continue;
                        }
                        userProfileNode.save();
                    }
                }
            }
            if (!isNew) {
                List<String> oldmoderators = ForumServiceUtils.getUserPermission(oldModeratoForums);
                for (String string : oldmoderators) {
                    boolean isDelete = true;
                    if (moderators.contains(string)) {
                        isDelete = false;
                    }
                    if (!isDelete) continue;
                    try {
                        String[] moderatorForums;
                        list = new ArrayList();
                        Node userProfileNode = userProfileHomeNode.getNode(string);
                        for (String string2 : moderatorForums = this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues())) {
                            if (string2.indexOf(forum.getId()) >= 0) continue;
                            list.add(string2);
                        }
                        userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(list));
                        if (list.size() > 0) continue;
                        if (userProfileNode.hasProperty("exo:userRole")) {
                            long role = userProfileNode.getProperty("exo:userRole").getLong();
                            if (role != 1L) continue;
                            userProfileNode.setProperty("exo:userRole", 2L);
                            continue;
                        }
                        userProfileNode.setProperty("exo:userRole", 2L);
                    }
                    catch (PathNotFoundException e) {}
                }
            }
            if (userProfileHomeNode.isNew()) {
                userProfileHomeNode.getSession().save();
            } else {
                userProfileHomeNode.save();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    public void saveModerateOfForums(SessionProvider sProvider, List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        for (String path : forumPaths) {
            String forumPath = forumHomeNode.getPath() + "/" + path;
            try {
                List<String> list;
                String[] oldUserNamesModerate;
                Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
                if (isDelete) {
                    if (!forumNode.hasProperty("exo:moderators")) continue;
                    oldUserNamesModerate = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
                    list = new ArrayList();
                    for (String string : oldUserNamesModerate) {
                        if (string.equals(userName)) continue;
                        list.add(string);
                    }
                    forumNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                    continue;
                }
                oldUserNamesModerate = new String[]{};
                if (forumNode.hasProperty("exo:moderators")) {
                    oldUserNamesModerate = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
                }
                list = new ArrayList<String>();
                for (String string : oldUserNamesModerate) {
                    if (string.equals(userName)) continue;
                    list.add(string);
                }
                list.add(userName);
                forumNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                Node parentNode = forumNode.getParent();
                if (!parentNode.hasProperty("exo:userPrivate") || (list = this.ValuesToList(parentNode.getProperty("exo:userPrivate").getValues())).get(0).equals(" ") || list.contains(userName)) continue;
                String[] strings = new String[list.size() + 1];
                int i = 0;
                Iterator<String> i$ = list.iterator();
                while (i$.hasNext()) {
                    String string;
                    strings[i] = string = i$.next();
                    ++i;
                }
                strings[i] = userName;
                parentNode.setProperty("exo:userPrivate", strings);
            }
            catch (PathNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    private Forum getForum(Node forumNode) throws Exception {
        Forum forum = new Forum();
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setOwner(forumNode.getProperty("exo:owner").getString());
        forum.setForumName(forumNode.getProperty("exo:name").getString());
        forum.setForumOrder(Integer.valueOf(forumNode.getProperty("exo:forumOrder").getString()));
        forum.setCreatedDate(forumNode.getProperty("exo:createdDate").getDate().getTime());
        if (forumNode.hasProperty("exo:modifiedBy")) {
            forum.setModifiedBy(forumNode.getProperty("exo:modifiedBy").getString());
        }
        if (forumNode.hasProperty("exo:modifiedDate")) {
            forum.setModifiedDate(forumNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        String lastTopicPath = "";
        if (forumNode.hasProperty("exo:lastTopicPath") && (lastTopicPath = forumNode.getProperty("exo:lastTopicPath").getString()).trim().length() > 0) {
            lastTopicPath = lastTopicPath.lastIndexOf("/") > 0 ? forum.getPath() + lastTopicPath.substring(lastTopicPath.lastIndexOf("/")) : forum.getPath() + "/" + lastTopicPath;
        }
        forum.setLastTopicPath(lastTopicPath);
        if (forumNode.hasProperty("exo:description")) {
            forum.setDescription(forumNode.getProperty("exo:description").getString());
        }
        forum.setPostCount(forumNode.getProperty("exo:postCount").getLong());
        forum.setTopicCount(forumNode.getProperty("exo:topicCount").getLong());
        if (forumNode.hasProperty("exo:isModerateTopic")) {
            forum.setIsModerateTopic(forumNode.getProperty("exo:isModerateTopic").getBoolean());
        }
        if (forumNode.hasProperty("exo:isModeratePost")) {
            forum.setIsModeratePost(forumNode.getProperty("exo:isModeratePost").getBoolean());
        }
        forum.setIsClosed(forumNode.getProperty("exo:isClosed").getBoolean());
        forum.setIsLock(forumNode.getProperty("exo:isLock").getBoolean());
        if (forumNode.hasProperty("exo:isAutoAddEmailNotify")) {
            forum.setIsAutoAddEmailNotify(forumNode.getProperty("exo:isAutoAddEmailNotify").getBoolean());
        }
        if (forumNode.hasProperty("exo:notifyWhenAddPost")) {
            forum.setNotifyWhenAddPost(this.ValuesToArray(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
        }
        if (forumNode.hasProperty("exo:notifyWhenAddTopic")) {
            forum.setNotifyWhenAddTopic(this.ValuesToArray(forumNode.getProperty("exo:notifyWhenAddTopic").getValues()));
        }
        if (forumNode.hasProperty("exo:viewer")) {
            forum.setViewer(this.ValuesToArray(forumNode.getProperty("exo:viewer").getValues()));
        }
        if (forumNode.hasProperty("exo:createTopicRole")) {
            forum.setCreateTopicRole(this.ValuesToArray(forumNode.getProperty("exo:createTopicRole").getValues()));
        }
        if (forumNode.hasProperty("exo:poster")) {
            forum.setPoster(this.ValuesToArray(forumNode.getProperty("exo:poster").getValues()));
        }
        if (forumNode.hasProperty("exo:moderators")) {
            forum.setModerators(this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues()));
        }
        if (forumNode.hasProperty("exo:banIPs")) {
            forum.setBanIP(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
        }
        if (forumNode.isNodeType("exo:forumWatching")) {
            forum.setEmailNotification(this.ValuesToArray(forumNode.getProperty("exo:emailWatching").getValues()));
        }
        return forum;
    }

    public Forum removeForum(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Forum forum = new Forum();
        try {
            Node catNode = forumHomeNode.getNode(categoryId);
            Node forumNode = catNode.getNode(forumId);
            forum = this.getForum(forumNode);
            forumNode.remove();
            catNode.setProperty("exo:forumCount", catNode.getProperty("exo:forumCount").getLong() - 1L);
            catNode.save();
            String[] moderators = forum.getModerators();
            Node userProfileHomeNode = this.getUserProfileHome(sProvider);
            forumId = forum.getForumName() + "(" + categoryId + "/" + forumId;
            for (String user : moderators) {
                ArrayList<String> list = new ArrayList<String>();
                try {
                    Node userProfileNode = userProfileHomeNode.getNode(user.trim());
                    list.addAll(this.ValuesToList(userProfileNode.getProperty("exo:moderateForums").getValues()));
                    if (list.contains(forumId)) {
                        list.remove(forumId);
                    }
                    if (list.size() == 0 && userProfileNode.getProperty("exo:userRole").getLong() > 0L) {
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                    }
                    userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(list));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (userProfileHomeNode.isNew()) {
                userProfileHomeNode.getSession().save();
            } else {
                userProfileHomeNode.save();
            }
            return forum;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void moveForum(SessionProvider sProvider, List<Forum> forums, String destCategoryPath) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        String oldCatePath = "";
        if (forums.isEmpty()) {
            return;
        }
        String forumPath = forums.get(0).getPath();
        oldCatePath = forumPath.substring(0, forumPath.lastIndexOf("/"));
        Node oldCatNode = (Node)forumHomeNode.getSession().getItem(oldCatePath);
        Node newCatNode = (Node)forumHomeNode.getSession().getItem(destCategoryPath);
        for (Forum forum : forums) {
            String newForumPath = destCategoryPath + "/" + forum.getId();
            forumHomeNode.getSession().getWorkspace().move(forum.getPath(), newForumPath);
            Node forumNode = (Node)forumHomeNode.getSession().getItem(newForumPath);
            forumNode.setProperty("exo:path", newForumPath);
            String[] strModerators = forum.getModerators();
            forumNode.setProperty("exo:moderators", strModerators);
            if (strModerators == null || strModerators.length <= 0 || strModerators[0].equals(" ") || !newCatNode.hasProperty("exo:userPrivate")) continue;
            ArrayList<String> listPrivate = new ArrayList<String>();
            listPrivate.addAll(this.ValuesToList(newCatNode.getProperty("exo:userPrivate").getValues()));
            if (((String)listPrivate.get(0)).equals(" ")) continue;
            for (int i = 0; i < strModerators.length; ++i) {
                if (listPrivate.contains(strModerators[i])) continue;
                listPrivate.add(strModerators[i]);
            }
            newCatNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[0]));
        }
        long forumCount = forums.size();
        oldCatNode.setProperty("exo:forumCount", oldCatNode.getProperty("exo:forumCount").getLong() - forumCount);
        if (newCatNode.hasProperty("exo:forumCount")) {
            forumCount = newCatNode.getProperty("exo:forumCount").getLong() + forumCount;
        }
        newCatNode.setProperty("exo:forumCount", forumCount);
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    private void setActiveTopicByForum(SessionProvider sProvider, Node forumNode, boolean isClosed) throws Exception {
        NodeIterator iter = forumNode.getNodes();
        Node topicNode = null;
        boolean bl = isClosed = !isClosed;
        while (iter.hasNext()) {
            topicNode = iter.nextNode();
            if (!topicNode.isNodeType("exo:topic")) continue;
            topicNode.setProperty("exo:isActiveByForum", isClosed);
            this.setActivePostByTopic(sProvider, topicNode, isClosed);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    private void setActivePostByTopic(SessionProvider sProvider, Node topicNode, boolean isActiveTopic) throws Exception {
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isApproved").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isWaiting").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isClosed").getBoolean();
        }
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isActive").getBoolean();
        }
        Node postNode = null;
        NodeIterator iter = topicNode.getNodes();
        while (iter.hasNext()) {
            postNode = iter.nextNode();
            if (!postNode.isNodeType("exo:post")) continue;
            postNode.setProperty("exo:isActiveByTopic", isActiveTopic);
        }
        if (topicNode.isNew()) {
            topicNode.getSession().save();
        } else {
            topicNode.save();
        }
    }

    public JCRPageList getPageTopic(SessionProvider sProvider, String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node CategoryNode = forumHomeNode.getNode(categoryId);
            ForumAdministration administration = this.getForumAdministration(sProvider);
            String orderBy = administration.getTopicSortBy();
            String orderType = administration.getTopicSortByType();
            Node forumNode = CategoryNode.getNode(forumId);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)");
            stringBuffer.append("[@exo:isActive='true'");
            if (strQuery != null && strQuery.length() > 0) {
                stringBuffer.append(" and ").append(strQuery);
            }
            stringBuffer.append("] order by @exo:isSticky descending");
            if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
                if (orderBy != null && orderBy.length() > 0) {
                    stringBuffer.append(",@exo:").append(orderBy).append(" ").append(orderType);
                    if (!orderBy.equals("lastPostDate")) {
                        stringBuffer.append(",@exo:lastPostDate descending");
                    }
                } else {
                    stringBuffer.append(",@exo:lastPostDate descending");
                }
            } else {
                stringBuffer.append(",@exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    stringBuffer.append(",@exo:lastPostDate descending");
                }
            }
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10L, pathQuery, true);
            return pagelist;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public List<Topic> getTopics(SessionProvider sProvider, String categoryId, String forumId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node CategoryNode = forumHomeNode.getNode(categoryId);
            Node forumNode = CategoryNode.getNode(forumId);
            NodeIterator iter = forumNode.getNodes();
            ArrayList<Topic> topics = new ArrayList<Topic>();
            while (iter.hasNext()) {
                Node topicNode = iter.nextNode();
                topics.add(this.getTopicNode(topicNode));
            }
            return topics;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public Topic getTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId, String userRead) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node topicNode = forumHomeNode.getNode(categoryId + "/" + forumId + "/" + topicId);
            Topic topicNew = new Topic();
            topicNew = this.getTopicNode(topicNode);
            if (userRead != null && userRead.length() > 0 && !userRead.equals("user_gest_uoom")) {
                long newViewCount = topicNode.getProperty("exo:viewCount").getLong() + 1L;
                topicNode.setProperty("exo:viewCount", newViewCount);
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
            return topicNew;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public Topic getTopicByPath(SessionProvider sProvider, String topicPath, boolean isLastPost) throws Exception {
        Topic topic;
        block5: {
            topic = null;
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                return null;
            }
            if (topicPath.indexOf(forumHomeNode.getName()) < 0) {
                topicPath = forumHomeNode.getPath() + "/" + topicPath;
            }
            try {
                Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                topic = this.getTopicNode(topicNode);
                if (topic == null && isLastPost && topicPath != null && topicPath.length() > 0) {
                    String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                    topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
                }
            }
            catch (RepositoryException e) {
                if (topicPath == null || topicPath.length() <= 0 || !isLastPost) break block5;
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
            }
        }
        return topic;
    }

    private Node queryLastTopic(SessionProvider sProvider, String forumPath) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String queryString = "/jcr:root" + forumPath + "//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false'] order by @exo:lastPostDate descending";
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node topicNode = null;
        boolean isSavePath = false;
        try {
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            while (iter.hasNext()) {
                topicNode = iter.nextNode();
                if (!forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                    isSavePath = true;
                    break;
                }
                if (!topicNode.getProperty("exo:isApproved").getBoolean()) continue;
                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                isSavePath = true;
                break;
            }
            if (!isSavePath) {
                forumNode.setProperty("exo:lastTopicPath", "");
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
        return topicNode;
    }

    private Topic getTopicNode(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setOwner(topicNode.getProperty("exo:owner").getString());
        topicNew.setTopicName(topicNode.getProperty("exo:name").getString());
        topicNew.setCreatedDate(topicNode.getProperty("exo:createdDate").getDate().getTime());
        if (topicNode.hasProperty("exo:modifiedBy")) {
            topicNew.setModifiedBy(topicNode.getProperty("exo:modifiedBy").getString());
        }
        if (topicNode.hasProperty("exo:modifiedDate")) {
            topicNew.setModifiedDate(topicNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (topicNode.hasProperty("exo:lastPostBy")) {
            topicNew.setLastPostBy(topicNode.getProperty("exo:lastPostBy").getString());
        }
        if (topicNode.hasProperty("exo:lastPostDate")) {
            topicNew.setLastPostDate(topicNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        topicNew.setDescription(topicNode.getProperty("exo:description").getString());
        topicNew.setPostCount(topicNode.getProperty("exo:postCount").getLong());
        topicNew.setViewCount(topicNode.getProperty("exo:viewCount").getLong());
        if (topicNode.hasProperty("exo:numberAttachments")) {
            topicNew.setNumberAttachment(topicNode.getProperty("exo:numberAttachments").getLong());
        }
        topicNew.setIcon(topicNode.getProperty("exo:icon").getString());
        topicNew.setLink(topicNode.getProperty("exo:link").getString());
        if (topicNode.hasProperty("exo:isNotifyWhenAddPost")) {
            topicNew.setIsNotifyWhenAddPost(topicNode.getProperty("exo:isNotifyWhenAddPost").getString());
        }
        topicNew.setIsModeratePost(topicNode.getProperty("exo:isModeratePost").getBoolean());
        topicNew.setIsClosed(topicNode.getProperty("exo:isClosed").getBoolean());
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsApproved(topicNode.getProperty("exo:isApproved").getBoolean());
        topicNew.setIsSticky(topicNode.getProperty("exo:isSticky").getBoolean());
        topicNew.setIsWaiting(topicNode.getProperty("exo:isWaiting").getBoolean());
        topicNew.setIsActive(topicNode.getProperty("exo:isActive").getBoolean());
        topicNew.setIsActiveByForum(topicNode.getProperty("exo:isActiveByForum").getBoolean());
        topicNew.setCanView(this.ValuesToArray(topicNode.getProperty("exo:canView").getValues()));
        topicNew.setCanPost(this.ValuesToArray(topicNode.getProperty("exo:canPost").getValues()));
        if (topicNode.hasProperty("exo:isPoll")) {
            topicNew.setIsPoll(topicNode.getProperty("exo:isPoll").getBoolean());
        }
        if (topicNode.hasProperty("exo:userVoteRating")) {
            topicNew.setUserVoteRating(this.ValuesToArray(topicNode.getProperty("exo:userVoteRating").getValues()));
        }
        if (topicNode.hasProperty("exo:tagId")) {
            topicNew.setTagId(this.ValuesToArray(topicNode.getProperty("exo:tagId").getValues()));
        }
        if (topicNode.hasProperty("exo:voteRating")) {
            topicNew.setVoteRating(topicNode.getProperty("exo:voteRating").getDouble());
        }
        if (topicNode.isNodeType("exo:forumWatching")) {
            topicNew.setEmailNotification(this.ValuesToArray(topicNode.getProperty("exo:emailWatching").getValues()));
        }
        String idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST);
        try {
            Node FirstPostNode = topicNode.getNode(idFirstPost);
            if (FirstPostNode.hasProperty("exo:numberAttachments") && FirstPostNode.getProperty("exo:numberAttachments").getLong() > 0L) {
                NodeIterator postAttachments = FirstPostNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("nt:file")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(node.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                topicNew.setAttachments(attachments);
            }
            return topicNew;
        }
        catch (PathNotFoundException e) {
            return topicNew;
        }
    }

    public JCRPageList getPageTopicOld(SessionProvider sProvider, long date) throws Exception {
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10L, stringBuffer.toString(), true);
            return pagelist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JCRPageList getPageTopicByUser(SessionProvider sProvider, String userName, boolean isMod, String strOrderBy) throws Exception {
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:topic)[@exo:owner='").append(userName).append("'");
            if (!isMod) {
                stringBuffer.append(" and @exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' ").append("and @exo:isActive='true' and @exo:isActiveByForum='true'");
            }
            stringBuffer.append("] order by @exo:isSticky descending");
            if (strOrderBy != null && strOrderBy.trim().length() > 0) {
                stringBuffer.append(",@exo:").append(strOrderBy);
            }
            stringBuffer.append(",exo:createdDate");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10L, pathQuery, true);
            return pagelist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void modifyTopic(SessionProvider sProvider, List<Topic> topics, int type) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ArrayList<String> userIdsp = new ArrayList<String>();
        long topicCount = 0L;
        long postCount = 0L;
        Node forumNode = null;
        try {
            String topicPath = topics.get(0).getPath();
            forumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
            topicCount = forumNode.getProperty("exo:topicCount").getLong();
            postCount = forumNode.getProperty("exo:postCount").getLong();
            if (forumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
            }
            userIdsp.addAll(this.getAllAdministrator(sProvider));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        for (Topic topic : topics) {
            try {
                String topicPath = topic.getPath();
                Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                switch (type) {
                    case 1: {
                        topicNode.setProperty("exo:isClosed", topic.getIsClosed());
                        this.setActivePostByTopic(sProvider, topicNode, !topic.getIsClosed());
                        break;
                    }
                    case 2: {
                        topicNode.setProperty("exo:isLock", topic.getIsLock());
                        break;
                    }
                    case 3: {
                        topicNode.setProperty("exo:isApproved", topic.getIsApproved());
                        this.sendNotification(forumHomeNode, topicNode.getParent(), topic, null, "", true);
                        this.setActivePostByTopic(sProvider, topicNode, topic.getIsApproved());
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 4: {
                        topicNode.setProperty("exo:isSticky", topic.getIsSticky());
                        break;
                    }
                    case 5: {
                        boolean isWaiting = topic.getIsWaiting();
                        topicNode.setProperty("exo:isWaiting", isWaiting);
                        this.setActivePostByTopic(sProvider, topicNode, !isWaiting);
                        if (!isWaiting) {
                            this.sendNotification(forumHomeNode, topicNode.getParent(), topic, null, "", true);
                        }
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 6: {
                        topicNode.setProperty("exo:isActive", topic.getIsActive());
                        this.setActivePostByTopic(sProvider, topicNode, topic.getIsActive());
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 7: {
                        topicNode.setProperty("exo:name", topic.getTopicName());
                        try {
                            Node nodeFirstPost = topicNode.getNode(topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST));
                            nodeFirstPost.setProperty("exo:name", topic.getTopicName());
                        }
                        catch (PathNotFoundException e) {}
                        break;
                    }
                }
                if ((type == 3 || type == 5) && !topic.getIsWaiting() && topic.getIsApproved()) {
                    ++topicCount;
                    postCount += topicNode.getProperty("exo:postCount").getLong() + 1L;
                }
                if (type == 2 || type == 4 || type >= 7) continue;
                this.queryLastTopic(sProvider, topicPath.substring(0, topicPath.lastIndexOf("/")));
            }
            catch (PathNotFoundException e) {}
        }
        if (type == 3 || type == 5) {
            forumNode.setProperty("exo:topicCount", topicCount);
            forumNode.setProperty("exo:postCount", postCount);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    public void saveTopic(SessionProvider sProvider, String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        Node topicNode;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Node forumNode = forumHomeNode.getNode(categoryId + "/" + forumId);
        if (isNew) {
            Node newProfileNode;
            topicNode = forumNode.addNode(topic.getId(), "exo:topic");
            topicNode.setProperty("exo:id", topic.getId());
            topicNode.setProperty("exo:owner", topic.getOwner());
            Calendar calendar = this.getGreenwichMeanTime();
            topic.setCreatedDate(calendar.getTime());
            topicNode.setProperty("exo:createdDate", calendar);
            topicNode.setProperty("exo:lastPostBy", topic.getOwner());
            topicNode.setProperty("exo:lastPostDate", calendar);
            topicNode.setProperty("exo:postCount", -1L);
            topicNode.setProperty("exo:viewCount", 0L);
            topicNode.setProperty("exo:tagId", topic.getTagId());
            topicNode.setProperty("exo:isActiveByForum", true);
            topicNode.setProperty("exo:isPoll", topic.getIsPoll());
            topicNode.setProperty("exo:link", topic.getLink());
            topicNode.setProperty("exo:path", forumId);
            if (!forumNode.getProperty("exo:isModerateTopic").getBoolean() && !topic.getIsWaiting()) {
                long newTopicCount = forumNode.getProperty("exo:topicCount").getLong() + 1L;
                forumNode.setProperty("exo:topicCount", newTopicCount);
            }
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                newProfileNode = userProfileNode.getNode(topic.getOwner());
                long totalTopicByUser = newProfileNode.getProperty("exo:totalTopic").getLong();
                newProfileNode.setProperty("exo:totalTopic", totalTopicByUser + 1L);
            }
            catch (PathNotFoundException e) {
                newProfileNode = userProfileNode.addNode(topic.getOwner(), Utils.USER_PROFILES_TYPE);
                newProfileNode.setProperty("exo:userId", topic.getOwner());
                newProfileNode.setProperty("exo:userTitle", Utils.USER);
                if (this.isAdminRole(topic.getOwner())) {
                    newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                }
                newProfileNode.setProperty("exo:totalTopic", 1L);
            }
            if (userProfileNode.isNew()) {
                userProfileNode.getSession().save();
            } else {
                userProfileNode.save();
            }
            this.sendNotification(forumHomeNode, forumNode, topic, null, defaultEmailContent, true);
        } else {
            topicNode = forumNode.getNode(topic.getId());
        }
        topicNode.setProperty("exo:name", topic.getTopicName());
        topicNode.setProperty("exo:modifiedBy", topic.getModifiedBy());
        topicNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
        topicNode.setProperty("exo:description", topic.getDescription());
        topicNode.setProperty("exo:icon", topic.getIcon());
        topicNode.setProperty("exo:isModeratePost", topic.getIsModeratePost());
        topicNode.setProperty("exo:isNotifyWhenAddPost", topic.getIsNotifyWhenAddPost());
        topicNode.setProperty("exo:isClosed", topic.getIsClosed());
        topicNode.setProperty("exo:isLock", topic.getIsLock());
        topicNode.setProperty("exo:isApproved", topic.getIsApproved());
        topicNode.setProperty("exo:isSticky", topic.getIsSticky());
        topicNode.setProperty("exo:isWaiting", topic.getIsWaiting());
        topicNode.setProperty("exo:isActive", topic.getIsActive());
        topicNode.setProperty("exo:canView", topic.getCanView());
        topicNode.setProperty("exo:canPost", topic.getCanPost());
        topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
        topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
        topicNode.setProperty("exo:numberAttachments", topic.getNumberAttachment());
        if (isNew) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
        if (!isMove) {
            String id;
            if (isNew) {
                id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                Post post = new Post();
                post.setId(id);
                post.setOwner(topic.getOwner());
                post.setCreatedDate(new Date());
                post.setName(topic.getTopicName());
                post.setMessage(topic.getDescription());
                post.setRemoteAddr("");
                post.setIcon(topic.getIcon());
                post.setIsApproved(true);
                post.setAttachments(topic.getAttachments());
                post.setUserPrivate(new String[]{"exoUserPri"});
                post.setLink(topic.getLink());
                post.setRemoteAddr(topic.getRemoteAddr());
                this.savePost(sProvider, categoryId, forumId, topic.getId(), post, true, defaultEmailContent);
            } else {
                id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                if (topicNode.hasNode(id)) {
                    Node fistPostNode = topicNode.getNode(id);
                    Post post = this.getPost(fistPostNode);
                    post.setModifiedBy(topic.getModifiedBy());
                    post.setModifiedDate(new Date());
                    post.setEditReason(topic.getEditReason());
                    post.setName(topic.getTopicName());
                    post.setMessage(topic.getDescription());
                    post.setIcon(topic.getIcon());
                    post.setAttachments(topic.getAttachments());
                    this.savePost(sProvider, categoryId, forumId, topic.getId(), post, false, defaultEmailContent);
                }
            }
        }
    }

    public Topic removeTopic(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Topic topic = new Topic();
        try {
            Node forumNode = forumHomeNode.getNode(categoryId + "/" + forumId);
            topic = this.getTopic(sProvider, categoryId, forumId, topicId, "user_gest_uoom");
            String owner = topic.getOwner();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            Node newProfileNode = userProfileNode.getNode(owner);
            newProfileNode.setProperty("exo:totalTopic", newProfileNode.getProperty("exo:totalTopic").getLong() - 1L);
            newProfileNode.save();
            long newTopicCount = forumNode.getProperty("exo:topicCount").getLong() - 1L;
            forumNode.setProperty("exo:topicCount", newTopicCount);
            long postCount = topic.getPostCount() + 1L;
            long newPostCount = forumNode.getProperty("exo:postCount").getLong() - postCount;
            forumNode.setProperty("exo:postCount", newPostCount);
            forumNode.getNode(topicId).remove();
            forumNode.save();
            return topic;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void moveTopic(SessionProvider sProvider, List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        long tmp = 0L;
        Node node = null;
        String forumName = null;
        node = (Node)forumHomeNode.getSession().getItem(destForumPath);
        forumName = node.getProperty("exo:name").getString();
        UserProfile forumOwner = this.getUserProfileManagement(sProvider, node.getProperty("exo:owner").getString());
        Message message = new Message();
        message.setMimeType("text/html");
        String headerSubject = "";
        String objectName = "[" + node.getParent().getProperty("exo:name").getString() + "][" + node.getProperty("exo:name").getString() + "] ";
        try {
            node = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
            if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        message.setFrom(forumOwner.getFullName() + "<" + forumOwner.getEmail() + ">");
        for (Topic topic : topics) {
            String topicPath = topic.getPath();
            String newTopicPath = destForumPath + "/" + topic.getId();
            Node srcForumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
            forumHomeNode.getSession().getWorkspace().move(topicPath, newTopicPath);
            tmp = srcForumNode.getProperty("exo:topicCount").getLong();
            tmp = tmp > 0L ? --tmp : 0L;
            srcForumNode.setProperty("exo:topicCount", tmp);
            this.queryLastTopic(sProvider, srcForumNode.getPath());
            Node topicNode = (Node)forumHomeNode.getSession().getItem(newTopicPath);
            topicNode.setProperty("exo:path", destForumPath.substring(destForumPath.lastIndexOf("/")));
            long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
            Node destForumNode = (Node)forumHomeNode.getSession().getItem(destForumPath);
            destForumNode.setProperty("exo:topicCount", destForumNode.getProperty("exo:topicCount").getLong() + 1L);
            this.queryLastTopic(sProvider, destForumNode.getPath());
            tmp = srcForumNode.getProperty("exo:postCount").getLong();
            tmp = tmp > topicPostCount ? (tmp -= topicPostCount) : 0L;
            srcForumNode.setProperty("exo:postCount", tmp);
            destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + topicPostCount);
            message.setSubject(headerSubject + objectName + topic.getTopicName());
            message.setBody(mailContent.replace("$topicName_", topic.getTopicName()).replace("$forumName_", forumName).replace("$link_", link.replaceFirst("pathId", topic.getId())));
            this.sendEmailNotification(Arrays.asList(this.getUserProfileManagement(sProvider, topic.getOwner()).getEmail()), message);
        }
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    public JCRPageList getPosts(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node topicNode = forumHomeNode.getNode(categoryId + "/" + forumId + "/" + topicId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            stringBuffer.append((CharSequence)this.getPathQuery(isApproved, isHidden, userLogin));
            stringBuffer.append(" order by @exo:createdDate ascending");
            ForumPageList pagelist = new ForumPageList(null, 10L, stringBuffer.toString(), true);
            return pagelist;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private StringBuilder getPathQuery(String isApproved, String isHidden, String userLogin) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        boolean isAnd = false;
        if (userLogin != null && userLogin.length() > 0) {
            isAnd = true;
            strBuilder.append("[((@exo:userPrivate='").append(userLogin).append("') or (@exo:userPrivate='exoUserPri'))");
        }
        if (isApproved != null && isApproved.length() > 0) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isApproved='").append(isApproved).append("')");
            } else {
                strBuilder.append("[(@exo:isApproved='").append(isApproved).append("')");
            }
            if (isHidden.equals("false")) {
                strBuilder.append(" and (@exo:isHidden='false')");
            }
            strBuilder.append("]");
        } else if (isHidden.equals("true")) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isHidden='true')]");
            } else {
                strBuilder.append("[@exo:isHidden='true']");
            }
        } else if (isHidden.equals("false")) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isHidden='false')]");
            } else {
                strBuilder.append("[@exo:isHidden='false']");
            }
        } else if (isAnd) {
            strBuilder.append("]");
        }
        return strBuilder;
    }

    public long getAvailablePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(categoryId).append("/").append(forumId).append("/").append(topicId);
        try {
            Node topicNode = forumHomeNode.getNode(strBuilder.toString());
            strBuilder = new StringBuilder();
            strBuilder.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            strBuilder.append((CharSequence)this.getPathQuery(isApproved, isHidden, userLogin));
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(strBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            return iter.getSize();
        }
        catch (PathNotFoundException e) {
            return 0L;
        }
    }

    public JCRPageList getPagePostByUser(SessionProvider sProvider, String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer pathQuery = new StringBuffer();
            pathQuery.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:post)[@exo:isFirstPost='false' and @exo:owner='").append(userName);
            if (isMod) {
                pathQuery.append("' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            } else {
                pathQuery.append("' and @exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            }
            if (strOrderBy != null && strOrderBy.trim().length() > 0) {
                pathQuery.append("order by @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("createdDate") < 0) {
                    pathQuery.append(",@exo:createdDate descending");
                }
            }
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10L, pathQuery.toString(), true);
            return pagelist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Post getPost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node postNode;
            if (postId.lastIndexOf("/") > 0) {
                if (postId.indexOf(forumHomeNode.getName()) < 0) {
                    postId = forumHomeNode.getPath() + "/" + postId;
                }
                postNode = (Node)forumHomeNode.getSession().getItem(postId);
            } else {
                postNode = forumHomeNode.getNode(categoryId + "/" + forumId + "/" + topicId + "/" + postId);
            }
            Post postNew = new Post();
            postNew = this.getPost(postNode);
            return postNew;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public JCRPageList getListPostsByIP(String ip, String strOrderBy, SessionProvider sessionProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuilder builder = new StringBuilder();
        builder.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:post)[@exo:remoteAddr='").append(ip).append("']");
        if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
            builder.append(" order by @exo:lastPostDate descending");
        } else {
            builder.append(" order by @exo:").append(strOrderBy);
            if (strOrderBy.indexOf("lastPostDate") < 0) {
                builder.append(", @exo:lastPostDate descending");
            }
        }
        String pathQuery = builder.toString();
        Query query = qm.createQuery(pathQuery, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ForumPageList pagelist = new ForumPageList(iter, 5L, pathQuery, true);
        return pagelist;
    }

    protected Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        if (postNode.hasProperty("exo:owner")) {
            postNew.setOwner(postNode.getProperty("exo:owner").getString());
        }
        if (postNode.hasProperty("exo:createdDate")) {
            postNew.setCreatedDate(postNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:modifiedBy")) {
            postNew.setModifiedBy(postNode.getProperty("exo:modifiedBy").getString());
        }
        if (postNode.hasProperty("exo:modifiedDate")) {
            postNew.setModifiedDate(postNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:editReason")) {
            postNew.setEditReason(postNode.getProperty("exo:editReason").getString());
        }
        if (postNode.hasProperty("exo:name")) {
            postNew.setName(postNode.getProperty("exo:name").getString());
        }
        if (postNode.hasProperty("exo:message")) {
            postNew.setMessage(postNode.getProperty("exo:message").getString());
        }
        if (postNode.hasProperty("exo:remoteAddr")) {
            postNew.setRemoteAddr(postNode.getProperty("exo:remoteAddr").getString());
        }
        if (postNode.hasProperty("exo:icon")) {
            postNew.setIcon(postNode.getProperty("exo:icon").getString());
        }
        if (postNode.hasProperty("exo:link")) {
            postNew.setLink(postNode.getProperty("exo:link").getString());
        }
        if (postNode.hasProperty("exo:isApproved")) {
            postNew.setIsApproved(postNode.getProperty("exo:isApproved").getBoolean());
        }
        if (postNode.hasProperty("exo:isHidden")) {
            postNew.setIsHidden(postNode.getProperty("exo:isHidden").getBoolean());
        }
        if (postNode.hasProperty("exo:isActiveByTopic")) {
            postNew.setIsActiveByTopic(postNode.getProperty("exo:isActiveByTopic").getBoolean());
        }
        if (postNode.hasProperty("exo:userPrivate")) {
            postNew.setUserPrivate(this.ValuesToArray(postNode.getProperty("exo:userPrivate").getValues()));
        }
        if (postNode.hasProperty("exo:numberAttach")) {
            long numberAttach = postNode.getProperty("exo:numberAttach").getLong();
            postNew.setNumberAttach(numberAttach);
            if (numberAttach > 0L) {
                NodeIterator postAttachments = postNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("nt:file")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(node.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                postNew.setAttachments(attachments);
            }
        }
        return postNew;
    }

    public void savePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        Node postNode;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Node CategoryNode = forumHomeNode.getNode(categoryId);
        Node forumNode = CategoryNode.getNode(forumId);
        Node topicNode = forumNode.getNode(topicId);
        Calendar calendar = this.getGreenwichMeanTime();
        if (isNew) {
            Node newProfileNode;
            postNode = topicNode.addNode(post.getId(), "exo:post");
            postNode.setProperty("exo:id", post.getId());
            postNode.setProperty("exo:path", forumId);
            postNode.setProperty("exo:owner", post.getOwner());
            post.setCreatedDate(calendar.getTime());
            postNode.setProperty("exo:createdDate", calendar);
            postNode.setProperty("exo:userPrivate", post.getUserPrivate());
            postNode.setProperty("exo:isActiveByTopic", true);
            postNode.setProperty("exo:link", post.getLink());
            if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                postNode.setProperty("exo:isFirstPost", true);
            } else {
                postNode.setProperty("exo:isFirstPost", false);
            }
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                newProfileNode = userProfileNode.getNode(post.getOwner());
                long totalPostByUser = 0L;
                totalPostByUser = newProfileNode.getProperty("exo:totalPost").getLong();
                newProfileNode.setProperty("exo:totalPost", totalPostByUser + 1L);
            }
            catch (PathNotFoundException e) {
                newProfileNode = userProfileNode.addNode(post.getOwner(), Utils.USER_PROFILES_TYPE);
                newProfileNode.setProperty("exo:userId", post.getOwner());
                newProfileNode.setProperty("exo:userTitle", Utils.USER);
                if (this.isAdminRole(post.getOwner())) {
                    newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                }
                newProfileNode.setProperty("exo:totalPost", 1L);
            }
            newProfileNode.setProperty("exo:lastPostDate", calendar);
            if (userProfileNode.isNew()) {
                userProfileNode.getSession().save();
            } else {
                userProfileNode.save();
            }
        } else {
            postNode = topicNode.getNode(post.getId());
        }
        if (post.getModifiedBy() != null && post.getModifiedBy().length() > 0) {
            postNode.setProperty("exo:modifiedBy", post.getModifiedBy());
            postNode.setProperty("exo:modifiedDate", calendar);
            postNode.setProperty("exo:editReason", post.getEditReason());
        }
        postNode.setProperty("exo:name", post.getName());
        postNode.setProperty("exo:message", post.getMessage());
        postNode.setProperty("exo:remoteAddr", post.getRemoteAddr());
        postNode.setProperty("exo:icon", post.getIcon());
        postNode.setProperty("exo:isApproved", post.getIsApproved());
        postNode.setProperty("exo:isHidden", post.getIsHidden());
        long numberAttach = 0L;
        ArrayList<String> listFileName = new ArrayList<String>();
        List<ForumAttachment> attachments = post.getAttachments();
        if (attachments != null) {
            Iterator<ForumAttachment> it = attachments.iterator();
            for (ForumAttachment attachment : attachments) {
                ++numberAttach;
                BufferAttachment file = null;
                listFileName.add(attachment.getId());
                try {
                    file = (BufferAttachment)it.next();
                    Node nodeFile = null;
                    nodeFile = !postNode.hasNode(file.getId()) ? postNode.addNode(file.getId(), "exo:forumAttachment") : postNode.getNode(file.getId());
                    ForumServiceUtils.reparePermissions(nodeFile, "any");
                    nodeFile.setProperty("exo:fileName", file.getName());
                    Node nodeContent = null;
                    if (nodeFile.hasNode("jcr:content")) continue;
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                    nodeContent.setProperty("jcr:mimeType", file.getMimeType());
                    nodeContent.setProperty("jcr:data", file.getInputStream());
                    nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                }
                catch (Exception e) {}
            }
        }
        NodeIterator postAttachments = postNode.getNodes();
        Node postAttachmentNode = null;
        while (postAttachments.hasNext()) {
            postAttachmentNode = postAttachments.nextNode();
            if (listFileName.contains(postAttachmentNode.getName())) continue;
            postAttachmentNode.remove();
        }
        if (isNew) {
            long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
            long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong() + numberAttach;
            if (topicPostCount == 0L) {
                topicNode.setProperty("exo:postCount", topicPostCount);
            }
            long forumPostCount = forumNode.getProperty("exo:postCount").getLong() + 1L;
            boolean isSetLastPost = true;
            boolean sendAlertJob = true;
            boolean isFistPost = false;
            if (topicNode.getProperty("exo:isClosed").getBoolean()) {
                sendAlertJob = false;
                postNode.setProperty("exo:isActiveByTopic", false);
            } else {
                if (isSetLastPost && topicNode.getProperty("exo:isWaiting").getBoolean()) {
                    isSetLastPost = false;
                }
                if (isSetLastPost) {
                    isSetLastPost = topicNode.getProperty("exo:isActive").getBoolean();
                }
                if (isSetLastPost) {
                    if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                        isFistPost = true;
                        if (!post.getIsHidden()) {
                            topicNode.setProperty("exo:postCount", topicPostCount);
                            topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                            topicNode.setProperty("exo:lastPostDate", calendar);
                            topicNode.setProperty("exo:lastPostBy", post.getOwner());
                        }
                        if (!forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                            forumNode.setProperty("exo:postCount", forumPostCount);
                            forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                            sendAlertJob = false;
                        } else if (topicNode.getProperty("exo:isApproved").getBoolean()) {
                            forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                            sendAlertJob = false;
                        }
                    } else {
                        if (post.getIsApproved() && !post.getIsHidden() && post.getUserPrivate().length != 2) {
                            forumNode.setProperty("exo:postCount", forumPostCount);
                            topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                            topicNode.setProperty("exo:postCount", topicPostCount);
                            topicNode.setProperty("exo:lastPostDate", calendar);
                            topicNode.setProperty("exo:lastPostBy", post.getOwner());
                        }
                        if (forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                            if (topicNode.getProperty("exo:isApproved").getBoolean() && !topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                sendAlertJob = false;
                            }
                        } else if (!topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                            forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                            sendAlertJob = false;
                        } else if (post.getIsApproved()) {
                            forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                            sendAlertJob = false;
                        }
                    }
                } else {
                    postNode.setProperty("exo:isActiveByTopic", false);
                    sendAlertJob = true;
                }
            }
            try {
                if (!isFistPost) {
                    this.sendNotification(forumHomeNode, topicNode, null, post, defaultEmailContent, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isNew && defaultEmailContent.length() == 0) {
                sendAlertJob = false;
            }
            if (sendAlertJob) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(userIdsp);
            }
        } else {
            long temp = topicNode.getProperty("exo:numberAttachments").getLong() - postNode.getProperty("exo:numberAttach").getLong();
            topicNode.setProperty("exo:numberAttachments", temp + numberAttach);
        }
        postNode.setProperty("exo:numberAttach", numberAttach);
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(Node forumHomeNode, Node node, Topic topic, Post post, String defaultEmailContent, boolean isApprovePost) throws Exception {
        block67: {
            Node forumAdminNode = null;
            String headerSubject = "";
            String objectName = "";
            try {
                forumAdminNode = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
            }
            catch (Exception e) {
                // empty catch block
            }
            String content = "";
            if (forumAdminNode != null) {
                if (forumAdminNode.hasProperty("exo:notifyEmailContent")) {
                    content = forumAdminNode.getProperty("exo:notifyEmailContent").getString();
                }
                if (forumAdminNode.hasProperty("exo:enableHeaderSubject") && forumAdminNode.getProperty("exo:enableHeaderSubject").getBoolean() && forumAdminNode.hasProperty("exo:headerSubject")) {
                    headerSubject = forumAdminNode.getProperty("exo:headerSubject").getString() + " ";
                }
            } else {
                content = defaultEmailContent != null && defaultEmailContent.length() > 0 ? defaultEmailContent : Utils.DEFAULT_EMAIL_CONTENT;
            }
            List<String> listUser = new ArrayList<String>();
            List<Object> emailList = new ArrayList<String>();
            SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
            Node userProfileHome = null;
            try {
                userProfileHome = this.getUserProfileHome(sProvider);
            }
            catch (Exception e) {
            }
            finally {
                sProvider.close();
            }
            int count = 0;
            if (post == null) {
                objectName = "[" + node.getParent().getProperty("exo:name").getString() + "][" + node.getProperty("exo:name").getString() + "] " + topic.getTopicName();
                while (true) {
                    emailList = new ArrayList();
                    if (node.isNodeType("exo:forumWatching") && topic.getIsActive() && topic.getIsApproved() && topic.getIsActiveByForum() && !topic.getIsClosed() && !topic.getIsLock() && !topic.getIsWaiting()) {
                        Node categoryNode = null;
                        categoryNode = node.isNodeType("exo:forumCategory") ? node : node.getParent();
                        if (categoryNode.hasProperty("exo:userPrivate")) {
                            listUser.addAll(this.ValuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                        }
                        if (!listUser.isEmpty() && !((String)listUser.get(0)).equals(" ")) {
                            List<String> emails = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                            int i = 0;
                            for (String user : this.ValuesToList(node.getProperty("exo:userWatching").getValues())) {
                                if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                    emailList.add(emails.get(i));
                                }
                                ++i;
                            }
                        } else {
                            emailList.addAll(this.ValuesToList(node.getProperty("exo:emailWatching").getValues()));
                        }
                    }
                    if (node.hasProperty("exo:notifyWhenAddTopic")) {
                        emailList.addAll(this.ValuesToList(node.getProperty("exo:notifyWhenAddTopic").getValues()));
                    }
                    if (emailList.size() > 0) {
                        Message message = new Message();
                        message.setMimeType("text/html");
                        String owner = topic.getOwner();
                        try {
                            Node userNode = userProfileHome.getNode(owner);
                            String email = userNode.getProperty("exo:email").getString();
                            String fullName = userNode.getProperty("exo:fullName").getString();
                            if (email != null && email.length() > 0) {
                                message.setFrom(fullName + "<" + email + ">");
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        String content_ = node.getProperty("exo:name").getString();
                        if (node.isNodeType("exo:forum")) {
                            message.setSubject(headerSubject + objectName);
                            content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)content_);
                            content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.FORUM);
                        } else {
                            message.setSubject(headerSubject + objectName);
                            content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)content_);
                            content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)"Category");
                        }
                        content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Topic");
                        content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(topic.getDescription()));
                        Date createdDate = topic.getCreatedDate();
                        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
                        content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter.format((Object)createdDate) + " GMT+0"));
                        formatter = new SimpleDateFormat("MM/dd/yyyy");
                        content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter.format((Object)createdDate));
                        content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)topic.getOwner());
                        content_ = StringUtils.replace((String)content_, (String)"$LINK", (String)("<a target=\"_blank\" href=\"" + topic.getLink() + "\">click here</a><br/>"));
                        message.setBody(content_);
                        this.sendEmailNotification(emailList, message);
                    }
                    if (!node.isNodeType("exo:forumCategory") && count <= 1) {
                        ++count;
                        node = node.getParent();
                        continue;
                    }
                    break block67;
                    break;
                }
            }
            if (!node.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                SimpleDateFormat formatter;
                Date createdDate;
                Message message;
                Node forumNode = node.getParent();
                Node categoryNode = forumNode.getParent();
                objectName = "[" + categoryNode.getProperty("exo:name").getString() + "][" + forumNode.getProperty("exo:name").getString() + "] ";
                boolean isSend = false;
                if (post.getIsApproved() && post.getIsActiveByTopic() && !post.getIsHidden()) {
                    isSend = true;
                    ArrayList<String> listCanViewInTopic = new ArrayList<String>();
                    listCanViewInTopic.addAll(this.ValuesToList(node.getProperty("exo:canView").getValues()));
                    if (post.getUserPrivate() != null && post.getUserPrivate().length > 1) {
                        listUser.addAll(Arrays.asList(post.getUserPrivate()));
                    }
                    if (listUser.isEmpty() || listUser.size() == 1) {
                        if (!listCanViewInTopic.isEmpty() && !((String)listCanViewInTopic.get(0)).equals(" ")) {
                            listCanViewInTopic.addAll(this.ValuesToList(forumNode.getProperty("exo:poster").getValues()));
                            listCanViewInTopic.addAll(this.ValuesToList(forumNode.getProperty("exo:viewer").getValues()));
                        }
                        if (categoryNode.hasProperty("exo:userPrivate")) {
                            listUser.addAll(this.ValuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                        }
                        if (!listUser.isEmpty() && !((String)listUser.get(0)).equals(" ")) {
                            if (!listCanViewInTopic.isEmpty() && !((String)listCanViewInTopic.get(0)).equals(" ") && ((listUser = JCRDataStorage.combineListToList(listUser, listCanViewInTopic)).isEmpty() || listUser.get(0).equals(" "))) {
                                isSend = false;
                            }
                        } else {
                            listUser = listCanViewInTopic;
                        }
                    }
                }
                if (node.isNodeType("exo:forumWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(node.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailList.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailList = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                    }
                }
                ArrayList<String> emailListForum = new ArrayList<String>();
                if (isApprovePost) {
                    String ownerTopicEmail = node.getProperty("exo:isNotifyWhenAddPost").getString();
                    String[] users = post.getUserPrivate();
                    if (users != null && users.length == 2) {
                        String owner = node.getProperty("exo:owner").getString();
                        if (ownerTopicEmail.trim().length() > 0 && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailList.add(ownerTopicEmail);
                        }
                        owner = forumNode.getProperty("exo:owner").getString();
                        if (forumNode.hasProperty("exo:notifyWhenAddPost") && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    } else {
                        if (ownerTopicEmail.trim().length() > 0) {
                            emailList.add(ownerTopicEmail);
                        }
                        if (forumNode.hasProperty("exo:notifyWhenAddPost")) {
                            emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    }
                }
                if (forumNode.isNodeType("exo:forumWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(forumNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(forumNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailListForum.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                ArrayList<String> emailListCategory = new ArrayList<String>();
                if (categoryNode.isNodeType("exo:forumWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(categoryNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(categoryNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailListCategory.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListCategory.addAll(this.ValuesToList(categoryNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                String email = "";
                String fullName = "";
                String owner = post.getOwner();
                try {
                    Node userNode = userProfileHome.getNode(owner);
                    email = userNode.getProperty("exo:email").getString();
                    fullName = userNode.getProperty("exo:fullName").getString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String content_ = "";
                if (emailList.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    content_ = node.getProperty("exo:name").getString();
                    message.setSubject(headerSubject + objectName + content_);
                    content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)content_);
                    content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.TOPIC);
                    content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Post");
                    content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage()));
                    Date createdDate2 = post.getCreatedDate();
                    SimpleDateFormat formatter2 = new SimpleDateFormat("HH:mm");
                    content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter2.format((Object)createdDate2) + " GMT+0"));
                    formatter2 = new SimpleDateFormat("MM/dd/yyyy");
                    content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter2.format((Object)createdDate2));
                    content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)owner);
                    content_ = StringUtils.replace((String)content_, (String)"$LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "\">click here</a><br/>"));
                    message.setBody(content_);
                    this.sendEmailNotification(emailList, message);
                }
                if (emailListForum.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    String forumName = forumNode.getProperty("exo:name").getString();
                    content_ = node.getProperty("exo:name").getString();
                    message.setSubject(headerSubject + objectName + content_);
                    content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)forumName);
                    content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.FORUM);
                    content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Post");
                    content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage()));
                    createdDate = post.getCreatedDate();
                    formatter = new SimpleDateFormat("HH:mm");
                    content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter.format((Object)createdDate) + " GMT+0"));
                    formatter = new SimpleDateFormat("MM/dd/yyyy");
                    content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter.format((Object)createdDate));
                    content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)post.getOwner());
                    content_ = StringUtils.replace((String)content_, (String)"$LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "\">click here</a><br/>"));
                    message.setBody(content_);
                    this.sendEmailNotification(emailListForum, message);
                }
                if (emailListCategory.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    String categoryName = categoryNode.getProperty("exo:name").getString();
                    content_ = node.getProperty("exo:name").getString();
                    message.setSubject(headerSubject + objectName + content_);
                    content = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)categoryName);
                    content = StringUtils.replace((String)content, (String)"$OBJECT_WATCH_TYPE", (String)"Category");
                    content = StringUtils.replace((String)content, (String)"$ADD_TYPE", (String)"Post");
                    content = StringUtils.replace((String)content, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage()));
                    createdDate = post.getCreatedDate();
                    formatter = new SimpleDateFormat("HH:mm");
                    content = StringUtils.replace((String)content, (String)"$TIME", (String)(formatter.format((Object)createdDate) + " GMT+0"));
                    formatter = new SimpleDateFormat("MM/dd/yyyy");
                    content = StringUtils.replace((String)content, (String)"$DATE", (String)formatter.format((Object)createdDate));
                    content = StringUtils.replace((String)content, (String)"$POSTER", (String)post.getOwner());
                    content = StringUtils.replace((String)content, (String)"$LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "\">click here</a><br/>"));
                    message.setBody(content);
                    this.sendEmailNotification(emailListCategory, message);
                }
            }
        }
    }

    public void modifyPost(SessionProvider sProvider, List<Post> posts, int type) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        for (Post post : posts) {
            try {
                boolean isGetLastPost = false;
                String postPath = post.getPath();
                String topicPath = postPath.substring(0, postPath.lastIndexOf("/"));
                String forumPath = postPath.substring(0, topicPath.lastIndexOf("/"));
                Node postNode = (Node)forumHomeNode.getSession().getItem(postPath);
                Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
                Calendar lastPostDate = topicNode.getProperty("exo:lastPostDate").getDate();
                Calendar postDate = postNode.getProperty("exo:createdDate").getDate();
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong();
                long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong();
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong();
                ArrayList<String> userIdsp = new ArrayList<String>();
                try {
                    if (forumNode.hasProperty("exo:moderators")) {
                        userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                    }
                    userIdsp.addAll(this.getAllAdministrator(sProvider));
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (type) {
                    case 1: {
                        postNode.setProperty("exo:isApproved", true);
                        post.setIsApproved(true);
                        this.sendNotification(forumHomeNode, topicNode, null, post, "", false);
                        break;
                    }
                    case 2: {
                        if (post.getIsHidden()) {
                            postNode.setProperty("exo:isHidden", true);
                            Node postLastNode = this.getLastDatePost(forumHomeNode, topicNode, postNode);
                            if (postLastNode != null) {
                                topicNode.setProperty("exo:lastPostDate", postLastNode.getProperty("exo:createdDate").getDate());
                                topicNode.setProperty("exo:lastPostBy", postLastNode.getProperty("exo:owner").getString());
                                isGetLastPost = true;
                            }
                            if ((newNumberAttach -= postNode.getProperty("exo:numberAttach").getLong()) < 0L) {
                                newNumberAttach = 0L;
                            }
                            topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                            topicNode.setProperty("exo:postCount", topicPostCount - 1L);
                            forumNode.setProperty("exo:postCount", forumPostCount - 1L);
                            break;
                        }
                        postNode.setProperty("exo:isHidden", false);
                        this.sendNotification(forumHomeNode, topicNode, null, post, "", false);
                        break;
                    }
                }
                if (!post.getIsHidden() && post.getIsApproved()) {
                    if (postDate.getTimeInMillis() > lastPostDate.getTimeInMillis()) {
                        topicNode.setProperty("exo:lastPostDate", postDate);
                        topicNode.setProperty("exo:lastPostBy", post.getOwner());
                        isGetLastPost = true;
                    }
                    topicNode.setProperty("exo:numberAttachments", newNumberAttach += postNode.getProperty("exo:numberAttach").getLong());
                    topicNode.setProperty("exo:postCount", topicPostCount + 1L);
                    forumNode.setProperty("exo:postCount", forumPostCount + 1L);
                }
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
                if (!isGetLastPost) continue;
                this.queryLastTopic(sProvider, topicPath.substring(0, topicPath.lastIndexOf("/")));
                this.getTotalJobWatting(userIdsp);
            }
            catch (PathNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private Node getLastDatePost(Node forumHomeNode, Node node, Node postNode_) throws Exception {
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer pathQuery = new StringBuffer();
        pathQuery.append("/jcr:root").append(node.getPath()).append("//element(*,exo:post)[@exo:isHidden='false' and @exo:isApproved='true'] order by @exo:createdDate descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node postNode = null;
        while (iter.hasNext() && (postNode = iter.nextNode()).getName().equals(postNode_.getName())) {
        }
        return postNode;
    }

    public Post removePost(SessionProvider sProvider, String categoryId, String forumId, String topicId, String postId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Post post = new Post();
        try {
            Node CategoryNode = forumHomeNode.getNode(categoryId);
            try {
                post = this.getPost(sProvider, categoryId, forumId, topicId, postId);
                Node forumNode = CategoryNode.getNode(forumId);
                Node topicNode = forumNode.getNode(topicId);
                Node postNode = topicNode.getNode(postId);
                long numberAttachs = postNode.getProperty("exo:numberAttach").getLong();
                String owner = postNode.getProperty("exo:owner").getString();
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    Node newProfileNode = userProfileNode.getNode(owner);
                    newProfileNode.setProperty("exo:totalPost", newProfileNode.getProperty("exo:totalPost").getLong() - 1L);
                    newProfileNode.save();
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                postNode.remove();
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() - 1L;
                topicNode.setProperty("exo:postCount", topicPostCount);
                long newNumberAttachs = topicNode.getProperty("exo:numberAttachments").getLong();
                newNumberAttachs = newNumberAttachs > numberAttachs ? (newNumberAttachs -= numberAttachs) : 0L;
                topicNode.setProperty("exo:numberAttachments", newNumberAttachs);
                NodeIterator nodeIterator = topicNode.getNodes();
                long last = nodeIterator.getSize() - 1L;
                nodeIterator.skip(last);
                while (nodeIterator.hasNext()) {
                    postNode = nodeIterator.nextNode();
                }
                topicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
                topicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() - 1L;
                forumNode.setProperty("exo:postCount", forumPostCount);
                forumNode.save();
                return post;
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void movePost(SessionProvider sProvider, List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        String srcTopicPath = posts.get(0).getPath();
        srcTopicPath = srcTopicPath.substring(0, srcTopicPath.lastIndexOf("/"));
        Node srcTopicNode = (Node)forumHomeNode.getSession().getItem(srcTopicPath);
        Node srcForumNode = srcTopicNode.getParent();
        Node destTopicNode = (Node)forumHomeNode.getSession().getItem(destTopicPath);
        Node destForumNode = destTopicNode.getParent();
        long totalAtt = 0L;
        long totalpost = posts.size();
        int count = 0;
        Node postNode = null;
        for (Post post : posts) {
            totalAtt += post.getNumberAttach();
            String newPostPath = destTopicPath + "/" + post.getId();
            forumHomeNode.getSession().getWorkspace().move(post.getPath(), newPostPath);
            postNode = (Node)forumHomeNode.getSession().getItem(newPostPath);
            postNode.setProperty("exo:path", destTopicPath.substring(destTopicPath.lastIndexOf(Utils.FORUM), destTopicPath.lastIndexOf("/")));
            postNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
            if (isCreatNewTopic && count == 0) {
                ++count;
                postNode.setProperty("exo:isFirstPost", true);
                continue;
            }
            postNode.setProperty("exo:isFirstPost", false);
        }
        destTopicNode.setProperty("exo:postCount", destTopicNode.getProperty("exo:postCount").getLong() + totalpost);
        destTopicNode.setProperty("exo:numberAttachments", destTopicNode.getProperty("exo:numberAttachments").getLong() + totalAtt);
        destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + totalpost);
        destTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
        destTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
        long temp = srcTopicNode.getProperty("exo:postCount").getLong();
        if ((temp -= totalpost) < 0L) {
            temp = 0L;
        }
        srcTopicNode.setProperty("exo:postCount", temp);
        temp = srcTopicNode.getProperty("exo:numberAttachments").getLong();
        if ((temp -= totalAtt) < 0L) {
            temp = 0L;
        }
        srcTopicNode.setProperty("exo:numberAttachments", temp);
        NodeIterator nodeIterator = srcTopicNode.getNodes();
        long posLast = nodeIterator.getSize() - 1L;
        nodeIterator.skip(posLast);
        while (nodeIterator.hasNext()) {
            postNode = nodeIterator.nextNode();
        }
        srcTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
        srcTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
        temp = srcForumNode.getProperty("exo:postCount").getLong();
        if ((temp -= totalpost) < 0L) {
            temp = 0L;
        }
        srcForumNode.setProperty("exo:postCount", temp);
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
        String topicName = destTopicNode.getProperty("exo:name").getString();
        UserProfile forumOwner = this.getUserProfileManagement(sProvider, destForumNode.getProperty("exo:owner").getString());
        Message message = new Message();
        String headerSubject = "";
        String objectName = "[" + destForumNode.getParent().getProperty("exo:name").getString() + "][" + destForumNode.getProperty("exo:name").getString() + "] " + topicName;
        try {
            Node node = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
            if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        link = link.replaceFirst("pathId", destTopicNode.getProperty("exo:id").getString());
        for (int i = 0; i < posts.size(); ++i) {
            message = new Message();
            message.setMimeType("text/html");
            message.setFrom(forumOwner.getFullName() + "<" + forumOwner.getEmail() + ">");
            message.setSubject(headerSubject + objectName);
            message.setBody(mailContent.replace("$postContent_", posts.get(i).getMessage()).replace("$topicName_", topicName).replace("$link_", link));
            this.sendEmailNotification(Arrays.asList(this.getUserProfileManagement(sProvider, posts.get(i).getOwner()).getEmail()), message);
        }
    }

    public Poll getPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Node CategoryNode = forumHomeNode.getNode(categoryId);
        try {
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            if (!topicNode.hasNode(pollId)) {
                return null;
            }
            Node pollNode = topicNode.getNode(pollId);
            Poll pollNew = new Poll();
            pollNew.setId(pollId);
            if (pollNode.hasProperty("exo:owner")) {
                pollNew.setOwner(pollNode.getProperty("exo:owner").getString());
            }
            if (pollNode.hasProperty("exo:createdDate")) {
                pollNew.setCreatedDate(pollNode.getProperty("exo:createdDate").getDate().getTime());
            }
            if (pollNode.hasProperty("exo:modifiedBy")) {
                pollNew.setModifiedBy(pollNode.getProperty("exo:modifiedBy").getString());
            }
            if (pollNode.hasProperty("exo:modifiedDate")) {
                pollNew.setModifiedDate(pollNode.getProperty("exo:modifiedDate").getDate().getTime());
            }
            if (pollNode.hasProperty("exo:timeOut")) {
                pollNew.setTimeOut(pollNode.getProperty("exo:timeOut").getLong());
            }
            if (pollNode.hasProperty("exo:question")) {
                pollNew.setQuestion(pollNode.getProperty("exo:question").getString());
            }
            if (pollNode.hasProperty("exo:option")) {
                pollNew.setOption(this.ValuesToArray(pollNode.getProperty("exo:option").getValues()));
            }
            if (pollNode.hasProperty("exo:vote")) {
                pollNew.setVote(this.ValuesToArray(pollNode.getProperty("exo:vote").getValues()));
            }
            if (pollNode.hasProperty("exo:userVote")) {
                pollNew.setUserVote(this.ValuesToArray(pollNode.getProperty("exo:userVote").getValues()));
            }
            if (pollNode.hasProperty("exo:isMultiCheck")) {
                pollNew.setIsMultiCheck(pollNode.getProperty("exo:isMultiCheck").getBoolean());
            }
            if (pollNode.hasProperty("exo:isAgainVote")) {
                pollNew.setIsAgainVote(pollNode.getProperty("exo:isAgainVote").getBoolean());
            }
            if (pollNode.hasProperty("exo:isClosed")) {
                pollNew.setIsClosed(pollNode.getProperty("exo:isClosed").getBoolean());
            }
            return pollNew;
        }
        catch (PathNotFoundException e) {
            try {
                return null;
            }
            catch (PathNotFoundException e2) {
                return null;
            }
        }
    }

    public Poll removePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Poll poll = new Poll();
        try {
            Node CategoryNode = forumHomeNode.getNode(categoryId);
            try {
                poll = this.getPoll(sProvider, categoryId, forumId, topicId);
                Node forumNode = CategoryNode.getNode(forumId);
                Node topicNode = forumNode.getNode(topicId);
                String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
                topicNode.getNode(pollId).remove();
                topicNode.setProperty("exo:isPoll", false);
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
                return poll;
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public void savePoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        block11: {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            try {
                Node CategoryNode = forumHomeNode.getNode(categoryId);
                try {
                    Node forumNode = CategoryNode.getNode(forumId);
                    Node topicNode = forumNode.getNode(topicId);
                    String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
                    if (isVote) {
                        Node pollNode = topicNode.getNode(pollId);
                        pollNode.setProperty("exo:vote", poll.getVote());
                        pollNode.setProperty("exo:userVote", poll.getUserVote());
                    } else {
                        Node pollNode;
                        if (isNew) {
                            pollNode = topicNode.addNode(pollId, "exo:poll");
                            pollNode.setProperty("exo:id", pollId);
                            pollNode.setProperty("exo:owner", poll.getOwner());
                            pollNode.setProperty("exo:userVote", new String[0]);
                            pollNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                            pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                            topicNode.setProperty("exo:isPoll", true);
                        } else {
                            pollNode = topicNode.getNode(pollId);
                        }
                        if (poll.getUserVote().length > 0) {
                            pollNode.setProperty("exo:userVote", poll.getUserVote());
                        }
                        pollNode.setProperty("exo:vote", poll.getVote());
                        pollNode.setProperty("exo:modifiedBy", poll.getModifiedBy());
                        if (poll.getTimeOut() == 0L) {
                            pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                        }
                        pollNode.setProperty("exo:timeOut", poll.getTimeOut());
                        pollNode.setProperty("exo:question", poll.getQuestion());
                        pollNode.setProperty("exo:option", poll.getOption());
                        pollNode.setProperty("exo:isMultiCheck", poll.getIsMultiCheck());
                        pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                        pollNode.setProperty("exo:isAgainVote", poll.getIsAgainVote());
                    }
                    if (topicNode.isNew()) {
                        topicNode.getSession().save();
                        break block11;
                    }
                    topicNode.save();
                }
                catch (PathNotFoundException e) {}
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void setClosedPoll(SessionProvider sProvider, String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node topicNode = forumHomeNode.getNode(categoryId + "/" + forumId + "/" + topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            if (topicNode.hasNode(pollId)) {
                Node pollNode = topicNode.getNode(pollId);
                pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                if (poll.getTimeOut() == 0L) {
                    pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                    pollNode.setProperty("exo:timeOut", 0L);
                }
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addTopicInTag(SessionProvider sProvider, String tagId, String topicPath) throws Exception {
        Node topicNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(topicPath);
        if (topicNode.hasProperty("exo:tagId")) {
            String[] oldTagsId = this.ValuesToArray(topicNode.getProperty("exo:tagId").getValues());
            ArrayList<String> list = new ArrayList<String>();
            for (String string : oldTagsId) {
                list.add(string);
            }
            list.add(tagId);
            topicNode.setProperty("exo:tagId", JCRDataStorage.getStringsInList(list));
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
        }
    }

    public void removeTopicInTag(SessionProvider sProvider, String tagId, String topicPath) throws Exception {
        Node topicNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(topicPath);
        String[] oldTagsId = this.ValuesToArray(topicNode.getProperty("exo:tagId").getValues());
        ArrayList<String> list = new ArrayList<String>();
        for (String string : oldTagsId) {
            if (string.equals(tagId)) continue;
            list.add(string);
        }
        topicNode.setProperty("exo:tagId", JCRDataStorage.getStringsInList(list));
        if (topicNode.isNew()) {
            topicNode.getSession().save();
        } else {
            topicNode.save();
        }
    }

    public Tag getTag(SessionProvider sProvider, String tagId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        try {
            Node tagNode = forumHomeNode.getNode(tagId);
            return this.getTagNode(tagNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public List<Tag> getTags(SessionProvider sProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + forumHomeNode.getPath() + "//element(*,exo:forumTag)");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (iter.hasNext()) {
            Node tagNode = iter.nextNode();
            tags.add(this.getTagNode(tagNode));
        }
        return tags;
    }

    private Tag getTagNode(Node tagNode) throws Exception {
        Tag newTag = new Tag();
        if (tagNode.hasProperty("exo:id")) {
            newTag.setId(tagNode.getProperty("exo:id").getString());
        }
        if (tagNode.hasProperty("exo:owner")) {
            newTag.setOwner(tagNode.getProperty("exo:owner").getString());
        }
        if (tagNode.hasProperty("exo:name")) {
            newTag.setName(tagNode.getProperty("exo:name").getString());
        }
        if (tagNode.hasProperty("exo:description")) {
            newTag.setDescription(tagNode.getProperty("exo:description").getString());
        }
        if (tagNode.hasProperty("exo:color")) {
            newTag.setColor(tagNode.getProperty("exo:color").getString());
        }
        return newTag;
    }

    public List<Tag> getTagsByUser(SessionProvider sProvider, String userName) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String pathQuery = "/jcr:root" + forumHomeNode.getPath() + "//element(*,exo:forumTag)[@exo:owner='" + userName + "']";
        Query query = qm.createQuery(pathQuery, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (iter.hasNext()) {
            Node tagNode = iter.nextNode();
            tags.add(this.getTagNode(tagNode));
        }
        return tags;
    }

    public List<Tag> getTagsByTopic(SessionProvider sProvider, String[] tagIds) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + forumHomeNode.getPath() + "//element(*,exo:forumTag)");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        block0: while (iter.hasNext()) {
            Node tagNode = iter.nextNode();
            String nodeId = tagNode.getName();
            for (String tagId : tagIds) {
                if (!nodeId.equals(tagId)) continue;
                tags.add(this.getTagNode(tagNode));
                continue block0;
            }
        }
        return tags;
    }

    public JCRPageList getTopicsByTag(SessionProvider sProvider, String tagId, String strOrderBy) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuilder builder = new StringBuilder();
        builder.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:topic)[@exo:tagId='").append(tagId).append("']").append(" order by @exo:isSticky descending");
        if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
            builder.append(", @exo:lastPostDate descending");
        } else {
            builder.append(", @exo:").append(strOrderBy);
            if (strOrderBy.indexOf("lastPostDate") < 0) {
                builder.append(", @exo:lastPostDate descending");
            }
        }
        String pathQuery = builder.toString();
        Query query = qm.createQuery(pathQuery, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ForumPageList pagelist = new ForumPageList(iter, 10L, pathQuery, true);
        return pagelist;
    }

    public void saveTag(SessionProvider sProvider, Tag newTag, boolean isNew) throws Exception {
        Node newTagNode;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        if (isNew) {
            newTagNode = forumHomeNode.addNode(newTag.getId(), "exo:forumTag");
            newTagNode.setProperty("exo:id", newTag.getId());
            newTagNode.setProperty("exo:owner", newTag.getOwner());
        } else {
            newTagNode = forumHomeNode.getNode(newTag.getId());
        }
        newTagNode.setProperty("exo:name", newTag.getName());
        newTagNode.setProperty("exo:description", newTag.getDescription());
        newTagNode.setProperty("exo:color", newTag.getColor());
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    public void removeTag(SessionProvider sProvider, String tagId) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        forumHomeNode.getNode(tagId).remove();
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    public JCRPageList getPageListUserProfile(SessionProvider sProvider) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        NodeIterator iterator = userProfileNode.getNodes();
        ForumPageList pageList = new ForumPageList(iterator, 10L, userProfileNode.getPath(), false);
        return pageList;
    }

    public JCRPageList searchUserProfile(SessionProvider sessionProvider, String userSearch) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sessionProvider);
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(userProfileNode.getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append("[(jcr:contains(., '").append(userSearch).append("'))]");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ForumPageList pagelist = new ForumPageList(iter, 10L, stringBuffer.toString(), true);
        return pagelist;
    }

    public UserProfile getDefaultUserProfile(SessionProvider sProvider, String userName, String ip) throws Exception {
        String[] array;
        String str;
        Value[] values;
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
        userProfile.setUserId(userName);
        if (this.isAdminRole(userName)) {
            userProfile.setUserRole(0L);
        } else {
            userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
        }
        userProfile.setModerateForums(this.ValuesToArray(profileNode.getProperty("exo:moderateForums").getValues()));
        userProfile.setNewMessage(profileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
        userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
        userProfile.setIsBanned(profileNode.getProperty("exo:isBanned").getBoolean());
        userProfile.setEmail(profileNode.getProperty("exo:email").getString());
        for (Value vl : values = profileNode.getProperty("exo:readTopic").getValues()) {
            str = vl.getString();
            if (str.indexOf(":") <= 0) continue;
            array = str.split(":");
            userProfile.setLastTimeAccessTopic(array[0], Long.parseLong(array[1]));
        }
        for (Value vl : values = profileNode.getProperty("exo:readForum").getValues()) {
            str = vl.getString();
            if (str.indexOf(":") <= 0) continue;
            array = str.split(":");
            userProfile.setLastTimeAccessForum(array[0], Long.parseLong(array[1]));
        }
        if (userProfile.getIsBanned()) {
            if (profileNode.hasProperty("exo:banUntil")) {
                userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
                if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                    profileNode.setProperty("exo:isBanned", false);
                    profileNode.save();
                }
            }
        } else if (ip != null) {
            userProfile.setIsBanned(this.isBanIp(ip));
        }
        return userProfile;
    }

    private boolean isBanIp(String ip) throws Exception {
        List<String> banList = this.getBanList();
        return banList.contains(ip);
    }

    public UserProfile getUserSettingProfile(SessionProvider sProvider, String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
        userProfile.setUserId(userName);
        userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
        userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
        userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
        userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
        userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
        userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
        return userProfile;
    }

    public void saveUserSettingProfile(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
        profileNode.setProperty("exo:userTitle", userProfile.getUserTitle());
        profileNode.setProperty("exo:signature", userProfile.getSignature());
        profileNode.setProperty("exo:isDisplaySignature", userProfile.getIsDisplaySignature());
        profileNode.setProperty("exo:isDisplayAvatar", userProfile.getIsDisplayAvatar());
        profileNode.setProperty("exo:userRole", userProfile.getUserRole().longValue());
        profileNode.setProperty("exo:timeZone", userProfile.getTimeZone());
        profileNode.setProperty("exo:shortDateformat", userProfile.getShortDateFormat());
        profileNode.setProperty("exo:longDateformat", userProfile.getLongDateFormat());
        profileNode.setProperty("exo:timeFormat", userProfile.getTimeFormat());
        profileNode.setProperty("exo:maxPost", userProfile.getMaxPostInPage().longValue());
        profileNode.setProperty("exo:maxTopic", userProfile.getMaxTopicInPage().longValue());
        profileNode.setProperty("exo:isShowForumJump", userProfile.getIsShowForumJump());
        profileNode.setProperty("exo:isAutoWatchMyTopics", userProfile.getIsAutoWatchMyTopics());
        profileNode.setProperty("exo:isAutoWatchTopicIPost", userProfile.getIsAutoWatchTopicIPost());
        profileNode.save();
    }

    public UserProfile getUserInfo(SessionProvider sProvider, String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        Node userProfileNode = this.getUserProfileHome(sProvider);
        String title = "";
        try {
            Node newProfileNode = userProfileNode.getNode(userName);
            userProfile.setUserId(userName);
            if (newProfileNode.hasProperty("exo:userTitle")) {
                title = newProfileNode.getProperty("exo:userTitle").getString();
            }
            if (userProfileNode.hasProperty("exo:fullName")) {
                userProfile.setFullName(userProfileNode.getProperty("exo:fullName").getString());
            }
            if (userProfileNode.hasProperty("exo:firstName")) {
                userProfile.setFirstName(userProfileNode.getProperty("exo:firstName").getString());
            }
            if (userProfileNode.hasProperty("exo:lastName")) {
                userProfile.setLastName(userProfileNode.getProperty("exo:lastName").getString());
            }
            if (userProfileNode.hasProperty("exo:email")) {
                userProfile.setEmail(userProfileNode.getProperty("exo:email").getString());
            }
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
            } else if (newProfileNode.hasProperty("exo:userRole")) {
                userProfile.setUserRole(newProfileNode.getProperty("exo:userRole").getLong());
            }
            userProfile.setUserTitle(title);
            if (newProfileNode.hasProperty("exo:signature")) {
                userProfile.setSignature(newProfileNode.getProperty("exo:signature").getString());
            }
            if (newProfileNode.hasProperty("exo:totalPost")) {
                userProfile.setTotalPost(newProfileNode.getProperty("exo:totalPost").getLong());
            }
            if (newProfileNode.hasProperty("exo:totalTopic")) {
                userProfile.setTotalTopic(newProfileNode.getProperty("exo:totalTopic").getLong());
            }
            if (newProfileNode.hasProperty("exo:bookmark")) {
                userProfile.setBookmark(this.ValuesToArray(newProfileNode.getProperty("exo:bookmark").getValues()));
            }
            if (newProfileNode.hasProperty("exo:lastLoginDate")) {
                userProfile.setLastLoginDate(newProfileNode.getProperty("exo:lastLoginDate").getDate().getTime());
            }
            if (newProfileNode.hasProperty("exo:joinedDate")) {
                userProfile.setJoinedDate(newProfileNode.getProperty("exo:joinedDate").getDate().getTime());
            }
            if (newProfileNode.hasProperty("exo:lastPostDate")) {
                userProfile.setLastPostDate(newProfileNode.getProperty("exo:lastPostDate").getDate().getTime());
            }
            if (newProfileNode.hasProperty("exo:isDisplaySignature")) {
                userProfile.setIsDisplaySignature(newProfileNode.getProperty("exo:isDisplaySignature").getBoolean());
            }
            if (newProfileNode.hasProperty("exo:isDisplayAvatar")) {
                userProfile.setIsDisplayAvatar(newProfileNode.getProperty("exo:isDisplayAvatar").getBoolean());
            }
            return userProfile;
        }
        catch (PathNotFoundException e) {
            userProfile.setUserId(userName);
            userProfile.setUserTitle(Utils.USER);
            userProfile.setUserRole(2L);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(sProvider, userProfile, false, false);
            }
            return userProfile;
        }
    }

    public List<UserProfile> getQuickProfiles(SessionProvider sProvider, List<String> userList) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        ArrayList<UserProfile> profiles = new ArrayList<UserProfile>();
        for (String userName : userList) {
            Node profileNode = userProfileHome.getNode(userName);
            UserProfile userProfile = new UserProfile();
            userProfile.setUserId(userName);
            userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
            userProfile.setJoinedDate(profileNode.getProperty("exo:joinedDate").getDate().getTime());
            userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
            userProfile.setTotalPost(profileNode.getProperty("exo:totalPost").getLong());
            userProfile.setLastPostDate(profileNode.getProperty("exo:lastPostDate").getDate().getTime());
            userProfile.setLastLoginDate(profileNode.getProperty("exo:lastLoginDate").getDate().getTime());
            userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
            if (userProfile.getIsDisplaySignature()) {
                userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
            }
            profiles.add(userProfile);
        }
        return profiles;
    }

    public UserProfile getQuickProfile(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileHome.getNode(userName);
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userName);
        userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
        userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
        userProfile.setJoinedDate(profileNode.getProperty("exo:joinedDate").getDate().getTime());
        userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setTotalPost(profileNode.getProperty("exo:totalPost").getLong());
        userProfile.setLastPostDate(profileNode.getProperty("exo:lastPostDate").getDate().getTime());
        userProfile.setLastLoginDate(profileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
        if (userProfile.getIsDisplaySignature()) {
            userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
        }
        return userProfile;
    }

    public UserProfile getUserInformations(SessionProvider sProvider, UserProfile userProfile) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileHome.getNode(userProfile.getUserId());
        userProfile.setFirstName(profileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(profileNode.getProperty("exo:lastName").getString());
        userProfile.setFullName(profileNode.getProperty("exo:fullName").getString());
        userProfile.setEmail(profileNode.getProperty("exo:email").getString());
        return userProfile;
    }

    public void saveUserProfile(SessionProvider sProvider, UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        String userName = newUserProfile.getUserId();
        if (userName != null && userName.length() > 0) {
            Node newProfileNode;
            block12: {
                try {
                    newProfileNode = userProfileNode.getNode(userName);
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileNode.addNode(userName, Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", userName);
                    newProfileNode.setProperty("exo:totalPost", 0L);
                    newProfileNode.setProperty("exo:totalTopic", 0L);
                    newProfileNode.setProperty("exo:readTopic", new String[0]);
                    newProfileNode.setProperty("exo:readForum", new String[0]);
                    if (newUserProfile.getUserRole() >= 2L) {
                        newUserProfile.setUserRole(2L);
                    }
                    if (!this.isAdminRole(userName)) break block12;
                    newUserProfile.setUserTitle(Utils.ADMIN);
                }
            }
            newProfileNode.setProperty("exo:userRole", newUserProfile.getUserRole().longValue());
            newProfileNode.setProperty("exo:userTitle", newUserProfile.getUserTitle());
            newProfileNode.setProperty("exo:signature", newUserProfile.getSignature());
            newProfileNode.setProperty("exo:isAutoWatchMyTopics", newUserProfile.getIsAutoWatchMyTopics());
            newProfileNode.setProperty("exo:isAutoWatchTopicIPost", newUserProfile.getIsAutoWatchTopicIPost());
            newProfileNode.setProperty("exo:moderateForums", newUserProfile.getModerateForums());
            Calendar calendar = this.getGreenwichMeanTime();
            if (newUserProfile.getLastLoginDate() != null) {
                calendar.setTime(newUserProfile.getLastLoginDate());
            }
            newProfileNode.setProperty("exo:lastLoginDate", calendar);
            newProfileNode.setProperty("exo:isDisplaySignature", newUserProfile.getIsDisplaySignature());
            newProfileNode.setProperty("exo:isDisplayAvatar", newUserProfile.getIsDisplayAvatar());
            if (isOption) {
                newProfileNode.setProperty("exo:timeZone", newUserProfile.getTimeZone());
                newProfileNode.setProperty("exo:shortDateformat", newUserProfile.getShortDateFormat());
                newProfileNode.setProperty("exo:longDateformat", newUserProfile.getLongDateFormat());
                newProfileNode.setProperty("exo:timeFormat", newUserProfile.getTimeFormat());
                newProfileNode.setProperty("exo:maxPost", newUserProfile.getMaxPostInPage().longValue());
                newProfileNode.setProperty("exo:maxTopic", newUserProfile.getMaxTopicInPage().longValue());
                newProfileNode.setProperty("exo:isShowForumJump", newUserProfile.getIsShowForumJump());
            }
            if (isBan) {
                if (newProfileNode.hasProperty("exo:isBanned")) {
                    if (!newProfileNode.getProperty("exo:isBanned").getBoolean() && newUserProfile.getIsBanned()) {
                        newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                    }
                } else {
                    newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                }
                newProfileNode.setProperty("exo:isBanned", newUserProfile.getIsBanned());
                newProfileNode.setProperty("exo:banUntil", newUserProfile.getBanUntil().longValue());
                newProfileNode.setProperty("exo:banReason", newUserProfile.getBanReason());
                newProfileNode.setProperty("exo:banCounter", "" + newUserProfile.getBanCounter());
                newProfileNode.setProperty("exo:banReasonSummary", newUserProfile.getBanReasonSummary());
            }
            if (userProfileNode.isNew()) {
                userProfileNode.getSession().save();
            } else {
                userProfileNode.save();
            }
        }
    }

    public UserProfile getUserProfileManagement(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node userProfileNode = userProfileHome.getNode(userName);
        return this.getUserProfile(userProfileNode);
    }

    private UserProfile getUserProfile(Node userProfileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userProfileNode.getName());
        userProfile.setUserTitle(userProfileNode.getProperty("exo:userTitle").getString());
        userProfile.setFullName(userProfileNode.getProperty("exo:fullName").getString());
        userProfile.setFirstName(userProfileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(userProfileNode.getProperty("exo:lastName").getString());
        userProfile.setEmail(userProfileNode.getProperty("exo:email").getString());
        userProfile.setUserRole(userProfileNode.getProperty("exo:userRole").getLong());
        userProfile.setSignature(userProfileNode.getProperty("exo:signature").getString());
        userProfile.setTotalPost(userProfileNode.getProperty("exo:totalPost").getLong());
        userProfile.setTotalTopic(userProfileNode.getProperty("exo:totalTopic").getLong());
        userProfile.setModerateForums(this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues()));
        if (userProfileNode.hasProperty("exo:lastLoginDate")) {
            userProfile.setLastLoginDate(userProfileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:joinedDate")) {
            userProfile.setJoinedDate(userProfileNode.getProperty("exo:joinedDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:lastPostDate")) {
            userProfile.setLastPostDate(userProfileNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        userProfile.setIsDisplaySignature(userProfileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(userProfileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setNewMessage(userProfileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(userProfileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(userProfileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(userProfileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(userProfileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(userProfileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(userProfileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(userProfileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsBanned(userProfileNode.getProperty("exo:isBanned").getBoolean());
        if (userProfileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(userProfileNode.getProperty("exo:banUntil").getLong());
        }
        if (userProfileNode.hasProperty("exo:banReason")) {
            userProfile.setBanReason(userProfileNode.getProperty("exo:banReason").getString());
        }
        if (userProfileNode.hasProperty("exo:banCounter")) {
            userProfile.setBanCounter(Integer.parseInt(userProfileNode.getProperty("exo:banCounter").getString()));
        }
        if (userProfileNode.hasProperty("exo:banReasonSummary")) {
            userProfile.setBanReasonSummary(this.ValuesToArray(userProfileNode.getProperty("exo:banReasonSummary").getValues()));
        }
        if (userProfileNode.hasProperty("exo:createdDateBan")) {
            userProfile.setCreatedDateBan(userProfileNode.getProperty("exo:createdDateBan").getDate().getTime());
        }
        return userProfile;
    }

    public void saveUserBookmark(SessionProvider sProvider, String userName, String bookMark, boolean isNew) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = userProfileNode.getNode(userName);
            if (newProfileNode.hasProperty("exo:bookmark")) {
                List<String> listOld = this.ValuesToList(newProfileNode.getProperty("exo:bookmark").getValues());
                ArrayList<String> listNew = new ArrayList<String>();
                String pathNew = bookMark.substring(bookMark.lastIndexOf("//") + 1);
                String pathOld = "";
                boolean isAdd = true;
                for (String string : listOld) {
                    pathOld = string.substring(string.lastIndexOf("//") + 1);
                    if (pathNew.equals(pathOld)) {
                        if (isNew) {
                            listNew.add(bookMark);
                        }
                        isAdd = false;
                        continue;
                    }
                    listNew.add(string);
                }
                if (isAdd) {
                    listNew.add(bookMark);
                }
                String[] bookMarks = listNew.toArray(new String[0]);
                newProfileNode.setProperty("exo:bookmark", bookMarks);
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            } else {
                newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            Node newProfileNode = userProfileNode.addNode(userName, Utils.USER_PROFILES_TYPE);
            newProfileNode.setProperty("exo:userId", userName);
            newProfileNode.setProperty("exo:userTitle", Utils.USER);
            if (this.isAdminRole(userName)) {
                newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
            }
            newProfileNode.setProperty("exo:userRole", 2L);
            newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
            if (newProfileNode.isNew()) {
                newProfileNode.getSession().save();
            }
            newProfileNode.save();
        }
    }

    public void saveReadMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileNode.getNode(userName);
        long totalNewMessage = 0L;
        boolean isNew = false;
        try {
            Node messageNode = profileNode.getNode(messageId);
            if (messageNode.hasProperty("exo:isUnread")) {
                isNew = messageNode.getProperty("exo:isUnread").getBoolean();
            }
            if (isNew) {
                messageNode.setProperty("exo:isUnread", false);
            }
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        if (type.equals(Utils.RECEIVE_MESSAGE) && isNew && profileNode.hasProperty("exo:newMessage") && (totalNewMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
            profileNode.setProperty("exo:newMessage", totalNewMessage - 1L);
        }
        if (isNew) {
            if (userProfileNode.isNew()) {
                userProfileNode.getSession().save();
            } else {
                userProfileNode.save();
            }
        }
    }

    public JCRPageList getPrivateMessage(SessionProvider sProvider, String userName, String type) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            QueryManager qm = profileNode.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + profileNode.getPath() + "//element(*,exo:privateMessage)[@exo:type='" + type + "'] order by @exo:receivedDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10L, pathQuery, true);
            return pagelist;
        }
        catch (PathNotFoundException e) {
            e.fillInStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewPrivateMessage(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (!profileNode.getProperty("exo:isBanned").getBoolean()) {
                long l = profileNode.getProperty("exo:newMessage").getLong();
                return l;
            }
        }
        catch (PathNotFoundException e) {
            long l = -1L;
            return l;
        }
        finally {
            sProvider.close();
        }
        return -1L;
    }

    public void savePrivateMessage(SessionProvider sProvider, ForumPrivateMessage privateMessage) throws Exception {
        String id;
        List<String> userNames;
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = null;
        Node profileNodeFirst = null;
        Node messageNode = null;
        String sendTo = privateMessage.getSendTo();
        sendTo = sendTo.replaceAll(";", ",");
        String[] strUserNames = sendTo.split(",");
        try {
            userNames = ForumServiceUtils.getUserPermission(strUserNames);
        }
        catch (Exception e) {
            userNames = Arrays.asList(strUserNames);
        }
        String userNameFirst = privateMessage.getFrom();
        try {
            profileNodeFirst = userProfileNode.getNode(userNameFirst);
        }
        catch (PathNotFoundException e) {
            profileNodeFirst = this.addNodeUserProfile(sProvider, userNameFirst);
        }
        long totalMessage = 0L;
        if (profileNodeFirst != null) {
            id = userNameFirst + IdGenerator.generate();
            messageNode = profileNodeFirst.addNode(id, "exo:privateMessage");
            messageNode.setProperty("exo:from", privateMessage.getFrom());
            messageNode.setProperty("exo:sendTo", privateMessage.getSendTo());
            messageNode.setProperty("exo:name", privateMessage.getName());
            messageNode.setProperty("exo:message", privateMessage.getMessage());
            messageNode.setProperty("exo:receivedDate", this.getGreenwichMeanTime());
            messageNode.setProperty("exo:isUnread", true);
            messageNode.setProperty("exo:type", Utils.RECEIVE_MESSAGE);
        }
        for (String userName : userNames) {
            try {
                profileNode = userProfileNode.getNode(userName);
                totalMessage = profileNode.getProperty("exo:newMessage").getLong() + 1L;
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", totalMessage);
            }
            catch (Exception e) {
                profileNode = this.addNodeUserProfile(sProvider, userName);
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", 1L);
            }
        }
        if (messageNode != null) {
            messageNode.setProperty("exo:type", Utils.SEND_MESSAGE);
        }
        if (userProfileNode.isNew()) {
            userProfileNode.getSession().save();
        } else {
            userProfileNode.save();
        }
    }

    private Node addNodeUserProfile(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileNode.addNode(userName, Utils.USER_PROFILES_TYPE);
        profileNode.setProperty("exo:userId", userName);
        profileNode.setProperty("exo:userTitle", Utils.USER);
        if (this.isAdminRole(userName)) {
            profileNode.setProperty("exo:userRole", 0L);
            profileNode.setProperty("exo:userTitle", Utils.ADMIN);
        }
        profileNode.setProperty("exo:userRole", 2L);
        if (userProfileNode.isNew()) {
            userProfileNode.getSession().save();
        } else {
            userProfileNode.save();
        }
        return profileNode;
    }

    public void removePrivateMessage(SessionProvider sProvider, String messageId, String userName, String type) throws Exception {
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileNode.getNode(userName);
        try {
            long totalMessage;
            Node messageNode = profileNode.getNode(messageId);
            if (type.equals(Utils.RECEIVE_MESSAGE) && messageNode.hasProperty("exo:isUnread") && messageNode.getProperty("exo:isUnread").getBoolean() && (totalMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalMessage - 1L);
            }
            messageNode.remove();
            profileNode.save();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
    }

    public ForumStatistic getForumStatistic(SessionProvider sProvider) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ForumStatistic forumStatistic = new ForumStatistic();
        try {
            Node forumStatisticNode = forumHomeNode.getNode(Utils.FORUM_STATISTIC);
            forumStatistic.setPostCount(forumStatisticNode.getProperty("exo:postCount").getLong());
            forumStatistic.setTopicCount(forumStatisticNode.getProperty("exo:topicCount").getLong());
            forumStatistic.setMembersCount(forumStatisticNode.getProperty("exo:membersCount").getLong());
            forumStatistic.setActiveUsers(forumStatisticNode.getProperty("exo:activeUsers").getLong());
            forumStatistic.setNewMembers(forumStatisticNode.getProperty("exo:newMembers").getString());
            forumStatistic.setMostUsersOnline(forumStatisticNode.getProperty("exo:mostUsersOnline").getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        return forumStatistic;
    }

    public void saveForumStatistic(SessionProvider sProvider, ForumStatistic forumStatistic) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Node forumStatisticNode = forumHomeNode.hasNode(Utils.FORUM_STATISTIC) ? forumHomeNode.getNode(Utils.FORUM_STATISTIC) : forumHomeNode.addNode(Utils.FORUM_STATISTIC, "exo:forumStatistic");
        forumStatisticNode.setProperty("exo:postCount", forumStatistic.getPostCount());
        forumStatisticNode.setProperty("exo:topicCount", forumStatistic.getTopicCount());
        forumStatisticNode.setProperty("exo:membersCount", forumStatistic.getMembersCount());
        forumStatisticNode.setProperty("exo:activeUsers", forumStatistic.getActiveUsers());
        forumStatisticNode.setProperty("exo:newMembers", forumStatistic.getNewMembers());
        forumStatisticNode.setProperty("exo:mostUsersOnline", forumStatistic.getMostUsersOnline());
        if (forumStatisticNode.isNew()) {
            forumStatisticNode.getSession().save();
        } else {
            forumStatisticNode.save();
        }
    }

    private String[] ValuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private List<String> ValuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        if (values.length == 1) {
            list.add(values[0].getString());
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list;
    }

    private static String[] getStringsInList(List<String> list) throws Exception {
        return list.toArray(new String[0]);
    }

    private static List<String> combineListToList(List<String> pList, List<String> cList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : pList) {
            if (!cList.contains(string)) continue;
            list.add(string);
        }
        return list;
    }

    public Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public Object getObjectNameByPath(SessionProvider sProvider, String path) throws Exception {
        Object object = new Object();
        try {
            Node myNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            if (path.indexOf(Utils.POST) > 0) {
                Post post = new Post();
                post.setId(myNode.getName());
                post.setPath(path);
                post.setName(myNode.getProperty("exo:name").getString());
                object = post;
            } else if (path.indexOf(Utils.TOPIC) > 0) {
                Topic topic = new Topic();
                topic.setId(myNode.getName());
                topic.setPath(path);
                topic.setTopicName(myNode.getProperty("exo:name").getString());
                object = topic;
            } else if (path.indexOf(Utils.FORUM) > 0 && path.lastIndexOf(Utils.FORUM) > path.indexOf(Utils.CATEGORY)) {
                Forum forum = new Forum();
                forum.setId(myNode.getName());
                forum.setPath(path);
                forum.setForumName(myNode.getProperty("exo:name").getString());
                object = forum;
            } else if (path.indexOf(Utils.CATEGORY) > 0) {
                Category category = new Category();
                category.setId(myNode.getName());
                category.setPath(path);
                category.setCategoryName(myNode.getProperty("exo:name").getString());
                object = category;
            } else if (path.indexOf(Utils.TAG) > 0) {
                Tag tag = new Tag();
                tag.setId(myNode.getName());
                tag.setName(myNode.getProperty("exo:name").getString());
                object = tag;
            } else {
                return null;
            }
            return object;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Object getObjectNameById(SessionProvider sProvider, String id, String type) throws Exception {
        Object object;
        block6: {
            object = new Object();
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:").append(type).append(")[exo:id='").append(id).append("']");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (!iter.hasNext()) break block6;
            Node node = (Node)iter.next();
            if (type.equals(Utils.CATEGORY)) {
                Category category = this.getCategory(node);
                object = category;
            } else if (type.equals(Utils.FORUM)) {
                Forum forum = this.getForum(node);
                object = forum;
            } else if (type.equals(Utils.TOPIC)) {
                Topic topic = this.getTopicNode(node);
                object = topic;
            } else {
                Post post = this.getPost(node);
                object = post;
            }
        }
        return object;
    }

    public List<ForumLinkData> getAllLink(SessionProvider sProvider, String strQueryCate, String strQueryForum) throws Exception {
        ArrayList<ForumLinkData> forumLinks = new ArrayList<ForumLinkData>();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer();
        queryString.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:forumCategory)").append(strQueryCate).append(" order by @exo:categoryOrder ascending, @exo:createdDate ascending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ForumLinkData linkData = new ForumLinkData();
        while (iter.hasNext()) {
            linkData = new ForumLinkData();
            Node cateNode = iter.nextNode();
            linkData.setId(cateNode.getName());
            linkData.setName(cateNode.getProperty("exo:name").getString());
            linkData.setType(Utils.CATEGORY);
            linkData.setPath(cateNode.getName());
            forumLinks.add(linkData);
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(cateNode.getPath()).append("//element(*,exo:forum)").append(strQueryForum).append(" order by @exo:forumOrder ascending,@exo:createdDate ascending");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            NodeIterator iterForum = result.getNodes();
            while (iterForum.hasNext()) {
                linkData = new ForumLinkData();
                Node forumNode = iterForum.nextNode();
                linkData.setId(forumNode.getName());
                linkData.setName(forumNode.getProperty("exo:name").getString());
                linkData.setType(Utils.FORUM);
                linkData.setPath(cateNode.getName() + "/" + forumNode.getName());
                if (forumNode.hasProperty("exo:isLock")) {
                    linkData.setIsLock(forumNode.getProperty("exo:isLock").getBoolean());
                }
                if (forumNode.hasProperty("exo:isClosed")) {
                    linkData.setIsClosed(forumNode.getProperty("exo:isClosed").getBoolean());
                }
                forumLinks.add(linkData);
                NodeIterator iterTopic = forumNode.getNodes();
                while (iterTopic.hasNext()) {
                    linkData = new ForumLinkData();
                    Node topicNode = iterTopic.nextNode();
                    linkData.setId(topicNode.getName());
                    if (topicNode.hasProperty("exo:name")) {
                        linkData.setName(topicNode.getProperty("exo:name").getString());
                    } else {
                        linkData.setName("null");
                    }
                    linkData.setType(Utils.TOPIC);
                    linkData.setPath(cateNode.getName() + "/" + forumNode.getName() + "/" + topicNode.getName());
                    if (topicNode.hasProperty("exo:isLock")) {
                        linkData.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
                    }
                    if (topicNode.hasProperty("exo:isClosed")) {
                        linkData.setIsClosed(topicNode.getProperty("exo:isClosed").getBoolean());
                    }
                    forumLinks.add(linkData);
                }
            }
        }
        return forumLinks;
    }

    public List<ForumSearch> getQuickSearch(SessionProvider sProvider, String textQuery, String type_, String pathQuery, List<String> currentUserInfo) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        if (pathQuery == null || pathQuery.length() <= 0) {
            pathQuery = forumHomeNode.getPath();
        }
        textQuery = StringUtils.replace((String)textQuery, (String)"'", (String)"&apos;");
        String[] values = type_.split(",");
        boolean isAdmin = false;
        if (values[0].equals("true")) {
            isAdmin = true;
        }
        String[] types = new String[]{Utils.CATEGORY, Utils.FORUM, Utils.TOPIC, Utils.POST};
        if (!values[1].equals("all")) {
            types = values[1].split("/");
        }
        boolean isAnd = false;
        for (String type : types) {
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(pathQuery).append("//element(*,exo:").append(type).append(")");
            queryString.append("[");
            if (textQuery != null && textQuery.length() > 0 && !textQuery.equals("null")) {
                queryString.append("(jcr:contains(., '").append(textQuery).append("'))");
                isAnd = true;
            }
            if (!isAdmin) {
                if (type.equals(Utils.FORUM)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("(@exo:isClosed='false'");
                    for (String currentUser : currentUserInfo) {
                        queryString.append(" or @exo:moderators='").append(currentUser).append("'");
                    }
                    queryString.append(")");
                } else if (type.equals(Utils.TOPIC)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("@exo:isClosed='false' and @exo:isApproved='true' and @exo:isActive='true' and @exo:isActiveByForum='true'");
                } else if (type.equals(Utils.POST)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("(@exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true'").append(" and (@exo:userPrivate='exoUserPri'");
                    for (String currentUser : currentUserInfo) {
                        queryString.append(" or @exo:userPrivate='").append(currentUser).append("'");
                    }
                    queryString.append(") and @exo:isFirstPost='false')");
                }
            } else if (type.equals(Utils.POST)) {
                if (isAnd) {
                    queryString.append(" and ");
                }
                queryString.append("(@exo:userPrivate='exoUserPri'");
                for (String currentUser : currentUserInfo) {
                    queryString.append(" or @exo:userPrivate='").append(currentUser).append("'");
                }
                queryString.append(") and @exo:isFirstPost='false'");
            }
            queryString.append("]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                ForumSearch forumSearch = new ForumSearch();
                Node nodeObj = iter.nextNode();
                forumSearch.setId(nodeObj.getName());
                forumSearch.setName(nodeObj.getProperty("exo:name").getString());
                forumSearch.setType(type);
                if (type.equals(Utils.FORUM)) {
                    if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                        forumSearch.setIcon("ForumCloseIcon");
                    } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                        forumSearch.setIcon("ForumLockedIcon");
                    } else {
                        forumSearch.setIcon("ForumNormalIcon");
                    }
                } else if (type.equals(Utils.TOPIC)) {
                    if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                        forumSearch.setIcon("HotThreadNoNewClosePost");
                    } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                        forumSearch.setIcon("HotThreadNoNewLockPost");
                    } else {
                        forumSearch.setIcon("HotThreadNoNewPost");
                    }
                } else if (type.equals(Utils.CATEGORY)) {
                    forumSearch.setIcon("CategoryIcon");
                } else {
                    forumSearch.setIcon(nodeObj.getProperty("exo:icon").getString());
                }
                forumSearch.setType(type);
                forumSearch.setPath(nodeObj.getPath());
                listSearchEvent.add(forumSearch);
            }
        }
        return listSearchEvent;
    }

    public List<ForumSearch> getAdvancedSearch(SessionProvider sProvider, ForumEventQuery eventQuery) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String path = eventQuery.getPath();
        if (path == null || path.length() <= 0) {
            path = forumHomeNode.getPath();
        }
        eventQuery.setPath(path);
        String type = eventQuery.getType();
        String queryString = eventQuery.getPathQuery();
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            ForumSearch forumSearch = new ForumSearch();
            Node nodeObj = iter.nextNode();
            forumSearch.setId(nodeObj.getName());
            forumSearch.setName(nodeObj.getProperty("exo:name").getString());
            forumSearch.setType(type);
            if (type.equals(Utils.FORUM)) {
                if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                    forumSearch.setIcon("ForumCloseIcon");
                } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                    forumSearch.setIcon("ForumLockedIcon");
                } else {
                    forumSearch.setIcon("ForumNormalIcon");
                }
            } else if (type.equals(Utils.TOPIC)) {
                if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                    forumSearch.setIcon("HotThreadNoNewClosePost");
                } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                    forumSearch.setIcon("HotThreadNoNewLockPost");
                } else {
                    forumSearch.setIcon("HotThreadNoNewPost");
                }
            } else if (type.equals(Utils.CATEGORY)) {
                forumSearch.setIcon("CategoryIcon");
            } else {
                forumSearch.setIcon(nodeObj.getProperty("exo:icon").getString());
            }
            forumSearch.setPath(nodeObj.getPath());
            listSearchEvent.add(forumSearch);
        }
        return listSearchEvent;
    }

    public void addWatch(SessionProvider sProvider, int watchType, String path, List<String> values, String currentUser) throws Exception {
        Node watchingNode = null;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        if (path.indexOf(forumHomeNode.getName()) < 0) {
            path = forumHomeNode.getPath() + "/" + path;
        }
        try {
            watchingNode = (Node)forumHomeNode.getSession().getItem(path);
            if (watchingNode.isNodeType("exo:forumWatching")) {
                if (watchType == 1) {
                    ArrayList<String> listEmail = new ArrayList<String>();
                    listEmail.addAll(Arrays.asList(this.ValuesToArray(watchingNode.getProperty("exo:emailWatching").getValues())));
                    ArrayList<String> listUsers = new ArrayList<String>();
                    listUsers.addAll(Arrays.asList(this.ValuesToArray(watchingNode.getProperty("exo:userWatching").getValues())));
                    for (String str : values) {
                        if (listEmail.contains(str)) continue;
                        listEmail.add(0, str);
                        listUsers.add(0, currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(listEmail));
                    watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listUsers));
                }
            } else {
                watchingNode.addMixin("exo:forumWatching");
                if (watchType == 1) {
                    ArrayList<String> listUsers = new ArrayList<String>();
                    for (int i = 0; i < values.size(); ++i) {
                        listUsers.add(currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(values));
                    watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listUsers));
                }
            }
            if (watchingNode.isNew()) {
                watchingNode.getSession().save();
            } else {
                watchingNode.save();
            }
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void removeWatch(SessionProvider sProvider, int watchType, String path, List<String> values) throws Exception {
        Node watchingNode = null;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        String string = forumHomeNode.getPath();
        if (path.indexOf(forumHomeNode.getName()) < 0) {
            path = string + "/" + path;
        }
        try {
            watchingNode = (Node)forumHomeNode.getSession().getItem(path);
            ArrayList<String> newValues = new ArrayList<String>();
            ArrayList<String> listNewUsers = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching") && watchType == 1) {
                String[] strings = this.ValuesToArray(watchingNode.getProperty("exo:emailWatching").getValues());
                String[] listOldUsers = this.ValuesToArray(watchingNode.getProperty("exo:userWatching").getValues());
                for (int i = 0; i < strings.length; ++i) {
                    if (values.contains(strings[i])) continue;
                    newValues.add(strings[i]);
                    listNewUsers.add(listOldUsers[i]);
                }
                watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(newValues));
                watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listNewUsers));
                if (watchingNode.isNew()) {
                    watchingNode.getSession().save();
                } else {
                    watchingNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
    }

    public List<Watch> getWatchByUser(String userId, SessionProvider sessionProvider) throws Exception {
        Node forumHome = this.getForumHomeNode(sessionProvider);
        String rootPath = forumHome.getPath();
        Session sess = forumHome.getSession();
        QueryManager qm = sess.getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer();
        queryString.append("/jcr:root").append(rootPath).append("//element(*,exo:forumWatching)[@exo:userWatching='").append(userId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        ArrayList<Watch> listWaches = new ArrayList<Watch>();
        Watch watch = new Watch();
        Node node = null;
        String[] users = null;
        String[] emails = null;
        String path = null;
        String pathName = "";
        String typeNode = null;
        while (iterator.hasNext()) {
            rootPath = forumHome.getPath();
            pathName = "";
            node = iterator.nextNode();
            users = this.ValuesToArray(node.getProperty("exo:userWatching").getValues());
            emails = this.ValuesToArray(node.getProperty("exo:emailWatching").getValues());
            path = node.getPath();
            typeNode = node.isNodeType("exo:forumCategory") ? "exo:forumCategory" : (node.isNodeType("exo:forum") ? "exo:forum" : "exo:topic");
            for (String str : path.replace(rootPath + "/", "").split("/")) {
                rootPath = rootPath + "/" + str;
                if (pathName.trim().length() > 0) {
                    pathName = pathName + " > ";
                }
                pathName = pathName + ((Node)sess.getItem(rootPath)).getProperty("exo:name").getString();
            }
            for (int i = 0; i < users.length; ++i) {
                if (!users[i].equals(userId)) continue;
                watch = new Watch();
                watch.setId(node.getName());
                watch.setNodePath(path);
                watch.setUserId(userId);
                watch.setEmail(emails[i]);
                watch.setPath(pathName);
                watch.setTypeNode(typeNode);
                listWaches.add(watch);
            }
        }
        return listWaches;
    }

    private void sendEmailNotification(List<String> addresses, Message message) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.SendMailJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            this.messagesInfoMap_.put(name, new SendMessageInfo(addresses, message));
            schedulerService.addPeriodJob(info, periodInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateImportedData(String path) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.UpdateDataJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            JobDataMap jdatamap = new JobDataMap();
            jdatamap.put("path", path);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            schedulerService.addPeriodJob(info, periodInfo, jdatamap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForum(String path) throws Exception {
        HashMap<String, Long> topicMap = new HashMap<String, Long>();
        HashMap<String, Long> postMap = new HashMap<String, Long>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHome = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
        try {
            long l;
            String owner;
            Node node;
            Query query = qm.createQuery("/jcr:root" + path + "//element(*,exo:topic)", "xpath");
            QueryResult result = query.execute();
            NodeIterator topicIter = result.getNodes();
            query = qm.createQuery("/jcr:root" + path + "//element(*,exo:post)", "xpath");
            result = query.execute();
            NodeIterator postIter = result.getNodes();
            Node forumStatisticNode = forumHome.getNode(Utils.FORUM_STATISTIC);
            long count = forumStatisticNode.getProperty("exo:postCount").getLong() + postIter.getSize();
            forumStatisticNode.setProperty("exo:postCount", count);
            count = forumStatisticNode.getProperty("exo:topicCount").getLong() + topicIter.getSize();
            forumStatisticNode.setProperty("exo:topicCount", count);
            forumStatisticNode.save();
            while (topicIter.hasNext()) {
                node = topicIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (topicMap.containsKey(owner)) {
                    l = (Long)topicMap.get(owner) + 1L;
                    topicMap.put(owner, l);
                    continue;
                }
                l = 1L;
                topicMap.put(owner, l);
            }
            while (postIter.hasNext()) {
                node = postIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (postMap.containsKey(owner)) {
                    l = (Long)postMap.get(owner) + 1L;
                    postMap.put(owner, l);
                    continue;
                }
                l = 1L;
                postMap.put(owner, l);
            }
            Node profileHome = this.getUserProfileHome(sProvider);
            for (String userId : topicMap.keySet()) {
                Node profile;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    Calendar cal = this.getGreenwichMeanTime();
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long l2 = profile.getProperty("exo:totalTopic").getLong() + (Long)topicMap.get(userId);
                profile.setProperty("exo:totalTopic", l2);
                if (postMap.containsKey(userId)) {
                    long t = profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                    profile.setProperty("exo:totalPost", t);
                    postMap.remove(userId);
                }
                profileHome.save();
            }
            for (String userId : postMap.keySet()) {
                Node profile;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    Calendar cal = this.getGreenwichMeanTime();
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long t = profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                profileHome.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    public SendMessageInfo getMessageInfo(String name) throws Exception {
        SendMessageInfo messageInfo = this.messagesInfoMap_.get(name);
        this.messagesInfoMap_.remove(name);
        return messageInfo;
    }

    private String getPath(String index, String path) throws Exception {
        int t = path.lastIndexOf(index);
        if (t > 0) {
            path = path.substring(t + 1);
        }
        return path;
    }

    public List<ForumSearch> getJobWattingForModerator(SessionProvider sProvider, String[] paths) throws Exception {
        Node node;
        ForumSearch forumSearch;
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        String string = forumHomeNode.getPath();
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String pathQuery = "";
        StringBuffer buffer = new StringBuffer();
        int l = paths.length;
        if (l > 0) {
            buffer.append(" and (");
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    buffer.append(" or ");
                }
                String str = this.getPath("/" + Utils.FORUM, paths[i]);
                buffer.append("@exo:path='").append(str).append("'");
            }
            buffer.append(")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)").append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("] order by @exo:modifiedDate descending");
        pathQuery = stringBuffer.toString();
        Query query = qm.createQuery(pathQuery, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            forumSearch = new ForumSearch();
            node = (Node)iter.next();
            forumSearch.setId(node.getName());
            forumSearch.setPath(node.getPath());
            forumSearch.setType(Utils.TOPIC);
            forumSearch.setName(node.getProperty("exo:name").getString());
            forumSearch.setContent(node.getProperty("exo:description").getString());
            forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
            list.add(forumSearch);
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)").append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("] order by @exo:modifiedDate descending");
        pathQuery = stringBuffer.toString();
        query = qm.createQuery(pathQuery, "xpath");
        result = query.execute();
        iter = result.getNodes();
        while (iter.hasNext()) {
            forumSearch = new ForumSearch();
            node = (Node)iter.next();
            forumSearch.setId(node.getName());
            forumSearch.setPath(node.getPath());
            forumSearch.setType(Utils.POST);
            forumSearch.setName(node.getProperty("exo:name").getString());
            forumSearch.setContent(node.getProperty("exo:message").getString());
            forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
            list.add(forumSearch);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalJobWattingForModerator(SessionProvider sProvider, String userId) throws Exception {
        try {
            Node newProfileNode = this.getUserProfileHome(sProvider).getNode(userId);
            long t = 3L;
            t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            int totalJob = 0;
            if (t < 2L) {
                String[] paths;
                int l;
                Node forumHomeNode = this.getForumHomeNode(sProvider);
                String string = forumHomeNode.getPath();
                QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
                StringBuffer stringBuffer = new StringBuffer();
                String pathQuery = "";
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)");
                StringBuffer buffer = new StringBuffer();
                if (t > 0L && (l = (paths = this.ValuesToArray(newProfileNode.getProperty("exo:moderateForums").getValues())).length) > 0) {
                    buffer.append(" and (");
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            buffer.append(" or ");
                        }
                        String str = this.getPath("/" + Utils.FORUM, paths[i]);
                        buffer.append("@exo:path='").append(str).append("'");
                    }
                    buffer.append(")");
                }
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("]").toString();
                Query query = qm.createQuery(pathQuery, "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                totalJob = (int)iter.getSize();
                stringBuffer = new StringBuffer();
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)");
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("]").toString();
                query = qm.createQuery(pathQuery, "xpath");
                result = query.execute();
                iter = result.getNodes();
                totalJob += (int)iter.getSize();
            }
            int n = totalJob;
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTotalJobWatting(List<String> userIds) {
        SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
        try {
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            Category cat = new Category();
            ArrayList<String> list = new ArrayList<String>();
            ContinuationService continuation = this.getContinuationService();
            for (String userId : userIds) {
                if (userId.trim().length() == 0 || list.contains(userId)) continue;
                list.add(userId);
                int job = this.getTotalJobWattingForModerator(sProvider, userId);
                if (job < 0) continue;
                cat.setCategoryName(String.valueOf(job));
                JsonValue json = generatorImpl.createJsonObject((Object)cat);
                continuation.sendMessage(userId, "/eXo/Application/Forum/messages", (Object)json, cat.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    public NodeIterator search(String queryString, SessionProvider sessionProvider) throws Exception {
        QueryManager qm = this.getForumHomeNode(sessionProvider).getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public void evaluateActiveUsers(SessionProvider sysProvider, String query) throws Exception {
        try {
            String path = this.getUserProfileHome(sysProvider).getPath();
            StringBuilder stringBuilder = new StringBuilder();
            if (query == null || query.length() == 0) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(calendar.getTimeInMillis() - 864000000L);
                stringBuilder.append("/jcr:root").append(path).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
            } else {
                stringBuilder.append("/jcr:root").append(path).append(query);
            }
            NodeIterator iter = this.search(stringBuilder.toString(), sysProvider);
            Node forumHomeNode = this.getForumHomeNode(sysProvider);
            if (forumHomeNode.hasNode(Utils.FORUM_STATISTIC)) {
                forumHomeNode.getNode(Utils.FORUM_STATISTIC).setProperty("exo:activeUsers", iter.getSize());
                forumHomeNode.save();
            } else {
                ForumStatistic forumStatistic = new ForumStatistic();
                forumStatistic.setActiveUsers(iter.getSize());
                this.saveForumStatistic(sysProvider, forumStatistic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object exportXML(String categoryId, String forumId, String nodePath, ByteArrayOutputStream bos, SessionProvider sessionProvider) throws Exception {
        Session session = null;
        Node homeNode = this.getForumHomeNode(sessionProvider);
        if (categoryId != null) {
            session = forumId != null ? homeNode.getNode(categoryId).getNode(forumId).getSession() : homeNode.getNode(categoryId).getSession();
            session.exportSystemView(nodePath, (OutputStream)bos, false, false);
            session.logout();
            return null;
        }
        ArrayList<File> listFiles = new ArrayList<File>();
        File file = null;
        BufferedWriter writer = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        session = homeNode.getSession();
        for (Category category : this.getCategories(sessionProvider)) {
            outputStream = new ByteArrayOutputStream();
            session.exportSystemView(category.getPath(), (OutputStream)outputStream, false, false);
            file = new File(category.getId() + ".xml");
            file.deleteOnExit();
            file.createNewFile();
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(outputStream.toString());
            ((Writer)writer).close();
            listFiles.add(file);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream("exportCategory.zip"));
        byte[] buffer = new byte[4096];
        FileInputStream inputStream = null;
        ZipEntry zipEntry = null;
        for (File f : listFiles) {
            int byteReads;
            inputStream = new FileInputStream(f);
            zipEntry = new ZipEntry(f.getPath());
            zipOutputStream.putNextEntry(zipEntry);
            while ((byteReads = inputStream.read(buffer)) != -1) {
                zipOutputStream.write(buffer, 0, byteReads);
            }
            inputStream.close();
        }
        zipOutputStream.close();
        file = new File("exportCategory.zip");
        session.logout();
        for (File f : listFiles) {
            f.deleteOnExit();
        }
        return file;
    }

    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport, SessionProvider sessionProvider) throws Exception {
        byte[] bdata = new byte[bis.available()];
        bis.read(bdata);
        ByteArrayInputStream is = new ByteArrayInputStream(bdata);
        Session session = this.getForumHomeNode(sessionProvider).getSession();
        session.importXML(nodePath, (InputStream)is, typeImport);
        session.save();
        Node parentNode = (Node)session.getItem(nodePath);
        if (parentNode.isNodeType("exo:forumHome")) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            is = new ByteArrayInputStream(bdata);
            Document doc = docBuilder.parse(is);
            NodeList list = doc.getChildNodes();
            String name = list.item(0).getAttributes().getNamedItem("sv:name").getTextContent();
            this.updateImportedData(nodePath + "/" + name);
        }
        session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readTopic")) {
                values = this.ValuesToList(profile.getProperty("exo:readTopic").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(topicId) == 0) {
                    values.set(i, topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && ((String)values.get(0)).trim().length() < 1) {
                values.remove(0);
            }
            profile.setProperty("exo:readTopic", values.toArray(new String[0]));
            profile.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForumAccess(String userId, String forumId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readForum")) {
                values = this.ValuesToList(profile.getProperty("exo:readForum").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(forumId) == 0) {
                    values.set(i, forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && ((String)values.get(0)).trim().length() < 1) {
                values.remove(0);
            }
            profile.setProperty("exo:readForum", values.toArray(new String[0]));
            profile.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }

    public List<String> getBookmarks(SessionProvider sProvider, String userName) throws Exception {
        Node profile = this.getUserProfileHome(sProvider).getNode(userName);
        if (profile.hasProperty("exo:bookmark")) {
            return this.ValuesToList(profile.getProperty("exo:bookmark").getValues());
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBanList() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            if (banNode.hasProperty("exo:ips")) {
                List<String> list = this.ValuesToList(banNode.getProperty("exo:ips").getValues());
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBanIP(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            return false;
        }
        ips.add(ip);
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            banNode.setProperty("exo:ips", ips.toArray(new String[0]));
            if (banNode.isNew()) {
                banNode.getSession().save();
            } else {
                banNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBan(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            ips.remove(ip);
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node banNode = this.getForumBanNode(sProvider);
                banNode.setProperty("exo:ips", JCRDataStorage.getStringsInList(ips));
                banNode.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getForumBanList(String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node forumNode;
            if (forumId.indexOf(".") > 0) {
                forumId = StringUtils.replace((String)forumId, (String)".", (String)"/");
            }
            if ((forumNode = this.getForumHomeNode(sProvider).getNode(forumId)).hasProperty("exo:banIPs")) {
                list.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getForumHomeNode(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                boolean bl = false;
                return bl;
            }
            ips.add(ip);
            forumNode.setProperty("exo:banIPs", JCRDataStorage.getStringsInList(ips));
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBanIPForum(SessionProvider sProvider, String ip, String forumId) throws Exception {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getForumHomeNode(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                ips.remove(ip);
                forumNode.setProperty("exo:banIPs", JCRDataStorage.getStringsInList(ips));
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private List<String> getAllAdministrator(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder();
        pathQuery.append("/jcr:root").append(this.getUserProfileHome(sProvider).getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[@exo:userRole=0]");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Node userNode = (Node)iter.next();
            list.add(userNode.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            long count;
            Node forumHomeNode = this.getForumHomeNode(sysProvider);
            Node forumStatisticNode = forumHomeNode.getNode(Utils.FORUM_STATISTIC);
            if (topicCount != 0L) {
                count = forumStatisticNode.getProperty("exo:topicCount").getLong() + topicCount;
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:topicCount", count);
            }
            if (postCount != 0L) {
                count = forumStatisticNode.getProperty("exo:postCount").getLong() + postCount;
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:postCount", count);
            }
            forumStatisticNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatisticCounts1(String absPath) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sysProvider);
            Node forumStatisticNode = forumHomeNode.getNode(Utils.FORUM_STATISTIC);
            forumStatisticNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }
}

