/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    public NewUserListener(InitParams params) throws Exception {
    }

    public void postSave(User user, boolean isNew) throws Exception {
        ForumService fservice = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (isNew) {
            try {
                ForumStatistic statistic = fservice.getForumStatistic();
                statistic.setNewMembers(user.getUserName());
                statistic.setMembersCount(statistic.getMembersCount() + 1L);
                fservice.saveForumStatistic(statistic);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                fservice.createUserProfile(user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            fservice.updateUserProfile(user);
        }
    }

    public void postDelete(User user) throws Exception {
        ForumService fservice = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        try {
            fservice.removeProfile(user.getUserName());
            ForumStatistic statistic = fservice.getForumStatistic();
            if (user.getUserName().equals(statistic.getNewMembers())) {
                fservice.updateForumStatistic();
            } else {
                statistic.setMembersCount(statistic.getMembersCount() - 1L);
                fservice.saveForumStatistic(statistic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

