/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.CalculateModeratorEventListener;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.EmailNotifyPlugin;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRForumAttachment;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SortSettings;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicListAccess;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.CategoryData;
import org.exoplatform.forum.service.conf.CategoryEventListener;
import org.exoplatform.forum.service.conf.ForumData;
import org.exoplatform.forum.service.conf.InitializeForumPlugin;
import org.exoplatform.forum.service.conf.PostData;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.conf.StatisticEventListener;
import org.exoplatform.forum.service.conf.TopicData;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.ListAccess;
import org.exoplatform.ks.common.bbcode.BBCodeOperator;
import org.exoplatform.ks.common.bbcode.InitBBCodePlugin;
import org.exoplatform.ks.common.conf.InitialRSSListener;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.rss.ForumRSSEventListener;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.quartz.JobDataMap;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="storage")})
@ManagedDescription(value="Data Storage for this forum")
public class JCRDataStorage {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService rService_;
    private static final String KS_USER_AVATAR = "ksUserAvatar".intern();
    Map<String, String> serverConfig_ = new HashMap<String, String>();
    Map<String, Object> infoMap_ = new HashMap<String, Object>();
    List<RoleRulesPlugin> rulesPlugins_ = new ArrayList<RoleRulesPlugin>();
    List<InitializeForumPlugin> defaultPlugins_ = new ArrayList<InitializeForumPlugin>();
    List<InitBBCodePlugin> defaultBBCodePlugins_ = new ArrayList<InitBBCodePlugin>();
    Map<String, EventListener> listeners_ = new HashMap<String, EventListener>();
    private boolean isInitRssListener_ = true;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rService) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.rService_ = rService;
    }

    public JCRDataStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="repository for forum storage")
    public String getRepository() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String string = ((RepositoryImpl)this.getForumHomeNode(sProvider).getSession().getRepository()).getName();
            return string;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="workspace for the forum storage")
    public String getWorkspace() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String string = this.getForumHomeNode(sProvider).getSession().getWorkspace().getName();
            return string;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="data path for forum storage")
    public String getPath() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String string = this.getForumHomeNode(sProvider).getPath();
            return string;
        }
        finally {
            sProvider.close();
        }
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            if (plugin instanceof EmailNotifyPlugin) {
                this.serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add plugin ", (Throwable)e);
        }
    }

    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof RoleRulesPlugin) {
            this.rulesPlugins_.add((RoleRulesPlugin)plugin);
        }
    }

    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitializeForumPlugin) {
            this.defaultPlugins_.add((InitializeForumPlugin)plugin);
        }
    }

    public void addInitRssPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitialRSSListener) {
            this.isInitRssListener_ = ((InitialRSSListener)plugin).isInitRssListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRSSEventListenner() throws Exception {
        if (!this.isInitRssListener_) {
            return;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        try {
            ObservationManager observation = categoryHome.getSession().getWorkspace().getObservationManager();
            String wsName = categoryHome.getSession().getWorkspace().getName();
            String repoName = ((RepositoryImpl)categoryHome.getSession().getRepository()).getName();
            ForumRSSEventListener forumRSSListener = new ForumRSSEventListener(this.nodeHierarchyCreator_, wsName, repoName);
            observation.addEventListener((EventListener)forumRSSListener, 19, categoryHome.getPath(), true, null, null, false);
        }
        catch (Exception e) {
            log.error((Object)"Failed to add rss event listenner ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalculateModeratorEventListenner() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        try {
            NodeIterator iter = categoryHome.getNodes();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                if (!catNode.isNodeType("exo:forumCategory")) continue;
                this.addModeratorCalculateListener(catNode);
                NodeIterator iter1 = catNode.getNodes();
                while (iter1.hasNext()) {
                    Node forumNode = iter1.nextNode();
                    if (!forumNode.isNodeType("exo:forum")) continue;
                    this.addModeratorCalculateListener(forumNode);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add calculate moderator event listenner ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    protected void addModeratorCalculateListener(Node node) throws Exception {
        try {
            String path = node.getPath();
            ObservationManager observation = node.getSession().getWorkspace().getObservationManager();
            CalculateModeratorEventListener moderatorListener = new CalculateModeratorEventListener(this.nodeHierarchyCreator_);
            moderatorListener.setPath(path);
            observation.addEventListener((EventListener)moderatorListener, 28, path, false, null, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCategoryListener() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        this.listeners_.clear();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            ObservationManager observation = categoryHome.getSession().getWorkspace().getObservationManager();
            String wsName = categoryHome.getSession().getWorkspace().getName();
            String repoName = ((RepositoryImpl)categoryHome.getSession().getRepository()).getName();
            if (!this.listeners_.containsKey(categoryHome.getPath())) {
                CategoryEventListener categoryListener = new CategoryEventListener(wsName, repoName);
                observation.addEventListener((EventListener)categoryListener, 3, categoryHome.getPath(), false, null, null, false);
                this.listeners_.put(categoryHome.getPath(), categoryListener);
            }
            NodeIterator iter = categoryHome.getNodes();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                if (this.listeners_.containsKey(catNode.getPath())) continue;
                StatisticEventListener sListener = new StatisticEventListener(wsName, repoName);
                observation.addEventListener((EventListener)sListener, 3, catNode.getPath(), true, null, null, false);
                this.listeners_.put(catNode.getPath(), sListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAutoPruneSchedules() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHNode.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHNode.getPath()).append("//element(*,exo:pruneSetting) [@exo:isActive = 'true']");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                this.addOrRemoveSchedule(this.getPruneSetting(iter.nextNode()));
            }
        }
        finally {
            sProvider.close();
        }
    }

    public boolean isAdminRole(String userName) throws Exception {
        try {
            String[] adminrules = new String[]{};
            for (int i = 0; i < this.rulesPlugins_.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(this.rulesPlugins_.get(i).getRules(Utils.ADMIN_ROLE));
                if (list.contains(userName)) {
                    return true;
                }
                adminrules = JCRDataStorage.getStringsInList(list);
                if (!ForumServiceUtils.hasPermission(adminrules, userName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        Node tmpNode = this.nodeHierarchyCreator_.getPublicApplicationNode(SessionProvider.createSystemProvider());
        Session session = sProvider.getSession(this.rService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.rService_.getCurrentRepository());
        Node appNode = (Node)session.getItem(tmpNode.getPath());
        try {
            return appNode.getNode(CommonUtils.FORUM_SERVICE);
        }
        catch (PathNotFoundException e) {
            Node forumHomeNode = appNode.addNode(CommonUtils.FORUM_SERVICE, "exo:forumHome");
            return forumHomeNode;
        }
    }

    private Node getTopicTypeHome(SessionProvider sProvider) throws Exception {
        try {
            return this.getForumDataHome(sProvider).getNode(Utils.TOPIC_TYPE_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumDataHome(sProvider).addNode(Utils.TOPIC_TYPE_HOME, "exo:topicTypeHome");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getForumSystemHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumHomeNode(sysProvider).getNode(CommonUtils.FORUM_SYSTEM);
        }
        catch (PathNotFoundException e) {
            return this.getForumHomeNode(sysProvider).addNode(CommonUtils.FORUM_SYSTEM, "exo:forumSystem");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getForumDataHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumHomeNode(sysProvider).getNode(CommonUtils.FORUM_DATA);
        }
        catch (PathNotFoundException e) {
            return this.getForumHomeNode(sysProvider).addNode(CommonUtils.FORUM_DATA, "exo:forumData");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getBanIPHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumSystemHome(sysProvider).getNode(Utils.BANIP_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumSystemHome(sysProvider).addNode(Utils.BANIP_HOME, "exo:banIPHome");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Node getStatisticHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumSystemHome(sysProvider).getNode(Utils.STATISTIC_HOME);
        }
        catch (PathNotFoundException e) {
            Node staHome = this.getForumSystemHome(sysProvider).addNode(Utils.STATISTIC_HOME, "exo:statisticHome");
            staHome.getSession().save();
            ForumStatistic forumStatistic = new ForumStatistic();
            this.saveForumStatistic(forumStatistic);
            return staHome;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getAdminHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumSystemHome(sysProvider).getNode(Utils.ADMINISTRATION_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumSystemHome(sysProvider).addNode(Utils.ADMINISTRATION_HOME, "exo:administrationHome");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Node getUserProfileHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumSystemHome(sysProvider).getNode(Utils.USER_PROFILE_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumSystemHome(sysProvider).addNode(Utils.USER_PROFILE_HOME, "exo:userProfileHome");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getCategoryHome(SessionProvider sysProvider) throws Exception {
        Node forumHome = this.getForumDataHome(sysProvider);
        try {
            return forumHome.getNode(Utils.CATEGORY_HOME);
        }
        catch (PathNotFoundException e) {
            Node categoryHome = forumHome.addNode(Utils.CATEGORY_HOME, "exo:categoryHome");
            forumHome.getSession().save();
            return categoryHome;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getTagHome(SessionProvider sysProvider) throws Exception {
        try {
            return this.getForumDataHome(sysProvider).getNode(Utils.TAG_HOME);
        }
        catch (PathNotFoundException e) {
            return this.getForumDataHome(sysProvider).addNode(Utils.TAG_HOME, "exo:tagHome");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getKSUserAvatarHomeNode(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode(KS_USER_AVATAR);
        }
        catch (PathNotFoundException ex) {
            Node faqHome = userApp.addNode(KS_USER_AVATAR, "nt:unstructured");
            userApp.getSession().save();
            return faqHome;
        }
    }

    private Node getForumBanNode(SessionProvider sysProvider) throws Exception {
        try {
            return this.getBanIPHome(sysProvider).getNode(Utils.FORUM_BAN_IP);
        }
        catch (PathNotFoundException e) {
            return this.getBanIPHome(sysProvider).addNode(Utils.FORUM_BAN_IP, "exo:banIP");
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAvatar(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node;
            Node ksAvatarHomnode = this.getKSUserAvatarHomeNode(sProvider);
            if (ksAvatarHomnode.hasNode(userName) && (node = ksAvatarHomnode.getNode(userName)).isNodeType("nt:file")) {
                node.remove();
                ksAvatarHomnode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * Exception decompiling
     */
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node ksAvatarHomnode = this.getKSUserAvatarHomeNode(sysSession);
            Node avatarNode = null;
            avatarNode = ksAvatarHomnode.hasNode(userId) ? ksAvatarHomnode.getNode(userId) : ksAvatarHomnode.addNode(userId, "nt:file");
            ForumServiceUtils.reparePermissions(avatarNode, "any");
            Node nodeContent = null;
            nodeContent = avatarNode.hasNode("jcr:content") ? avatarNode.getNode("jcr:content") : avatarNode.addNode("jcr:content", "nt:resource");
            nodeContent.setProperty("jcr:mimeType", fileAttachment.getMimeType());
            nodeContent.setProperty("jcr:data", fileAttachment.getInputStream());
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            if (avatarNode.isNew()) {
                ksAvatarHomnode.getSession().save();
            } else {
                ksAvatarHomnode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode;
            Node administrationHome = this.getAdminHome(sProvider);
            try {
                forumAdminNode = administrationHome.getNode(Utils.FORUMADMINISTRATION);
            }
            catch (PathNotFoundException e) {
                forumAdminNode = administrationHome.addNode(Utils.FORUMADMINISTRATION, "exo:administration");
            }
            forumAdminNode.setProperty("exo:forumSortBy", forumAdministration.getForumSortBy());
            forumAdminNode.setProperty("exo:forumSortByType", forumAdministration.getForumSortByType());
            forumAdminNode.setProperty("exo:topicSortBy", forumAdministration.getTopicSortBy());
            forumAdminNode.setProperty("exo:topicSortByType", forumAdministration.getTopicSortByType());
            forumAdminNode.setProperty("exo:censoredKeyword", forumAdministration.getCensoredKeyword());
            forumAdminNode.setProperty("exo:enableHeaderSubject", forumAdministration.getEnableHeaderSubject());
            forumAdminNode.setProperty("exo:headerSubject", forumAdministration.getHeaderSubject());
            forumAdminNode.setProperty("exo:notifyEmailContent", forumAdministration.getNotifyEmailContent());
            forumAdminNode.setProperty("exo:notifyEmailMoved", forumAdministration.getNotifyEmailMoved());
            if (forumAdminNode.isNew()) {
                forumAdminNode.getSession().save();
            } else {
                forumAdminNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForumAdministration getForumAdministration() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumAdministration forumAdministration = new ForumAdministration();
            try {
                Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                PropertyReader reader = new PropertyReader(forumAdminNode);
                forumAdministration.setForumSortBy(reader.string("exo:forumSortBy"));
                forumAdministration.setForumSortByType(reader.string("exo:forumSortByType"));
                forumAdministration.setTopicSortBy(reader.string("exo:topicSortBy"));
                forumAdministration.setTopicSortByType(reader.string("exo:topicSortByType"));
                forumAdministration.setCensoredKeyword(reader.string("exo:censoredKeyword"));
                forumAdministration.setEnableHeaderSubject(reader.bool("exo:enableHeaderSubject"));
                forumAdministration.setHeaderSubject(reader.string("exo:headerSubject"));
                forumAdministration.setNotifyEmailContent(reader.string("exo:notifyEmailContent"));
                forumAdministration.setNotifyEmailMoved(reader.string("exo:notifyEmailMoved"));
                ForumAdministration forumAdministration2 = forumAdministration;
                return forumAdministration2;
            }
            catch (PathNotFoundException e) {
                ForumAdministration forumAdministration3 = forumAdministration;
                sProvider.close();
                return forumAdministration3;
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortSettings getForumSortSettings() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            SortSettings sortSettings = new SortSettings(reader.string("exo:forumSortBy"), reader.string("exo:forumSortByType"));
            return sortSettings;
        }
        catch (PathNotFoundException e) {
            log.warn((Object)("Could not log forum sort order in forum administration node: " + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
        return new SortSettings(SortSettings.SortField.ORDER, SortSettings.Direction.ASC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortSettings getTopicSortSettings() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            SortSettings sortSettings = new SortSettings(reader.string("exo:topicSortBy"), reader.string("exo:topicSortByType"));
            return sortSettings;
        }
        catch (Exception e) {
            log.warn((Object)("Could not log topic sort order in forum administration node: " + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
        return new SortSettings(SortSettings.SortField.LASTPOST, SortSettings.Direction.DESC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefaultData() throws Exception {
        SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (categoryHome.hasNodes()) {
                return;
            }
            for (InitializeForumPlugin pln : this.defaultPlugins_) {
                List<CategoryData> categories = pln.getForumInitialData().getCategories();
                for (CategoryData categoryData : categories) {
                    Category category = new Category();
                    category.setCategoryName(categoryData.getName());
                    category.setDescription(categoryData.getDescription());
                    category.setOwner(categoryData.getOwner());
                    this.saveCategory(category, true);
                    List<ForumData> forums = categoryData.getForums();
                    for (ForumData forumData : forums) {
                        Forum forum = new Forum();
                        forum.setForumName(forumData.getName());
                        forum.setDescription(forumData.getDescription());
                        forum.setOwner(forumData.getOwner());
                        this.saveForum(category.getId(), forum, true);
                        List<TopicData> topics = forumData.getTopics();
                        String ct = "";
                        for (TopicData topicData : topics) {
                            Topic topic = new Topic();
                            topic.setTopicName(topicData.getName());
                            ct = topicData.getContent();
                            ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                            ct = Utils.removeCharterStrange(ct);
                            topic.setDescription(ct);
                            topic.setOwner(topicData.getOwner());
                            topic.setIcon(topicData.getIcon());
                            this.saveTopic(category.getId(), forum.getId(), topic, true, false, "");
                            List<PostData> posts = topicData.getPosts();
                            for (PostData postData : posts) {
                                Post post = new Post();
                                post.setName(postData.getName());
                                ct = postData.getContent();
                                ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                                ct = Utils.removeCharterStrange(ct);
                                post.setMessage(ct);
                                post.setOwner(postData.getOwner());
                                post.setIcon(postData.getIcon());
                                this.savePost(category.getId(), forum.getId(), topic.getId(), post, true, "");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + categoryHome.getPath() + "/element(*,exo:forumCategory) order by @exo:categoryOrder ascending, @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                try {
                    Node cateNode = iter.nextNode();
                    categories.add(this.getCategory(cateNode));
                }
                catch (Exception e) {}
            }
            ArrayList<Category> arrayList = categories;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Category> arrayList = categories;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Category category = this.getCategory(this.getCategoryHome(sProvider).getNode(categoryId));
            return category;
        }
        catch (Exception e) {
            Category category = null;
            return category;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        String[] canCreated = new String[]{" "};
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateNode = this.getCategoryHome(sProvider).getNode(categoryId);
            if (type.equals("createTopic") && cateNode.hasProperty("exo:createTopicRole")) {
                canCreated = this.ValuesToArray(cateNode.getProperty("exo:createTopicRole").getValues());
            }
            if (type.equals("viewer") && cateNode.hasProperty("exo:viewer")) {
                canCreated = this.ValuesToArray(cateNode.getProperty("exo:viewer").getValues());
            }
            if (type.equals("poster") && cateNode.hasProperty("exo:poster")) {
                canCreated = this.ValuesToArray(cateNode.getProperty("exo:poster").getValues());
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return canCreated;
    }

    private Category getCategory(Node cateNode) throws Exception {
        Category cat = new Category(cateNode.getName());
        cat.setPath(cateNode.getPath());
        PropertyReader reader = new PropertyReader(cateNode);
        cat.setOwner(reader.string("exo:owner"));
        cat.setCategoryName(reader.string("exo:name"));
        cat.setCategoryOrder(reader.l("exo:categoryOrder"));
        cat.setCreatedDate(reader.date("exo:createdDate"));
        cat.setDescription(reader.string("exo:description"));
        cat.setModifiedBy(reader.string("exo:modifiedBy"));
        cat.setModifiedDate(reader.date("exo:modifiedDate"));
        cat.setUserPrivate(reader.strings("exo:userPrivate"));
        cat.setModerators(reader.strings("exo:moderators"));
        cat.setForumCount(reader.l("exo:forumCount"));
        if (cateNode.isNodeType("exo:forumWatching")) {
            cat.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        cat.setViewer(reader.strings("exo:viewer"));
        cat.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        cat.setPoster(reader.strings("exo:poster"));
        return cat;
    }

    public void saveCategory(Category category, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> presentPoster = new ArrayList();
        ArrayList<String> presentViewer = new ArrayList();
        try {
            ArrayList<String> list;
            Node catNode;
            Node categoryHome = this.getCategoryHome(sProvider);
            if (isNew) {
                catNode = categoryHome.addNode(category.getId(), "exo:forumCategory");
                catNode.setProperty("exo:id", category.getId());
                catNode.setProperty("exo:owner", category.getOwner());
                catNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                categoryHome.getSession().save();
                this.addModeratorCalculateListener(catNode);
            } else {
                catNode = categoryHome.getNode(category.getId());
                String[] oldcategoryMod = new String[]{""};
                try {
                    oldcategoryMod = this.ValuesToArray(catNode.getProperty("exo:moderators").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
                catNode.setProperty("exo:tempModerators", oldcategoryMod);
                try {
                    presentPoster = this.ValuesToList(catNode.getProperty("exo:poster").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    presentViewer = this.ValuesToList(catNode.getProperty("exo:viewer").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catNode.setProperty("exo:name", category.getCategoryName());
            catNode.setProperty("exo:categoryOrder", category.getCategoryOrder());
            catNode.setProperty("exo:description", category.getDescription());
            catNode.setProperty("exo:modifiedBy", category.getModifiedBy());
            catNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            catNode.setProperty("exo:userPrivate", category.getUserPrivate());
            catNode.setProperty("exo:createTopicRole", category.getCreateTopicRole());
            catNode.setProperty("exo:poster", category.getPoster());
            catNode.setProperty("exo:viewer", category.getViewer());
            catNode.setProperty("exo:moderators", category.getModerators());
            ArrayList<String> listV = new ArrayList<String>();
            listV.addAll(Arrays.asList(category.getPoster()));
            if (!isNew && Utils.isAddNewList(presentPoster, listV)) {
                list = new ArrayList<String>();
                for (String string : presentPoster) {
                    if (listV.contains(string)) {
                        listV.remove(string);
                        continue;
                    }
                    list.add(string);
                }
                this.setPermissionByCategory(catNode, list, listV, "exo:canPost");
            }
            listV = new ArrayList();
            listV.addAll(Arrays.asList(category.getViewer()));
            if (!isNew && Utils.isAddNewList(presentViewer, listV)) {
                list = new ArrayList();
                for (String string : presentPoster) {
                    if (listV.contains(string)) {
                        listV.remove(string);
                        continue;
                    }
                    list.add(string);
                }
                this.setPermissionByCategory(catNode, list, listV, "exo:canView");
            }
            catNode.save();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateHome = this.getCategoryHome(sProvider);
            Node cateNode = null;
            for (String cateId : moderatorCate) {
                boolean isAddNew = true;
                try {
                    cateNode = cateHome.getNode(cateId);
                    List<String> listTemp = this.ValuesToList(cateNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    list.addAll(listTemp);
                    if (isAdd) {
                        if (list.isEmpty() || list.size() == 1 && ((String)list.get(0)).equals(" ")) {
                            list = new ArrayList();
                            list.add(userId);
                        } else if (!list.contains(userId)) {
                            list.add(userId);
                        } else {
                            isAddNew = false;
                        }
                        if (!isAddNew) continue;
                        cateNode.setProperty("exo:tempModerators", JCRDataStorage.getStringsInList(listTemp));
                        cateNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                        continue;
                    }
                    if (list.isEmpty() || !list.contains(userId)) continue;
                    list.remove(userId);
                    if (list.isEmpty()) {
                        list.add(" ");
                    }
                    cateNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                    cateNode.setProperty("exo:tempModerators", JCRDataStorage.getStringsInList(listTemp));
                }
                catch (Exception e) {}
            }
            cateHome.save();
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateModerator(String nodePath, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = (Node)this.getCategoryHome(sProvider).getSession().getItem(nodePath);
            String[] modTemp = new String[]{};
            if (node.hasProperty("exo:tempModerators")) {
                modTemp = this.ValuesToArray(node.getProperty("exo:tempModerators").getValues());
            }
            if (node.isNodeType("exo:forumCategory")) {
                Category category = new Category(node.getName());
                category.setCategoryName(node.getProperty("exo:name").getString());
                category.setModerators(this.ValuesToArray(node.getProperty("exo:moderators").getValues()));
                if (isNew || Utils.isAddNewArray(modTemp, category.getModerators())) {
                    this.updateModeratorInForums(sProvider, node, category.getModerators());
                    this.updateUserProfileModInCategory(sProvider, node, modTemp, category, isNew);
                }
            } else {
                Forum forum = new Forum();
                forum.setId(node.getName());
                forum.setForumName(node.getProperty("exo:name").getString());
                forum.setModerators(this.ValuesToArray(node.getProperty("exo:moderators").getValues()));
                if (isNew || Utils.isAddNewArray(modTemp, forum.getModerators())) {
                    String categoryId = nodePath.substring(nodePath.indexOf(Utils.CATEGORY), nodePath.lastIndexOf("/"));
                    this.setModeratorForum(sProvider, forum.getModerators(), modTemp, forum, categoryId, isNew);
                }
            }
            node.setProperty("exo:tempModerators", new String[0]);
            node.save();
        }
        catch (Exception e) {
            log.debug((Object)"PathNotFoundException  cateogry node or forum node not found");
        }
        finally {
            sProvider.close();
        }
    }

    private void updateModeratorInForums(SessionProvider sProvider, Node cateNode, String[] moderatorCat) throws Exception {
        NodeIterator iter = cateNode.getNodes();
        while (iter.hasNext()) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                String[] oldModeratoForums;
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:forum")) continue;
                try {
                    oldModeratoForums = this.ValuesToArray(node.getProperty("exo:moderators").getValues());
                }
                catch (Exception e) {
                    oldModeratoForums = new String[]{};
                }
                list.addAll(Arrays.asList(oldModeratoForums));
                for (int i = 0; i < moderatorCat.length; ++i) {
                    if (list.contains(moderatorCat[i])) continue;
                    list.add(moderatorCat[i]);
                }
                String[] strModerators = JCRDataStorage.getStringsInList(list);
                node.setProperty("exo:moderators", strModerators);
                node.setProperty("exo:tempModerators", oldModeratoForums);
            }
            catch (Exception e) {}
        }
        cateNode.save();
    }

    private void updateUserProfileModInCategory(SessionProvider sProvider, Node catNode, String[] oldcategoryMod, Category category, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = this.getUserProfileHome(sProvider);
        String categoryId = category.getId();
        String cateName = category.getCategoryName();
        List<String> moderators = ForumServiceUtils.getUserPermission(category.getModerators());
        if (!moderators.isEmpty()) {
            for (String string : moderators) {
                try {
                    boolean isAdd = true;
                    userProfileNode = userProfileHomeNode.getNode(string);
                    List<Object> moderateCategory = new ArrayList();
                    try {
                        moderateCategory = this.ValuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (String string2 : moderateCategory) {
                        if (string2.indexOf(categoryId) <= 0) continue;
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    moderateCategory.add(cateName + "(" + categoryId);
                    userProfileNode.setProperty("exo:moderateCategory", JCRDataStorage.getStringsInList(moderateCategory));
                }
                catch (Exception e) {}
            }
        }
        if (!isNew && oldcategoryMod != null && oldcategoryMod.length > 0 && !oldcategoryMod[0].equals(" ") && Utils.isAddNewArray(oldcategoryMod, category.getModerators())) {
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(oldcategoryMod);
            for (String oldUserId : oldmoderators) {
                if (moderators.contains(oldUserId)) continue;
                userProfileNode = userProfileHomeNode.getNode(oldUserId);
                List<Object> moderateList = new ArrayList();
                try {
                    moderateList = this.ValuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (String string : moderateList) {
                    if (string.indexOf(categoryId) <= 0) continue;
                    moderateList.remove(string);
                    userProfileNode.setProperty("exo:moderateCategory", JCRDataStorage.getStringsInList(moderateList));
                    break;
                }
                moderateList = this.ValuesToList(userProfileNode.getProperty("exo:moderateForums").getValues());
                NodeIterator iter = catNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:forum")) continue;
                    for (String string : moderateList) {
                        if (string.indexOf(node.getName()) < 0) continue;
                        moderateList.remove(string);
                        break;
                    }
                    List<String> forumMode = this.ValuesToList(node.getProperty("exo:moderators").getValues());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(forumMode);
                    for (int i = 0; i < oldcategoryMod.length; ++i) {
                        if (!forumMode.contains(oldcategoryMod[i])) continue;
                        forumMode.remove(oldcategoryMod[i]);
                    }
                    node.setProperty("exo:moderators", JCRDataStorage.getStringsInList(forumMode));
                    node.setProperty("exo:tempModerators", JCRDataStorage.getStringsInList(arrayList));
                }
                catNode.save();
                if (moderateList.isEmpty() || moderateList.size() == 1 && ((String)moderateList.get(0)).equals(" ")) {
                    if (userProfileNode.hasProperty("exo:userRole")) {
                        long l = userProfileNode.getProperty("exo:userRole").getLong();
                        if (l == 1L) {
                            userProfileNode.setProperty("exo:userRole", 2L);
                            userProfileNode.setProperty("exo:userTitle", Utils.USER);
                        }
                    } else {
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                    }
                }
                userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(moderateList));
            }
        }
        try {
            userProfileHomeNode.save();
        }
        catch (Exception e) {
            userProfileHomeNode.getSession().save();
        }
    }

    private void setPermissionByCategory(Node catNode, List<String> remov, List<String> addNew, String property) throws Exception {
        QueryManager qm = catNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("/jcr:root").append(catNode.getPath()).append("//element(*,exo:topic)[@").append(property).append(" != ' ']");
        Query query = qm.createQuery(queryBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Node topicNode = iter.nextNode();
            List<String> list = this.ValuesToList(topicNode.getProperty(property).getValues());
            if ((list = this.removeAndAddNewInList(remov, addNew, list)).isEmpty()) {
                list.add(" ");
            }
            topicNode.setProperty(property, JCRDataStorage.getStringsInList(list));
        }
    }

    private List<String> removeAndAddNewInList(List<String> remov, List<String> addNew, List<String> present) {
        for (String string : remov) {
            if (!present.contains(string)) continue;
            present.remove(string);
        }
        for (String string : addNew) {
            if (present.contains(string) || string.trim().length() <= 0) continue;
            present.add(string);
        }
        return present;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerForCategory(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            String id = path.substring(path.lastIndexOf("/") + 1);
            Node catNode = categoryHome.getNode(id);
            if (!this.listeners_.containsKey(catNode.getPath())) {
                String wsName = catNode.getSession().getWorkspace().getName();
                RepositoryImpl repo = (RepositoryImpl)catNode.getSession().getRepository();
                ObservationManager observation = catNode.getSession().getWorkspace().getObservationManager();
                StatisticEventListener statisticEventListener = new StatisticEventListener(wsName, repo.getName());
                observation.addEventListener((EventListener)statisticEventListener, 3, catNode.getPath(), true, null, null, false);
                this.listeners_.put(catNode.getPath(), statisticEventListener);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to register listener for category " + path), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterListenerForCategory(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            if (this.listeners_.containsKey(path)) {
                ObservationManager obserManager = this.getForumHomeNode(sProvider).getSession().getWorkspace().getObservationManager();
                obserManager.removeEventListener((EventListener)((StatisticEventListener)this.listeners_.get(path)));
                this.listeners_.remove(path);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister listener for category " + path), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category removeCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Node categoryNode = categoryHome.getNode(categoryId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(categoryNode);
            Category category = this.getCategory(categoryNode);
            try {
                categoryNode.setProperty("exo:tempModerators", this.ValuesToArray(categoryNode.getProperty("exo:moderators").getValues()));
                categoryNode.setProperty("exo:moderators", new String[]{" "});
                NodeIterator iter = categoryNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:forum")) continue;
                    node.setProperty("exo:tempModerators", this.ValuesToArray(node.getProperty("exo:moderators").getValues()));
                    node.setProperty("exo:moderators", new String[]{" "});
                }
                categoryNode.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            categoryNode.remove();
            categoryHome.save();
            try {
                this.addUpdateUserProfileJob(userPostMap);
            }
            catch (Exception e) {
                // empty catch block
            }
            Category category2 = category;
            return category2;
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove category " + categoryId));
            Category category = null;
            return category;
        }
        finally {
            sProvider.close();
        }
    }

    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.getForums(categoryId, strQuery, false);
    }

    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.getForums(categoryId, strQuery, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Forum> getForums(String categoryId, String strQuery, boolean summary) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            SortSettings sort = this.getForumSortSettings();
            SortSettings.SortField orderBy = sort.getField();
            SortSettings.Direction orderType = sort.getDirection();
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            String categoryPath = catNode.getPath();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(categoryPath).append("/element(*,exo:forum)");
            if (strQuery != null && strQuery.trim().length() > 0) {
                queryBuffer.append("[").append(strQuery).append("]");
            }
            queryBuffer.append(" order by @exo:").append((Object)orderBy).append(" ").append((Object)orderType);
            if (orderBy != SortSettings.SortField.ORDER) {
                queryBuffer.append(", @exo:forumOrder ascending");
                if (orderBy != SortSettings.SortField.CREATED) {
                    queryBuffer.append(", @exo:createdDate ascending");
                }
            } else {
                queryBuffer.append(", @exo:createdDate ascending");
            }
            QueryManager qm = catNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<Forum> forums = new ArrayList<Forum>();
            while (iter.hasNext()) {
                Node forumNode = null;
                try {
                    forumNode = iter.nextNode();
                    if (summary) {
                        forums.add(this.getForum(forumNode));
                        continue;
                    }
                    forums.add(this.getForumSummary(forumNode));
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to load forum node " + forumNode.getPath()), (Throwable)e);
                }
            }
            ArrayList<Forum> arrayList = forums;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving forums for category " + categoryId), (Throwable)e);
            ArrayList<Forum> arrayList = new ArrayList<Forum>();
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Forum getForum(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            Forum forum = this.getForum(forumNode);
            return forum;
        }
        catch (Exception e) {
            Forum forum = null;
            return forum;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyForum(Forum forum, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String forumPath = forum.getPath();
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            switch (type) {
                case 1: {
                    forumNode.setProperty("exo:isClosed", forum.getIsClosed());
                    this.setActiveTopicByForum(sProvider, forumNode, forum.getIsClosed());
                    break;
                }
                case 2: {
                    forumNode.setProperty("exo:isLock", forum.getIsLock());
                    break;
                }
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed to modify forum " + forum.getForumName()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private String[] updateModeratorInForum(Node catNode, String[] mods) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.addAll(this.ValuesToList(catNode.getProperty("exo:moderators").getValues()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!list.isEmpty() && !((String)list.get(0)).equals(" ")) {
            for (int i = 0; i < mods.length; ++i) {
                if (list.contains(mods[i])) continue;
                list.add(mods[i]);
            }
            return list.toArray(new String[0]);
        }
        return mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode;
            boolean isNewModerateTopic;
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            boolean isModerateTopic = isNewModerateTopic = forum.getIsModerateTopic();
            String[] oldMod = new String[]{};
            if (isNew) {
                forumNode = catNode.addNode(forum.getId(), "exo:forum");
                forumNode.setProperty("exo:id", forum.getId());
                forumNode.setProperty("exo:owner", forum.getOwner());
                forumNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                forumNode.setProperty("exo:lastTopicPath", forum.getLastTopicPath());
                forumNode.setProperty("exo:postCount", 0L);
                forumNode.setProperty("exo:topicCount", 0L);
                forumNode.setProperty("exo:banIPs", new String[0]);
                forum.setPath(forumNode.getPath());
                long forumCount = 1L;
                if (catNode.hasProperty("exo:forumCount")) {
                    forumCount = catNode.getProperty("exo:forumCount").getLong() + 1L;
                }
                catNode.setProperty("exo:forumCount", forumCount);
                catNode.getSession().save();
                this.addModeratorCalculateListener(forumNode);
            } else {
                forumNode = catNode.getNode(forum.getId());
                oldMod = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
                forumNode.setProperty("exo:tempModerators", oldMod);
                if (forumNode.hasProperty("exo:isModerateTopic")) {
                    isModerateTopic = forumNode.getProperty("exo:isModerateTopic").getBoolean();
                }
            }
            forumNode.setProperty("exo:name", forum.getForumName());
            forumNode.setProperty("exo:forumOrder", (long)forum.getForumOrder());
            forumNode.setProperty("exo:modifiedBy", forum.getModifiedBy());
            forumNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            forumNode.setProperty("exo:description", forum.getDescription());
            forumNode.setProperty("exo:isAutoAddEmailNotify", forum.getIsAutoAddEmailNotify());
            forumNode.setProperty("exo:notifyWhenAddPost", forum.getNotifyWhenAddPost());
            forumNode.setProperty("exo:notifyWhenAddTopic", forum.getNotifyWhenAddTopic());
            forumNode.setProperty("exo:isModerateTopic", isNewModerateTopic);
            forumNode.setProperty("exo:isModeratePost", forum.getIsModeratePost());
            forumNode.setProperty("exo:isClosed", forum.getIsClosed());
            forumNode.setProperty("exo:isLock", forum.getIsLock());
            forumNode.setProperty("exo:viewer", forum.getViewer());
            forumNode.setProperty("exo:createTopicRole", forum.getCreateTopicRole());
            forumNode.setProperty("exo:poster", forum.getPoster());
            String[] strModerators = forum.getModerators();
            strModerators = this.updateModeratorInForum(catNode, strModerators);
            boolean isEditMod = isNew;
            if (!isNew && Utils.isAddNewArray(oldMod, strModerators)) {
                isEditMod = true;
            }
            forumNode.setProperty("exo:moderators", strModerators);
            if (isEditMod && strModerators != null && strModerators.length > 0 && !strModerators[0].equals(" ") && catNode.hasProperty("exo:userPrivate")) {
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(this.ValuesToList(catNode.getProperty("exo:userPrivate").getValues()));
                if (listPrivate.size() > 0 && !((String)listPrivate.get(0)).equals(" ")) {
                    for (int i = 0; i < strModerators.length; ++i) {
                        if (listPrivate.contains(strModerators[i])) continue;
                        listPrivate.add(strModerators[i]);
                    }
                    catNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[0]));
                }
            }
            catNode.save();
            StringBuilder id = new StringBuilder();
            id.append(catNode.getProperty("exo:categoryOrder").getString());
            id.append(catNode.getProperty("exo:createdDate").getDate().getTimeInMillis());
            id.append(forum.getForumOrder());
            if (isNew) {
                id.append(this.getGreenwichMeanTime());
                PruneSetting pruneSetting = new PruneSetting();
                pruneSetting.setId(id.toString());
                pruneSetting.setForumPath(forum.getPath());
                this.savePruneSetting(pruneSetting);
            } else {
                id.append(forum.getCreatedDate().getTime());
                if (isModerateTopic != isNewModerateTopic) {
                    this.queryLastTopic(sProvider, forumNode.getPath());
                }
                Node pruneSetting = forumNode.getNode(Utils.PRUNESETTING);
                pruneSetting.setProperty("exo:id", id.toString());
                pruneSetting.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void setModeratorForum(SessionProvider sProvider, String[] strModerators, String[] oldModeratoForums, Forum forum, String categoryId, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = this.getUserProfileHome(sProvider);
        ArrayList<String> list = new ArrayList<String>();
        List<String> moderators = ForumServiceUtils.getUserPermission(strModerators);
        if (moderators.size() > 0) {
            for (String string : moderators) {
                string = string.trim();
                list = new ArrayList();
                try {
                    userProfileNode = userProfileHomeNode.getNode(string);
                    List<String> moderatorForums = this.ValuesToList(userProfileNode.getProperty("exo:moderateForums").getValues());
                    boolean hasMod = false;
                    for (String string2 : moderatorForums) {
                        if (string2.indexOf(forum.getId()) > 0) {
                            hasMod = true;
                        }
                        if (string2.equals(" ")) continue;
                        list.add(string2);
                    }
                    if (hasMod) continue;
                    list.add(forum.getForumName() + "(" + categoryId + "/" + forum.getId());
                    userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(list));
                    if (userProfileNode.getProperty("exo:userRole").getLong() >= 2L) {
                        userProfileNode.setProperty("exo:userRole", 1L);
                        userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    }
                    this.getTotalJobWattingForModerator(sProvider, string);
                }
                catch (PathNotFoundException e) {
                    userProfileNode = userProfileHomeNode.addNode(string, Utils.USER_PROFILES_TYPE);
                    String[] strings = new String[]{forum.getForumName() + "(" + categoryId + "/" + forum.getId()};
                    userProfileNode.setProperty("exo:moderateForums", strings);
                    userProfileNode.setProperty("exo:userRole", 1L);
                    userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    if (userProfileNode.isNew()) {
                        userProfileNode.getSession().save();
                    } else {
                        userProfileNode.save();
                    }
                    this.getTotalJobWattingForModerator(sProvider, string);
                }
            }
        }
        if (!isNew) {
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(oldModeratoForums);
            for (String string : oldmoderators) {
                boolean isDelete = true;
                if (moderators.contains(string)) {
                    isDelete = false;
                }
                if (!isDelete) continue;
                try {
                    String[] moderatorForums;
                    list = new ArrayList();
                    userProfileNode = userProfileHomeNode.getNode(string);
                    for (String string2 : moderatorForums = this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues())) {
                        if (string2.indexOf(forum.getId()) >= 0) continue;
                        list.add(string2);
                    }
                    userProfileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(list));
                    if (list.size() > 0) continue;
                    if (userProfileNode.hasProperty("exo:userRole")) {
                        long role = userProfileNode.getProperty("exo:userRole").getLong();
                        if (role != 1L) continue;
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                        continue;
                    }
                    userProfileNode.setProperty("exo:userRole", 2L);
                    userProfileNode.setProperty("exo:userTitle", Utils.USER);
                }
                catch (PathNotFoundException e) {}
            }
        }
        if (userProfileHomeNode.isNew()) {
            userProfileHomeNode.getSession().save();
        } else {
            userProfileHomeNode.save();
        }
    }

    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHomeNode = this.getCategoryHome(sProvider);
        for (String path : forumPaths) {
            String forumPath = categoryHomeNode.getPath() + "/" + path;
            try {
                Node forumNode = (Node)categoryHomeNode.getSession().getItem(forumPath);
                Node cateNode = forumNode.getParent();
                if (isDelete) {
                    List<String> moderators;
                    String[] cateMods = this.ValuesToArray(cateNode.getProperty("exo:moderators").getValues());
                    if (cateMods != null && cateMods.length > 0 && !cateMods[0].equals(" ") && (moderators = ForumServiceUtils.getUserPermission(cateMods)).contains(userName) || !forumNode.hasProperty("exo:moderators")) continue;
                    String[] oldUserNamesModerate = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    for (String string : oldUserNamesModerate) {
                        if (string.equals(userName)) continue;
                        list.add(string);
                    }
                    forumNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                    forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                    continue;
                }
                String[] oldUserNamesModerate = new String[]{};
                if (forumNode.hasProperty("exo:moderators")) {
                    oldUserNamesModerate = this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues());
                }
                List<String> list = new ArrayList<String>();
                for (String string : oldUserNamesModerate) {
                    if (string.equals(userName)) continue;
                    list.add(string);
                }
                list.add(userName);
                forumNode.setProperty("exo:moderators", JCRDataStorage.getStringsInList(list));
                forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                if (!cateNode.hasProperty("exo:userPrivate") || (list = this.ValuesToList(cateNode.getProperty("exo:userPrivate").getValues())).get(0).equals(" ") || list.contains(userName)) continue;
                String[] strings = new String[list.size() + 1];
                int i = 0;
                Iterator<String> i$ = list.iterator();
                while (i$.hasNext()) {
                    String string;
                    strings[i] = string = i$.next();
                    ++i;
                }
                strings[i] = userName;
                cateNode.setProperty("exo:userPrivate", strings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (categoryHomeNode.isNew()) {
            categoryHomeNode.getSession().save();
        } else {
            categoryHomeNode.save();
        }
        sProvider.close();
    }

    private Forum getForumSummary(Node forumNode) throws Exception {
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setForumName(reader.string("exo:name"));
        forum.setDescription(reader.string("exo:description"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        String lastTopicPath = "";
        if (forumNode.hasProperty("exo:lastTopicPath") && (lastTopicPath = forumNode.getProperty("exo:lastTopicPath").getString()).trim().length() > 0) {
            lastTopicPath = lastTopicPath.lastIndexOf("/") > 0 ? forum.getPath() + lastTopicPath.substring(lastTopicPath.lastIndexOf("/")) : forum.getPath() + "/" + lastTopicPath;
        }
        forum.setLastTopicPath(lastTopicPath);
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        return forum;
    }

    private Forum getForum(Node forumNode) throws Exception {
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setOwner(reader.string("exo:owner"));
        forum.setForumName(reader.string("exo:name"));
        forum.setForumOrder(Integer.valueOf(reader.string("exo:forumOrder")));
        forum.setCreatedDate(reader.date("exo:createdDate"));
        forum.setModifiedBy(reader.string("exo:modifiedBy"));
        forum.setModifiedDate(reader.date("exo:modifiedDate"));
        String lastTopicPath = "";
        if (forumNode.hasProperty("exo:lastTopicPath") && (lastTopicPath = forumNode.getProperty("exo:lastTopicPath").getString()).trim().length() > 0) {
            lastTopicPath = lastTopicPath.lastIndexOf("/") > 0 ? forum.getPath() + lastTopicPath.substring(lastTopicPath.lastIndexOf("/")) : forum.getPath() + "/" + lastTopicPath;
        }
        forum.setLastTopicPath(lastTopicPath);
        forum.setDescription(reader.string("exo:description"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        forum.setIsModeratePost(reader.bool("exo:isModeratePost"));
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        forum.setIsAutoAddEmailNotify(reader.bool("exo:isAutoAddEmailNotify", false));
        forum.setNotifyWhenAddPost(reader.strings("exo:notifyWhenAddPost"));
        forum.setNotifyWhenAddTopic(reader.strings("exo:notifyWhenAddTopic"));
        forum.setViewer(reader.strings("exo:viewer"));
        forum.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        forum.setPoster(reader.strings("exo:poster"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setBanIP(reader.list("exo:banIPs"));
        if (forumNode.isNodeType("exo:forumWatching") && forumNode.hasProperty("exo:emailWatching")) {
            forum.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        return forum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Forum forum = new Forum();
        try {
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = catNode.getNode(forumId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(forumNode);
            forum = this.getForum(forumNode);
            forumNode.setProperty("exo:tempModerators", this.ValuesToArray(forumNode.getProperty("exo:moderators").getValues()));
            forumNode.setProperty("exo:moderators", new String[]{" "});
            forumNode.save();
            forumNode.remove();
            catNode.setProperty("exo:forumCount", catNode.getProperty("exo:forumCount").getLong() - 1L);
            catNode.save();
            try {
                this.addUpdateUserProfileJob(userPostMap);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            Forum forum2 = null;
            return forum2;
        }
        finally {
            sProvider.close();
        }
        return forum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String oldCatePath = "";
            if (forums.isEmpty()) {
                return;
            }
            String forumPath = forums.get(0).getPath();
            oldCatePath = forumPath.substring(0, forumPath.lastIndexOf("/"));
            Node oldCatNode = (Node)forumHomeNode.getSession().getItem(oldCatePath);
            Node newCatNode = (Node)forumHomeNode.getSession().getItem(destCategoryPath);
            for (Forum forum : forums) {
                String newForumPath = destCategoryPath + "/" + forum.getId();
                forumHomeNode.getSession().getWorkspace().move(forum.getPath(), newForumPath);
                Node forumNode = (Node)forumHomeNode.getSession().getItem(newForumPath);
                forumNode.setProperty("exo:path", newForumPath);
                String[] strModerators = forum.getModerators();
                forumNode.setProperty("exo:moderators", strModerators);
                if (strModerators == null || strModerators.length <= 0 || strModerators[0].equals(" ") || !newCatNode.hasProperty("exo:userPrivate")) continue;
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(this.ValuesToList(newCatNode.getProperty("exo:userPrivate").getValues()));
                if (((String)listPrivate.get(0)).equals(" ")) continue;
                for (int i = 0; i < strModerators.length; ++i) {
                    if (listPrivate.contains(strModerators[i])) continue;
                    listPrivate.add(strModerators[i]);
                }
                newCatNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[0]));
            }
            long forumCount = forums.size();
            oldCatNode.setProperty("exo:forumCount", oldCatNode.getProperty("exo:forumCount").getLong() - forumCount);
            if (newCatNode.hasProperty("exo:forumCount")) {
                forumCount = newCatNode.getProperty("exo:forumCount").getLong() + forumCount;
            }
            newCatNode.setProperty("exo:forumCount", forumCount);
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void setActiveTopicByForum(SessionProvider sProvider, Node forumNode, boolean isClosed) throws Exception {
        NodeIterator iter = forumNode.getNodes();
        Node topicNode = null;
        boolean bl = isClosed = !isClosed;
        while (iter.hasNext()) {
            topicNode = iter.nextNode();
            if (!topicNode.isNodeType("exo:topic")) continue;
            topicNode.setProperty("exo:isActiveByForum", isClosed);
            this.setActivePostByTopic(sProvider, topicNode, isClosed);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    private void setActivePostByTopic(SessionProvider sProvider, Node topicNode, boolean isActiveTopic) throws Exception {
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isApproved").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isWaiting").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isClosed").getBoolean();
        }
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isActive").getBoolean();
        }
        Node postNode = null;
        NodeIterator iter = topicNode.getNodes();
        while (iter.hasNext()) {
            postNode = iter.nextNode();
            if (!postNode.isNodeType("exo:post")) continue;
            postNode.setProperty("exo:isActiveByTopic", isActiveTopic);
        }
        if (topicNode.isNew()) {
            topicNode.getSession().save();
        } else {
            topicNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            String pathQuery = this.buildTopicQuery(strQuery, strOrderBy, forumPath);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String xpathConditions, String strOrderBy, int pageSize) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            String topicQuery = this.buildTopicQuery(xpathConditions, strOrderBy, forumPath);
            TopicListAccess topicListAccess = new TopicListAccess(topicQuery);
            LazyPageList<Topic> lazyPageList = new LazyPageList<Topic>((ListAccess<Topic>)topicListAccess, pageSize);
            return lazyPageList;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve topic list for forum " + forumId));
            LazyPageList<Topic> lazyPageList = null;
            return lazyPageList;
        }
        finally {
            sProvider.close();
        }
    }

    private String buildTopicQuery(String strQuery, String strOrderBy, String forumPath) throws Exception {
        SortSettings sortSettings = this.getTopicSortSettings();
        SortSettings.SortField orderBy = sortSettings.getField();
        SortSettings.Direction orderType = sortSettings.getDirection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumPath).append("//element(*,exo:topic)");
        if (strQuery != null && strQuery.length() > 0) {
            stringBuffer.append("[").append(strQuery).append("]");
        }
        stringBuffer.append(" order by @exo:isSticky descending");
        if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
            if (orderBy != null) {
                stringBuffer.append(", @exo:").append((Object)orderBy).append(" ").append((Object)orderType);
                if (!orderBy.equals((Object)SortSettings.SortField.LASTPOST)) {
                    stringBuffer.append(", @exo:lastPostDate descending");
                }
            } else {
                stringBuffer.append(", @exo:lastPostDate descending");
            }
        } else {
            stringBuffer.append(", @exo:").append(strOrderBy);
            if (strOrderBy.indexOf("lastPostDate") < 0) {
                stringBuffer.append(", @exo:lastPostDate descending");
            }
        }
        String pathQuery = stringBuffer.toString();
        return pathQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId).getNode(forumId);
            NodeIterator iter = forumNode.getNodes();
            ArrayList<Topic> topics = new ArrayList<Topic>();
            while (iter.hasNext()) {
                try {
                    Node topicNode = iter.nextNode();
                    if (!topicNode.isNodeType("exo:topic")) continue;
                    topics.add(this.getTopicNode(topicNode));
                }
                catch (Exception e) {}
            }
            ArrayList<Topic> arrayList = topics;
            return arrayList;
        }
        catch (Exception e) {
            List<Topic> list = null;
            return list;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCountTopic(String path, String userRead) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = this.getCategoryHome(sProvider).getNode(path);
            if (userRead != null && userRead.length() > 0 && !userRead.equals("user_gest_uoom")) {
                long newViewCount = topicNode.getProperty("exo:viewCount").getLong() + 1L;
                topicNode.setProperty("exo:viewCount", newViewCount);
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId + "/" + topicId);
            Topic topicNew = new Topic();
            Topic topic = topicNew = this.getTopicNode(topicNode);
            return topic;
        }
        catch (Exception e) {
            Topic topic = null;
            return topic;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopicSummary(String topicPath, boolean isLastPost) throws Exception {
        Topic topic = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                Topic topic2 = null;
                return topic2;
            }
            if (topicPath.indexOf(forumHomeNode.getName()) < 0) {
                topicPath = forumHomeNode.getPath() + "/" + topicPath;
            }
            if ((topic = this.getTopicNodeSummary(topicNode = (Node)forumHomeNode.getSession().getItem(topicPath))) == null && isLastPost && topicPath != null && topicPath.length() > 0) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNodeSummary(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic3 = topic;
            return topic3;
        }
        catch (RepositoryException e) {
            if (topicPath != null && topicPath.length() > 0 && isLastPost) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNodeSummary(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic4 = topic;
            return topic4;
        }
        catch (Exception e) {
            Topic topic5 = null;
            return topic5;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        Topic topic = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node catogoryHome = this.getCategoryHome(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                Topic topic2 = null;
                return topic2;
            }
            if (topicPath.indexOf(catogoryHome.getName()) < 0) {
                topicPath = catogoryHome.getPath() + "/" + topicPath;
            }
            if ((topic = this.getTopicNode(topicNode = (Node)catogoryHome.getSession().getItem(topicPath))) == null && isLastPost && topicPath != null && topicPath.length() > 0) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic3 = topic;
            return topic3;
        }
        catch (RepositoryException e) {
            if (topicPath != null && topicPath.length() > 0 && isLastPost) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic4 = topic;
            return topic4;
        }
        catch (Exception e) {
            Topic topic5 = null;
            return topic5;
        }
        finally {
            sProvider.close();
        }
    }

    private Node queryLastTopic(SessionProvider sProvider, String forumPath) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String queryString = "/jcr:root" + forumPath + "//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false' and (@exo:canView=' ' or @exo:canView='')] order by @exo:lastPostDate descending";
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node topicNode = null;
        boolean isSavePath = false;
        try {
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            while (iter.hasNext()) {
                topicNode = iter.nextNode();
                if (!forumNode.hasProperty("exo:isModerateTopic") && !forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                    isSavePath = true;
                    break;
                }
                if (!topicNode.getProperty("exo:isApproved").getBoolean()) continue;
                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                isSavePath = true;
                break;
            }
            if (!isSavePath) {
                forumNode.setProperty("exo:lastTopicPath", "");
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return topicNode;
    }

    private Topic getTopicNodeSummary(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        return topicNew;
    }

    private Topic getTopicNode(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setOwner(reader.string("exo:owner"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setCreatedDate(reader.date("exo:createdDate"));
        topicNew.setModifiedBy(reader.string("exo:modifiedBy"));
        topicNew.setModifiedDate(reader.date("exo:modifiedDate"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setDescription(reader.string("exo:description"));
        topicNew.setTopicType(reader.string("exo:topicType", " "));
        topicNew.setPostCount(reader.l("exo:postCount"));
        topicNew.setViewCount(reader.l("exo:viewCount"));
        topicNew.setNumberAttachment(reader.l("exo:numberAttachments"));
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setLink(reader.string("exo:link"));
        topicNew.setIsNotifyWhenAddPost(reader.string("exo:isNotifyWhenAddPost", null));
        topicNew.setIsModeratePost(reader.bool("exo:isModeratePost"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsSticky(reader.bool("exo:isSticky"));
        topicNew.setIsWaiting(reader.bool("exo:isWaiting"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsActiveByForum(reader.bool("exo:isActiveByForum"));
        topicNew.setCanView(reader.strings("exo:canView"));
        topicNew.setCanPost(reader.strings("exo:canPost"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        topicNew.setUserVoteRating(reader.strings("exo:userVoteRating"));
        topicNew.setTagId(reader.strings("exo:tagId"));
        topicNew.setVoteRating(reader.d("exo:voteRating"));
        if (topicNode.isNodeType("exo:forumWatching") && topicNode.hasProperty("exo:emailWatching")) {
            topicNew.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        String idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST);
        try {
            Node FirstPostNode = topicNode.getNode(idFirstPost);
            if (reader.l("exo:numberAttachments") > 0L) {
                NodeIterator postAttachments = FirstPostNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("exo:forumAttachment")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                topicNew.setAttachments(attachments);
            }
            return topicNew;
        }
        catch (PathNotFoundException e) {
            return topicNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            if (forumPatch == null || forumPatch.length() <= 0) {
                forumPatch = categoryHome.getPath();
            }
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Topic> topics = new ArrayList<Topic>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            if (forumPatch == null || forumPatch.length() <= 0) {
                forumPatch = categoryHome.getPath();
            }
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                Topic topic = new Topic();
                topic.setId(node.getName());
                topic.setPath(node.getPath());
                topic.setIsActive(node.getProperty("exo:isActive").getBoolean());
                topic.setPostCount(node.getProperty("exo:postCount").getLong());
                topics.add(topic);
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalTopicOld(long date, String forumPatch) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("') and @exo:isActive='true'] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            long l = iter.getSize();
            return l;
        }
        catch (Exception e) {
            long l = 0L;
            return l;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[@exo:owner='").append(userName).append("'");
            if (!isMod) {
                stringBuffer.append(" and @exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' ").append("and @exo:isActive='true' and @exo:isActiveByForum='true'");
            }
            stringBuffer.append("] order by @exo:isSticky descending");
            if (strOrderBy != null && strOrderBy.trim().length() > 0) {
                stringBuffer.append(",@exo:").append(strOrderBy);
            }
            stringBuffer.append(",exo:createdDate ascending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    public void modifyTopic(List<Topic> topics, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        ArrayList<String> userIdsp = new ArrayList<String>();
        long topicCount = 0L;
        long postCount = 0L;
        Node forumNode = null;
        try {
            String topicPath = topics.get(0).getPath();
            forumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
            topicCount = forumNode.getProperty("exo:topicCount").getLong();
            postCount = forumNode.getProperty("exo:postCount").getLong();
            if (forumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
            }
            userIdsp.addAll(this.getAllAdministrator(sProvider));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        for (Topic topic : topics) {
            try {
                String topicPath = topic.getPath();
                Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                switch (type) {
                    case 1: {
                        topicNode.setProperty("exo:isClosed", topic.getIsClosed());
                        this.setActivePostByTopic(sProvider, topicNode, !topic.getIsClosed());
                        break;
                    }
                    case 2: {
                        topicNode.setProperty("exo:isLock", topic.getIsLock());
                        break;
                    }
                    case 3: {
                        topicNode.setProperty("exo:isApproved", topic.getIsApproved());
                        this.sendNotification(topicNode.getParent(), topic, null, "", true);
                        this.setActivePostByTopic(sProvider, topicNode, topic.getIsApproved());
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 4: {
                        topicNode.setProperty("exo:isSticky", topic.getIsSticky());
                        break;
                    }
                    case 5: {
                        boolean isWaiting = topic.getIsWaiting();
                        topicNode.setProperty("exo:isWaiting", isWaiting);
                        this.setActivePostByTopic(sProvider, topicNode, !isWaiting);
                        if (!isWaiting) {
                            this.sendNotification(topicNode.getParent(), topic, null, "", true);
                        }
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 6: {
                        topicNode.setProperty("exo:isActive", topic.getIsActive());
                        this.setActivePostByTopic(sProvider, topicNode, topic.getIsActive());
                        this.getTotalJobWatting(userIdsp);
                        break;
                    }
                    case 7: {
                        topicNode.setProperty("exo:name", topic.getTopicName());
                        try {
                            Node nodeFirstPost = topicNode.getNode(topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST));
                            nodeFirstPost.setProperty("exo:name", topic.getTopicName());
                        }
                        catch (PathNotFoundException e) {}
                        break;
                    }
                }
                if ((type == 3 || type == 5) && !topic.getIsWaiting() && topic.getIsApproved()) {
                    ++topicCount;
                    postCount += topicNode.getProperty("exo:postCount").getLong() + 1L;
                }
                if (type == 2 || type == 4 || type >= 7) continue;
                this.queryLastTopic(sProvider, topicPath.substring(0, topicPath.lastIndexOf("/")));
            }
            catch (PathNotFoundException e) {}
        }
        if (type == 3 || type == 5) {
            forumNode.setProperty("exo:topicCount", topicCount);
            forumNode.setProperty("exo:postCount", postCount);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
        sProvider.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            if (isNew) {
                Node newProfileNode;
                topicNode = forumNode.addNode(topic.getId(), "exo:topic");
                topicNode.setProperty("exo:id", topic.getId());
                topicNode.setProperty("exo:owner", topic.getOwner());
                Calendar calendar = this.getGreenwichMeanTime();
                topic.setCreatedDate(calendar.getTime());
                topicNode.setProperty("exo:createdDate", calendar);
                topicNode.setProperty("exo:lastPostBy", topic.getOwner());
                if (isMove && topic.getLastPostDate() != null) {
                    calendar.setTime(topic.getLastPostDate());
                }
                topicNode.setProperty("exo:lastPostDate", calendar);
                topicNode.setProperty("exo:postCount", -1L);
                topicNode.setProperty("exo:viewCount", 0L);
                topicNode.setProperty("exo:tagId", topic.getTagId());
                topicNode.setProperty("exo:isActiveByForum", true);
                topicNode.setProperty("exo:isPoll", topic.getIsPoll());
                topicNode.setProperty("exo:link", topic.getLink());
                topicNode.setProperty("exo:path", forumId);
                if (!forumNode.getProperty("exo:isModerateTopic").getBoolean() && !topic.getIsWaiting()) {
                    long newTopicCount = forumNode.getProperty("exo:topicCount").getLong() + 1L;
                    forumNode.setProperty("exo:topicCount", newTopicCount);
                }
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    newProfileNode = userProfileNode.getNode(topic.getOwner());
                    long totalTopicByUser = newProfileNode.getProperty("exo:totalTopic").getLong();
                    newProfileNode.setProperty("exo:totalTopic", totalTopicByUser + 1L);
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileNode.addNode(topic.getOwner(), Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", topic.getOwner());
                    newProfileNode.setProperty("exo:userTitle", Utils.USER);
                    if (this.isAdminRole(topic.getOwner())) {
                        newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                    }
                    newProfileNode.setProperty("exo:totalTopic", 1L);
                }
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
                this.sendNotification(forumNode, topic, null, defaultEmailContent, true);
            } else {
                topicNode = forumNode.getNode(topic.getId());
            }
            topicNode.setProperty("exo:name", topic.getTopicName());
            topicNode.setProperty("exo:modifiedBy", topic.getModifiedBy());
            topicNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            topicNode.setProperty("exo:description", topic.getDescription());
            topicNode.setProperty("exo:topicType", topic.getTopicType());
            topicNode.setProperty("exo:icon", topic.getIcon());
            topicNode.setProperty("exo:isModeratePost", topic.getIsModeratePost());
            topicNode.setProperty("exo:isNotifyWhenAddPost", topic.getIsNotifyWhenAddPost());
            topicNode.setProperty("exo:isClosed", topic.getIsClosed());
            topicNode.setProperty("exo:isLock", topic.getIsLock());
            topicNode.setProperty("exo:isApproved", topic.getIsApproved());
            topicNode.setProperty("exo:isSticky", topic.getIsSticky());
            topicNode.setProperty("exo:isWaiting", topic.getIsWaiting());
            topicNode.setProperty("exo:isActive", topic.getIsActive());
            String[] strs = topic.getCanView();
            boolean isGetLastTopic = false;
            if (!isNew) {
                if (topicNode.hasProperty("exo:canView") && strs != null && strs.length > 0) {
                    List<String> list = this.ValuesToList(topicNode.getProperty("exo:canView").getValues());
                    if (Utils.isAddNewList(list, Arrays.asList(strs))) {
                        isGetLastTopic = true;
                    }
                } else {
                    isGetLastTopic = true;
                }
            }
            if (strs == null || strs.length == 0) {
                strs = new String[]{" "};
            }
            topicNode.setProperty("exo:canView", strs);
            strs = topic.getCanPost();
            if (strs == null || strs.length == 0) {
                strs = new String[]{" "};
            }
            topicNode.setProperty("exo:canPost", strs);
            topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
            topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
            topicNode.setProperty("exo:numberAttachments", topic.getNumberAttachment());
            if (isNew) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            if (topic.getIsWaiting() || !topic.getIsApproved()) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(userIdsp);
                isGetLastTopic = true;
            }
            if (!isNew && (isGetLastTopic || topic.getIsActive() || topic.getIsClosed())) {
                this.queryLastTopic(sProvider, forumNode.getPath());
            }
            if (!isMove) {
                String id;
                if (isNew) {
                    id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                    Post post = new Post();
                    post.setId(id);
                    post.setOwner(topic.getOwner());
                    post.setCreatedDate(new Date());
                    post.setName(topic.getTopicName());
                    post.setMessage(topic.getDescription());
                    post.setRemoteAddr("");
                    post.setIcon(topic.getIcon());
                    post.setIsApproved(true);
                    post.setAttachments(topic.getAttachments());
                    post.setUserPrivate(new String[]{"exoUserPri"});
                    post.setLink(topic.getLink());
                    post.setRemoteAddr(topic.getRemoteAddr());
                    this.savePost(categoryId, forumId, topic.getId(), post, true, defaultEmailContent);
                } else {
                    id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                    if (topicNode.hasNode(id)) {
                        Node fistPostNode = topicNode.getNode(id);
                        Post post = this.getPost(fistPostNode);
                        post.setModifiedBy(topic.getModifiedBy());
                        post.setModifiedDate(new Date());
                        post.setEditReason(topic.getEditReason());
                        post.setName(topic.getTopicName());
                        post.setMessage(topic.getDescription());
                        post.setIcon(topic.getIcon());
                        post.setAttachments(topic.getAttachments());
                        this.savePost(categoryId, forumId, topic.getId(), post, false, defaultEmailContent);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private Map<String, Long> getDeletePostByUser(Node node) throws Exception {
        HashMap<String, Long> userPostMap = new HashMap<String, Long>();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("/jcr:root").append(node.getPath()).append("//element(*,exo:post)");
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(strBuilder.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node post = null;
        String owner = null;
        while (iter.hasNext()) {
            post = iter.nextNode();
            try {
                owner = post.getProperty("exo:owner").getString();
                userPostMap.put(owner, (Long)userPostMap.get(owner) + 1L);
            }
            catch (Exception e) {
                userPostMap.put(owner, Long.parseLong("1"));
            }
        }
        return userPostMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserProfileInfo(String name) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sysProvider);
            Node userNode = null;
            HashMap userPostMap = (HashMap)this.infoMap_.get(name);
            for (String user : userPostMap.keySet()) {
                try {
                    userNode = userProfileHome.getNode(user);
                    long totalPost = userNode.getProperty("exo:totalPost").getLong();
                    userNode.setProperty("exo:totalPost", totalPost - (Long)userPostMap.get(user));
                    userNode.save();
                }
                catch (Exception e) {}
            }
            this.infoMap_.remove(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    private void addUpdateUserProfileJob(Map<String, Long> userPostMap) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.UpdateUserProfileJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            this.infoMap_.put(name, userPostMap);
            schedulerService.addPeriodJob(info, periodInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic removeTopic(String categoryId, String forumId, String topicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            Topic topic = this.getTopic(categoryId, forumId, topicId, "user_gest_uoom");
            Node topicNode = forumNode.getNode(topicId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(topicNode);
            forumNode.setProperty("exo:topicCount", forumNode.getProperty("exo:topicCount").getLong() - 1L);
            long newPostCount = forumNode.getProperty("exo:postCount").getLong() - (topic.getPostCount() + 1L);
            forumNode.setProperty("exo:postCount", newPostCount);
            topicNode.remove();
            forumNode.save();
            if (!topic.getIsActive() || !topic.getIsApproved() || topic.getIsWaiting()) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(userIdsp);
            }
            try {
                this.calculateLastRead(sProvider, null, forumId, topicId);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.addUpdateUserProfileJob(userPostMap);
            }
            catch (Exception e) {
                // empty catch block
            }
            Topic topic2 = topic;
            return topic2;
        }
        catch (Exception e) {
            Topic topic = null;
            return topic;
        }
        finally {
            sProvider.close();
        }
    }

    private List<String> getFullNameAndEmail(SessionProvider sProvider, String userId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Node userProfile = this.getUserProfileHome(sProvider).getNode(userId);
        list.add(userProfile.getProperty("exo:fullName").getString());
        list.add(userProfile.getProperty("exo:email").getString());
        return list;
    }

    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            long tmp = 0L;
            String forumName = null;
            Node destForumNode = (Node)forumHomeNode.getSession().getItem(destForumPath);
            forumName = destForumNode.getProperty("exo:name").getString();
            List<String> fullNameEmailOwnerDestForum = this.getFullNameAndEmail(sProvider, destForumNode.getProperty("exo:owner").getString());
            Message message = new Message();
            message.setMimeType("text/html");
            String headerSubject = "";
            String objectName = "[" + destForumNode.getParent().getProperty("exo:name").getString() + "][" + destForumNode.getProperty("exo:name").getString() + "] ";
            try {
                String str;
                Node node = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                    headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
                }
                if (node.hasProperty("exo:notifyEmailMoved") && (str = node.getProperty("exo:notifyEmailMoved").getString()) != null && str.trim().length() > 0) {
                    mailContent = str;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_TYPE", (String)Utils.TOPIC);
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_PARENT_TYPE", (String)Utils.FORUM);
            message.setFrom(fullNameEmailOwnerDestForum.get(0) + "<" + fullNameEmailOwnerDestForum.get(1) + ">");
            String destForumId = destForumNode.getName();
            String srcForumId = "";
            for (Topic topic : topics) {
                String topicPath = topic.getPath();
                String newTopicPath = destForumPath + "/" + topic.getId();
                Node srcForumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
                srcForumId = srcForumNode.getName();
                forumHomeNode.getSession().getWorkspace().move(topicPath, newTopicPath);
                tmp = srcForumNode.getProperty("exo:topicCount").getLong();
                tmp = tmp > 0L ? --tmp : 0L;
                srcForumNode.setProperty("exo:topicCount", tmp);
                this.queryLastTopic(sProvider, srcForumNode.getPath());
                Node topicNode = (Node)forumHomeNode.getSession().getItem(newTopicPath);
                topicNode.setProperty("exo:path", destForumNode.getName());
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
                destForumNode.setProperty("exo:topicCount", destForumNode.getProperty("exo:topicCount").getLong() + 1L);
                this.queryLastTopic(sProvider, destForumNode.getPath());
                tmp = srcForumNode.getProperty("exo:postCount").getLong();
                tmp = tmp > topicPostCount ? (tmp -= topicPostCount) : 0L;
                srcForumNode.setProperty("exo:postCount", tmp);
                destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + topicPostCount);
                message.setSubject(headerSubject + objectName + topic.getTopicName());
                message.setBody(mailContent.replace("$OBJECT_NAME", topic.getTopicName()).replace("$OBJECT_PARENT_NAME", forumName).replace("$VIEWPOST_LINK", link.replaceFirst("pathId", topic.getId())));
                List<String> fullNameEmailOwnerTopic = this.getFullNameAndEmail(sProvider, topic.getOwner());
                fullNameEmailOwnerTopic.remove(0);
                this.sendEmailNotification(fullNameEmailOwnerTopic, message);
                try {
                    this.calculateLastRead(sProvider, destForumId, srcForumId, topic.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    private void calculateLastRead(SessionProvider sProvider, String destForumId, String srcForumId, String topicId) throws Exception {
        Node profileHome = this.getUserProfileHome(sProvider);
        QueryManager qm = profileHome.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(profileHome.getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append("[(jcr:contains(@exo:lastReadPostOfForum, '").append("*" + topicId + "*").append("'))]");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> list2 = new ArrayList<String>();
            Node profileNode = iter.nextNode();
            list.addAll(this.ValuesToList(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
            list2.addAll(list);
            boolean isRead = false;
            for (String string : list) {
                block10: {
                    if (destForumId != null && string.indexOf(destForumId) >= 0) {
                        isRead = true;
                        try {
                            long lastAccessTopicTime = 0L;
                            long lastAccessForumTime = 0L;
                            if (!profileNode.hasProperty("exo:lastReadPostOfTopic")) break block10;
                            ArrayList<String> listAccess = new ArrayList<String>();
                            listAccess.addAll(this.ValuesToList(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                            for (String string2 : listAccess) {
                                if (string2.indexOf(topicId) < 0) continue;
                                lastAccessTopicTime = Long.parseLong(string2.split(",")[2]);
                                if (lastAccessTopicTime > 0L) {
                                    Value[] values;
                                    for (Value vl : values = profileNode.getProperty("exo:readForum").getValues()) {
                                        String str = vl.getString();
                                        if (str.indexOf(destForumId) < 0 || str.indexOf(":") <= 0) continue;
                                        lastAccessForumTime = Long.parseLong(str.split(":")[1]);
                                        break;
                                    }
                                }
                                if (lastAccessTopicTime > lastAccessForumTime) {
                                    list2.remove(string);
                                    list2.add(destForumId + "," + string2.substring(0, string2.lastIndexOf(",")));
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (string.indexOf(srcForumId) < 0) continue;
                list2.remove(string);
            }
            if (!isRead && destForumId != null) {
                list2.add(destForumId + "," + topicId + "/" + topicId.replace(Utils.TOPIC, Utils.POST));
            }
            profileNode.setProperty("exo:lastReadPostOfForum", list2.toArray(new String[0]));
        }
        profileHome.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node catNode = this.getCategoryHome(sProvider);
            Node postNode = catNode.getNode(path);
            if (postNode != null) {
                Calendar cal = postNode.getProperty("exo:createdDate").getDate();
                StringBuilder builder = new StringBuilder();
                builder.append("/jcr:root").append(postNode.getParent().getPath()).append("/element(*,exo:post)");
                StringBuilder strBd = this.getPathQuery(isApproved, isHidden, userLogin);
                if (strBd.length() > 0) {
                    builder.append(strBd.toString().replace("]", "")).append(" and ");
                } else {
                    builder.append("[");
                }
                builder.append("(@exo:createdDate <= xs:dateTime('").append(ISO8601.format((Calendar)cal)).append("'))]");
                QueryManager qm = postNode.getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery(builder.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                long size = iter.getSize();
                boolean isView = false;
                while (iter.hasNext()) {
                    if (!iter.nextNode().getName().equals(postNode.getName())) continue;
                    isView = true;
                    break;
                }
                if (!isView) {
                    size = 1L;
                }
                long l = size;
                return l;
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node topicNode = this.getCategoryHome(sProvider).getNode(topicPath);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            stringBuffer.append(this.getPathQuery(null, "", "exoUserPri").toString().replaceAll("]", "")).append(" and exo:isFirstPost='false'] order by @exo:createdDate ascending");
            QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node topicNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId + "/" + topicId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            stringBuffer.append((CharSequence)this.getPathQuery(isApproved, isHidden, userLogin));
            stringBuffer.append(" order by @exo:createdDate ascending");
            ForumPageList forumPageList = pagelist = new ForumPageList(null, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (PathNotFoundException e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    private StringBuilder getPathQuery(String isApproved, String isHidden, String userLogin) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        boolean isAnd = false;
        if (userLogin != null && userLogin.length() > 0) {
            isAnd = true;
            strBuilder.append("[((@exo:userPrivate='").append(userLogin).append("') or (@exo:userPrivate='exoUserPri'))");
        }
        if (isApproved != null && isApproved.length() > 0) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isApproved='").append(isApproved).append("')");
            } else {
                strBuilder.append("[(@exo:isApproved='").append(isApproved).append("')");
            }
            if (isHidden.equals("false")) {
                strBuilder.append(" and (@exo:isHidden='false')");
            }
            strBuilder.append("]");
        } else if (isHidden.equals("true")) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isHidden='true')]");
            } else {
                strBuilder.append("[@exo:isHidden='true']");
            }
        } else if (isHidden.equals("false")) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isHidden='false')]");
            } else {
                strBuilder.append("[@exo:isHidden='false']");
            }
        } else if (isAnd) {
            strBuilder.append("]");
        }
        return strBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(categoryId).append("/").append(forumId).append("/").append(topicId);
            Node topicNode = this.getCategoryHome(sProvider).getNode(strBuilder.toString());
            strBuilder = new StringBuilder();
            strBuilder.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            strBuilder.append((CharSequence)this.getPathQuery(isApproved, isHidden, userLogin));
            QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(strBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            long l = iter.getSize();
            return l;
        }
        catch (PathNotFoundException e) {
            long l = 0L;
            return l;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer pathQuery = new StringBuffer();
            pathQuery.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:post)[@exo:isFirstPost='false' and @exo:owner='").append(userName);
            if (isMod) {
                pathQuery.append("' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            } else {
                pathQuery.append("' and @exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            }
            if (strOrderBy != null && strOrderBy.trim().length() > 0) {
                pathQuery.append("order by @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("createdDate") < 0) {
                    pathQuery.append(",@exo:createdDate descending");
                }
            }
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node postNode;
            Node categoryHome = this.getCategoryHome(sProvider);
            if (postId.lastIndexOf("/") > 0) {
                if (postId.indexOf(categoryHome.getName()) < 0) {
                    postId = categoryHome.getPath() + "/" + postId;
                }
                postNode = (Node)categoryHome.getSession().getItem(postId);
            } else {
                postNode = categoryHome.getNode(categoryId + "/" + forumId + "/" + topicId + "/" + postId);
            }
            Post postNew = new Post();
            Post post = postNew = this.getPost(postNode);
            return post;
        }
        catch (PathNotFoundException e) {
            Post post = null;
            return post;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:post)[@exo:remoteAddr='").append(ip).append("']");
            if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
                builder.append(" order by @exo:lastPostDate descending");
            } else {
                builder.append(" order by @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    builder.append(", @exo:lastPostDate descending");
                }
            }
            String pathQuery = builder.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 5, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    protected Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        PropertyReader reader = new PropertyReader(postNode);
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        postNew.setOwner(reader.string("exo:owner"));
        postNew.setCreatedDate(reader.date("exo:createdDate"));
        postNew.setModifiedBy(reader.string("exo:modifiedBy"));
        postNew.setModifiedDate(reader.date("exo:modifiedDate"));
        postNew.setEditReason(reader.string("exo:editReason"));
        postNew.setName(reader.string("exo:name"));
        postNew.setMessage(reader.string("exo:message"));
        postNew.setRemoteAddr(reader.string("exo:remoteAddr"));
        postNew.setIcon(reader.string("exo:icon"));
        postNew.setLink(reader.string("exo:link"));
        postNew.setIsApproved(reader.bool("exo:isApproved"));
        postNew.setIsHidden(reader.bool("exo:isHidden"));
        postNew.setIsActiveByTopic(reader.bool("exo:isActiveByTopic"));
        postNew.setUserPrivate(reader.strings("exo:userPrivate"));
        postNew.setNumberAttach(reader.l("exo:numberAttach"));
        if (postNew.getNumberAttach() > 0L) {
            NodeIterator postAttachments = postNode.getNodes();
            ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
            while (postAttachments.hasNext()) {
                Node node = postAttachments.nextNode();
                if (!node.isNodeType("exo:forumAttachment")) continue;
                JCRForumAttachment attachment = new JCRForumAttachment();
                Node nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getName());
                attachment.setPathNode(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                String workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                attachment.setPath("/" + workspace + node.getPath());
                attachments.add(attachment);
            }
            postNew.setAttachments(attachments);
        }
        return postNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node postNode;
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Calendar calendar = this.getGreenwichMeanTime();
            if (isNew) {
                Node newProfileNode;
                postNode = topicNode.addNode(post.getId(), "exo:post");
                postNode.setProperty("exo:id", post.getId());
                postNode.setProperty("exo:path", forumId);
                postNode.setProperty("exo:owner", post.getOwner());
                post.setCreatedDate(calendar.getTime());
                postNode.setProperty("exo:createdDate", calendar);
                postNode.setProperty("exo:userPrivate", post.getUserPrivate());
                postNode.setProperty("exo:isActiveByTopic", true);
                postNode.setProperty("exo:link", post.getLink());
                if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                    postNode.setProperty("exo:isFirstPost", true);
                } else {
                    postNode.setProperty("exo:isFirstPost", false);
                }
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    newProfileNode = userProfileNode.getNode(post.getOwner());
                    long totalPostByUser = 0L;
                    totalPostByUser = newProfileNode.getProperty("exo:totalPost").getLong();
                    newProfileNode.setProperty("exo:totalPost", totalPostByUser + 1L);
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileNode.addNode(post.getOwner(), Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", post.getOwner());
                    newProfileNode.setProperty("exo:userTitle", Utils.USER);
                    if (this.isAdminRole(post.getOwner())) {
                        newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                    }
                    newProfileNode.setProperty("exo:totalPost", 1L);
                }
                newProfileNode.setProperty("exo:lastPostDate", calendar);
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
            } else {
                postNode = topicNode.getNode(post.getId());
            }
            if (post.getModifiedBy() != null && post.getModifiedBy().length() > 0) {
                postNode.setProperty("exo:modifiedBy", post.getModifiedBy());
                postNode.setProperty("exo:modifiedDate", calendar);
                postNode.setProperty("exo:editReason", post.getEditReason());
            }
            postNode.setProperty("exo:name", post.getName());
            postNode.setProperty("exo:message", post.getMessage());
            postNode.setProperty("exo:remoteAddr", post.getRemoteAddr());
            postNode.setProperty("exo:icon", post.getIcon());
            postNode.setProperty("exo:isApproved", post.getIsApproved());
            postNode.setProperty("exo:isHidden", post.getIsHidden());
            long numberAttach = 0L;
            ArrayList<String> listFileName = new ArrayList<String>();
            List<ForumAttachment> attachments = post.getAttachments();
            if (attachments != null) {
                Iterator<ForumAttachment> it = attachments.iterator();
                for (ForumAttachment attachment : attachments) {
                    ++numberAttach;
                    BufferAttachment file = null;
                    listFileName.add(attachment.getId());
                    try {
                        file = (BufferAttachment)it.next();
                        Node nodeFile = null;
                        nodeFile = !postNode.hasNode(file.getId()) ? postNode.addNode(file.getId(), "exo:forumAttachment") : postNode.getNode(file.getId());
                        ForumServiceUtils.reparePermissions(nodeFile, "any");
                        Node nodeContent = null;
                        if (nodeFile.hasNode("jcr:content")) continue;
                        nodeContent = nodeFile.addNode("jcr:content", "exo:forumResource");
                        nodeContent.setProperty("jcr:mimeType", file.getMimeType());
                        nodeContent.setProperty("jcr:data", file.getInputStream());
                        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                        nodeContent.setProperty("exo:fileName", file.getName());
                    }
                    catch (Exception e) {}
                }
            }
            NodeIterator postAttachments = postNode.getNodes();
            Node postAttachmentNode = null;
            while (postAttachments.hasNext()) {
                postAttachmentNode = postAttachments.nextNode();
                if (listFileName.contains(postAttachmentNode.getName())) continue;
                postAttachmentNode.remove();
            }
            boolean sendAlertJob = true;
            boolean isFistPost = false;
            if (isNew) {
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
                long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong() + numberAttach;
                if (topicPostCount == 0L) {
                    topicNode.setProperty("exo:postCount", topicPostCount);
                }
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() + 1L;
                boolean isSetLastPost = true;
                if (topicNode.getProperty("exo:isClosed").getBoolean()) {
                    sendAlertJob = false;
                    postNode.setProperty("exo:isActiveByTopic", false);
                } else {
                    if (isSetLastPost && topicNode.getProperty("exo:isWaiting").getBoolean()) {
                        isSetLastPost = false;
                        sendAlertJob = false;
                    }
                    if (isSetLastPost) {
                        sendAlertJob = false;
                        isSetLastPost = topicNode.getProperty("exo:isActive").getBoolean();
                    }
                    if (isSetLastPost) {
                        if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                            isFistPost = true;
                            if (!forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                                forumNode.setProperty("exo:postCount", forumPostCount);
                                if (!topicNode.hasProperty("exo:canView") || topicNode.getProperty("exo:canView").getValues()[0].getString().equals(" ")) {
                                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                }
                                sendAlertJob = false;
                            } else if (topicNode.getProperty("exo:isApproved").getBoolean()) {
                                if (!topicNode.hasProperty("exo:canView") || topicNode.getProperty("exo:canView").getValues()[0].getString().equals(" ")) {
                                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                }
                                sendAlertJob = false;
                            }
                            if (!post.getIsHidden()) {
                                topicNode.setProperty("exo:postCount", topicPostCount);
                                topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                topicNode.setProperty("exo:lastPostDate", calendar);
                                topicNode.setProperty("exo:lastPostBy", post.getOwner());
                            }
                        } else {
                            if (forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                                if (topicNode.getProperty("exo:isApproved").getBoolean() && !topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                                    if (!topicNode.hasProperty("exo:canView") || topicNode.getProperty("exo:canView").getValues()[0].getString().equals(" ")) {
                                        forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                    }
                                    sendAlertJob = false;
                                }
                            } else if (!topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                sendAlertJob = false;
                            } else if (post.getIsApproved()) {
                                if (!topicNode.hasProperty("exo:canView") || topicNode.getProperty("exo:canView").getValues()[0].getString().equals(" ")) {
                                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                }
                                sendAlertJob = false;
                            }
                            if (post.getIsApproved()) {
                                if (!post.getIsHidden() && post.getUserPrivate().length != 2) {
                                    forumNode.setProperty("exo:postCount", forumPostCount);
                                    topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                    topicNode.setProperty("exo:postCount", topicPostCount);
                                    topicNode.setProperty("exo:lastPostDate", calendar);
                                    topicNode.setProperty("exo:lastPostBy", post.getOwner());
                                }
                                if (post.getIsHidden()) {
                                    sendAlertJob = true;
                                }
                            } else if (!sendAlertJob) {
                                sendAlertJob = true;
                            }
                        }
                    } else {
                        postNode.setProperty("exo:isActiveByTopic", false);
                        sendAlertJob = true;
                    }
                }
                if (isNew && defaultEmailContent.length() == 0) {
                    sendAlertJob = false;
                }
            } else {
                if (post.getIsApproved() && !post.getIsHidden()) {
                    sendAlertJob = false;
                }
                long temp = topicNode.getProperty("exo:numberAttachments").getLong() - postNode.getProperty("exo:numberAttach").getLong();
                topicNode.setProperty("exo:numberAttachments", temp + numberAttach);
            }
            postNode.setProperty("exo:numberAttach", numberAttach);
            if (isNew) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            try {
                if (!isFistPost && isNew) {
                    this.sendNotification(topicNode, null, post, defaultEmailContent, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sendAlertJob) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(userIdsp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(Node node, Topic topic, Post post, String defaultEmailContent, boolean isApprovePost) throws Exception {
        block86: {
            Node forumAdminNode = null;
            String headerSubject = "";
            String catName = "";
            String forumName = "";
            String topicName = "";
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            BBCodeOperator bbcodeObject = new BBCodeOperator(this.nodeHierarchyCreator_, this.rService_);
            try {
                SimpleDateFormat formatter;
                Date createdDate;
                Message message;
                try {
                    forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String content = "";
                if (forumAdminNode != null) {
                    if (forumAdminNode.hasProperty("exo:notifyEmailContent")) {
                        content = forumAdminNode.getProperty("exo:notifyEmailContent").getString();
                    }
                    if (forumAdminNode.hasProperty("exo:enableHeaderSubject") && forumAdminNode.getProperty("exo:enableHeaderSubject").getBoolean() && forumAdminNode.hasProperty("exo:headerSubject")) {
                        headerSubject = forumAdminNode.getProperty("exo:headerSubject").getString();
                    }
                } else {
                    content = defaultEmailContent != null && defaultEmailContent.length() > 0 ? defaultEmailContent : Utils.DEFAULT_EMAIL_CONTENT;
                }
                List<String> listUser = new ArrayList<String>();
                List<Object> emailList = new ArrayList<String>();
                ArrayList<String> emailListCate = new ArrayList<String>();
                Node userProfileHome = null;
                userProfileHome = this.getUserProfileHome(sProvider);
                int count = 0;
                if (post == null) {
                    Node forumNode = node;
                    forumName = node.getProperty("exo:name").getString();
                    node = node.getParent();
                    catName = node.getProperty("exo:name").getString();
                    topicName = topic.getTopicName();
                    while (true) {
                        List<String> notyfys;
                        emailListCate.addAll(emailList);
                        emailList = new ArrayList();
                        if (node.isNodeType("exo:forumWatching") && topic.getIsActive() && topic.getIsApproved() && topic.getIsActiveByForum() && !topic.getIsClosed() && !topic.getIsLock() && !topic.getIsWaiting()) {
                            Node categoryNode = null;
                            categoryNode = node.isNodeType("exo:forumCategory") ? node : node.getParent();
                            if (categoryNode.hasProperty("exo:userPrivate")) {
                                listUser.addAll(this.ValuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                            }
                            if (!listUser.isEmpty() && !((String)listUser.get(0)).equals(" ")) {
                                if (node.hasProperty("exo:emailWatching")) {
                                    List<String> emails = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                                    int i = 0;
                                    for (String user : this.ValuesToList(node.getProperty("exo:userWatching").getValues())) {
                                        if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                            emailList.add(emails.get(i));
                                        }
                                        ++i;
                                    }
                                }
                            } else if (node.hasProperty("exo:emailWatching")) {
                                emailList.addAll(this.ValuesToList(node.getProperty("exo:emailWatching").getValues()));
                            }
                        }
                        if (node.hasProperty("exo:notifyWhenAddTopic") && !(notyfys = this.ValuesToList(node.getProperty("exo:notifyWhenAddTopic").getValues())).isEmpty()) {
                            emailList.addAll(notyfys);
                        }
                        for (String string : emailListCate) {
                            while (emailList.contains(string)) {
                                emailList.remove(string);
                            }
                        }
                        if (emailList.size() > 0) {
                            Message message2 = new Message();
                            message2.setMimeType("text/html");
                            String owner = topic.getOwner();
                            try {
                                Node userNode = userProfileHome.getNode(owner);
                                String email = userNode.getProperty("exo:email").getString();
                                String fullName = userNode.getProperty("exo:fullName").getString();
                                if (email != null && email.length() > 0) {
                                    message2.setFrom(fullName + "<" + email + ">");
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            String content_ = node.getProperty("exo:name").getString();
                            if (headerSubject != null && headerSubject.length() > 0) {
                                headerSubject = StringUtils.replace((String)headerSubject, (String)"$CATEGORY", (String)catName);
                                headerSubject = StringUtils.replace((String)headerSubject, (String)"$FORUM", (String)forumName);
                                headerSubject = StringUtils.replace((String)headerSubject, (String)"$TOPIC", (String)topicName);
                            } else {
                                headerSubject = "Email notify [" + catName + "][" + forumName + "]" + topicName;
                            }
                            message2.setSubject(headerSubject);
                            if (node.isNodeType("exo:forum")) {
                                content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)content_);
                                content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.FORUM);
                            } else {
                                content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)content_);
                                content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)"Category");
                            }
                            String postFistId = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                            content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Topic");
                            content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(topic.getDescription(), bbcodeObject.getActiveBBCode()));
                            Date createdDate2 = topic.getCreatedDate();
                            SimpleDateFormat formatter2 = new SimpleDateFormat("HH:mm");
                            content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter2.format((Object)createdDate2) + " GMT+0"));
                            formatter2 = new SimpleDateFormat("MM/dd/yyyy");
                            content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter2.format((Object)createdDate2));
                            content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)topic.getOwner());
                            content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)("<a target=\"_blank\" href=\"" + topic.getLink() + "\">click here</a><br/>"));
                            content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)("<a target=\"_blank\" href=\"" + topic.getLink().replace("public", "private") + "/" + postFistId + "/true\">click here</a><br/>"));
                            content_ = StringUtils.replace((String)content_, (String)"$CATEGORY", (String)catName);
                            content_ = StringUtils.replace((String)content_, (String)"$FORUM", (String)forumName);
                            content_ = StringUtils.replace((String)content_, (String)"$TOPIC", (String)topicName);
                            message2.setBody(content_);
                            this.sendEmailNotification(emailList, message2);
                        }
                        if (node.isNodeType("exo:forum")) break block86;
                        if (count > 1) {
                            break block86;
                        }
                        ++count;
                        node = forumNode;
                    }
                }
                if (node.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) break block86;
                Node forumNode = node.getParent();
                Node categoryNode = forumNode.getParent();
                catName = categoryNode.getProperty("exo:name").getString();
                forumName = forumNode.getProperty("exo:name").getString();
                topicName = node.getProperty("exo:name").getString();
                boolean isSend = false;
                if (post.getIsApproved() && post.getIsActiveByTopic() && !post.getIsHidden()) {
                    isSend = true;
                    ArrayList<String> listCanViewInTopic = new ArrayList<String>();
                    listCanViewInTopic.addAll(this.ValuesToList(node.getProperty("exo:canView").getValues()));
                    if (post.getUserPrivate() != null && post.getUserPrivate().length > 1) {
                        listUser.addAll(Arrays.asList(post.getUserPrivate()));
                    }
                    if (listUser.isEmpty() || listUser.size() == 1) {
                        if (!listCanViewInTopic.isEmpty() && !((String)listCanViewInTopic.get(0)).equals(" ")) {
                            listCanViewInTopic.addAll(this.ValuesToList(forumNode.getProperty("exo:poster").getValues()));
                            listCanViewInTopic.addAll(this.ValuesToList(forumNode.getProperty("exo:viewer").getValues()));
                        }
                        if (categoryNode.hasProperty("exo:userPrivate")) {
                            listUser.addAll(this.ValuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                        }
                        if (!listUser.isEmpty() && !((String)listUser.get(0)).equals(" ")) {
                            if (!listCanViewInTopic.isEmpty() && !((String)listCanViewInTopic.get(0)).equals(" ") && ((listUser = JCRDataStorage.combineListToList(listUser, listCanViewInTopic)).isEmpty() || listUser.get(0).equals(" "))) {
                                isSend = false;
                            }
                        } else {
                            listUser = listCanViewInTopic;
                        }
                    }
                }
                if (node.isNodeType("exo:forumWatching") && node.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(node.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailList.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailList = this.ValuesToList(node.getProperty("exo:emailWatching").getValues());
                    }
                }
                ArrayList<String> emailListForum = new ArrayList<String>();
                if (isApprovePost) {
                    String[] users;
                    String ownerTopicEmail = "";
                    String owner = node.getProperty("exo:owner").getString();
                    if (node.hasProperty("exo:isNotifyWhenAddPost") && node.getProperty("exo:isNotifyWhenAddPost").getString().trim().length() > 0) {
                        try {
                            Node userOwner = userProfileHome.getNode(owner);
                            ownerTopicEmail = userOwner.getProperty("exo:email").getString();
                        }
                        catch (Exception e) {
                            ownerTopicEmail = node.getProperty("exo:isNotifyWhenAddPost").getString();
                        }
                    }
                    if ((users = post.getUserPrivate()) != null && users.length == 2) {
                        if (ownerTopicEmail.trim().length() > 0 && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailList.add(ownerTopicEmail);
                        }
                        owner = forumNode.getProperty("exo:owner").getString();
                        if (forumNode.hasProperty("exo:notifyWhenAddPost") && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    } else {
                        if (ownerTopicEmail.trim().length() > 0) {
                            emailList.add(ownerTopicEmail);
                        }
                        if (forumNode.hasProperty("exo:notifyWhenAddPost")) {
                            emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    }
                }
                if (forumNode.isNodeType("exo:forumWatching") && forumNode.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(forumNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(forumNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailListForum.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListForum.addAll(this.ValuesToList(forumNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                ArrayList<String> emailListCategory = new ArrayList<String>();
                if (categoryNode.isNodeType("exo:forumWatching") && categoryNode.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || ((String)listUser.get(0)).equals(" "))) {
                        List<String> emails = this.ValuesToList(categoryNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : this.ValuesToList(categoryNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[0]), user)) {
                                emailListCategory.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListCategory.addAll(this.ValuesToList(categoryNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                String email = "";
                String fullName = "";
                String owner = post.getOwner();
                try {
                    Node userNode = userProfileHome.getNode(owner);
                    email = userNode.getProperty("exo:email").getString();
                    fullName = userNode.getProperty("exo:fullName").getString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String content_ = "";
                if (emailListCategory.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    String categoryName = categoryNode.getProperty("exo:name").getString();
                    content_ = node.getProperty("exo:name").getString();
                    if (headerSubject != null && headerSubject.length() > 0) {
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$CATEGORY", (String)catName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$FORUM", (String)forumName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$TOPIC", (String)topicName);
                    } else {
                        headerSubject = "Email notify [" + catName + "][" + forumName + "]" + topicName;
                    }
                    message.setSubject(headerSubject);
                    content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)categoryName);
                    content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)"Category");
                    content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Post");
                    content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage(), bbcodeObject.getActiveBBCode()));
                    Date createdDate3 = post.getCreatedDate();
                    SimpleDateFormat formatter3 = new SimpleDateFormat("HH:mm");
                    content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter3.format((Object)createdDate3) + " GMT+0"));
                    formatter3 = new SimpleDateFormat("MM/dd/yyyy");
                    content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter3.format((Object)createdDate3));
                    content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)post.getOwner());
                    content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "/" + post.getId() + "\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink().replace("public", "private") + "/" + post.getId() + "/true\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$CATEGORY", (String)catName);
                    content_ = StringUtils.replace((String)content_, (String)"$FORUM", (String)forumName);
                    content_ = StringUtils.replace((String)content_, (String)"$TOPIC", (String)topicName);
                    message.setBody(content_);
                    this.sendEmailNotification(emailListCategory, message);
                }
                for (String string : emailListCategory) {
                    while (emailListForum.contains(string)) {
                        emailListForum.remove(string);
                    }
                }
                if (emailListForum.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    if (headerSubject != null && headerSubject.length() > 0) {
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$CATEGORY", (String)catName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$FORUM", (String)forumName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$TOPIC", (String)topicName);
                    } else {
                        headerSubject = "Email notify [" + catName + "][" + forumName + "]" + topicName;
                    }
                    message.setSubject(headerSubject);
                    content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)forumNode.getProperty("exo:name").getString());
                    content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.FORUM);
                    content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Post");
                    content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage(), bbcodeObject.getActiveBBCode()));
                    createdDate = post.getCreatedDate();
                    formatter = new SimpleDateFormat("HH:mm");
                    content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter.format((Object)createdDate) + " GMT+0"));
                    formatter = new SimpleDateFormat("MM/dd/yyyy");
                    content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter.format((Object)createdDate));
                    content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)post.getOwner());
                    content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "/" + post.getId() + "\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink().replace("public", "private") + "/" + post.getId() + "/true\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$CATEGORY", (String)catName);
                    content_ = StringUtils.replace((String)content_, (String)"$FORUM", (String)forumName);
                    content_ = StringUtils.replace((String)content_, (String)"$TOPIC", (String)topicName);
                    message.setBody(content_);
                    this.sendEmailNotification(emailListForum, message);
                }
                for (String string : emailListCategory) {
                    while (emailList.contains(string)) {
                        emailList.remove(string);
                    }
                }
                for (String string : emailListForum) {
                    while (emailList.contains(string)) {
                        emailList.remove(string);
                    }
                }
                if (emailList.size() > 0) {
                    message = new Message();
                    if (email != null && email.length() > 0) {
                        message.setFrom(fullName + " <" + email + ">");
                    }
                    message.setMimeType("text/html");
                    if (headerSubject != null && headerSubject.length() > 0) {
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$CATEGORY", (String)catName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$FORUM", (String)forumName);
                        headerSubject = StringUtils.replace((String)headerSubject, (String)"$TOPIC", (String)topicName);
                    } else {
                        headerSubject = "Email notify [" + catName + "][" + forumName + "]" + topicName;
                    }
                    message.setSubject(headerSubject);
                    content_ = StringUtils.replace((String)content, (String)"$OBJECT_NAME", (String)topicName);
                    content_ = StringUtils.replace((String)content_, (String)"$OBJECT_WATCH_TYPE", (String)Utils.TOPIC);
                    content_ = StringUtils.replace((String)content_, (String)"$ADD_TYPE", (String)"Post");
                    content_ = StringUtils.replace((String)content_, (String)"$POST_CONTENT", (String)Utils.convertCodeHTML(post.getMessage(), bbcodeObject.getActiveBBCode()));
                    createdDate = post.getCreatedDate();
                    formatter = new SimpleDateFormat("HH:mm");
                    content_ = StringUtils.replace((String)content_, (String)"$TIME", (String)(formatter.format((Object)createdDate) + " GMT+0"));
                    formatter = new SimpleDateFormat("MM/dd/yyyy");
                    content_ = StringUtils.replace((String)content_, (String)"$DATE", (String)formatter.format((Object)createdDate));
                    content_ = StringUtils.replace((String)content_, (String)"$POSTER", (String)owner);
                    content_ = StringUtils.replace((String)content_, (String)"$VIEWPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink() + "/" + post.getId() + "\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$REPLYPOST_LINK", (String)("<a target=\"_blank\" href=\"" + post.getLink().replace("public", "private") + "/" + post.getId() + "/true\">click here</a><br/>"));
                    content_ = StringUtils.replace((String)content_, (String)"$CATEGORY", (String)catName);
                    content_ = StringUtils.replace((String)content_, (String)"$FORUM", (String)forumName);
                    content_ = StringUtils.replace((String)content_, (String)"$TOPIC", (String)topicName);
                    message.setBody(content_);
                    this.sendEmailNotification(emailList, message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                bbcodeObject = null;
                sProvider.close();
            }
        }
    }

    public void modifyPost(List<Post> posts, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        for (Post post : posts) {
            try {
                boolean isGetLastPost = false;
                String postPath = post.getPath();
                String topicPath = postPath.substring(0, postPath.lastIndexOf("/"));
                String forumPath = postPath.substring(0, topicPath.lastIndexOf("/"));
                Node postNode = (Node)forumHomeNode.getSession().getItem(postPath);
                Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
                Calendar lastPostDate = topicNode.getProperty("exo:lastPostDate").getDate();
                Calendar postDate = postNode.getProperty("exo:createdDate").getDate();
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong();
                long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong();
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong();
                ArrayList<String> userIdsp = new ArrayList<String>();
                try {
                    if (forumNode.hasProperty("exo:moderators")) {
                        userIdsp.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                    }
                    userIdsp.addAll(this.getAllAdministrator(sProvider));
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (type) {
                    case 1: {
                        postNode.setProperty("exo:isApproved", true);
                        post.setIsApproved(true);
                        this.sendNotification(topicNode, null, post, "", false);
                        break;
                    }
                    case 2: {
                        if (post.getIsHidden()) {
                            postNode.setProperty("exo:isHidden", true);
                            Node postLastNode = this.getLastDatePost(forumHomeNode, topicNode, postNode);
                            if (postLastNode != null) {
                                topicNode.setProperty("exo:lastPostDate", postLastNode.getProperty("exo:createdDate").getDate());
                                topicNode.setProperty("exo:lastPostBy", postLastNode.getProperty("exo:owner").getString());
                                isGetLastPost = true;
                            }
                            if ((newNumberAttach -= postNode.getProperty("exo:numberAttach").getLong()) < 0L) {
                                newNumberAttach = 0L;
                            }
                            topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                            topicNode.setProperty("exo:postCount", topicPostCount - 1L);
                            forumNode.setProperty("exo:postCount", forumPostCount - 1L);
                            break;
                        }
                        postNode.setProperty("exo:isHidden", false);
                        this.sendNotification(topicNode, null, post, "", false);
                        break;
                    }
                }
                if (!post.getIsHidden() && post.getIsApproved()) {
                    if (postDate.getTimeInMillis() > lastPostDate.getTimeInMillis()) {
                        topicNode.setProperty("exo:lastPostDate", postDate);
                        topicNode.setProperty("exo:lastPostBy", post.getOwner());
                        isGetLastPost = true;
                    }
                    topicNode.setProperty("exo:numberAttachments", newNumberAttach += postNode.getProperty("exo:numberAttach").getLong());
                    topicNode.setProperty("exo:postCount", topicPostCount + 1L);
                    forumNode.setProperty("exo:postCount", forumPostCount + 1L);
                }
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
                if (isGetLastPost) {
                    this.queryLastTopic(sProvider, topicPath.substring(0, topicPath.lastIndexOf("/")));
                }
                this.getTotalJobWatting(userIdsp);
            }
            catch (PathNotFoundException e) {
                e.printStackTrace();
            }
        }
        sProvider.close();
    }

    private Node getLastDatePost(Node forumHomeNode, Node node, Node postNode_) throws Exception {
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer pathQuery = new StringBuffer();
        pathQuery.append("/jcr:root").append(node.getPath()).append("//element(*,exo:post)[@exo:isHidden='false' and @exo:isApproved='true'] order by @exo:createdDate descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node postNode = null;
        while (iter.hasNext() && (postNode = iter.nextNode()).getName().equals(postNode_.getName())) {
        }
        return postNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Post removePost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Post post = new Post();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            post = this.getPost(categoryId, forumId, topicId, postId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Node postNode = topicNode.getNode(postId);
            long numberAttachs = postNode.getProperty("exo:numberAttach").getLong();
            String owner = postNode.getProperty("exo:owner").getString();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                Node newProfileNode = userProfileNode.getNode(owner);
                newProfileNode.setProperty("exo:totalPost", newProfileNode.getProperty("exo:totalPost").getLong() - 1L);
                newProfileNode.save();
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            postNode.remove();
            if (!post.getIsHidden() && post.getIsApproved() && (post.getUserPrivate() == null || post.getUserPrivate().length == 1)) {
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() - 1L;
                topicNode.setProperty("exo:postCount", topicPostCount);
                long newNumberAttachs = topicNode.getProperty("exo:numberAttachments").getLong();
                newNumberAttachs = newNumberAttachs > numberAttachs ? (newNumberAttachs -= numberAttachs) : 0L;
                topicNode.setProperty("exo:numberAttachments", newNumberAttachs);
            }
            NodeIterator nodeIterator = topicNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                postNode = node;
            }
            topicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            topicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            forumNode.save();
            if (!post.getIsHidden() && post.getIsApproved() && (post.getUserPrivate() == null || post.getUserPrivate().length == 1)) {
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() - 1L;
                forumNode.setProperty("exo:postCount", forumPostCount);
                forumNode.save();
            } else if (post.getUserPrivate() == null || post.getUserPrivate().length == 1) {
                ArrayList<String> list = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    list.addAll(this.ValuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                list.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(list);
            }
            Post post2 = post;
            return post2;
        }
        catch (Exception e) {
            Post post3 = null;
            return post3;
        }
        finally {
            sProvider.close();
        }
    }

    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String srcTopicPath = postPaths[0];
            srcTopicPath = srcTopicPath.substring(0, srcTopicPath.lastIndexOf("/"));
            Node srcTopicNode = (Node)forumHomeNode.getSession().getItem(srcTopicPath);
            Node srcForumNode = srcTopicNode.getParent();
            Node destTopicNode = (Node)forumHomeNode.getSession().getItem(destTopicPath);
            Node destForumNode = destTopicNode.getParent();
            long totalAtt = 0L;
            long totalpost = postPaths.length;
            Node postNode = null;
            boolean destModeratePost = false;
            if (destTopicNode.hasProperty("exo:isModeratePost")) {
                destModeratePost = destTopicNode.getProperty("exo:isModeratePost").getBoolean();
            }
            boolean srcModeratePost = false;
            if (srcTopicNode.hasProperty("exo:isModeratePost")) {
                srcModeratePost = srcTopicNode.getProperty("exo:isModeratePost").getBoolean();
            }
            boolean unAproved = false;
            int i = 0;
            while ((long)i < totalpost) {
                String path = postPaths[i];
                String newPostPath = destTopicPath + path.substring(path.lastIndexOf("/"));
                forumHomeNode.getSession().getWorkspace().move(path, newPostPath);
                postPaths[i] = newPostPath;
                postNode = (Node)forumHomeNode.getSession().getItem(newPostPath);
                postNode.setProperty("exo:path", destForumNode.getName());
                postNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                if (isCreatNewTopic && i == 0) {
                    postNode.setProperty("exo:isFirstPost", true);
                } else {
                    postNode.setProperty("exo:isFirstPost", false);
                }
                if (!destModeratePost) {
                    postNode.setProperty("exo:isApproved", true);
                } else if (!postNode.getProperty("exo:isApproved").getBoolean()) {
                    unAproved = true;
                }
                ++i;
            }
            destTopicNode.setProperty("exo:postCount", destTopicNode.getProperty("exo:postCount").getLong() + totalpost);
            destTopicNode.setProperty("exo:numberAttachments", destTopicNode.getProperty("exo:numberAttachments").getLong() + totalAtt);
            destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + totalpost);
            destTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            destTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            long temp = srcTopicNode.getProperty("exo:postCount").getLong();
            if ((temp -= totalpost) < 0L) {
                temp = 0L;
            }
            srcTopicNode.setProperty("exo:postCount", temp);
            temp = srcTopicNode.getProperty("exo:numberAttachments").getLong();
            if ((temp -= totalAtt) < 0L) {
                temp = 0L;
            }
            srcTopicNode.setProperty("exo:numberAttachments", temp);
            NodeIterator nodeIterator = srcTopicNode.getNodes();
            long posLast = nodeIterator.getSize() - 1L;
            nodeIterator.skip(posLast);
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                postNode = node;
            }
            srcTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            srcTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            temp = srcForumNode.getProperty("exo:postCount").getLong();
            if ((temp -= totalpost) < 0L) {
                temp = 0L;
            }
            srcForumNode.setProperty("exo:postCount", temp);
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
            String topicName = destTopicNode.getProperty("exo:name").getString();
            List<String> fullNameEmailOwnerDestForum = this.getFullNameAndEmail(sProvider, destForumNode.getProperty("exo:owner").getString());
            Message message = new Message();
            String headerSubject = "";
            String objectName = "[" + destForumNode.getParent().getProperty("exo:name").getString() + "][" + destForumNode.getProperty("exo:name").getString() + "] " + topicName;
            try {
                String str;
                Node node = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
                if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                    headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
                }
                if (node.hasProperty("exo:notifyEmailMoved") && (str = node.getProperty("exo:notifyEmailMoved").getString()) != null && str.trim().length() > 0) {
                    mailContent = str;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_TYPE", (String)Utils.POST);
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_PARENT_TYPE", (String)Utils.TOPIC);
            link = link.replaceFirst("pathId", destTopicNode.getProperty("exo:id").getString());
            int i2 = 0;
            while ((long)i2 < totalpost) {
                postNode = (Node)forumHomeNode.getSession().getItem(postPaths[i2]);
                message = new Message();
                message.setMimeType("text/html");
                message.setFrom(fullNameEmailOwnerDestForum.get(0) + "<" + fullNameEmailOwnerDestForum.get(1) + ">");
                message.setSubject(headerSubject + objectName);
                message.setBody(mailContent.replace("$OBJECT_NAME", postNode.getProperty("exo:name").getString()).replace("$OBJECT_PARENT_NAME", topicName).replace("$VIEWPOST_LINK", link));
                List<String> fullNameEmailOwnerPost = this.getFullNameAndEmail(sProvider, postNode.getProperty("exo:owner").getString());
                fullNameEmailOwnerPost.remove(0);
                this.sendEmailNotification(fullNameEmailOwnerPost, message);
                ++i2;
            }
            ArrayList<String> userIdsp = new ArrayList<String>();
            if (destModeratePost && srcModeratePost) {
                if (srcForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
                }
                if (unAproved && destForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(destForumNode.getProperty("exo:moderators").getValues()));
                }
            } else if (srcModeratePost && !destModeratePost) {
                if (srcForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(this.ValuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
            } else if (!srcModeratePost && destModeratePost && unAproved && destForumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(this.ValuesToList(destForumNode.getProperty("exo:moderators").getValues()));
            }
            if (!userIdsp.isEmpty()) {
                this.getTotalJobWatting(userIdsp);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node srcTopicNode = this.getCategoryHome(sProvider).getNode(srcTopicPath);
            NodeIterator iter = srcTopicNode.getNodes();
            ArrayList<Post> posts = new ArrayList<Post>();
            while (iter.hasNext()) {
                Post post = new Post();
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                post.setPath(node.getPath());
                post.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                posts.add(post);
            }
            if (posts.size() > 0) {
                Collections.sort(posts, new Utils.DatetimeComparatorPostDESC());
                String[] postPaths = new String[posts.size()];
                int i = 0;
                for (Post p : posts) {
                    postPaths[i] = p.getPath();
                    ++i;
                }
                this.movePost(postPaths, destTopicPath, false, mailContent, link);
                String[] ids = srcTopicPath.split("/");
                this.removeTopic(ids[0], ids[1], srcTopicNode.getName());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poll getPoll(String categoryId, String forumId, String topicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            if (!topicNode.hasNode(pollId)) {
                Poll poll = null;
                return poll;
            }
            Node pollNode = topicNode.getNode(pollId);
            Poll pollNew = new Poll();
            pollNew.setId(pollId);
            if (pollNode.hasProperty("exo:owner")) {
                pollNew.setOwner(pollNode.getProperty("exo:owner").getString());
            }
            if (pollNode.hasProperty("exo:createdDate")) {
                pollNew.setCreatedDate(pollNode.getProperty("exo:createdDate").getDate().getTime());
            }
            if (pollNode.hasProperty("exo:modifiedBy")) {
                pollNew.setModifiedBy(pollNode.getProperty("exo:modifiedBy").getString());
            }
            if (pollNode.hasProperty("exo:modifiedDate")) {
                pollNew.setModifiedDate(pollNode.getProperty("exo:modifiedDate").getDate().getTime());
            }
            if (pollNode.hasProperty("exo:timeOut")) {
                pollNew.setTimeOut(pollNode.getProperty("exo:timeOut").getLong());
            }
            if (pollNode.hasProperty("exo:question")) {
                pollNew.setQuestion(pollNode.getProperty("exo:question").getString());
            }
            if (pollNode.hasProperty("exo:option")) {
                pollNew.setOption(this.ValuesToArray(pollNode.getProperty("exo:option").getValues()));
            }
            if (pollNode.hasProperty("exo:vote")) {
                pollNew.setVote(this.ValuesToArray(pollNode.getProperty("exo:vote").getValues()));
            }
            if (pollNode.hasProperty("exo:userVote")) {
                pollNew.setUserVote(this.ValuesToArray(pollNode.getProperty("exo:userVote").getValues()));
            }
            if (pollNode.hasProperty("exo:isMultiCheck")) {
                pollNew.setIsMultiCheck(pollNode.getProperty("exo:isMultiCheck").getBoolean());
            }
            if (pollNode.hasProperty("exo:isAgainVote")) {
                pollNew.setIsAgainVote(pollNode.getProperty("exo:isAgainVote").getBoolean());
            }
            if (pollNode.hasProperty("exo:isClosed")) {
                pollNew.setIsClosed(pollNode.getProperty("exo:isClosed").getBoolean());
            }
            Poll poll = pollNew;
            return poll;
        }
        catch (PathNotFoundException e) {
            Poll poll = null;
            return poll;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poll removePoll(String categoryId, String forumId, String topicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Poll poll = new Poll();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            poll = this.getPoll(categoryId, forumId, topicId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            topicNode.getNode(pollId).remove();
            topicNode.setProperty("exo:isPoll", false);
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
            Poll poll2 = poll;
            return poll2;
        }
        catch (PathNotFoundException e) {
            Poll poll3 = null;
            return poll3;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePoll(String categoryId, String forumId, String topicId, Poll poll, boolean isNew, boolean isVote) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            if (isVote) {
                Node pollNode = topicNode.getNode(pollId);
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:userVote", poll.getUserVote());
            } else {
                Node pollNode;
                if (isNew) {
                    pollNode = topicNode.addNode(pollId, "exo:poll");
                    pollNode.setProperty("exo:id", pollId);
                    pollNode.setProperty("exo:owner", poll.getOwner());
                    pollNode.setProperty("exo:userVote", new String[0]);
                    pollNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                    pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                    topicNode.setProperty("exo:isPoll", true);
                } else {
                    pollNode = topicNode.getNode(pollId);
                }
                if (poll.getUserVote().length > 0) {
                    pollNode.setProperty("exo:userVote", poll.getUserVote());
                }
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:modifiedBy", poll.getModifiedBy());
                if (poll.getTimeOut() == 0L) {
                    pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                }
                pollNode.setProperty("exo:timeOut", poll.getTimeOut());
                pollNode.setProperty("exo:question", poll.getQuestion());
                pollNode.setProperty("exo:option", poll.getOption());
                pollNode.setProperty("exo:isMultiCheck", poll.getIsMultiCheck());
                pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                pollNode.setProperty("exo:isAgainVote", poll.getIsAgainVote());
            }
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosedPoll(String categoryId, String forumId, String topicId, Poll poll) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId + "/" + topicId);
            String pollId = topicId.replaceFirst(Utils.TOPIC, Utils.POLL);
            if (topicNode.hasNode(pollId)) {
                Node pollNode = topicNode.getNode(pollId);
                pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                if (poll.getTimeOut() == 0L) {
                    pollNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                    pollNode.setProperty("exo:timeOut", 0L);
                }
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(topicPath);
            List<Object> listId = new ArrayList();
            ArrayList<String> list = new ArrayList<String>();
            if (topicNode.hasProperty("exo:tagId")) {
                listId = this.ValuesToList(topicNode.getProperty("exo:tagId").getValues());
            }
            list.addAll(listId);
            for (Tag tag : tags) {
                boolean isAdd = true;
                String userIdAndTagId = userName + ":" + tag.getId();
                for (String string : listId) {
                    if (!userIdAndTagId.equals(string)) continue;
                    isAdd = false;
                    break;
                }
                if (!isAdd) continue;
                list.add(userIdAndTagId);
                this.saveTag(tag);
            }
            topicNode.setProperty("exo:tagId", JCRDataStorage.getStringsInList(list));
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unTag(String tagId, String userName, String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Node topicNode = (Node)categoryHome.getSession().getItem(topicPath);
            List<String> oldTagsId = this.ValuesToList(topicNode.getProperty("exo:tagId").getValues());
            String userIdTagId = userName + ":" + tagId;
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[@exo:tagId='").append(userIdTagId).append("']");
            Query query = qm.createQuery(builder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (oldTagsId.contains(userIdTagId)) {
                oldTagsId.remove(userIdTagId);
                topicNode.setProperty("exo:tagId", oldTagsId.toArray(new String[0]));
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
            Tag tag = this.getTag(tagId);
            ArrayList<String> userTags = new ArrayList<String>();
            userTags.addAll(Arrays.asList(tag.getUserTag()));
            if (iter.getSize() == 1L && userTags.size() > 1) {
                if (userTags.contains(userName)) {
                    userTags.remove(userName);
                    tag.setUserTag(userTags.toArray(new String[0]));
                    Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                    long count = tagNode.getProperty("exo:useCount").getLong();
                    if (count > 1L) {
                        tagNode.setProperty("exo:useCount", count - 1L);
                    }
                    tagNode.setProperty("exo:userTag", userTags.toArray(new String[0]));
                    tagNode.save();
                }
            } else if (iter.getSize() == 1L && userTags.size() == 1) {
                Node tagHomNode = this.getTagHome(sProvider);
                tagHomNode.getNode(tagId).remove();
                tagHomNode.save();
            } else if (iter.getSize() > 1L) {
                Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                long count = tagNode.getProperty("exo:useCount").getLong();
                if (count > 1L) {
                    tagNode.setProperty("exo:useCount", count - 1L);
                }
                tagNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getTag(String tagId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tagNode = this.getTagHome(sProvider).getNode(tagId);
            Tag tag = this.getTagNode(tagNode);
            return tag;
        }
        catch (Exception e) {
            Tag tag = null;
            return tag;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Object node;
            Node tagHome = this.getTagHome(sProvider);
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            String topicId = userAndTopicId.substring(t + 1);
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[exo:id='").append(topicId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            StringBuilder builder = new StringBuilder();
            StringBuilder builder1 = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                boolean b = true;
                t = 0;
                ArrayList<String> list = new ArrayList<String>();
                for (String string : this.ValuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2) continue;
                    if (temp[0].equals(userId)) {
                        if (t == 0) {
                            builder.append("(@exo:id != '").append(temp[1]).append("'");
                        } else {
                            builder.append(" and @exo:id != '").append(temp[1]).append("'");
                        }
                        list.add(temp[1]);
                        t = 1;
                        continue;
                    }
                    if (list.contains(temp[1])) continue;
                    if (b) {
                        builder1.append(" (@exo:id='").append(temp[1]).append("'");
                    } else {
                        builder1.append(" or @exo:id='").append(temp[1]).append("'");
                    }
                    b = false;
                }
                if (!b) {
                    builder1.append(")");
                }
                if (t == 1) {
                    builder.append(")");
                }
            }
            if (builder1.length() == 0) {
                node = tagNames;
                return node;
            }
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)");
            boolean isQr = false;
            if (builder.length() > 0) {
                queryString.append("[").append((CharSequence)builder);
                isQr = true;
            }
            if (builder1.length() > 0) {
                if (isQr) {
                    queryString.append(" and ").append((CharSequence)builder1);
                } else {
                    queryString.append("[").append((CharSequence)builder1);
                    isQr = true;
                }
            }
            if (isQr) {
                queryString.append("]");
            }
            queryString.append("order by @exo:useCount descending, @exo:name ascending ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            iter = result.getNodes();
            String str = "";
            while (iter.hasNext()) {
                try {
                    Node node2 = iter.nextNode();
                    str = node2.getProperty("exo:name").getString();
                    str = str + "  <font color=\"Salmon\">(" + node2.getProperty("exo:useCount").getString() + ")</font>";
                    tagNames.add(str);
                    if (tagNames.size() != 5) continue;
                    break;
                }
                catch (Exception e) {
                }
            }
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTagName(String keyValue, String userAndTopicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Node node;
            Node tagHome = this.getTagHome(sProvider);
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            String topicId = userAndTopicId.substring(t + 1);
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[exo:id='").append(topicId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            StringBuilder builder = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                t = 0;
                for (String string : this.ValuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2 || !temp[0].equals(userId)) continue;
                    if (t == 0) {
                        builder.append("@exo:id != '").append(temp[1]).append("'");
                    } else {
                        builder.append(" and @exo:id != '").append(temp[1]).append("'");
                    }
                    t = 1;
                }
            }
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)[(jcr:contains(@exo:name, '").append(keyValue).append("*'))");
            if (builder.length() > 0) {
                queryString.append(" and (").append((CharSequence)builder).append(")");
            }
            queryString.append("]order by @exo:useCount descending, @exo:name ascending ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            iter = result.getNodes();
            String str = "";
            while (iter.hasNext()) {
                try {
                    Node node2 = iter.nextNode();
                    str = node2.getProperty("exo:name").getString();
                    str = str + "  <font color=\"Salmon\">(" + node2.getProperty("exo:useCount").getString() + ")</font>";
                    tagNames.add(str);
                    if (tagNames.size() != 5) continue;
                    break;
                }
                catch (Exception e) {
                }
            }
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getAllTags() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + tagHome.getPath() + "//element(*,exo:forumTag)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                try {
                    tags.add(this.getTagNode(iter.nextNode()));
                }
                catch (Exception e) {}
            }
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    private Tag getTagNode(Node tagNode) throws Exception {
        Tag newTag = new Tag();
        newTag.setId(tagNode.getName());
        newTag.setUserTag(this.ValuesToArray(tagNode.getProperty("exo:userTag").getValues()));
        newTag.setName(tagNode.getProperty("exo:name").getString());
        newTag.setUseCount(tagNode.getProperty("exo:useCount").getLong());
        return newTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            for (String id : tagIds) {
                try {
                    tags.add(this.getTagNode(tagHome.getNode(id)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)");
            if (userIdAndtagId.indexOf(":") > 0) {
                builder.append("[@exo:tagId='").append(userIdAndtagId).append("']");
            } else {
                builder.append("[jcr:contains(@exo:tagId,'").append(userIdAndtagId).append("')]");
            }
            builder.append(" order by @exo:isSticky descending");
            if (strOrderBy == null || strOrderBy.trim().length() <= 0) {
                builder.append(", @exo:lastPostDate descending");
            } else {
                builder.append(", @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    builder.append(", @exo:lastPostDate descending");
                }
            }
            String pathQuery = builder.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTag(Tag newTag) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tagHome = this.getTagHome(sProvider);
            try {
                Node newTagNode = tagHome.getNode(newTag.getId());
                List<String> userTags = this.ValuesToList(newTagNode.getProperty("exo:userTag").getValues());
                if (!userTags.contains(newTag.getUserTag()[0])) {
                    userTags.add(newTag.getUserTag()[0]);
                    newTagNode.setProperty("exo:userTag", userTags.toArray(new String[0]));
                }
                long count = newTagNode.getProperty("exo:useCount").getLong();
                newTagNode.setProperty("exo:useCount", count + 1L);
            }
            catch (Exception e) {
                String id = Utils.TAG + newTag.getName();
                Node newTagNode = tagHome.addNode(id, "exo:forumTag");
                newTagNode.setProperty("exo:id", id);
                newTagNode.setProperty("exo:userTag", newTag.getUserTag());
                newTagNode.setProperty("exo:name", newTag.getName());
                newTagNode.setProperty("exo:useCount", 1L);
            }
            if (tagHome.isNew()) {
                tagHome.getSession().save();
            } else {
                tagHome.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPageListUserProfile() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pageList;
            Node userProfileNode = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(userProfileNode.getPath()).append("/element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append(" order by @exo:userId ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pageList = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node userProfileHome = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(userProfileHome.getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append("[(jcr:contains(., '").append(userSearch).append("'))] order by @exo:userId ascending ");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String[] array;
            String str;
            Value[] values;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
            userProfile.setUserId(userName);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
            } else {
                userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            }
            userProfile.setModerateForums(this.ValuesToArray(profileNode.getProperty("exo:moderateForums").getValues()));
            try {
                userProfile.setModerateCategory(this.ValuesToArray(profileNode.getProperty("exo:moderateCategory").getValues()));
            }
            catch (Exception e) {
                userProfile.setModerateCategory(new String[0]);
            }
            userProfile.setNewMessage(profileNode.getProperty("exo:newMessage").getLong());
            userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
            userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
            userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
            userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
            userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
            userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
            userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
            userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
            userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
            try {
                userProfile.setLastReadPostOfForum(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
            }
            catch (Exception e) {
                userProfile.setLastReadPostOfForum(new String[0]);
            }
            try {
                userProfile.setLastReadPostOfTopic(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
            }
            catch (Exception e) {
                userProfile.setLastReadPostOfTopic(new String[0]);
            }
            userProfile.setIsBanned(profileNode.getProperty("exo:isBanned").getBoolean());
            if (profileNode.hasProperty("exo:collapCategories")) {
                userProfile.setCollapCategories(this.ValuesToArray(profileNode.getProperty("exo:collapCategories").getValues()));
            }
            userProfile.setEmail(profileNode.getProperty("exo:email").getString());
            for (Value vl : values = profileNode.getProperty("exo:readTopic").getValues()) {
                str = vl.getString();
                if (str.indexOf(":") <= 0) continue;
                array = str.split(":");
                userProfile.setLastTimeAccessTopic(array[0], Long.parseLong(array[1]));
            }
            for (Value vl : values = profileNode.getProperty("exo:readForum").getValues()) {
                str = vl.getString();
                if (str.indexOf(":") <= 0) continue;
                array = str.split(":");
                userProfile.setLastTimeAccessForum(array[0], Long.parseLong(array[1]));
            }
            if (userProfile.getIsBanned()) {
                if (profileNode.hasProperty("exo:banUntil")) {
                    userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
                    if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                        profileNode.setProperty("exo:isBanned", false);
                        profileNode.save();
                        userProfile.setIsBanned(false);
                    }
                }
            } else if (ip != null) {
                userProfile.setIsBanned(this.isBanIp(ip));
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        if (userProfile.getIsBanned()) {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
                if (profileNode.hasProperty("exo:banUntil")) {
                    userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
                    if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                        profileNode.setProperty("exo:isBanned", false);
                        profileNode.save();
                        userProfile.setIsBanned(false);
                    }
                }
            }
            finally {
                sProvider.close();
            }
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenName(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        String screenName = userName;
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            screenName = userProfileHome.getNode(userName).getProperty("exo:screenName").getString();
            if (screenName == null || screenName.trim().length() <= 0) {
                screenName = userName;
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return screenName;
    }

    private boolean isBanIp(String ip) throws Exception {
        List<String> banList = this.getBanList();
        return banList.contains(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
            userProfile.setUserId(userName);
            userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
            try {
                userProfile.setScreenName(profileNode.getProperty("exo:screenName").getString());
            }
            catch (Exception e) {
                userProfile.setScreenName(userName);
            }
            userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
            userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
            userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
            userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
            userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
            userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
            userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
            userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
            userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
            userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
            userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
            userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
        try {
            profileNode.setProperty("exo:userTitle", userProfile.getUserTitle());
            profileNode.setProperty("exo:screenName", userProfile.getScreenName());
            profileNode.setProperty("exo:signature", userProfile.getSignature());
            profileNode.setProperty("exo:isDisplaySignature", userProfile.getIsDisplaySignature());
            profileNode.setProperty("exo:isDisplayAvatar", userProfile.getIsDisplayAvatar());
            profileNode.setProperty("exo:userRole", userProfile.getUserRole().longValue());
            profileNode.setProperty("exo:timeZone", userProfile.getTimeZone());
            profileNode.setProperty("exo:shortDateformat", userProfile.getShortDateFormat());
            profileNode.setProperty("exo:longDateformat", userProfile.getLongDateFormat());
            profileNode.setProperty("exo:timeFormat", userProfile.getTimeFormat());
            profileNode.setProperty("exo:maxPost", userProfile.getMaxPostInPage().longValue());
            profileNode.setProperty("exo:maxTopic", userProfile.getMaxTopicInPage().longValue());
            profileNode.setProperty("exo:isShowForumJump", userProfile.getIsShowForumJump());
            profileNode.setProperty("exo:isAutoWatchMyTopics", userProfile.getIsAutoWatchMyTopics());
            profileNode.setProperty("exo:isAutoWatchTopicIPost", userProfile.getIsAutoWatchTopicIPost());
            profileNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getLastPostIdRead(UserProfile userProfile, String isOfForum) throws Exception {
        block15: {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
            try {
                if (isOfForum.equals("true")) {
                    try {
                        userProfile.setLastReadPostOfForum(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
                    }
                    catch (Exception e) {
                        userProfile.setLastReadPostOfForum(new String[0]);
                    }
                    break block15;
                }
                if (isOfForum.equals("false")) {
                    try {
                        userProfile.setLastReadPostOfTopic(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                    }
                    catch (Exception e) {
                        userProfile.setLastReadPostOfTopic(new String[0]);
                    }
                    break block15;
                }
                try {
                    userProfile.setLastReadPostOfForum(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
                }
                catch (Exception e) {
                    userProfile.setLastReadPostOfForum(new String[0]);
                }
                try {
                    userProfile.setLastReadPostOfTopic(this.ValuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                }
                catch (Exception e) {
                    userProfile.setLastReadPostOfTopic(new String[0]);
                }
            }
            catch (Exception e) {
            }
            finally {
                sProvider.close();
            }
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profileHome = this.getUserProfileHome(sProvider);
        Node profileNode = profileHome.getNode(userId);
        try {
            profileNode.setProperty("exo:lastReadPostOfForum", lastReadPostOfForum);
            profileNode.setProperty("exo:lastReadPostOfTopic", lastReadPostOfTopic);
            profileHome.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (isModeCate) {
                try {
                    list.addAll(this.ValuesToList(profileNode.getProperty("exo:moderateCategory").getValues()));
                }
                catch (Exception e) {}
            } else {
                list.addAll(this.ValuesToList(profileNode.getProperty("exo:moderateForums").getValues()));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (isModeCate) {
                profileNode.setProperty("exo:moderateCategory", JCRDataStorage.getStringsInList(ids));
            } else {
                profileNode.setProperty("exo:moderateForums", JCRDataStorage.getStringsInList(ids));
            }
            profileNode.save();
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserInfo(String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        String title = "";
        PropertyReader reader = new PropertyReader(userProfileNode);
        try {
            Node newProfileNode = userProfileNode.getNode(userName);
            PropertyReader readernew = new PropertyReader(newProfileNode);
            userProfile.setUserId(userName);
            if (newProfileNode.hasProperty("exo:userTitle")) {
                title = newProfileNode.getProperty("exo:userTitle").getString();
            }
            userProfile.setScreenName(reader.string("exo:screenName", userName));
            userProfile.setFullName(reader.string("exo:fullName"));
            userProfile.setFirstName(reader.string("exo:firstName"));
            userProfile.setLastName(reader.string("exo:fullName"));
            userProfile.setEmail(reader.string("exo:lastName"));
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
            } else {
                userProfile.setUserRole(readernew.l("exo:userRole"));
            }
            userProfile.setUserTitle(title);
            userProfile.setSignature(readernew.string("exo:signature"));
            userProfile.setTotalPost(readernew.l("exo:totalPost"));
            userProfile.setTotalTopic(readernew.l("exo:totalTopic"));
            userProfile.setBookmark(readernew.strings("exo:bookmark"));
            userProfile.setLastLoginDate(readernew.date("exo:lastLoginDate"));
            userProfile.setJoinedDate(readernew.date("exo:joinedDate"));
            userProfile.setLastPostDate(readernew.date("exo:lastPostDate"));
            userProfile.setIsDisplaySignature(readernew.bool("exo:isDisplaySignature"));
            userProfile.setIsDisplayAvatar(readernew.bool("exo:isDisplayAvatar"));
        }
        catch (PathNotFoundException e) {
            userProfile.setUserId(userName);
            userProfile.setUserTitle(Utils.USER);
            userProfile.setUserRole(2L);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(userProfile, false, false);
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        ArrayList<UserProfile> profiles = new ArrayList<UserProfile>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            for (String userName : userList) {
                Node profileNode = userProfileHome.getNode(userName);
                UserProfile userProfile = new UserProfile();
                userProfile.setUserId(userName);
                userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
                userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
                try {
                    userProfile.setScreenName(profileNode.getProperty("exo:screenName").getString());
                }
                catch (Exception e) {
                    userProfile.setScreenName(userName);
                }
                userProfile.setJoinedDate(profileNode.getProperty("exo:joinedDate").getDate().getTime());
                userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
                userProfile.setTotalPost(profileNode.getProperty("exo:totalPost").getLong());
                if (userProfile.getTotalPost() > 0L) {
                    userProfile.setLastPostDate(profileNode.getProperty("exo:lastPostDate").getDate().getTime());
                }
                userProfile.setLastLoginDate(profileNode.getProperty("exo:lastLoginDate").getDate().getTime());
                userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
                if (userProfile.getIsDisplaySignature()) {
                    userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
                }
                profiles.add(userProfile);
            }
        }
        finally {
            sProvider.close();
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getQuickProfile(String userName) throws Exception {
        UserProfile userProfile;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            Node profileNode = userProfileHome.getNode(userName);
            userProfile = new UserProfile();
            userProfile.setUserId(userName);
            userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
            try {
                userProfile.setScreenName(profileNode.getProperty("exo:screenName").getString());
            }
            catch (Exception e) {
                userProfile.setScreenName(userName);
            }
            userProfile.setJoinedDate(profileNode.getProperty("exo:joinedDate").getDate().getTime());
            userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
            userProfile.setTotalPost(profileNode.getProperty("exo:totalPost").getLong());
            if (userProfile.getTotalPost() > 0L) {
                userProfile.setLastPostDate(profileNode.getProperty("exo:lastPostDate").getDate().getTime());
            }
            userProfile.setLastLoginDate(profileNode.getProperty("exo:lastLoginDate").getDate().getTime());
            userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
            if (userProfile.getIsDisplaySignature()) {
                userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            Node profileNode = userProfileHome.getNode(userProfile.getUserId());
            userProfile.setFirstName(profileNode.getProperty("exo:firstName").getString());
            userProfile.setLastName(profileNode.getProperty("exo:lastName").getString());
            userProfile.setFullName(profileNode.getProperty("exo:fullName").getString());
            userProfile.setEmail(profileNode.getProperty("exo:email").getString());
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserProfile(UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        String userName = newUserProfile.getUserId();
        if (userName == null || userName.length() <= 0) {
            return;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode;
            long role;
            block17: {
                role = 2L;
                try {
                    newProfileNode = userProfileHome.getNode(userName);
                    if (userProfileHome.hasProperty("exo:userRole")) {
                        role = userProfileHome.getProperty("exo:userRole").getLong();
                    }
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", userName);
                    newProfileNode.setProperty("exo:totalPost", 0L);
                    newProfileNode.setProperty("exo:totalTopic", 0L);
                    newProfileNode.setProperty("exo:readTopic", new String[0]);
                    newProfileNode.setProperty("exo:readForum", new String[0]);
                    if (newUserProfile.getUserRole() >= 2L) {
                        newUserProfile.setUserRole(2L);
                    }
                    if (!this.isAdminRole(userName)) break block17;
                    newUserProfile.setUserTitle(Utils.ADMIN);
                }
            }
            newProfileNode.setProperty("exo:userRole", newUserProfile.getUserRole().longValue());
            newProfileNode.setProperty("exo:userTitle", newUserProfile.getUserTitle());
            newProfileNode.setProperty("exo:screenName", newUserProfile.getScreenName());
            newProfileNode.setProperty("exo:signature", newUserProfile.getSignature());
            newProfileNode.setProperty("exo:isAutoWatchMyTopics", newUserProfile.getIsAutoWatchMyTopics());
            newProfileNode.setProperty("exo:isAutoWatchTopicIPost", newUserProfile.getIsAutoWatchTopicIPost());
            newProfileNode.setProperty("exo:moderateCategory", newUserProfile.getModerateCategory());
            Calendar calendar = this.getGreenwichMeanTime();
            if (newUserProfile.getLastLoginDate() != null) {
                calendar.setTime(newUserProfile.getLastLoginDate());
            }
            newProfileNode.setProperty("exo:lastLoginDate", calendar);
            newProfileNode.setProperty("exo:isDisplaySignature", newUserProfile.getIsDisplaySignature());
            newProfileNode.setProperty("exo:isDisplayAvatar", newUserProfile.getIsDisplayAvatar());
            if (isOption) {
                newProfileNode.setProperty("exo:timeZone", newUserProfile.getTimeZone());
                newProfileNode.setProperty("exo:shortDateformat", newUserProfile.getShortDateFormat());
                newProfileNode.setProperty("exo:longDateformat", newUserProfile.getLongDateFormat());
                newProfileNode.setProperty("exo:timeFormat", newUserProfile.getTimeFormat());
                newProfileNode.setProperty("exo:maxPost", newUserProfile.getMaxPostInPage().longValue());
                newProfileNode.setProperty("exo:maxTopic", newUserProfile.getMaxTopicInPage().longValue());
                newProfileNode.setProperty("exo:isShowForumJump", newUserProfile.getIsShowForumJump());
            }
            if (isBan) {
                if (newProfileNode.hasProperty("exo:isBanned")) {
                    if (!newProfileNode.getProperty("exo:isBanned").getBoolean() && newUserProfile.getIsBanned()) {
                        newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                    }
                } else {
                    newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                }
                newProfileNode.setProperty("exo:isBanned", newUserProfile.getIsBanned());
                newProfileNode.setProperty("exo:banUntil", newUserProfile.getBanUntil().longValue());
                newProfileNode.setProperty("exo:banReason", newUserProfile.getBanReason());
                newProfileNode.setProperty("exo:banCounter", "" + newUserProfile.getBanCounter());
                newProfileNode.setProperty("exo:banReasonSummary", newUserProfile.getBanReasonSummary());
            }
            if (userProfileHome.isNew()) {
                userProfileHome.getSession().save();
            } else {
                userProfileHome.save();
            }
            if (role >= 2L && newUserProfile.getUserRole() < 2L && !this.isAdminRole(userName)) {
                this.getTotalJobWattingForModerator(sProvider, userName);
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileNode = this.getUserProfileHome(sProvider).getNode(userName);
            UserProfile userProfile = this.getUserProfile(userProfileNode);
            return userProfile;
        }
        catch (Exception e) {
            UserProfile userProfile = null;
            return userProfile;
        }
        finally {
            sProvider.close();
        }
    }

    private UserProfile getUserProfile(Node userProfileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userProfileNode.getName());
        userProfile.setUserTitle(userProfileNode.getProperty("exo:userTitle").getString());
        try {
            userProfile.setScreenName(userProfileNode.getProperty("exo:screenName").getString());
        }
        catch (Exception e) {
            userProfile.setScreenName(userProfileNode.getName());
        }
        userProfile.setFullName(userProfileNode.getProperty("exo:fullName").getString());
        userProfile.setFirstName(userProfileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(userProfileNode.getProperty("exo:lastName").getString());
        userProfile.setEmail(userProfileNode.getProperty("exo:email").getString());
        userProfile.setUserRole(userProfileNode.getProperty("exo:userRole").getLong());
        userProfile.setSignature(userProfileNode.getProperty("exo:signature").getString());
        userProfile.setTotalPost(userProfileNode.getProperty("exo:totalPost").getLong());
        userProfile.setTotalTopic(userProfileNode.getProperty("exo:totalTopic").getLong());
        userProfile.setModerateForums(this.ValuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues()));
        try {
            userProfile.setModerateCategory(this.ValuesToArray(userProfileNode.getProperty("exo:moderateCategory").getValues()));
        }
        catch (Exception e) {
            userProfile.setModerateCategory(new String[0]);
        }
        if (userProfileNode.hasProperty("exo:lastLoginDate")) {
            userProfile.setLastLoginDate(userProfileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:joinedDate")) {
            userProfile.setJoinedDate(userProfileNode.getProperty("exo:joinedDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:lastPostDate")) {
            userProfile.setLastPostDate(userProfileNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        userProfile.setIsDisplaySignature(userProfileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(userProfileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setNewMessage(userProfileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(userProfileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(userProfileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(userProfileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(userProfileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(userProfileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(userProfileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(userProfileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsBanned(userProfileNode.getProperty("exo:isBanned").getBoolean());
        if (userProfile.getIsBanned() && userProfileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(userProfileNode.getProperty("exo:banUntil").getLong());
            if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                userProfileNode.setProperty("exo:isBanned", false);
                userProfileNode.save();
                userProfile.setIsBanned(false);
            }
        }
        if (userProfileNode.hasProperty("exo:banReason")) {
            userProfile.setBanReason(userProfileNode.getProperty("exo:banReason").getString());
        }
        if (userProfileNode.hasProperty("exo:banCounter")) {
            userProfile.setBanCounter(Integer.parseInt(userProfileNode.getProperty("exo:banCounter").getString()));
        }
        if (userProfileNode.hasProperty("exo:banReasonSummary")) {
            userProfile.setBanReasonSummary(this.ValuesToArray(userProfileNode.getProperty("exo:banReasonSummary").getValues()));
        }
        if (userProfileNode.hasProperty("exo:createdDateBan")) {
            userProfile.setCreatedDateBan(userProfileNode.getProperty("exo:createdDateBan").getDate().getTime());
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = userProfileNode.getNode(userName);
            if (newProfileNode.hasProperty("exo:bookmark")) {
                List<String> listOld = this.ValuesToList(newProfileNode.getProperty("exo:bookmark").getValues());
                ArrayList<String> listNew = new ArrayList<String>();
                String pathNew = bookMark.substring(bookMark.lastIndexOf("//") + 1);
                String pathOld = "";
                boolean isAdd = true;
                for (String string : listOld) {
                    pathOld = string.substring(string.lastIndexOf("//") + 1);
                    if (pathNew.equals(pathOld)) {
                        if (isNew) {
                            listNew.add(bookMark);
                        }
                        isAdd = false;
                        continue;
                    }
                    listNew.add(string);
                }
                if (isAdd) {
                    listNew.add(bookMark);
                }
                String[] bookMarks = listNew.toArray(new String[0]);
                newProfileNode.setProperty("exo:bookmark", bookMarks);
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            } else {
                newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            Node newProfileNode = userProfileNode.addNode(userName, Utils.USER_PROFILES_TYPE);
            newProfileNode.setProperty("exo:userId", userName);
            newProfileNode.setProperty("exo:userTitle", Utils.USER);
            if (this.isAdminRole(userName)) {
                newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
            }
            newProfileNode.setProperty("exo:userRole", 2L);
            newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
            if (newProfileNode.isNew()) {
                newProfileNode.getSession().save();
            } else {
                newProfileNode.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = userProfileHome.getNode(userName);
            if (newProfileNode.hasProperty("exo:collapCategories")) {
                List<String> listCategoryId = this.ValuesToList(newProfileNode.getProperty("exo:collapCategories").getValues());
                if (listCategoryId.contains(categoryId)) {
                    if (!isAdd) {
                        listCategoryId.remove(categoryId);
                        isAdd = true;
                    }
                } else if (isAdd) {
                    listCategoryId.add(categoryId);
                }
                if (isAdd) {
                    String[] categoryIds = listCategoryId.toArray(new String[0]);
                    newProfileNode.setProperty("exo:collapCategories", categoryIds);
                    if (newProfileNode.isNew()) {
                        newProfileNode.getSession().save();
                    } else {
                        newProfileNode.save();
                    }
                }
            } else {
                newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            Node newProfileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
            newProfileNode.setProperty("exo:userId", userName);
            newProfileNode.setProperty("exo:userTitle", Utils.USER);
            if (this.isAdminRole(userName)) {
                newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
            }
            newProfileNode.setProperty("exo:userRole", 2L);
            newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
            if (newProfileNode.isNew()) {
                newProfileNode.getSession().save();
            } else {
                newProfileNode.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            long totalNewMessage = 0L;
            boolean isNew = false;
            try {
                Node messageNode = profileNode.getNode(messageId);
                if (messageNode.hasProperty("exo:isUnread")) {
                    isNew = messageNode.getProperty("exo:isUnread").getBoolean();
                }
                if (isNew) {
                    messageNode.setProperty("exo:isUnread", false);
                }
            }
            catch (PathNotFoundException e) {
                e.printStackTrace();
            }
            if (type.equals(Utils.RECEIVE_MESSAGE) && isNew && profileNode.hasProperty("exo:newMessage") && (totalNewMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalNewMessage - 1L);
            }
            if (isNew) {
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            ForumPageList pagelist;
            Node profileNode = userProfileNode.getNode(userName);
            QueryManager qm = profileNode.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + profileNode.getPath() + "//element(*,exo:privateMessage)[@exo:type='" + type + "'] order by @exo:receivedDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewPrivateMessage(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (!profileNode.getProperty("exo:isBanned").getBoolean()) {
                long l = profileNode.getProperty("exo:newMessage").getLong();
                return l;
            }
        }
        catch (PathNotFoundException e) {
            long l = -1L;
            return l;
        }
        finally {
            sProvider.close();
        }
        return -1L;
    }

    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        String id;
        List<String> userNames;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = null;
        Node profileNodeFirst = null;
        Node messageNode = null;
        String sendTo = privateMessage.getSendTo();
        sendTo = sendTo.replaceAll(";", ",");
        String[] strUserNames = sendTo.split(",");
        try {
            userNames = ForumServiceUtils.getUserPermission(strUserNames);
        }
        catch (Exception e) {
            userNames = Arrays.asList(strUserNames);
        }
        String userNameFirst = privateMessage.getFrom();
        try {
            profileNodeFirst = userProfileNode.getNode(userNameFirst);
        }
        catch (PathNotFoundException e) {
            profileNodeFirst = this.addNodeUserProfile(sProvider, userNameFirst);
        }
        long totalMessage = 0L;
        if (profileNodeFirst != null) {
            id = userNameFirst + IdGenerator.generate();
            messageNode = profileNodeFirst.addNode(id, "exo:privateMessage");
            messageNode.setProperty("exo:from", privateMessage.getFrom());
            messageNode.setProperty("exo:sendTo", privateMessage.getSendTo());
            messageNode.setProperty("exo:name", privateMessage.getName());
            messageNode.setProperty("exo:message", privateMessage.getMessage());
            messageNode.setProperty("exo:receivedDate", this.getGreenwichMeanTime());
            messageNode.setProperty("exo:isUnread", true);
            messageNode.setProperty("exo:type", Utils.RECEIVE_MESSAGE);
        }
        for (String userName : userNames) {
            try {
                profileNode = userProfileNode.getNode(userName);
                totalMessage = profileNode.getProperty("exo:newMessage").getLong() + 1L;
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", totalMessage);
            }
            catch (Exception e) {
                profileNode = this.addNodeUserProfile(sProvider, userName);
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", 1L);
            }
        }
        if (messageNode != null) {
            messageNode.setProperty("exo:type", Utils.SEND_MESSAGE);
        }
        if (userProfileNode.isNew()) {
            userProfileNode.getSession().save();
        } else {
            userProfileNode.save();
        }
        sProvider.close();
    }

    private Node addNodeUserProfile(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
        profileNode.setProperty("exo:userId", userName);
        profileNode.setProperty("exo:userTitle", Utils.USER);
        if (this.isAdminRole(userName)) {
            profileNode.setProperty("exo:userRole", 0L);
            profileNode.setProperty("exo:userTitle", Utils.ADMIN);
        }
        profileNode.setProperty("exo:userRole", 2L);
        if (userProfileHome.isNew()) {
            userProfileHome.getSession().save();
        } else {
            userProfileHome.save();
        }
        return profileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileNode.getNode(userName);
        try {
            long totalMessage;
            Node messageNode = profileNode.getNode(messageId);
            if (type.equals(Utils.RECEIVE_MESSAGE) && messageNode.hasProperty("exo:isUnread") && messageNode.getProperty("exo:isUnread").getBoolean() && (totalMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalMessage - 1L);
            }
            messageNode.remove();
            profileNode.save();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForumSubscription getForumSubscription(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ForumSubscription forumSubscription = new ForumSubscription();
        try {
            Node subscriptionNode = this.getUserProfileHome(sProvider).getNode(userId + "/" + Utils.FORUM_SUBSCRIOTION + userId);
            if (subscriptionNode.hasProperty("exo:categoryIds")) {
                forumSubscription.setCategoryIds(this.ValuesToArray(subscriptionNode.getProperty("exo:categoryIds").getValues()));
            }
            if (subscriptionNode.hasProperty("exo:forumIds")) {
                forumSubscription.setForumIds(this.ValuesToArray(subscriptionNode.getProperty("exo:forumIds").getValues()));
            }
            if (subscriptionNode.hasProperty("exo:topicIds")) {
                forumSubscription.setTopicIds(this.ValuesToArray(subscriptionNode.getProperty("exo:topicIds").getValues()));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return forumSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node subscriptionNode;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userId);
            String id = Utils.FORUM_SUBSCRIOTION + userId;
            try {
                subscriptionNode = profileNode.getNode(id);
            }
            catch (PathNotFoundException e) {
                subscriptionNode = profileNode.addNode(id, "exo:forumSubscription");
            }
            subscriptionNode.setProperty("exo:categoryIds", forumSubscription.getCategoryIds());
            subscriptionNode.setProperty("exo:forumIds", forumSubscription.getForumIds());
            subscriptionNode.setProperty("exo:topicIds", forumSubscription.getTopicIds());
            if (profileNode.isNew()) {
                profileNode.getSession().save();
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void addForumSubscription(SessionProvider sProvider, String userId, String objectId) {
        try {
            Node subscriptionNode;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userId);
            String id = Utils.FORUM_SUBSCRIOTION + userId;
            try {
                subscriptionNode = profileNode.getNode(id);
            }
            catch (PathNotFoundException e) {
                subscriptionNode = profileNode.addNode(id, "exo:forumSubscription");
            }
            if (objectId.indexOf(Utils.CATEGORY) == 0) {
                subscriptionNode.setProperty("exo:categoryIds", this.getValueProperty(subscriptionNode, "exo:categoryIds", objectId));
            } else if (objectId.indexOf(Utils.FORUM) == 0) {
                subscriptionNode.setProperty("exo:forumIds", this.getValueProperty(subscriptionNode, "exo:forumIds", objectId));
            } else if (objectId.indexOf(Utils.TOPIC) == 0) {
                subscriptionNode.setProperty("exo:topicIds", this.getValueProperty(subscriptionNode, "exo:topicIds", objectId));
            }
            if (profileNode.isNew()) {
                profileNode.getSession().save();
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getValueProperty(Node node, String property, String objectId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (node.hasProperty(property)) {
            list.addAll(this.ValuesToList(node.getProperty(property).getValues()));
            if (!list.contains(objectId)) {
                list.add(objectId);
            }
        } else {
            list.add(objectId);
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForumStatistic getForumStatistic() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ForumStatistic forumStatistic = new ForumStatistic();
        try {
            Node forumStatisticNode = this.getStatisticHome(sProvider).getNode(Utils.FORUM_STATISTIC);
            forumStatistic.setPostCount(forumStatisticNode.getProperty("exo:postCount").getLong());
            forumStatistic.setTopicCount(forumStatisticNode.getProperty("exo:topicCount").getLong());
            forumStatistic.setMembersCount(forumStatisticNode.getProperty("exo:membersCount").getLong());
            forumStatistic.setActiveUsers(forumStatisticNode.getProperty("exo:activeUsers").getLong());
            forumStatistic.setNewMembers(forumStatisticNode.getProperty("exo:newMembers").getString());
            forumStatistic.setMostUsersOnline(forumStatisticNode.getProperty("exo:mostUsersOnline").getString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return forumStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node statisticHome = this.getStatisticHome(sProvider);
            Node forumStatisticNode = statisticHome.hasNode(Utils.FORUM_STATISTIC) ? statisticHome.getNode(Utils.FORUM_STATISTIC) : statisticHome.addNode(Utils.FORUM_STATISTIC, "exo:forumStatistic");
            forumStatisticNode.setProperty("exo:postCount", forumStatistic.getPostCount());
            forumStatisticNode.setProperty("exo:topicCount", forumStatistic.getTopicCount());
            forumStatisticNode.setProperty("exo:membersCount", forumStatistic.getMembersCount());
            forumStatisticNode.setProperty("exo:activeUsers", forumStatistic.getActiveUsers());
            forumStatisticNode.setProperty("exo:newMembers", forumStatistic.getNewMembers());
            forumStatisticNode.setProperty("exo:mostUsersOnline", forumStatistic.getMostUsersOnline());
            if (forumStatisticNode.isNew()) {
                forumStatisticNode.getSession().save();
            } else {
                forumStatisticNode.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    String[] ValuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    List<String> ValuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        if (values.length == 1) {
            list.add(values[0].getString());
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list;
    }

    private static String[] getStringsInList(List<String> list) throws Exception {
        if (list.size() > 1) {
            while (list.contains(" ")) {
                list.remove(" ");
            }
        }
        return list.toArray(new String[0]);
    }

    private static List<String> combineListToList(List<String> pList, List<String> cList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : pList) {
            if (!cList.contains(string)) continue;
            list.add(string);
        }
        return list;
    }

    public Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectNameByPath(String path) throws Exception {
        Object object;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Object object2 = new Object();
        try {
            path = path.indexOf(Utils.CATEGORY_HOME) < 0 && path.indexOf(Utils.CATEGORY) >= 0 ? this.getCategoryHome(sProvider).getPath() + "/" + path : this.getTagHome(sProvider).getPath() + "/" + path;
            Node myNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            if (path.indexOf(Utils.POST) > 0) {
                Post post = new Post();
                post.setId(myNode.getName());
                post.setPath(path);
                post.setName(myNode.getProperty("exo:name").getString());
                object2 = post;
            } else if (path.indexOf(Utils.TOPIC) > 0) {
                Topic topic = new Topic();
                topic.setId(myNode.getName());
                topic.setPath(path);
                topic.setTopicName(myNode.getProperty("exo:name").getString());
                object2 = topic;
            } else if (path.indexOf(Utils.FORUM) > 0 && path.lastIndexOf(Utils.FORUM) > path.indexOf(Utils.CATEGORY)) {
                Forum forum = new Forum();
                forum.setId(myNode.getName());
                forum.setPath(path);
                forum.setForumName(myNode.getProperty("exo:name").getString());
                object2 = forum;
            } else if (path.indexOf(Utils.CATEGORY) > 0) {
                Category category = new Category();
                category.setId(myNode.getName());
                category.setPath(path);
                category.setCategoryName(myNode.getProperty("exo:name").getString());
                object2 = category;
            } else if (path.indexOf(Utils.TAG) > 0) {
                Tag tag = new Tag();
                tag.setId(myNode.getName());
                tag.setName(myNode.getProperty("exo:name").getString());
                object2 = tag;
            } else {
                Object var5_7 = null;
                return var5_7;
            }
            object = object2;
            return object;
        }
        catch (RepositoryException e) {
            object = null;
            return object;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectNameById(String id, String type) throws Exception {
        Object object = new Object();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:").append(type).append(")[exo:id='").append(id).append("']");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            Node node = result.getNodes().nextNode();
            if (type.equals(Utils.CATEGORY)) {
                Category category = this.getCategory(node);
                object = category;
            } else if (type.equals(Utils.FORUM)) {
                Forum forum = this.getForum(node);
                object = forum;
            } else if (type.equals(Utils.TOPIC)) {
                Topic topic = this.getTopicNode(node);
                object = topic;
            } else {
                Post post = this.getPost(node);
                object = post;
            }
        }
        catch (Exception e) {
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            sProvider.close();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        ArrayList<ForumLinkData> forumLinks = new ArrayList<ForumLinkData>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:forumCategory)").append(strQueryCate).append(" order by @exo:categoryOrder ascending, @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumLinkData linkData = new ForumLinkData();
            while (iter.hasNext()) {
                linkData = new ForumLinkData();
                Node cateNode = iter.nextNode();
                linkData.setId(cateNode.getName());
                linkData.setName(cateNode.getProperty("exo:name").getString());
                linkData.setType(Utils.CATEGORY);
                linkData.setPath(cateNode.getName());
                forumLinks.add(linkData);
                queryString = new StringBuffer();
                queryString.append("/jcr:root").append(cateNode.getPath()).append("//element(*,exo:forum)").append(strQueryForum).append(" order by @exo:forumOrder ascending,@exo:createdDate ascending");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                NodeIterator iterForum = result.getNodes();
                while (iterForum.hasNext()) {
                    linkData = new ForumLinkData();
                    Node forumNode = iterForum.nextNode();
                    linkData.setId(forumNode.getName());
                    linkData.setName(forumNode.getProperty("exo:name").getString());
                    linkData.setType(Utils.FORUM);
                    linkData.setPath(cateNode.getName() + "/" + forumNode.getName());
                    if (forumNode.hasProperty("exo:isLock")) {
                        linkData.setIsLock(forumNode.getProperty("exo:isLock").getBoolean());
                    }
                    if (forumNode.hasProperty("exo:isClosed")) {
                        linkData.setIsClosed(forumNode.getProperty("exo:isClosed").getBoolean());
                    }
                    forumLinks.add(linkData);
                }
            }
        }
        finally {
            sProvider.close();
        }
        return forumLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForumSearch> getQuickSearch(String textQuery, String type_, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            if (pathQuery == null || pathQuery.length() <= 0) {
                pathQuery = categoryHome.getPath();
            }
            textQuery = StringUtils.replace((String)textQuery, (String)"'", (String)"&apos;");
            String[] values = type_.split(",");
            boolean isAdmin = false;
            if (values[0].equals("true")) {
                isAdmin = true;
            }
            String[] types = new String[]{Utils.CATEGORY, Utils.FORUM, Utils.TOPIC, Utils.POST};
            if (!values[1].equals("all")) {
                types = values[1].split("/");
            }
            boolean isAnd = false;
            String searchBy = null;
            ArrayList<String> listOfUser = new ArrayList();
            if (!isAdmin) {
                listOfUser = ForumServiceUtils.getAllGroupAndMembershipOfUser(userId);
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds);
                listCateIds = mapList.get(Utils.CATEGORY);
                listForumIds = mapList.get(Utils.FORUM);
            }
            for (String type : types) {
                StringBuffer queryString = new StringBuffer();
                queryString.append("/jcr:root").append(pathQuery).append("//element(*,exo:").append(type).append(")");
                queryString.append("[");
                if (type.equals(Utils.CATEGORY) && listCateIds != null && listCateIds.size() > 0) {
                    queryString.append("(");
                    for (int i = 0; i < listCateIds.size(); ++i) {
                        queryString.append("fn:name() = '").append(listCateIds.get(i)).append("'");
                        if (i >= listCateIds.size() - 1) continue;
                        queryString.append(" or ");
                    }
                    queryString.append(") and ");
                } else if (listForumIds != null && listCateIds.size() > 0) {
                    searchBy = type.equals(Utils.FORUM) ? "fn:name()" : "@exo:path";
                    queryString.append("(");
                    for (int i = 0; i < listForumIds.size(); ++i) {
                        queryString.append(searchBy).append(" = '").append(listForumIds.get(i)).append("'");
                        if (i >= listForumIds.size() - 1) continue;
                        queryString.append(" or ");
                    }
                    queryString.append(") and ");
                }
                if (textQuery != null && textQuery.length() > 0 && !textQuery.equals("null")) {
                    queryString.append("(jcr:contains(., '").append(textQuery).append("'))");
                    isAnd = true;
                }
                if (!isAdmin) {
                    StringBuilder builder = new StringBuilder();
                    if (forumIdsOfModerator != null && !forumIdsOfModerator.isEmpty()) {
                        for (String string : forumIdsOfModerator) {
                            builder.append(" or (@exo:path='").append(string).append("')");
                        }
                    }
                    if (type.equals(Utils.FORUM)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("(@exo:isClosed='false'");
                        for (String forumId : forumIdsOfModerator) {
                            queryString.append(" or fn:name()='").append(forumId).append("'");
                        }
                        queryString.append(")");
                    } else if (type.equals(Utils.TOPIC)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("((@exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' and @exo:isActive='true' and @exo:isActiveByForum='true')");
                        if (builder.length() > 0) {
                            queryString.append((CharSequence)builder);
                        }
                        queryString.append(")");
                        listOfUser.add(" ");
                        String s = Utils.getQueryInList(listOfUser, "@exo:canView");
                        if (s != null && s.length() > 0) {
                            if (isAnd) {
                                queryString.append(" and ");
                            }
                            queryString.append(s);
                        }
                    } else if (type.equals(Utils.POST)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("((@exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true')");
                        if (builder.length() > 0) {
                            queryString.append((CharSequence)builder);
                        }
                        queryString.append(") and (@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
                    }
                } else if (type.equals(Utils.POST)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("(@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
                }
                queryString.append("]");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                while (iter.hasNext()) {
                    Node nodeObj = iter.nextNode();
                    listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
                }
                if (!type.equals(Utils.POST)) continue;
                listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, pathQuery, textQuery, listForumIds, listOfUser, isAdmin, ""));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return listSearchEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForumSearch> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String path = eventQuery.getPath();
            if (path == null || path.length() <= 0) {
                path = categoryHome.getPath();
            }
            eventQuery.setPath(path);
            String type = eventQuery.getType();
            String queryString = null;
            if (eventQuery.getUserPermission() > 0L) {
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, eventQuery.getListOfUser(), listCateIds, listForumIds);
                listCateIds = mapList.get(Utils.CATEGORY);
                listForumIds = mapList.get(Utils.FORUM);
            }
            queryString = type.equals(Utils.CATEGORY) ? eventQuery.getPathQuery(listCateIds) : eventQuery.getPathQuery(listForumIds);
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node nodeObj = iter.nextNode();
                listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
            }
            if ((type.equals(Utils.POST) || type.equals(Utils.TOPIC)) && eventQuery.getKeyValue() != null && eventQuery.getKeyValue().trim().length() > 0) {
                boolean isAdmin = false;
                if (eventQuery.getUserPermission() == 0L) {
                    isAdmin = true;
                }
                listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, eventQuery.getPath(), eventQuery.getKeyValue(), listForumIds, eventQuery.getListOfUser(), isAdmin, type));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return listSearchEvent;
    }

    private List<ForumSearch> getSearchByAttachment(Node categoryHome, String path, String key, List<String> listForumIds, List<String> listOfUser, boolean isAdmin, String type) throws Exception {
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder strQuery = new StringBuilder();
        strQuery.append("/jcr:root").append(path).append("//element(*,nt:resource) [");
        strQuery.append("(jcr:contains(., '").append(key).append("*'))]");
        Query query = qm.createQuery(strQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        boolean isAdd = true;
        List<Object> list = new ArrayList();
        String type_ = type;
        while (iter.hasNext()) {
            Node nodeObj = iter.nextNode().getParent().getParent();
            if (!nodeObj.isNodeType("exo:post")) continue;
            if (type == null || type.length() == 0) {
                type_ = nodeObj.getProperty("exo:isFirstPost").getBoolean() ? Utils.TOPIC : Utils.POST;
            } else if (!nodeObj.getProperty("exo:isFirstPost").getBoolean() ? type.equals(Utils.TOPIC) : !type.equals(Utils.TOPIC)) continue;
            if (!isAdmin && !listForumIds.isEmpty()) {
                String path_ = nodeObj.getPath();
                isAdd = listForumIds.contains(path_ = path_.substring(path_.lastIndexOf(Utils.FORUM), path_.lastIndexOf("/" + Utils.TOPIC)));
            }
            if (isAdd) {
                list = this.ValuesToList(nodeObj.getProperty("exo:userPrivate").getValues());
                if (!((String)list.get(0)).equals("exoUserPri") && !Utils.isListContentItemList(listOfUser, list)) {
                    isAdd = false;
                }
                if (isAdd && !isAdmin && !Utils.isListContentItemList(listOfUser, list = this.ValuesToList(nodeObj.getParent().getParent().getProperty("exo:moderators").getValues()))) {
                    Post post;
                    list = this.ValuesToList(nodeObj.getParent().getProperty("exo:canView").getValues());
                    if (!((String)list.get(0)).equals(" ") && !Utils.isListContentItemList(listOfUser, list)) {
                        isAdd = false;
                    }
                    if (isAdd && (!(post = this.getPost(nodeObj)).getIsActiveByTopic() || !post.getIsApproved() || post.getIsHidden())) {
                        isAdd = false;
                    }
                }
            }
            if (!isAdd) continue;
            if (type_.equals(Utils.TOPIC)) {
                nodeObj = nodeObj.getParent();
            }
            listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type_));
        }
        return listSearchEvent;
    }

    private ForumSearch setPropertyForForumSearch(Node nodeObj, String type) throws Exception {
        ForumSearch forumSearch = new ForumSearch();
        forumSearch.setId(nodeObj.getName());
        forumSearch.setName(nodeObj.getProperty("exo:name").getString());
        forumSearch.setType(type);
        if (type.equals(Utils.FORUM)) {
            if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                forumSearch.setIcon("ForumCloseIcon");
            } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                forumSearch.setIcon("ForumLockedIcon");
            } else {
                forumSearch.setIcon("ForumNormalIcon");
            }
        } else if (type.equals(Utils.TOPIC)) {
            if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                forumSearch.setIcon("HotThreadNoNewClosePost");
            } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                forumSearch.setIcon("HotThreadNoNewLockPost");
            } else {
                forumSearch.setIcon("HotThreadNoNewPost");
            }
        } else if (type.equals(Utils.CATEGORY)) {
            forumSearch.setIcon("CategoryIcon");
        } else {
            forumSearch.setIcon(nodeObj.getProperty("exo:icon").getString());
        }
        forumSearch.setPath(nodeObj.getPath());
        return forumSearch;
    }

    private Map<String, List<String>> getCategoryViewer(Node categoryHome, List<String> listOfUser, List<String> listCateIds, List<String> listForumIds) throws Exception {
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>();
        if (listOfUser == null || listOfUser.isEmpty()) {
            listOfUser = new ArrayList<String>();
            listOfUser.add("user_gest_uoom");
        }
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder();
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:forumCategory)");
        boolean i = false;
        for (String string : listOfUser) {
            if (!i) {
                queryString.append("[(@exo:userPrivate=' ') or (@exo:userPrivate='").append(string).append("')");
            } else {
                queryString.append(" or (@exo:userPrivate='").append(string).append("')");
            }
            i = true;
        }
        if (i) {
            queryString.append("]");
        }
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        NodeIterator iter1 = null;
        if (iter.getSize() > 0L && iter.getSize() != categoryHome.getNodes().getSize()) {
            ArrayList<String> listForumId = new ArrayList<String>();
            ArrayList<String> listCateId = new ArrayList<String>();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                String cateId = catNode.getName();
                if (listCateIds != null && !listCateIds.isEmpty()) {
                    if (listCateIds.contains(cateId)) {
                        listCateId.add(cateId);
                    }
                } else {
                    listCateId.add(cateId);
                }
                iter1 = catNode.getNodes();
                while (iter1.hasNext()) {
                    Node forumNode = iter1.nextNode();
                    if (!forumNode.isNodeType("exo:forum")) continue;
                    String forumId = forumNode.getName();
                    if (listForumIds != null && !listForumIds.isEmpty()) {
                        if (!listForumIds.contains(forumId)) continue;
                        listForumId.add(forumId);
                        continue;
                    }
                    listForumId.add(forumId);
                }
            }
            mapList.put(Utils.FORUM, listForumId);
            mapList.put(Utils.CATEGORY, listCateId);
        } else if (iter.getSize() == 0L) {
            listForumIds = new ArrayList<String>();
            listForumIds.add("forumId");
            mapList.put(Utils.FORUM, listForumIds);
            listCateIds = new ArrayList<String>();
            listCateIds.add("cateId");
            mapList.put(Utils.CATEGORY, listCateIds);
        } else {
            mapList.put(Utils.FORUM, listForumIds);
            mapList.put(Utils.CATEGORY, listCateIds);
        }
        return mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        Node watchingNode = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        try {
            if (watchType != -1) {
                if (path.indexOf(categoryHome.getName()) < 0) {
                    path = categoryHome.getPath() + "/" + path;
                }
                watchingNode = (Node)categoryHome.getSession().getItem(path);
            } else {
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer();
                queryString.append("/jcr:root").append(categoryHome.getPath()).append("//*[@exo:id='").append(path).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                watchingNode = result.getNodes().nextNode();
            }
            ArrayList<String> listUsers = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching")) {
                if (watchType == 1) {
                    ArrayList<String> listEmail = new ArrayList<String>();
                    if (watchingNode.hasProperty("exo:emailWatching")) {
                        listEmail.addAll(this.ValuesToList(watchingNode.getProperty("exo:emailWatching").getValues()));
                    }
                    if (watchingNode.hasProperty("exo:userWatching")) {
                        listUsers.addAll(this.ValuesToList(watchingNode.getProperty("exo:userWatching").getValues()));
                    }
                    for (String str : values) {
                        if (listEmail.contains(str)) continue;
                        listEmail.add(0, str);
                        listUsers.add(0, currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(listEmail));
                    watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listUsers));
                } else if (watchType == -1) {
                    watchingNode.setProperty("exo:rssWatching", this.getValueProperty(watchingNode, "exo:rssWatching", currentUser));
                }
            } else {
                watchingNode.addMixin("exo:forumWatching");
                if (watchType == 1) {
                    for (int i = 0; i < values.size(); ++i) {
                        listUsers.add(currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(values));
                    watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listUsers));
                } else if (watchType == -1) {
                    listUsers.add(currentUser);
                    watchingNode.setProperty("exo:rssWatching", JCRDataStorage.getStringsInList(listUsers));
                }
            }
            if (watchingNode.isNew()) {
                watchingNode.getSession().save();
            } else {
                watchingNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatch(int watchType, String path, String values) throws Exception {
        if (values == null || values.trim().length() == 0) {
            return;
        }
        Node watchingNode = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        String string = categoryHome.getPath();
        if (path.indexOf(categoryHome.getName()) < 0) {
            path = string + "/" + path;
        }
        try {
            watchingNode = (Node)categoryHome.getSession().getItem(path);
            ArrayList<String> newValues = new ArrayList<String>();
            ArrayList<String> listNewUsers = new ArrayList<String>();
            ArrayList<String> userRSS = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching") && watchType == 1) {
                String[] emails = new String[]{};
                String[] listOldUsers = new String[]{};
                String[] listRss = new String[]{};
                if (watchingNode.hasProperty("exo:emailWatching")) {
                    emails = this.ValuesToArray(watchingNode.getProperty("exo:emailWatching").getValues());
                }
                if (watchingNode.hasProperty("exo:userWatching")) {
                    listOldUsers = this.ValuesToArray(watchingNode.getProperty("exo:userWatching").getValues());
                }
                if (watchingNode.hasProperty("exo:rssWatching")) {
                    listRss = this.ValuesToArray(watchingNode.getProperty("exo:rssWatching").getValues());
                }
                int n = listRss.length > listOldUsers.length ? listRss.length : listOldUsers.length;
                for (int i = 0; i < n; ++i) {
                    if (listOldUsers.length > i && !values.contains("/" + emails[i])) {
                        newValues.add(emails[i]);
                        listNewUsers.add(listOldUsers[i]);
                    }
                    if (listRss.length <= i || values.contains(listRss[i] + "/")) continue;
                    userRSS.add(listRss[i]);
                }
                watchingNode.setProperty("exo:emailWatching", JCRDataStorage.getStringsInList(newValues));
                watchingNode.setProperty("exo:userWatching", JCRDataStorage.getStringsInList(listNewUsers));
                watchingNode.setProperty("exo:rssWatching", JCRDataStorage.getStringsInList(userRSS));
                if (watchingNode.isNew()) {
                    watchingNode.getSession().save();
                } else {
                    watchingNode.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node parentNode = this.getForumHomeNode(sProvider);
            QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(parentNode.getPath()).append("//element(*,exo:forumWatching)[(");
            for (int i = 0; i < listNodeId.size(); ++i) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("@exo:id='").append(listNodeId.get(i)).append("'");
            }
            queryString.append(")]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            Node watchingNode = null;
            ArrayList<String> listEmail = null;
            ArrayList<String> listUsers = null;
            while (iterator.hasNext()) {
                watchingNode = iterator.nextNode();
                listEmail = new ArrayList<String>();
                listUsers = new ArrayList<String>();
                if (watchingNode.hasProperty("exo:emailWatching")) {
                    listEmail.addAll(Arrays.asList(this.ValuesToArray(watchingNode.getProperty("exo:emailWatching").getValues())));
                }
                if (watchingNode.hasProperty("exo:userWatching")) {
                    listUsers.addAll(Arrays.asList(this.ValuesToArray(watchingNode.getProperty("exo:userWatching").getValues())));
                }
                if (listUsers.contains(userId)) {
                    for (int i = 0; i < listUsers.size(); ++i) {
                        if (!((String)listUsers.get(i)).equals(userId)) continue;
                        listEmail.set(i, newEmailAdd);
                    }
                } else {
                    listUsers.add(userId);
                    listEmail.add(newEmailAdd);
                }
                watchingNode.setProperty("exo:emailWatching", listEmail.toArray(new String[0]));
                watchingNode.setProperty("exo:userWatching", listUsers.toArray(new String[0]));
                watchingNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Watch> getWatchByUser(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            String rootPath = categoryHome.getPath();
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(rootPath).append("//element(*,exo:forumWatching)[(@exo:userWatching='").append(userId).append("') or (@exo:rssWatching='").append(userId).append("')]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            Watch watch = new Watch();
            Node node = null;
            ArrayList<String> users = new ArrayList<String>();
            ArrayList<String> RSSUsers = new ArrayList<String>();
            String[] emails = null;
            String path = null;
            String pathName = "";
            String typeNode = null;
            while (iterator.hasNext()) {
                users = new ArrayList();
                RSSUsers = new ArrayList();
                emails = new String[]{};
                rootPath = categoryHome.getPath();
                pathName = "";
                node = iterator.nextNode();
                if (node.hasProperty("exo:userWatching")) {
                    users.addAll(this.ValuesToList(node.getProperty("exo:userWatching").getValues()));
                }
                if (node.hasProperty("exo:emailWatching")) {
                    emails = this.ValuesToArray(node.getProperty("exo:emailWatching").getValues());
                }
                if (node.hasProperty("exo:rssWatching")) {
                    RSSUsers.addAll(this.ValuesToList(node.getProperty("exo:rssWatching").getValues()));
                }
                path = node.getPath();
                typeNode = node.isNodeType(Utils.TYPE_CATEGORY) ? Utils.TYPE_CATEGORY : (node.isNodeType(Utils.TYPE_FORUM) ? Utils.TYPE_FORUM : Utils.TYPE_TOPIC);
                for (String str : path.replace(rootPath + "/", "").split("/")) {
                    rootPath = rootPath + "/" + str;
                    if (pathName.trim().length() > 0) {
                        pathName = pathName + " > ";
                    }
                    pathName = pathName + ((Node)categoryHome.getSession().getItem(rootPath)).getProperty("exo:name").getString();
                }
                watch = new Watch();
                watch.setId(node.getName());
                watch.setNodePath(path);
                watch.setUserId(userId);
                watch.setPath(pathName);
                watch.setTypeNode(typeNode);
                if (users.contains(userId)) {
                    watch.setEmail(emails[users.indexOf(userId)]);
                    watch.setIsAddWatchByEmail(true);
                } else {
                    watch.setIsAddWatchByEmail(false);
                }
                if (RSSUsers.contains(userId)) {
                    watch.setIsAddWatchByRSS(true);
                } else {
                    watch.setIsAddWatchByRSS(false);
                }
                listWatches.add(watch);
            }
            ArrayList<Watch> arrayList = listWatches;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Watch> arrayList = listWatches;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    private void sendEmailNotification(List<String> addresses, Message message) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.SendMailJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            this.infoMap_.put(name, new SendMessageInfo(addresses, message));
            schedulerService.addPeriodJob(info, periodInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateImportedData(String path) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.UpdateDataJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            JobDataMap jdatamap = new JobDataMap();
            jdatamap.put("path", path);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            schedulerService.addPeriodJob(info, periodInfo, jdatamap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForum(String path) throws Exception {
        HashMap<String, Long> topicMap = new HashMap<String, Long>();
        HashMap<String, Long> postMap = new HashMap<String, Long>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Calendar cal;
            long l;
            String owner;
            Node node;
            Node forumStatisticNode = this.getStatisticHome(sProvider).getNode(Utils.FORUM_STATISTIC);
            QueryManager qm = forumStatisticNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery("/jcr:root" + path + "//element(*,exo:topic)", "xpath");
            QueryResult result = query.execute();
            NodeIterator topicIter = result.getNodes();
            query = qm.createQuery("/jcr:root" + path + "//element(*,exo:post)", "xpath");
            result = query.execute();
            NodeIterator postIter = result.getNodes();
            long count = forumStatisticNode.getProperty("exo:postCount").getLong() + postIter.getSize();
            forumStatisticNode.setProperty("exo:postCount", count);
            count = forumStatisticNode.getProperty("exo:topicCount").getLong() + topicIter.getSize();
            forumStatisticNode.setProperty("exo:topicCount", count);
            forumStatisticNode.save();
            while (topicIter.hasNext()) {
                node = topicIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (topicMap.containsKey(owner)) {
                    l = (Long)topicMap.get(owner) + 1L;
                    topicMap.put(owner, l);
                    continue;
                }
                l = 1L;
                topicMap.put(owner, l);
            }
            while (postIter.hasNext()) {
                node = postIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (postMap.containsKey(owner)) {
                    l = (Long)postMap.get(owner) + 1L;
                    postMap.put(owner, l);
                    continue;
                }
                l = 1L;
                postMap.put(owner, l);
            }
            Node profileHome = this.getUserProfileHome(sProvider);
            for (String userId : topicMap.keySet()) {
                Node profile;
                try {
                    profile = profileHome.getNode(userId);
                }
                catch (PathNotFoundException e) {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    cal = this.getGreenwichMeanTime();
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long l2 = profile.getProperty("exo:totalTopic").getLong() + (Long)topicMap.get(userId);
                profile.setProperty("exo:totalTopic", l2);
                if (!postMap.containsKey(userId)) continue;
                long t = profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                postMap.remove(userId);
            }
            for (String userId : postMap.keySet()) {
                Node profile;
                try {
                    profile = profileHome.getNode(userId);
                }
                catch (PathNotFoundException e) {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    cal = this.getGreenwichMeanTime();
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long t = profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
            }
            profileHome.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    public SendMessageInfo getMessageInfo(String name) throws Exception {
        SendMessageInfo messageInfo = (SendMessageInfo)this.infoMap_.get(name);
        this.infoMap_.remove(name);
        return messageInfo;
    }

    private String getPath(String index, String path) throws Exception {
        int t = path.lastIndexOf(index);
        if (t > 0) {
            path = path.substring(t + 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForumSearch> getJobWattingForModerator(String[] paths) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            Node node;
            ForumSearch forumSearch;
            Node categoryHome = this.getCategoryHome(sProvider);
            String string = categoryHome.getPath();
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String pathQuery = "";
            StringBuffer buffer = new StringBuffer();
            int l = paths.length;
            if (l > 0) {
                buffer.append(" and (");
                for (int i = 0; i < l; ++i) {
                    if (i > 0) {
                        buffer.append(" or ");
                    }
                    String str = this.getPath("/" + Utils.FORUM, paths[i]);
                    buffer.append("@exo:path='").append(str).append("'");
                }
                buffer.append(")");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)").append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("] order by @exo:modifiedDate descending");
            pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearch();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.TOPIC);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:description").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)").append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("] order by @exo:modifiedDate descending");
            pathQuery = stringBuffer.toString();
            query = qm.createQuery(pathQuery, "xpath");
            result = query.execute();
            iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearch();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.POST);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:message").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        int job = 0;
        try {
            Node newProfileNode = this.getUserProfileHome(sProvider).getNode(userId);
            long t = 3L;
            t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            if (t < 2L) {
                try {
                    job = (int)newProfileNode.getProperty("exo:jobWattingForModerator").getLong();
                }
                catch (Exception e) {
                    job = 0;
                }
            }
        }
        finally {
            sProvider.close();
        }
        return job;
    }

    private int getTotalJobWattingForModerator(SessionProvider sProvider, String userId) throws Exception {
        int totalJob = 0;
        try {
            Node newProfileNode = this.getUserProfileHome(sProvider).getNode(userId);
            long t = 3L;
            t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            if (t < 2L) {
                String[] paths;
                int l;
                Node categoryHome = this.getCategoryHome(sProvider);
                String string = categoryHome.getPath();
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer stringBuffer = new StringBuffer();
                String pathQuery = "";
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)");
                StringBuffer buffer = new StringBuffer();
                if (t > 0L && (l = (paths = this.ValuesToArray(newProfileNode.getProperty("exo:moderateForums").getValues())).length) > 0) {
                    buffer.append(" and (");
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            buffer.append(" or ");
                        }
                        String str = this.getPath("/" + Utils.FORUM, paths[i]);
                        buffer.append("@exo:path='").append(str).append("'");
                    }
                    buffer.append(")");
                }
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("]").toString();
                Query query = qm.createQuery(pathQuery, "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                totalJob = (int)iter.getSize();
                stringBuffer = new StringBuffer();
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)");
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("]").toString();
                query = qm.createQuery(pathQuery, "xpath");
                result = query.execute();
                iter = result.getNodes();
                newProfileNode.setProperty("exo:jobWattingForModerator", (long)(totalJob += (int)iter.getSize()));
                newProfileNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTotalJobWatting(List<String> userIds) {
        SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
        try {
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            Category cat = new Category();
            ArrayList<String> list = new ArrayList<String>();
            ContinuationService continuation = this.getContinuationService();
            for (String userId : userIds) {
                if (userId.trim().length() == 0 || list.contains(userId)) continue;
                list.add(userId);
                int job = this.getTotalJobWattingForModerator(sProvider, userId);
                if (job < 0) continue;
                cat.setCategoryName(String.valueOf(job));
                JsonValue json = generatorImpl.createJsonObject((Object)cat);
                continuation.sendMessage(userId, "/eXo/Application/Forum/messages", (Object)json, cat.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIterator search(String queryString) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            return nodeIterator;
        }
        catch (Exception e) {
            log.error((Object)"Failed to search by query.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateActiveUsers(String query) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String path = this.getUserProfileHome(sProvider).getPath();
            StringBuilder stringBuilder = new StringBuilder();
            if (query == null || query.length() == 0) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(calendar.getTimeInMillis() - 864000000L);
                stringBuilder.append("/jcr:root").append(path).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
            } else {
                stringBuilder.append("/jcr:root").append(path).append(query);
            }
            NodeIterator iter = this.search(stringBuilder.toString());
            Node statisticHome = this.getStatisticHome(sProvider);
            if (statisticHome.hasNode(Utils.FORUM_STATISTIC)) {
                statisticHome.getNode(Utils.FORUM_STATISTIC).setProperty("exo:activeUsers", iter.getSize());
                statisticHome.save();
            } else {
                ForumStatistic forumStatistic = new ForumStatistic();
                forumStatistic.setActiveUsers(iter.getSize());
                this.saveForumStatistic(forumStatistic);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to evaluate active users");
        }
        finally {
            sProvider.close();
        }
    }

    protected List<File> createCategoryFiles(List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        Node categoryHome = this.getCategoryHome(sessionProvider);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ArrayList<File> listFiles = new ArrayList<File>();
        File file = null;
        BufferedWriter writer = null;
        for (Category category : this.getCategories()) {
            if (objectIds != null && objectIds.size() > 0 && !objectIds.contains(category.getId())) continue;
            outputStream = new ByteArrayOutputStream();
            categoryHome.getSession().exportSystemView(category.getPath(), (OutputStream)outputStream, false, false);
            file = new File(category.getCategoryName() + ".xml");
            file.deleteOnExit();
            file.createNewFile();
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(outputStream.toString());
            ((Writer)writer).close();
            listFiles.add(file);
        }
        return listFiles;
    }

    protected List<File> createForumFiles(String categoryId, List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ArrayList<File> listFiles = new ArrayList<File>();
        File file = null;
        BufferedWriter writer = null;
        for (Forum forum : this.getForums(categoryId, null)) {
            if (objectIds.size() > 0 && !objectIds.contains(forum.getId())) continue;
            outputStream = new ByteArrayOutputStream();
            this.getCategoryHome(sessionProvider).getSession().exportSystemView(forum.getPath(), (OutputStream)outputStream, false, false);
            file = new File(forum.getForumName() + ".xml");
            file.deleteOnExit();
            file.createNewFile();
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(outputStream.toString());
            ((Writer)writer).close();
            listFiles.add(file);
        }
        return listFiles;
    }

    protected List<File> createFilesFromNode(Node node) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        File file = null;
        BufferedWriter writer = null;
        if (node != null) {
            outputStream = new ByteArrayOutputStream();
            node.getSession().exportSystemView(node.getPath(), (OutputStream)outputStream, false, false);
            file = new File(node.getName() + ".xml");
            file.deleteOnExit();
            file.createNewFile();
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(outputStream.toString());
            ((Writer)writer).close();
            listFiles.add(file);
        }
        return listFiles;
    }

    protected List<File> createAllForumFiles(SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        listFiles.addAll(this.createFilesFromNode(this.getAdminHome(sessionProvider)));
        listFiles.addAll(this.createFilesFromNode(this.getUserProfileHome(sessionProvider)));
        listFiles.addAll(this.createFilesFromNode(this.getTagHome(sessionProvider)));
        BBCodeOperator bbcodeObject = new BBCodeOperator(this.nodeHierarchyCreator_, this.rService_);
        listFiles.addAll(this.createFilesFromNode(bbcodeObject.getBBcodeHome(sessionProvider)));
        bbcodeObject = null;
        listFiles.addAll(this.createFilesFromNode(this.getBanIPHome(sessionProvider)));
        listFiles.addAll(this.createFilesFromNode(this.getCategoryHome(sessionProvider)));
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ArrayList<File> listFiles = new ArrayList<File>();
            if (!isExportAll) {
                if (categoryId != null) {
                    if (forumId != null && forumId.trim().length() >= 1) {
                        Node categoryHome = this.getCategoryHome(sessionProvider);
                        categoryHome.getSession().exportSystemView(nodePath, (OutputStream)bos, false, false);
                        categoryHome.getSession().logout();
                        Object var10_12 = null;
                        return var10_12;
                    }
                    listFiles.addAll(this.createForumFiles(categoryId, objectIds, sessionProvider));
                } else {
                    listFiles.addAll(this.createCategoryFiles(objectIds, sessionProvider));
                }
            } else {
                listFiles.addAll(this.createAllForumFiles(sessionProvider));
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream("exportCategory.zip"));
            byte[] buffer = new byte[4096];
            FileInputStream inputStream = null;
            ZipEntry zipEntry = null;
            for (File f : listFiles) {
                int byteReads;
                inputStream = new FileInputStream(f);
                zipEntry = new ZipEntry(f.getPath());
                zipOutputStream.putNextEntry(zipEntry);
                while ((byteReads = inputStream.read(buffer)) != -1) {
                    zipOutputStream.write(buffer, 0, byteReads);
                }
                inputStream.close();
            }
            zipOutputStream.close();
            File file = null;
            file = new File("exportCategory.zip");
            for (File f : listFiles) {
                f.deleteOnExit();
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            log.error((Object)"Failed to export data in forum ", (Throwable)e);
            return null;
        }
        finally {
            sessionProvider.close();
        }
    }

    public void importXML(String nodePath, InputStream is, String mimeType) throws Exception {
        if ("text/xml".equals(mimeType)) {
            this.importXMLFile(is, nodePath, 0);
        } else if ("application/zip".equals(mimeType)) {
            this.importZipFile(is, nodePath);
        }
    }

    private void importZipFile(InputStream is, String nodePath) throws Exception {
        ZipInputStream zipStream = new ZipInputStream(is);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[5120];
        ZipEntry entry = zipStream.getNextEntry();
        ByteArrayInputStream inputStream = null;
        while (entry != null) {
            out = new ByteArrayOutputStream();
            int available = -1;
            while ((available = zipStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            zipStream.closeEntry();
            out.close();
            inputStream = new ByteArrayInputStream(out.toByteArray());
            this.importXMLFile(inputStream, nodePath, 0);
            entry = zipStream.getNextEntry();
        }
        zipStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataFromXML(Node sourceNode, String nodePath, SessionProvider sessionProvider, InputStream is, String nodeName) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        Session session = forumHomeNode.getSession();
        Node tempNode = forumHomeNode.getParent().addNode("DataTemp");
        session.importXML(tempNode.getPath(), is, 0);
        session.save();
        Node importNode = tempNode.getNode(nodeName);
        try {
            this.copyFullNodes(sourceNode, importNode, session);
        }
        finally {
            tempNode.remove();
            forumHomeNode.getParent().save();
        }
    }

    private void copyFullNodes(Node sourceNode, Node importNode, Session session) throws RepositoryException {
        NodeIterator sourceIter = sourceNode.getNodes();
        NodeIterator importIter = importNode.getNodes();
        Node srcTemp = null;
        Node importTemp = null;
        boolean flag = false;
        while (importIter.hasNext()) {
            flag = true;
            importTemp = importIter.nextNode();
            while (sourceIter.hasNext()) {
                srcTemp = sourceIter.nextNode();
                if (!importTemp.getName().equals(srcTemp.getName())) continue;
                this.copyFullNodes(srcTemp, importTemp, session);
                flag = false;
                break;
            }
            if (!flag) continue;
            String path = sourceNode.getPath() + "/" + importTemp.getName();
            try {
                session.getWorkspace().copy(importTemp.getPath(), path);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXMLFile(InputStream is, String nodePath, int typeImport) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        byte[] bdata = new byte[is.available()];
        is.read(bdata);
        is = new ByteArrayInputStream(bdata);
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        String typeNodeExport = doc.getFirstChild().getChildNodes().item(0).getChildNodes().item(0).getTextContent();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            is = new ByteArrayInputStream(bdata);
            String nodeName = "";
            if (!typeNodeExport.equals("exo:forumCategory") && !typeNodeExport.equals("exo:forum")) {
                if (typeNodeExport.equals("exo:categoryHome")) {
                    nodePath = this.getCategoryHome(sessionProvider).getPath();
                    Node categoryHome = this.getCategoryHome(sessionProvider);
                    nodeName = "CategoryHome";
                    this.addDataFromXML(categoryHome, nodePath, sessionProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:userProfileHome")) {
                    Node userProfile = this.getUserProfileHome(sessionProvider);
                    nodeName = "UserProfileHome";
                    nodePath = this.getUserProfileHome(sessionProvider).getPath();
                    this.addDataFromXML(userProfile, nodePath, sessionProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:tagHome")) {
                    Node tagHome = this.getTagHome(sessionProvider);
                    nodePath = this.getTagHome(sessionProvider).getPath();
                    nodeName = "TagHome";
                    this.addDataFromXML(tagHome, nodePath, sessionProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:forumBBCodeHome")) {
                    BBCodeOperator bbcodeObject = new BBCodeOperator(this.nodeHierarchyCreator_, this.rService_);
                    nodePath = bbcodeObject.getBBcodeHome(sessionProvider).getPath();
                    Node bbcodeNode = bbcodeObject.getBBcodeHome(sessionProvider);
                    nodeName = "forumBBCode";
                    this.addDataFromXML(bbcodeNode, nodePath, sessionProvider, is, nodeName);
                    bbcodeObject = null;
                } else if (typeNodeExport.equals("exo:administrationHome")) {
                    nodePath = this.getForumSystemHome(sessionProvider).getPath();
                    Node node = this.getAdminHome(sessionProvider);
                    node.remove();
                    this.getForumSystemHome(sessionProvider).save();
                    typeImport = 2;
                } else if (typeNodeExport.equals("exo:banIPHome")) {
                    nodePath = this.getForumSystemHome(sessionProvider).getPath();
                    Node node = this.getBanIPHome(sessionProvider);
                    node.remove();
                    this.getForumSystemHome(sessionProvider).save();
                    typeImport = 2;
                }
            } else {
                String updatePath = nodePath;
                if (typeNodeExport.equals("exo:forumCategory")) {
                    nodePath = this.getCategoryHome(sessionProvider).getPath();
                    updatePath = nodePath + "/" + doc.getFirstChild().getAttributes().getNamedItem("sv:name").getTextContent();
                }
                Session session = this.getForumHomeNode(sessionProvider).getSession();
                session.importXML(nodePath, is, typeImport);
                session.save();
                if (typeNodeExport.equals("exo:forumCategory")) {
                    this.updateImportedData(updatePath);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to import data. " + e.getMessage()), (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readTopic")) {
                values = this.ValuesToList(profile.getProperty("exo:readTopic").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(topicId) == 0) {
                    values.set(i, topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && ((String)values.get(0)).trim().length() < 1) {
                values.remove(0);
            }
            profile.setProperty("exo:readTopic", values.toArray(new String[0]));
            profile.save();
        }
        catch (Exception e) {
            log.error((Object)("Failed to update topic access: " + e.getMessage()), (Throwable)e);
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForumAccess(String userId, String forumId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readForum")) {
                values = this.ValuesToList(profile.getProperty("exo:readForum").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(forumId) == 0) {
                    values.set(i, forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && ((String)values.get(0)).trim().length() < 1) {
                values.remove(0);
            }
            profile.setProperty("exo:readForum", values.toArray(new String[0]));
            profile.save();
        }
        catch (Exception e) {
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBookmarks(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sProvider).getNode(userName);
            if (profile.hasProperty("exo:bookmark")) {
                List<String> list = this.ValuesToList(profile.getProperty("exo:bookmark").getValues());
                return list;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get bookmark ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBanList() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            if (banNode.hasProperty("exo:ips")) {
                List<String> list = this.ValuesToList(banNode.getProperty("exo:ips").getValues());
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBanIP(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            return false;
        }
        ips.add(ip);
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            banNode.setProperty("exo:ips", ips.toArray(new String[0]));
            if (banNode.isNew()) {
                banNode.getSession().save();
            } else {
                banNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBan(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            ips.remove(ip);
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node banNode = this.getForumBanNode(sProvider);
                banNode.setProperty("exo:ips", JCRDataStorage.getStringsInList(ips));
                banNode.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getForumBanList(String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node forumNode;
            if (forumId.indexOf(".") > 0) {
                forumId = StringUtils.replace((String)forumId, (String)".", (String)"/");
            }
            if ((forumNode = this.getCategoryHome(sProvider).getNode(forumId)).hasProperty("exo:banIPs")) {
                list.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                boolean bl = false;
                return bl;
            }
            ips.add(ip);
            forumNode.setProperty("exo:banIPs", JCRDataStorage.getStringsInList(ips));
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(this.ValuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                ips.remove(ip);
                forumNode.setProperty("exo:banIPs", JCRDataStorage.getStringsInList(ips));
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private List<String> getAllAdministrator(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder();
        pathQuery.append("/jcr:root").append(this.getUserProfileHome(sProvider).getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[@exo:userRole=0]");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Node userNode = iter.nextNode();
            list.add(userNode.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            long count;
            Node forumStatisticNode = this.getStatisticHome(sysProvider).getNode(Utils.FORUM_STATISTIC);
            if (topicCount != 0L) {
                count = forumStatisticNode.getProperty("exo:topicCount").getLong() + topicCount;
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:topicCount", count);
            }
            if (postCount != 0L) {
                count = forumStatisticNode.getProperty("exo:postCount").getLong() + postCount;
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:postCount", count);
            }
            forumStatisticNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysProvider.close();
        }
    }

    private PruneSetting getPruneSetting(Node prunNode) throws Exception {
        PruneSetting pruneSetting = new PruneSetting();
        pruneSetting.setId(prunNode.getName());
        pruneSetting.setForumPath(prunNode.getParent().getPath());
        pruneSetting.setActive(prunNode.getProperty("exo:isActive").getBoolean());
        pruneSetting.setCategoryName(prunNode.getParent().getParent().getProperty("exo:name").getString());
        pruneSetting.setForumName(prunNode.getParent().getProperty("exo:name").getString());
        pruneSetting.setInActiveDay(prunNode.getProperty("exo:inActiveDay").getLong());
        pruneSetting.setPeriodTime(prunNode.getProperty("exo:periodTime").getLong());
        if (prunNode.hasProperty("exo:lastRunDate")) {
            pruneSetting.setLastRunDate(prunNode.getProperty("exo:lastRunDate").getDate().getTime());
        }
        return pruneSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        PruneSetting pruneSetting = new PruneSetting();
        try {
            Node forumNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(forumPath);
            pruneSetting = this.getPruneSetting(forumNode.getNode(Utils.PRUNESETTING));
        }
        finally {
            sProvider.close();
        }
        return pruneSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        ArrayList<PruneSetting> prunList = new ArrayList<PruneSetting>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHNode.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHNode.getPath()).append("//element(*,exo:pruneSetting) order by @exo:id ascending");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node prunNode = iter.nextNode();
                prunList.add(this.getPruneSetting(prunNode));
            }
        }
        finally {
            sProvider.close();
        }
        return prunList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node pruneNode;
            String path = pruneSetting.getForumPath();
            Node forumNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            try {
                pruneNode = forumNode.getNode(Utils.PRUNESETTING);
            }
            catch (Exception e) {
                pruneNode = forumNode.addNode(Utils.PRUNESETTING, "exo:pruneSetting");
                pruneNode.setProperty("exo:id", pruneSetting.getId());
            }
            pruneNode.setProperty("exo:inActiveDay", pruneSetting.getInActiveDay());
            pruneNode.setProperty("exo:periodTime", pruneSetting.getPeriodTime());
            pruneNode.setProperty("exo:isActive", pruneSetting.isActive());
            if (pruneSetting.getLastRunDate() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(pruneSetting.getLastRunDate());
                pruneNode.setProperty("exo:lastRunDate", calendar);
            }
            if (pruneNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            try {
                this.addOrRemoveSchedule(pruneSetting);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    private void addOrRemoveSchedule(PruneSetting pSetting) throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, -1, pSetting.getPeriodTime() * 86400000L);
        Class<?> clazz = Class.forName("org.exoplatform.forum.service.user.AutoPruneJob");
        JobInfo info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", clazz);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        schedulerService.removeJob(info);
        if (pSetting.isActive()) {
            info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", clazz);
            info.setDescription(pSetting.getForumPath());
            schedulerService.addPeriodJob(info, periodInfo);
            log.debug((Object)("\n\n>>>>Activated " + info.getJobName()));
        }
    }

    public void runPrune(String forumPath) throws Exception {
        this.runPrune(this.getPruneSetting(forumPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            Node forumNode = (Node)forumHome.getSession().getItem(pSetting.getForumPath());
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - pSetting.getInActiveDay() * 86400000L);
            QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[ @exo:isActive='true' and @exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')]");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node topic = iter.nextNode();
                topic.setProperty("exo:isActive", false);
            }
            Node setting = forumNode.getNode(pSetting.getId());
            setting.setProperty("exo:lastRunDate", this.getGreenwichMeanTime());
            forumNode.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            Node forumNode = (Node)forumHome.getSession().getItem(pSetting.getForumPath());
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - pSetting.getInActiveDay() * 86400000L);
            QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[ @exo:isActive='true' and @exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')]");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            long l = result.getNodes().getSize();
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }

    private TopicType getTopicType(Node node) throws Exception {
        TopicType topicType = new TopicType();
        topicType.setId(node.getName());
        topicType.setName(node.getProperty("exo:name").getString());
        topicType.setIcon(node.getProperty("exo:icon").getString());
        return topicType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicType> getTopicTypes() throws Exception {
        ArrayList<TopicType> listTT = new ArrayList<TopicType>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            NodeIterator iter = nodeHome.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                listTT.add(this.getTopicType(node));
            }
        }
        catch (Exception exception) {
        }
        finally {
            sProvider.close();
        }
        return listTT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicType getTopicType(String Id) throws Exception {
        TopicType topicType = new TopicType();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            topicType = this.getTopicType(nodeHome.getNode(Id));
        }
        catch (Exception e) {
            topicType.setId(TopicType.DEFAULT_ID);
            topicType.setName("Default");
        }
        finally {
            sProvider.close();
        }
        return topicType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTopicType(TopicType topicType) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node;
            Node nodeHome = this.getTopicTypeHome(sProvider);
            try {
                node = nodeHome.getNode(topicType.getId());
            }
            catch (Exception e) {
                node = nodeHome.addNode(topicType.getId(), "exo:topicType");
                node.setProperty("exo:id", topicType.getId());
            }
            node.setProperty("exo:name", topicType.getName());
            node.setProperty("exo:icon", topicType.getIcon());
            if (nodeHome.isNew()) {
                nodeHome.getSession().save();
            } else {
                nodeHome.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTopicType(String topicTypeId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            try {
                Node node = nodeHome.getNode(topicTypeId);
                node.remove();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nodeHome.isNew()) {
                nodeHome.getSession().save();
            } else {
                nodeHome.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRPageList getPageTopicByType(String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryNode.getPath()).append("//element(*,exo:topic)").append("[@topicType='").append(type).append("']").append(" order by @exo:createdDate descending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get page topic by type", (Throwable)e);
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }
}

