/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;

public class StatisticEventListener
implements EventListener {
    private String workspace_;
    private String repository_;
    private String path_;

    public StatisticEventListener(String ws, String repo) throws Exception {
        this.workspace_ = ws;
        this.repository_ = repo;
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            long topicCount = 0L;
            long postCount = 0L;
            while (evIter.hasNext()) {
                String id;
                Event ev = evIter.nextEvent();
                if (ev.getType() == 1) {
                    id = ev.getPath().substring(ev.getPath().lastIndexOf("/"));
                    if (id.indexOf(Utils.TOPIC) > 0) {
                        ++topicCount;
                        continue;
                    }
                    if (id.indexOf(Utils.POST) <= 0) continue;
                    ++postCount;
                    continue;
                }
                if (ev.getType() != 2) continue;
                id = ev.getPath().substring(ev.getPath().lastIndexOf("/"));
                if (id.indexOf(Utils.TOPIC) > 0) {
                    --topicCount;
                    continue;
                }
                if (id.indexOf(Utils.POST) <= 0) continue;
                --postCount;
            }
            if (topicCount != 0L || postCount != 0L) {
                forumService.updateStatisticCounts(topicCount, postCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

