/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateDataJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        try {
            ExoContainer exoContainer = Utils.getExoContainer((JobExecutionContext)context);
            ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
            ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
            String name = context.getJobDetail().getName();
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            String path = jdatamap.getString("path");
            forumService.updateForum(path);
            JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"\n\nForum statistic updated");
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            log_.trace((Object)("\nStatistic Forum could not updated: \n" + e.getCause()));
        }
        finally {
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

