/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.InitializeForumPlugin;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SendMessageInfo;
import org.exoplatform.forum.service.SortSettings;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.cache.model.CacheType;
import org.exoplatform.forum.service.cache.model.data.CategoryData;
import org.exoplatform.forum.service.cache.model.data.ForumData;
import org.exoplatform.forum.service.cache.model.data.LinkData;
import org.exoplatform.forum.service.cache.model.data.ListCategoryData;
import org.exoplatform.forum.service.cache.model.data.ListForumData;
import org.exoplatform.forum.service.cache.model.data.ListLinkData;
import org.exoplatform.forum.service.cache.model.data.ListPostData;
import org.exoplatform.forum.service.cache.model.data.ListWatchData;
import org.exoplatform.forum.service.cache.model.data.PostData;
import org.exoplatform.forum.service.cache.model.data.TagData;
import org.exoplatform.forum.service.cache.model.data.TopicData;
import org.exoplatform.forum.service.cache.model.data.WatchData;
import org.exoplatform.forum.service.cache.model.key.CategoryKey;
import org.exoplatform.forum.service.cache.model.key.CategoryListKey;
import org.exoplatform.forum.service.cache.model.key.ForumKey;
import org.exoplatform.forum.service.cache.model.key.ForumListKey;
import org.exoplatform.forum.service.cache.model.key.LinkListKey;
import org.exoplatform.forum.service.cache.model.key.ObjectNameKey;
import org.exoplatform.forum.service.cache.model.key.PostKey;
import org.exoplatform.forum.service.cache.model.key.PostListCountKey;
import org.exoplatform.forum.service.cache.model.key.PostListKey;
import org.exoplatform.forum.service.cache.model.key.TopicKey;
import org.exoplatform.forum.service.cache.model.selector.CategoryIdSelector;
import org.exoplatform.forum.service.cache.model.selector.ForumPathSelector;
import org.exoplatform.forum.service.cache.model.selector.PostListCountSelector;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.ks.common.cache.ServiceContext;
import org.exoplatform.ks.common.cache.model.CachedData;
import org.exoplatform.ks.common.cache.model.data.SimpleCacheData;
import org.exoplatform.ks.common.cache.model.key.SimpleCacheKey;
import org.exoplatform.ks.common.cache.model.selector.ScopeCacheSelector;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedDataStorage
implements DataStorage,
Startable {
    private static final Log LOG = ExoLogger.getLogger(CachedDataStorage.class);
    private static final String PRIVATE_MESSAGE_COUNT_KEY = "messageCount";
    private DataStorage storage;
    private CacheService service;
    private ExoCache<CategoryKey, CategoryData> categoryData;
    private ExoCache<CategoryListKey, ListCategoryData> categoryList;
    private ExoCache<ForumKey, ForumData> forumData;
    private ExoCache<ForumListKey, ListForumData> forumList;
    private ExoCache<PostKey, PostData> postData;
    private ExoCache<PostListKey, ListPostData> postList;
    private ExoCache<PostListCountKey, SimpleCacheData> postListCount;
    private ExoCache<TopicKey, TopicData> topicData;
    private ExoCache<SimpleCacheKey, ListWatchData> watchListData;
    private ExoCache<LinkListKey, ListLinkData> linkListData;
    private ExoCache<ObjectNameKey, CachedData> objectNameData;
    private ExoCache<SimpleCacheKey, SimpleCacheData> miscData;
    private FutureExoCache<CategoryKey, CategoryData, ServiceContext<CategoryData>> categoryDataFuture;
    private FutureExoCache<CategoryListKey, ListCategoryData, ServiceContext<ListCategoryData>> categoryListFuture;
    private FutureExoCache<ForumKey, ForumData, ServiceContext<ForumData>> forumDataFuture;
    private FutureExoCache<ForumListKey, ListForumData, ServiceContext<ListForumData>> forumListFuture;
    private FutureExoCache<PostKey, PostData, ServiceContext<PostData>> postDataFuture;
    private FutureExoCache<PostListKey, ListPostData, ServiceContext<ListPostData>> postListFuture;
    private FutureExoCache<PostListCountKey, SimpleCacheData, ServiceContext<SimpleCacheData>> postListCountFuture;
    private FutureExoCache<TopicKey, TopicData, ServiceContext<TopicData>> topicDataFuture;
    private FutureExoCache<SimpleCacheKey, ListWatchData, ServiceContext<ListWatchData>> watchListDataFuture;
    private FutureExoCache<LinkListKey, ListLinkData, ServiceContext<ListLinkData>> linkListDataFuture;
    private FutureExoCache<SimpleCacheKey, SimpleCacheData, ServiceContext<SimpleCacheData>> miscDataFuture;
    private ForumStatistic statistic;

    public CachedDataStorage(CacheService service, JCRDataStorage storage) {
        this.storage = storage;
        this.service = service;
    }

    private void clearForumCache(Forum forum, boolean isPutNewKey) throws Exception {
        if (isPutNewKey) {
            this.forumData.put((Serializable)((Object)new ForumKey(forum)), (Object)new ForumData(forum));
        } else {
            this.forumData.remove((Serializable)((Object)new ForumKey(forum)));
        }
        this.statistic = null;
    }

    private void clearForumCache(String categoryId, String forumId, boolean isPutNewKey) throws Exception {
        Forum forum = this.getForum(categoryId, forumId);
        if (forum != null) {
            this.clearForumCache(forum, isPutNewKey);
        }
    }

    private void clearForumListCache() throws Exception {
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearPostListCache() throws Exception {
        this.postList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearPostListCountCache(String topicId) throws Exception {
        this.postListCount.select((CachedObjectSelector)new PostListCountSelector(topicId));
    }

    private void clearLinkListCache() throws Exception {
        this.linkListData.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    private void clearTopicCache(String topicPath) throws Exception {
        this.topicData.remove((Serializable)((Object)new TopicKey(topicPath, true)));
    }

    private void clearTopicCache(String categoryId, String forumId, String topicId) throws Exception {
        Topic topic = this.getTopic(categoryId, forumId, topicId, null);
        this.clearTopicCache(topic);
    }

    private void clearTopicCache(Topic topic) throws Exception {
        if (topic != null) {
            this.clearTopicCache(topic.getPath());
            this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(topic.getPath())));
            this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(topic.getId(), Utils.TOPIC)));
        }
    }

    private void clearCategoryCache(String id) throws Exception {
        this.categoryData.remove((Serializable)((Object)new CategoryKey(id)));
    }

    private void clearCategoryCache(Category category) throws Exception {
        if (category != null) {
            this.clearCategoryCache(category.getId());
            this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(category.getPath())));
            this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(category.getId(), Utils.CATEGORY)));
        }
    }

    private void clearPostCache(String categoryId, String forumId, String topicId, String postId) throws Exception {
        this.postData.remove((Serializable)((Object)new PostKey(categoryId, forumId, topicId, postId)));
    }

    private void clearObjectCache(Forum forum, boolean isPutNewKey) throws Exception {
        if (forum != null) {
            ForumData forumData = new ForumData(forum);
            String categoryId = forum.getCategoryId();
            String forumId = forum.getId();
            if (isPutNewKey) {
                this.objectNameData.put((Serializable)((Object)new ObjectNameKey(categoryId + "/" + forumId)), (Object)forumData);
                this.objectNameData.put((Serializable)((Object)new ObjectNameKey(forumId, Utils.FORUM)), (Object)forumData);
            } else {
                this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(categoryId + "/" + forumId)));
                this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(forumId, Utils.FORUM)));
            }
        }
    }

    private void clearObjectCache(Category category, boolean isNew) throws Exception {
        if (isNew) {
            CategoryData categoryData = new CategoryData(category);
            this.objectNameData.put((Serializable)((Object)new ObjectNameKey(category.getId(), Utils.CATEGORY)), (Object)categoryData);
        } else {
            this.objectNameData.remove((Serializable)((Object)new ObjectNameKey(category.getId(), Utils.CATEGORY)));
        }
    }

    private void clearObjectCache(String categoryId, String forumId, boolean isPutNewKey) throws Exception {
        this.clearObjectCache(this.getForum(categoryId, forumId), isPutNewKey);
    }

    private void clearWatchingItemCache(String watchingItemPath) throws Exception {
        String topicId;
        String categoryId = watchingItemPath.contains("/") ? watchingItemPath.substring(0, watchingItemPath.indexOf("/")) : watchingItemPath;
        String forumId = watchingItemPath.contains("/" + Utils.FORUM) ? watchingItemPath.substring(watchingItemPath.indexOf("/" + Utils.FORUM) + 1) : null;
        forumId = !Utils.isEmpty(forumId) && forumId.contains("/") ? forumId.substring(0, forumId.indexOf("/")) : forumId;
        String string = topicId = watchingItemPath.contains(Utils.TOPIC) ? watchingItemPath.substring(watchingItemPath.indexOf(Utils.TOPIC)) : null;
        if (!Utils.isEmpty(topicId)) {
            this.topicData.remove((Serializable)((Object)new TopicKey(categoryId + "/" + forumId + "/" + topicId, false)));
        } else if (!Utils.isEmpty(forumId)) {
            this.forumData.remove((Serializable)((Object)new ForumKey(categoryId, forumId)));
        } else {
            this.categoryData.remove((Serializable)((Object)new CategoryKey(categoryId)));
        }
    }

    public void start() {
        this.categoryData = CacheType.CATEGORY_DATA.getFromService(this.service);
        this.categoryList = CacheType.CATEGORY_LIST.getFromService(this.service);
        this.forumData = CacheType.FORUM_DATA.getFromService(this.service);
        this.forumList = CacheType.FORUM_LIST.getFromService(this.service);
        this.postData = CacheType.POST_DATA.getFromService(this.service);
        this.postList = CacheType.POST_LIST.getFromService(this.service);
        this.postListCount = CacheType.POST_LIST_COUNT.getFromService(this.service);
        this.topicData = CacheType.TOPIC_DATA.getFromService(this.service);
        this.objectNameData = CacheType.OBJECT_NAME_DATA.getFromService(this.service);
        this.miscData = CacheType.MISC_DATA.getFromService(this.service);
        this.watchListData = CacheType.WATCH_LIST_DATA.getFromService(this.service);
        this.linkListData = CacheType.LINK_LIST_DATA.getFromService(this.service);
        this.categoryDataFuture = CacheType.CATEGORY_DATA.createFutureCache(this.categoryData);
        this.categoryListFuture = CacheType.CATEGORY_LIST.createFutureCache(this.categoryList);
        this.forumDataFuture = CacheType.FORUM_DATA.createFutureCache(this.forumData);
        this.forumListFuture = CacheType.FORUM_LIST.createFutureCache(this.forumList);
        this.postDataFuture = CacheType.POST_DATA.createFutureCache(this.postData);
        this.postListFuture = CacheType.POST_LIST.createFutureCache(this.postList);
        this.postListCountFuture = CacheType.POST_LIST_COUNT.createFutureCache(this.postListCount);
        this.topicDataFuture = CacheType.TOPIC_DATA.createFutureCache(this.topicData);
        this.watchListDataFuture = CacheType.WATCH_LIST_DATA.createFutureCache(this.watchListData);
        this.linkListDataFuture = CacheType.LINK_LIST_DATA.createFutureCache(this.linkListData);
        this.miscDataFuture = CacheType.MISC_DATA.createFutureCache(this.miscData);
    }

    public void stop() {
    }

    private ListLinkData buildLinkInput(List<ForumLinkData> links) {
        ArrayList<LinkData> data = new ArrayList<LinkData>();
        for (ForumLinkData l : links) {
            data.add(new LinkData(l));
        }
        return new ListLinkData(data);
    }

    private List<ForumLinkData> buildLinkOutput(ListLinkData data) {
        if (data == null) {
            return null;
        }
        ArrayList<ForumLinkData> out = new ArrayList<ForumLinkData>();
        for (LinkData d : data.getIds()) {
            out.add(d.build());
        }
        return out;
    }

    private ListWatchData buildWatchInput(List<Watch> watches) {
        ArrayList<WatchData> data = new ArrayList<WatchData>();
        for (Watch w : watches) {
            data.add(new WatchData(w));
        }
        return new ListWatchData(data);
    }

    private List<Watch> buildWatchOutput(ListWatchData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Watch> out = new ArrayList<Watch>();
        for (WatchData d : data.getIds()) {
            out.add(d.build());
        }
        return out;
    }

    private ListPostData buildPostInput(List<Post> posts) {
        ArrayList<PostKey> data = new ArrayList<PostKey>();
        for (Post p : posts) {
            data.add(new PostKey(p));
        }
        return new ListPostData(data);
    }

    private List<Post> buildPostOutput(ListPostData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Post> out = new ArrayList<Post>();
        for (PostKey k : data.getIds()) {
            try {
                out.add(this.getPost(k.getCategory(), k.getForum(), k.getTopic(), k.getPost()));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    private ListForumData buildForumInput(List<Forum> forums) {
        ArrayList<ForumKey> keys = new ArrayList<ForumKey>();
        for (Forum f : forums) {
            keys.add(new ForumKey(f));
        }
        return new ListForumData(keys);
    }

    private List<Forum> buildForumOutput(ListForumData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Forum> out = new ArrayList<Forum>();
        for (ForumKey k : data.getIds()) {
            out.add(this.getForum(k.getCategoryId(), k.getForumId()));
        }
        return out;
    }

    private ListCategoryData buildCategoryInput(List<Category> categories) {
        ArrayList<CategoryKey> keys = new ArrayList<CategoryKey>();
        for (Category c : categories) {
            keys.add(new CategoryKey(c));
        }
        return new ListCategoryData(keys);
    }

    private List<Category> buildCategoryOutput(ListCategoryData data) {
        if (data == null) {
            return null;
        }
        ArrayList<Category> out = new ArrayList<Category>();
        for (CategoryKey k : data.getIds()) {
            try {
                out.add(this.getCategory(k.getId()));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return out;
    }

    @Override
    @ManagedDescription(value="repository for forum storage")
    @Managed
    public String getRepository() throws Exception {
        return this.storage.getRepository();
    }

    @Override
    @ManagedDescription(value="workspace for the forum storage")
    @Managed
    public String getWorkspace() throws Exception {
        return this.storage.getWorkspace();
    }

    @Override
    @ManagedDescription(value="data path for forum storage")
    @Managed
    public String getPath() throws Exception {
        return this.storage.getPath();
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDataPlugin(plugin);
    }

    @Override
    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDefaultDataPlugin(plugin);
    }

    @Override
    public void addCalculateModeratorEventListener() throws Exception {
        this.storage.addCalculateModeratorEventListener();
    }

    @Override
    public void addDeletedUserCalculateListener() throws Exception {
        this.storage.addDeletedUserCalculateListener();
    }

    @Override
    public void initCategoryListener() {
        this.storage.initCategoryListener();
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.storage.isAdminRole(userName);
    }

    @Override
    public void setDefaultAvatar(String userName) {
        this.storage.setDefaultAvatar(userName);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        return this.storage.getUserAvatar(userName);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        this.storage.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        this.storage.saveForumAdministration(forumAdministration);
    }

    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        return this.storage.getForumAdministration();
    }

    @Override
    public SortSettings getForumSortSettings() throws Exception {
        return this.storage.getForumSortSettings();
    }

    @Override
    public SortSettings getTopicSortSettings() throws Exception {
        return this.storage.getTopicSortSettings();
    }

    @Override
    public List<Category> getCategories() {
        return this.buildCategoryOutput((ListCategoryData)((Object)this.categoryListFuture.get((Object)new ServiceContext<ListCategoryData>(){

            public ListCategoryData execute() {
                return CachedDataStorage.this.buildCategoryInput(CachedDataStorage.this.storage.getCategories());
            }
        }, (Object)new CategoryListKey(null))));
    }

    @Override
    public Category getCategory(final String categoryId) throws Exception {
        return ((CategoryData)this.categoryDataFuture.get((Object)new ServiceContext<CategoryData>(){

            public CategoryData execute() {
                try {
                    Category got = CachedDataStorage.this.storage.getCategory(categoryId);
                    if (got != null) {
                        return new CategoryData(got);
                    }
                    return CategoryData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new CategoryKey(categoryId))).build();
    }

    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        return this.storage.getPermissionTopicByCategory(categoryId, type);
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        this.storage.saveCategory(category, isNew);
        this.categoryData.put((Serializable)((Object)new CategoryKey(category)), (Object)new CategoryData(category));
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearLinkListCache();
        this.clearObjectCache(category, isNew);
        if (!isNew) {
            this.clearCategoryCache(category);
        }
    }

    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        this.storage.saveModOfCategory(moderatorCate, userId, isAdd);
        try {
            this.categoryData.select((CachedObjectSelector)new CategoryIdSelector(moderatorCate, this.categoryData));
        }
        catch (Exception e) {
            LOG.debug((Object)"Can not clear list categories in cached.", (Throwable)e);
        }
    }

    @Override
    public void calculateModerator(String nodePath, boolean isNew) throws Exception {
        this.storage.calculateModerator(nodePath, isNew);
        this.clearForumCache(Utils.getCategoryId(nodePath), Utils.getForumId(nodePath), false);
        this.clearForumListCache();
    }

    @Override
    public void registerListenerForCategory(String path) throws Exception {
        this.storage.registerListenerForCategory(path);
    }

    @Override
    public void unRegisterListenerForCategory(String path) throws Exception {
        this.storage.unRegisterListenerForCategory(path);
    }

    @Override
    public Category removeCategory(String categoryId) throws Exception {
        this.categoryData.remove((Serializable)((Object)new CategoryKey(categoryId)));
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearLinkListCache();
        return this.storage.removeCategory(categoryId);
    }

    @Override
    public List<Forum> getForums(final String categoryId, final String strQuery) throws Exception {
        return this.buildForumOutput((ListForumData)((Object)this.forumListFuture.get((Object)new ServiceContext<ListForumData>(){

            public ListForumData execute() {
                try {
                    return CachedDataStorage.this.buildForumInput(CachedDataStorage.this.storage.getForums(categoryId, strQuery));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new ForumListKey(categoryId, strQuery))));
    }

    @Override
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.getForums(categoryId, strQuery);
    }

    @Override
    public Forum getForum(final String categoryId, final String forumId) {
        return ((ForumData)this.forumDataFuture.get((Object)new ServiceContext<ForumData>(){

            public ForumData execute() {
                Forum got = CachedDataStorage.this.storage.getForum(categoryId, forumId);
                if (got != null) {
                    return new ForumData(got);
                }
                return ForumData.NULL;
            }
        }, (Object)new ForumKey(categoryId, forumId))).build();
    }

    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        this.storage.modifyForum(forum, type);
        this.clearForumCache(forum, true);
        this.clearForumListCache();
        this.clearObjectCache(forum, true);
    }

    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage.saveForum(categoryId, forum, isNew);
        this.clearForumCache(forum, true);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(forum, true);
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage.saveModerateOfForums(forumPaths, userName, isDelete);
        this.forumData.select((CachedObjectSelector)new ForumPathSelector(forumPaths.toArray(new String[forumPaths.size()]), this.forumData));
        this.clearForumListCache();
        for (String forumPath : forumPaths) {
            this.clearObjectCache(Utils.getCategoryId(forumPath), Utils.getForumId(forumPath), true);
        }
    }

    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        this.clearLinkListCache();
        this.clearObjectCache(categoryId, forumId, false);
        return this.storage.removeForum(categoryId, forumId);
    }

    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        for (Forum forum : forums) {
            this.clearForumCache(forum, false);
            this.clearObjectCache(forum, false);
        }
        this.clearForumListCache();
        this.clearLinkListCache();
        this.storage.moveForum(forums, destCategoryPath);
    }

    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String xpathConditions, String strOrderBy, int pageSize) throws Exception {
        return this.storage.getTopicList(categoryId, forumId, xpathConditions, strOrderBy, pageSize);
    }

    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        return this.storage.getTopics(categoryId, forumId);
    }

    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        return this.storage.getTopic(categoryId, forumId, topicId, userRead);
    }

    @Override
    public Topic getTopicSummary(final String topicPath, final boolean isLastPost) throws Exception {
        return ((TopicData)this.topicDataFuture.get((Object)new ServiceContext<TopicData>(){

            public TopicData execute() {
                try {
                    Topic got = CachedDataStorage.this.storage.getTopicSummary(topicPath, isLastPost);
                    if (got != null) {
                        return new TopicData(got);
                    }
                    return TopicData.NULL;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)new TopicKey(topicPath, isLastPost))).build();
    }

    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        return this.storage.getTopicByPath(topicPath, isLastPost);
    }

    @Override
    public Topic getTopicUpdate(Topic topic, boolean isSummary) throws Exception {
        return this.storage.getTopicUpdate(topic, isSummary);
    }

    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        return this.storage.getPageTopicOld(date, forumPatch);
    }

    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        return this.storage.getAllTopicsOld(date, forumPatch);
    }

    @Override
    public long getTotalTopicOld(long date, String forumPatch) {
        return this.storage.getTotalTopicOld(date, forumPatch);
    }

    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    @Override
    public void modifyTopic(List<Topic> topics, int type) {
        this.storage.modifyTopic(topics, type);
    }

    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, MessageBuilder messageBuilder) throws Exception {
        this.storage.saveTopic(categoryId, forumId, topic, isNew, isMove, messageBuilder);
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        if (!isNew) {
            this.clearPostCache(categoryId, forumId, topic.getId(), topic.getId().replace(Utils.TOPIC, Utils.POST));
            this.clearTopicCache(topic);
        }
    }

    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) {
        try {
            this.clearForumCache(categoryId, forumId, false);
            this.clearForumListCache();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.storage.removeTopic(categoryId, forumId, topicId);
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage.moveTopic(topics, destForumPath, mailContent, link);
        if (topics != null && topics.size() > 0) {
            this.forumData.select((CachedObjectSelector)new ForumPathSelector(new String[]{Utils.getForumPath(topics.get(0).getPath()), destForumPath}, this.forumData));
            this.clearForumListCache();
            for (Topic topic : topics) {
                this.clearTopicCache(topic);
            }
        }
    }

    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getLastReadIndex(path, isApproved, isHidden, userLogin);
    }

    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getAvailablePost(categoryId, forumId, topicId, isApproved, isHidden, userLogin);
    }

    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    @Override
    public Post getPost(final String categoryId, final String forumId, final String topicId, final String postId) throws Exception {
        PostKey key = new PostKey(categoryId, forumId, topicId, postId);
        return ((PostData)this.postDataFuture.get((Object)new ServiceContext<PostData>(){

            public PostData execute() {
                try {
                    Post got = CachedDataStorage.this.storage.getPost(categoryId, forumId, topicId, postId);
                    if (got == null) {
                        return PostData.NULL;
                    }
                    return new PostData(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        return this.storage.getListPostsByIP(ip, strOrderBy);
    }

    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, MessageBuilder messageBuilder) throws Exception {
        this.storage.savePost(categoryId, forumId, topicId, post, isNew, messageBuilder);
        this.clearForumCache(categoryId, forumId, false);
        this.clearForumListCache();
        this.clearTopicCache(categoryId, forumId, topicId);
        this.clearPostListCache();
        if (!isNew) {
            this.clearPostCache(categoryId, forumId, topicId, post.getId());
        } else {
            this.clearPostListCountCache(topicId);
        }
        this.statistic = null;
    }

    @Override
    public void modifyPost(List<Post> posts, int type) {
        this.storage.modifyPost(posts, type);
        try {
            this.clearPostListCache();
            for (Post post : posts) {
                String categoryId = Utils.getCategoryId(post.getPath());
                this.clearPostCache(categoryId, post.getForumId(), post.getTopicId(), post.getId());
                this.clearPostListCountCache(post.getTopicId());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) {
        try {
            this.clearForumCache(categoryId, forumId, false);
            this.clearForumListCache();
            this.clearTopicCache(categoryId, forumId, topicId);
            this.clearPostListCache();
            this.clearPostCache(categoryId, forumId, topicId, postId);
            this.clearPostListCountCache(topicId);
            this.statistic = null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.storage.removePost(categoryId, forumId, topicId, postId);
    }

    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        this.storage.addTag(tags, userName, topicPath);
    }

    @Override
    public void unTag(String tagId, String userName, String topicPath) {
        this.storage.unTag(tagId, userName, topicPath);
    }

    @Override
    public Tag getTag(String tagId) throws Exception {
        return this.storage.getTag(tagId);
    }

    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        return this.storage.getTagNameInTopic(userAndTopicId);
    }

    @Override
    public List<String> getAllTagName(String keyValue, String userAndTopicId) throws Exception {
        return this.storage.getAllTagName(keyValue, userAndTopicId);
    }

    @Override
    public List<Tag> getAllTags() throws Exception {
        return this.storage.getAllTags();
    }

    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        return this.storage.getMyTagInTopic(tagIds);
    }

    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        return this.storage.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    @Override
    public void saveTag(Tag newTag) throws Exception {
        this.storage.saveTag(newTag);
    }

    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        return this.storage.getPageListUserProfile();
    }

    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        return this.storage.searchUserProfile(userSearch);
    }

    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        return this.storage.getDefaultUserProfile(userName, ip);
    }

    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        return this.storage.updateUserProfileSetting(userProfile);
    }

    @Override
    public String getScreenName(final String userName) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey("screen", userName);
        return (String)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData execute() {
                try {
                    String got = CachedDataStorage.this.storage.getScreenName(userName);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        return this.storage.getUserSettingProfile(userName);
    }

    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        this.storage.saveUserSettingProfile(userProfile);
    }

    @Override
    public UserProfile getLastPostIdRead(UserProfile userProfile, String isOfForum) throws Exception {
        return this.storage.getLastPostIdRead(userProfile, isOfForum);
    }

    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        this.storage.saveLastPostIdRead(userId, lastReadPostOfForum, lastReadPostOfTopic);
    }

    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        return this.storage.getUserModerator(userName, isModeCate);
    }

    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        this.storage.saveUserModerator(userName, ids, isModeCate);
    }

    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        return this.storage.getUserInfo(userName);
    }

    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        return this.storage.getQuickProfiles(userList);
    }

    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        return this.storage.getQuickProfile(userName);
    }

    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        return this.storage.getUserInformations(userProfile);
    }

    @Override
    public void saveUserProfile(UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        this.storage.saveUserProfile(newUserProfile, isOption, isBan);
    }

    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        return this.storage.getUserProfileManagement(userName);
    }

    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        this.storage.saveUserBookmark(userName, bookMark, isNew);
    }

    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        this.storage.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        this.storage.saveReadMessage(messageId, userName, type);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName));
    }

    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        return this.storage.getPrivateMessage(userName, type);
    }

    @Override
    public long getNewPrivateMessage(final String userName) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName);
        return (Long)((SimpleCacheData)this.miscDataFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData execute() {
                try {
                    Long got = CachedDataStorage.this.storage.getNewPrivateMessage(userName);
                    return new SimpleCacheData((Object)got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)).build();
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        this.storage.savePrivateMessage(privateMessage);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, privateMessage.getSendTo()));
    }

    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        this.storage.removePrivateMessage(messageId, userName, type);
        this.miscData.remove((Serializable)new SimpleCacheKey(PRIVATE_MESSAGE_COUNT_KEY, userName));
    }

    @Override
    public ForumSubscription getForumSubscription(String userId) {
        return this.storage.getForumSubscription(userId);
    }

    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        this.storage.saveForumSubscription(forumSubscription, userId);
    }

    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        if (this.statistic != null) {
            return this.statistic;
        }
        this.statistic = this.storage.getForumStatistic();
        return this.statistic;
    }

    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        this.storage.saveForumStatistic(forumStatistic);
    }

    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        ObjectNameKey key = new ObjectNameKey(path);
        CachedData data = (CachedData)this.objectNameData.get((Serializable)((Object)key));
        if (data == null) {
            Object got = this.storage.getObjectNameByPath(path);
            if (got instanceof Post) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new PostData((Post)got));
            } else if (got instanceof Topic) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new TopicData((Topic)got));
            } else if (got instanceof Forum) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new ForumData((Forum)got));
            } else if (got instanceof Category) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new CategoryData((Category)got));
            } else if (got instanceof Tag) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new TagData((Tag)got));
            } else {
                this.objectNameData.put((Serializable)((Object)key), (Object)TopicData.NULL);
            }
            return got;
        }
        return data.build();
    }

    @Override
    public Object getObjectNameById(String id, String type) throws Exception {
        ObjectNameKey key = new ObjectNameKey(id, type);
        CachedData data = (CachedData)this.objectNameData.get((Serializable)((Object)key));
        if (data == null) {
            Object got = this.storage.getObjectNameById(id, type);
            if (got instanceof Post) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new PostData((Post)got));
            } else if (got instanceof Topic) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new TopicData((Topic)got));
            } else if (got instanceof Forum) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new ForumData((Forum)got));
            } else if (got instanceof Category) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new CategoryData((Category)got));
            } else if (got instanceof Tag) {
                this.objectNameData.put((Serializable)((Object)key), (Object)new TagData((Tag)got));
            } else {
                this.objectNameData.put((Serializable)((Object)key), (Object)TopicData.NULL);
            }
            return got;
        }
        return data.build();
    }

    @Override
    public List<ForumLinkData> getAllLink(final String strQueryCate, final String strQueryForum) throws Exception {
        LinkListKey key = new LinkListKey(strQueryCate, strQueryForum);
        return this.buildLinkOutput((ListLinkData)((Object)this.linkListDataFuture.get((Object)new ServiceContext<ListLinkData>(){

            public ListLinkData execute() {
                try {
                    List<ForumLinkData> got = CachedDataStorage.this.storage.getAllLink(strQueryCate, strQueryForum);
                    return CachedDataStorage.this.buildLinkInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)));
    }

    @Override
    public List<ForumSearch> getQuickSearch(String textQuery, String type_, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage.getQuickSearch(textQuery, type_, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearch> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) {
        return this.storage.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage.addWatch(watchType, path, values, currentUser);
        this.watchListData.remove((Serializable)new SimpleCacheKey(null, currentUser));
        this.clearWatchingItemCache(path);
    }

    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        this.storage.removeWatch(watchType, path, values);
        this.watchListData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.clearWatchingItemCache(path);
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        this.storage.updateEmailWatch(listNodeId, newEmailAdd, userId);
        this.watchListData.remove((Serializable)new SimpleCacheKey(null, userId));
        for (String id : listNodeId) {
            if (id.contains(Utils.CATEGORY)) {
                this.categoryData.remove((Serializable)((Object)new CategoryKey(id)));
                continue;
            }
            if (id.contains(Utils.FORUM)) {
                this.forumData.remove((Serializable)((Object)new ForumKey((Forum)this.getObjectNameById(id, Utils.FORUM))));
                continue;
            }
            if (!id.contains(Utils.TOPIC)) continue;
            this.topicData.remove((Serializable)((Object)new TopicKey((Topic)this.getObjectNameById(id, Utils.TOPIC))));
        }
    }

    @Override
    public List<Watch> getWatchByUser(final String userId) throws Exception {
        SimpleCacheKey key = new SimpleCacheKey(null, userId);
        return this.buildWatchOutput((ListWatchData)((Object)this.watchListDataFuture.get((Object)new ServiceContext<ListWatchData>(){

            public ListWatchData execute() {
                try {
                    List<Watch> got = CachedDataStorage.this.storage.getWatchByUser(userId);
                    return CachedDataStorage.this.buildWatchInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)));
    }

    @Override
    public void updateForum(String path) throws Exception {
        this.storage.updateForum(path);
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage.getMessageInfo(name);
    }

    @Override
    public Iterator<SendMessageInfo> getPendingMessages() throws Exception {
        return this.storage.getPendingMessages();
    }

    @Override
    public List<ForumSearch> getJobWattingForModerator(String[] paths) {
        return this.storage.getJobWattingForModerator(paths);
    }

    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        return this.storage.getJobWattingForModeratorByUser(userId);
    }

    @Override
    public NodeIterator search(String queryString) throws Exception {
        return this.storage.search(queryString);
    }

    @Override
    public void evaluateActiveUsers(String query) {
        this.storage.evaluateActiveUsers(query);
    }

    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        return this.storage.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        this.storage.importXML(nodePath, bis, typeImport);
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumData.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) {
        this.storage.updateTopicAccess(userId, topicId);
    }

    @Override
    public void writeReads() {
        this.storage.writeReads();
    }

    @Override
    public void updateForumAccess(String userId, String forumId) {
        this.storage.updateForumAccess(userId, forumId);
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        return this.storage.getBookmarks(userName);
    }

    @Override
    public List<String> getBanList() throws Exception {
        return this.storage.getBanList();
    }

    @Override
    public boolean isBanIp(String ip) throws Exception {
        return this.storage.isBanIp(ip);
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        return this.storage.addBanIP(ip);
    }

    @Override
    public void removeBan(String ip) throws Exception {
        this.storage.removeBan(ip);
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage.getForumBanList(forumId);
    }

    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        return this.storage.addBanIPForum(ip, forumId);
    }

    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        this.storage.removeBanIPForum(ip, forumId);
    }

    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage.updateStatisticCounts(topicCount, postCount);
    }

    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        return this.storage.getPruneSetting(forumPath);
    }

    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        return this.storage.getAllPruneSetting();
    }

    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        this.storage.savePruneSetting(pruneSetting);
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.storage.runPrune(forumPath);
    }

    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        this.storage.runPrune(pSetting);
    }

    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        return this.storage.checkPrune(pSetting);
    }

    @Override
    public List<TopicType> getTopicTypes() {
        return this.storage.getTopicTypes();
    }

    @Override
    public TopicType getTopicType(String Id) throws Exception {
        return this.storage.getTopicType(Id);
    }

    @Override
    public void saveTopicType(TopicType topicType) throws Exception {
        this.storage.saveTopicType(topicType);
    }

    @Override
    public void removeTopicType(String topicTypeId) throws Exception {
        this.storage.removeTopicType(topicTypeId);
    }

    @Override
    public JCRPageList getPageTopicByType(String type) throws Exception {
        return this.storage.getPageTopicByType(type);
    }

    @Override
    public boolean populateUserProfile(User user, UserProfile profileTemplate, boolean isNew) throws Exception {
        return this.storage.populateUserProfile(user, profileTemplate, isNew);
    }

    @Override
    public boolean deleteUserProfile(String userId) throws Exception {
        return this.storage.deleteUserProfile(userId);
    }

    @Override
    public void calculateDeletedUser(String userName) throws Exception {
        this.storage.calculateDeletedUser(userName);
    }

    @Override
    public void calculateDeletedGroup(String groupId, String groupName) throws Exception {
        this.storage.calculateDeletedGroup(groupId, groupName);
        this.forumData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.forumList.select((CachedObjectSelector)new ScopeCacheSelector());
        this.categoryData.select((CachedObjectSelector)new ScopeCacheSelector());
        this.categoryList.select((CachedObjectSelector)new ScopeCacheSelector());
    }

    @Override
    public void initDataPlugin() throws Exception {
        this.storage.initDataPlugin();
    }

    @Override
    public void initDefaultData() throws Exception {
        this.storage.initDefaultData();
    }

    @Override
    public List<RoleRulesPlugin> getRulesPlugins() {
        return this.storage.getRulesPlugins();
    }

    @Override
    public List<InitializeForumPlugin> getDefaultPlugins() {
        return this.storage.getDefaultPlugins();
    }

    @Override
    public void initAutoPruneSchedules() throws Exception {
        this.storage.initAutoPruneSchedules();
    }

    @Override
    public void updateLastLoginDate(String userId) throws Exception {
        this.storage.updateLastLoginDate(userId);
    }

    @Override
    public String getLatestUser() throws Exception {
        return this.storage.getLatestUser();
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        return this.storage.getNewPosts(number);
    }

    @Override
    public List<Post> getRecentPostsForUser(String userName, int number) throws Exception {
        return this.storage.getRecentPostsForUser(userName, number);
    }

    @Override
    public Map<String, String> getServerConfig() {
        return this.storage.getServerConfig();
    }

    @Override
    public KSDataLocation getDataLocation() {
        return this.storage.getDataLocation();
    }

    @Override
    public void setViewCountTopic(String path, String userRead) {
        this.storage.setViewCountTopic(path, userRead);
    }

    @Override
    public void writeViews() {
        this.storage.writeViews();
    }

    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        return this.storage.getPostForSplitTopic(topicPath);
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        this.forumData.select((CachedObjectSelector)new ForumPathSelector(new String[]{Utils.getForumPath(postPaths[0]), Utils.getForumPath(destTopicPath)}, this.forumData));
        this.clearForumListCache();
        String srcTopicPath = null;
        for (String postPath : postPaths) {
            srcTopicPath = postPath.substring(0, postPath.lastIndexOf("/"));
            this.clearTopicCache(srcTopicPath);
            Topic topic = this.getTopicByPath(srcTopicPath, false);
            this.clearPostListCountCache(topic.getId());
        }
        this.storage.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
        this.clearTopicCache(destTopicPath);
        Topic topic = this.getTopicByPath(destTopicPath, false);
        this.clearPostListCountCache(topic.getId());
        this.clearPostListCache();
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        this.storage.mergeTopic(srcTopicPath, destTopicPath, mailContent, link);
    }

    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        this.storage.updateUserProfileInfo(name);
    }

    @Override
    public InputStream createForumRss(String objectId, String link) throws Exception {
        return this.storage.createForumRss(objectId, link);
    }

    @Override
    public InputStream createUserRss(String userId, String link) throws Exception {
        return this.storage.createUserRss(userId, link);
    }

    @Override
    public List<Post> getPosts(final PostFilter filter, final int offset, final int limit) throws Exception {
        PostListKey key = new PostListKey(filter, offset, limit);
        return this.buildPostOutput((ListPostData)((Object)this.postListFuture.get((Object)new ServiceContext<ListPostData>(){

            public ListPostData execute() {
                try {
                    List<Post> got = CachedDataStorage.this.storage.getPosts(filter, offset, limit);
                    return CachedDataStorage.this.buildPostInput(got);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key)));
    }

    @Override
    public int getPostsCount(final PostFilter filter) throws Exception {
        PostListCountKey key = new PostListCountKey("postsCount", filter.toString(), filter.getTopicId());
        SimpleCacheData data = (SimpleCacheData)this.postListCountFuture.get((Object)new ServiceContext<SimpleCacheData>(){

            public SimpleCacheData execute() {
                try {
                    return new SimpleCacheData((Object)CachedDataStorage.this.storage.getPostsCount(filter));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Object)key);
        return (Integer)data.build();
    }
}

